#! /usr/bin/env python
###############################################################################
#                                                                             #
#   Copyright 2005 University of Cambridge Computer Laboratory.               #
#                                                                             #
#   This file is part of Nprobe.                                              #
#                                                                             #
#   Nprobe is free software; you can redistribute it and/or modify            #
#   it under the terms of the GNU General Public License as published by      #
#   the Free Software Foundation; either version 2 of the License, or         #
#   (at your option) any later version.                                       #
#                                                                             #
#   Nprobe is distributed in the hope that it will be useful,                 #
#   but WITHOUT ANY WARRANTY; without even the implied warranty of            #
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             #
#   GNU General Public License for more details.                              #
#                                                                             #
#   You should have received a copy of the GNU General Public License         #
#   along with Nprobe; if not, write to the Free Software                     #
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA #
#                                                                             #
###############################################################################


##############################################################################
##############################################################################
## 
##
## Print pretty coloured text to colour Xterm
##
## 

############################################################################
##############################################################################

from sys import stdout, stderr
from time import sleep

############################################################################
##############################################################################


#
# Colour escape codes 
#

F_BLACK = chr(27) + chr(91) + chr(51) + chr(48) + chr(109) + chr(0)
F_RED = chr(27) + chr(91) + chr(51) + chr(49) + chr(109) + chr(0)
F_GREEN = chr(27) + chr(91) + chr(51) + chr(50) + chr(109) + chr(0)
F_YELLOW = chr(27) + chr(91) + chr(51) + chr(51) + chr(109) + chr(0)
F_BLUE = chr(27) + chr(91) + chr(51) + chr(52) + chr(109) + chr(0)
F_MAGENTA = chr(27) + chr(91) + chr(51) + chr(53) + chr(109) + chr(0)
F_CYAN = chr(27) + chr(91) + chr(51) + chr(54) + chr(109) + chr(0)
F_WHITE = chr(27) + chr(91) + chr(51) + chr(55) + chr(109) + chr(0)
F_NORM = chr(0)
F_DEF = chr(27) + chr(91) + chr(51) + chr(59) + chr(109) + chr(0)

F_UNDER = chr(27) + chr(91) + chr(52) + chr(58) + chr(109) + chr(0)
F_BOLD = chr(27) + chr(91) + chr(49) + chr(58) + chr(109) + chr(0)

B_BLACK = chr(27) + chr(91) + chr(52) + chr(48) + chr(109) + chr(0)
B_RED = chr(27) + chr(91) + chr(52) + chr(49) + chr(109) + chr(0)
B_GREEN = chr(27) + chr(91) + chr(52) + chr(50) + chr(109) + chr(0)
B_YELLOW = chr(27) + chr(91) + chr(52) + chr(51) + chr(109) + chr(0)
B_BLUE = chr(27) + chr(91) + chr(52) + chr(52) + chr(109) + chr(0)
B_MAGENTA = chr(27) + chr(91) + chr(52) + chr(53) + chr(109) + chr(0)
B_CYAN = chr(27) + chr(91) + chr(52) + chr(54) + chr(109) + chr(0)
B_WHITE = chr(27) + chr(91) + chr(52) + chr(55) + chr(109) + chr(0)
B_NORM = chr(0)
B_DEF = chr(27) + chr(91) + chr(52) + chr(59) + chr(109) + chr(0)

#
# Other escape codes
#

C_UNDER = chr(27) + chr(91) + chr(52) + chr(58) + chr(109) + chr(0)
C_BLD = chr(27) + chr(91) + chr(49) + chr(58) + chr(109) + chr(0)
C_UP_LINE = chr(27) + chr(91) + chr(1) + chr(65) + chr(0)
C_HOME = chr(27) + chr(91) + chr(49) + chr(48) + chr(68) + chr(0)
C_CLEAR_R = chr(27) + chr(91) + chr(48) + chr(75) + chr(0)
C_UP_LINE_CLEAR = C_UP_LINE + C_CLEAR_R


############################################################################
##############################################################################

#
# Print colour to stream
#

def cprint(col, s, stream = stdout):

    print '%s%s%s%s' % (col, s, F_DEF, B_DEF)
    #stream.write('%s%s%s%s\n' % (col, s, F_DEF, B_DEF))
    #stream.write(s + '\n')
    #print s

##############################################################################

#
# Print bold colour to stream
#

def cbprint(col, s, stream = stdout):

    print '%s%s%s%s%s' % (C_BLD, col, s, F_DEF, B_DEF)
    #stream.write('%s%s%s%s\n' % (col, s, F_DEF, B_DEF))
    #stream.write(s + '\n')
    #print s

##############################################################################

#
# Print bold to stream
#

def bprint(s, stream = stdout):

    print '%s%s%s%s' % (C_BLD, s, F_DEF, B_DEF)
    #stream.write('%s%s%s%s\n' % (col, s, F_DEF, B_DEF))
    #stream.write(s + '\n')
    #print s

##############################################################################

#
# Print a whoops to stderr
#

def whoops(s):

##     stdout.flush(); stdout.flush();stdout.flush(); stdout.flush();
##     cprint(F_RED, 'WHOOPS %s' % (s), stream = stderr)

    cprint(F_RED, 'WHOOPS %s' % (s))


##############################################################################

#
# Print informative to stdout
#

def inform(s):

##     stdout.flush(); stdout.flush();stdout.flush(); stdout.flush();
##     cprint(F_BLUE, '%s' % (s), stream = stderr)

    cprint(F_BLUE, '%s' % (s))


##############################################################################

#
# Up a line on stdout
#

def upline():

    print C_UP_LINE + C_CLEAR_R


##############################################################################

#
# Overprint previous line on stdout
#

def overprint(s):

    cprint(C_UP_LINE_CLEAR, '%s' % (s))


#############################################################################
##############################################################################

#
# Test
#
	
def main():

    s = 'Hello'
    cprint(F_RED, s)

    s = 'complicated'
    cprint(F_BLUE, 'More %s' % (s))

    cprint(B_GREEN, 'Green background')
    
    print

    for i in range(5):
        print 'This is line %d' % (i),
        sleep(1)
        upline()

    print

    for i in range(5):
        overprint('This is line %d' % (i))
        sleep(1)

    print
        

#############################################################################


# Call main when run as script
if __name__ == '__main__':
        main()

#
# 
#

###########################################################################
# 
###########################################################################
