/******************************************************************************
*                                                                             *
*   Copyright 2005 University of Cambridge Computer Laboratory.               *
*                                                                             *
*   This file is part of Nprobe.                                              *
*                                                                             *
*   Nprobe is free software; you can redistribute it and/or modify            *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   Nprobe is distributed in the hope that it will be useful,                 *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with Nprobe; if not, write to the Free Software                     *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
*                                                                             *
******************************************************************************/


/* Configurable parameters **********************************************/

// Now done in Makefile

/**CL CONFIG*******************************************************/

#ifdef CAM_CONFIG

//#define WRITE_OBJECTS

#define USE_ONE_THREAD_ONLY    /* for debugging use */
//#define VLAN_HEADER     /* if set, skip over 4 byte VLAN header */

#define ETHERNET                  /* use ATM */
#define SK98                  /* use ATM */

#define NUM_IFACES 1                 /* number of network cards */
#define NUM_CPUS   1 	             /* must be a power of 2! */ 
#define MEM_SIZE   (1024 << 20UL)     /* Total memory */


#define FIFO_SIZE (8192*2)          /* number of bufs in system (was 8192) */

#define US_CHANNELS NUM_CPUS    /* number of channels to user space */


#define ETH_BUFFER_SIZE (1536+16+32+2) /* it'll be a 2KB thing anyway...*/

#define MARK_BUFFERS    /* special buffer tracing -- trashes LLC header!!! */

#define MAP_READONLY    /* spoils some of the buffer tracing... */

#undef PARANOID         /* this is slow! */


#endif


/**CAMBRIDGE CONFIG*******************************************************/

#ifdef OLD_CAM_CONFIG

#error WRONG CONFIG in config.h

//#define ATM_LANE

#define USE_ONE_THREAD_ONLY    /* for debugging use */

//#define ATM                     
#define ETHERNET                  

// neads to be defined if on CL-SRG switch link
//#define VLAN_HEADER     /* if set, skip over 4 byte VLAN header */

#define NUM_IFACES 1                 /* number of network cards */
#define NUM_CPUS   1 	             /* must be a power of 2! */ 
#define MEM_SIZE   (1024 << 20UL)     /* Total memory */


#define FIFO_SIZE (8192*2)          /* number of bufs in system (was 8192) */

#define US_CHANNELS NUM_CPUS    /* number of channels to user space */


#define ETH_BUFFER_SIZE (1536+16+32+2) /* it'll be a 2KB thing anyway...*/
#define ATM_BUFFER_SIZE (2048+4)       /* nicstar large buffers was 8192 */


#define MARK_BUFFERS    /* special buffer tracing -- trashes LLC header!!! */

#define MAP_READONLY    /* spoils some of the buffer tracing... */

#undef PARANOID         /* this is slow! */


/* ATM Card specific stuff */


#define DEFAULT_VPI 0           /* IAP Horrid default VC stuff */
#define DEFAULT_VCI 1           /* IAP Horrid default VC stuff */


//#define VP_LOG   // XXXX DEBUG
#endif
