/******************************************************************************
*                                                                             *
*   Copyright 2005 University of Cambridge Computer Laboratory.               *
*                                                                             *
*   This file is part of Nprobe.                                              *
*                                                                             *
*   Nprobe is free software; you can redistribute it and/or modify            *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   Nprobe is distributed in the hope that it will be useful,                 *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with Nprobe; if not, write to the Free Software                     *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
*                                                                             *
******************************************************************************/


typedef unsigned long u32;
/* Urgg... this is nasty, but is necessary to get kernel structures
   from userspace. */
#ifdef LINUX24
#define _LINUX_KERNEL_H
#define __LINUX_COMPILER_H
#else
#define _I386_BUG_H
#define __i386_UACCESS_H
#define _LINUX_IN6_H
#define might_sleep()
#define access_ok(type, addr, size) 1
#define verify_area(type, addr, size) 0
#define unlikely(x) (x)
#define likely(x) (x)
#define BUG_ON(x) assert(!(x))
#define BUG() abort()
#define barrier() __asm__ __volatile__("": : :"memory")
typedef unsigned long long u64;
typedef unsigned short u16;
#define BITS_PER_LONG 32
#define BITS_TO_LONGS(x) ((x)/BITS_PER_LONG)
#define _LINUX_WAIT_H
#include "linux/include/linux/compiler.h"
#define __force
typedef u64 __le64, __be64;
typedef u32 __le32, __be32;
typedef u16 __le16, __be16;
#endif
#define _LINUX_HIGHMEM_H
#define _LINUX_SCHED_H
#define _LINUX_TIME_H

#include "./linux/include/linux/skbuff.h"

#include <asm/types.h>
#include <sys/time.h>

extern char * km;   // pointer to the devmem area

