/******************************************************************************
*                                                                             *
*   Copyright 2005 University of Cambridge Computer Laboratory.               *
*                                                                             *
*   This file is part of Nprobe.                                              *
*                                                                             *
*   Nprobe is free software; you can redistribute it and/or modify            *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   Nprobe is distributed in the hope that it will be useful,                 *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with Nprobe; if not, write to the Free Software                     *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
*                                                                             *
******************************************************************************/


extern void NP_netif_rx(struct sk_buff *skb);
extern struct sk_buff * NP_dev_alloc_skb(unsigned int length);
extern void NP_dev_kfree_skb(struct sk_buff *);
extern struct sk_buff *  NP_alloc_and_pass_up(struct sk_buff * recv_skb,
				       unsigned int length );

#define FIFO_SIZE 1024

#define US_CHANNELS 1      // number of channels to user space
                           // must be a power of 2! 


#define ABC 0    // XXXX temporary

typedef struct sk_buff * skb_ptr;

typedef struct 
{
  // should take care with cashe alignment to avoid false sharing

  spinlock_t   lock;                              // 4 bytes
  volatile u32 tous_in;                           // read by user space
  volatile u32 frus_out;
  u32 pad1[5];

  volatile u32 tous_out;
  volatile u32 frus_in;                           // written from user space

  u32 pad2[6];

} us_control_t;


typedef struct {
  volatile u32     magic;
  u32              num_bufs;
  u32              pad[6];        // pad to 32 bytes cache line
  
  us_control_t     x[US_CHANNELS];
  
  skb_ptr          bufs [FIFO_SIZE];
  
  volatile skb_ptr tous_skb [US_CHANNELS] [FIFO_SIZE];
  volatile skb_ptr frus_skb [US_CHANNELS] [FIFO_SIZE];
  
  u32 end_magic;
} np_t;


#define NP_MAGIC  0xdeadbeef
#define NP_MAGIC2 0x11223344
#define NP_MAGIC3 0xaabbccdd

















