#! /bin/bash
###############################################################################
#                                                                             #
#   Copyright 2005 University of Cambridge Computer Laboratory.               #
#                                                                             #
#   This file is part of Nprobe.                                              #
#                                                                             #
#   Nprobe is free software; you can redistribute it and/or modify            #
#   it under the terms of the GNU General Public License as published by      #
#   the Free Software Foundation; either version 2 of the License, or         #
#   (at your option) any later version.                                       #
#                                                                             #
#   Nprobe is distributed in the hope that it will be useful,                 #
#   but WITHOUT ANY WARRANTY; without even the implied warranty of            #
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             #
#   GNU General Public License for more details.                              #
#                                                                             #
#   You should have received a copy of the GNU General Public License         #
#   along with Nprobe; if not, write to the Free Software                     #
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA #
#                                                                             #
###############################################################################

###############################################################################
#
# Set paths for Nprobe world
#
###############################################################################
#
# Args:
# 
# $1 = No. dirs to be prepended to LD_LIBRARY_PATH
# $2 = No. dirs to be prepended to PATH
# $3 = No. dirs to be prepended to PYTHONPATH
# $4 ... = list of dirs to be added
#

#
# Dirs will be prepended to the appropriate paths, those already on the path 
#  *not* being added - path-search order will therefore not be modified in 
#  the case of existing components.
#
###############################################################################

function makepaths()
{
#    echo makepaths $*;
    NARGS=$1
    NEWPATH=$2
    shift 2
    if [ $NARGS -eq 0 ];
	then
	    return;
    fi
    for ((NARGS += 1; NARGS -= 1;))
	do
	    
	    if ! echo $NEWPATH | /bin/egrep -q "(^|:)$1($|:)" ; 
		then
		    if [ $NEWPATH ];
			then
			    SUFF=":"
		    else
			SUFF=""
		    fi


		    NEWPATH=$1$SUFF$NEWPATH;
	    fi

	    shift;
	done
    return;
}

if [ $# -lt 3 ]; 
    then 
	echo $0: wrong number of arguments - at least 3 required; 
	echo - not setting up nprobe_world;
elif [ $[$1+$2+$3] -ne $[$#-3] ];
    then 
	echo $0: wrong number of arguments; 
	echo - not setting up nprobe_world;
else
    LD_LIBRARY_PATH_NARGS=$1
    PATH_NARGS=$2
    PYPATH_NARGS=$3
    shift 3

    makepaths $LD_LIBRARY_PATH_NARGS "$LD_LIBRARY_PATH" $*
    shift $LD_LIBRARY_PATH_NARGS

    if [ ! $NEWPATH ==  "$LD_LIBRARY_PATH" ];
	then
	    LD_LIBRARY_PATH=$NEWPATH
	    export LD_LIBRARY_PATH
	    echo **LD_LIBRARY_PATH set to $LD_LIBRARY_PATH**
    else
	echo  **LD_LIBRARY_PATH $LD_LIBRARY_PATH not modified**
    fi

    makepaths $PATH_NARGS "$PATH" $*
    shift $PATH_NARGS

    if [ ! $NEWPATH == "$PATH" ];
	then
	    PATH=$NEWPATH
	    export PATH
	    echo **PATH set to $PATH**
    else
	echo  **PATH $PATH not modified**
    fi

    makepaths $PYPATH_NARGS "$PYTHONPATH" $*
    shift $PYPATH_NARGS

    if [ ! $NEWPATH == "$PYTHONPATH" ];
	then
	    PYTHONPATH=$NEWPATH
	    export PYTHONPATH
	    echo **PYTHONPATH set to $PYTHONPATH**
    else
	echo  **PYTHONPATH $PYTHONPATH not modified**
    fi

fi
