#! /usr/bin/env python
###############################################################################
#                                                                             #
#   Copyright 2005 University of Cambridge Computer Laboratory.               #
#                                                                             #
#   This file is part of Nprobe.                                              #
#                                                                             #
#   Nprobe is free software; you can redistribute it and/or modify            #
#   it under the terms of the GNU General Public License as published by      #
#   the Free Software Foundation; either version 2 of the License, or         #
#   (at your option) any later version.                                       #
#                                                                             #
#   Nprobe is distributed in the hope that it will be useful,                 #
#   but WITHOUT ANY WARRANTY; without even the implied warranty of            #
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             #
#   GNU General Public License for more details.                              #
#                                                                             #
#   You should have received a copy of the GNU General Public License         #
#   along with Nprobe; if not, write to the Free Software                     #
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA #
#                                                                             #
###############################################################################


##############################################################################
## 
##
## Check feasability of time stamps in rep logs
## 
##
## 

############################################################################

import os
import sys
from sys import argv
import getopt
from signal import *
from traceback import print_stack

from print_col import upline, overprint

from nprobe import _inet_aton, tcp_open, tcp_hdrs, accept_conn, filter_help
from nprobe import REC_TCP_HTTP, REC_TCP_HTTP_OPEN, REC_TCP_HTTP_HDRS, \
     REC_UDP_DNS, OPEN_BIT, HDRS_BIT
from np_file_util import get_files
from np_http_util import allocate_http_reusable_objects, get_http_rec_and_trans
from np_longutil import tv2l, ull2l
from np_tfilter import TFilter

############################################################################

def usage(scriptname):
    print "usage: " + scriptname + "rep-file-list"

    sys.exit(1)   

#############################################################################

def handle_sigint(n, f):
    
    print 'SIGINT'
    print_stack()
    sys.exit(0)

############################################################################

	
def main():
	
    global namecache

    scriptname = os.path.basename(argv[0])
    draw_tree = 0
    nrecs = 0
    fspec = 0
    trace = 0
    verb = 0
    tfilt = TFilter()
    clis = None
    cachedir = None

    try:
        optlist, args = getopt.getopt(sys.argv[1:], 'hvV:dtc:r:F:T:')

    except getopt.error, s:
        print '%s: %s' % (scriptname, s)
        usage(scriptname)
        sys.exit(1)

    optstr = ''

    for opt in optlist:
        if opt[0] == "-h":
            usage(scriptname)


    signal(SIGINT, handle_sigint)

    cdict = {} # associate by conn id
    #
    # To get TCP records into
    #
    tcp_open_rec = tcp_open()
    hdrs = tcp_hdrs()
    connrec, translist = allocate_http_reusable_objects()
    

    openfilelist, counters, basepath = get_files(args)
    
    run_start = tv2l(counters.run_start())
    run_end = tv2l(counters.run_end())
    
    for file in openfilelist:

        flen = os.stat(file.fnm)[6]
        
        if len(openfilelist) > 1:
            print "\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
            print "File %s - %d records" % (file.fnm, file.counters.nrecords)
            print
            sys.stdout.flush()

        while 1:

            rectype = file.find_next_tcp_and_hdrs()

            if rectype ==  -1: #EOF
                break

            elif rectype == REC_TCP_HTTP_OPEN: # notification of TCP open
                file.advance()
                continue

            elif rectype == REC_TCP_HTTP_HDRS: # a block of hdrs
                hdrs.get_hdrs(file)
                conn_id = hdrs.conn_id
                htm = ull2l(hdrs.get_hdrs_abstm())
                try:
                    ent = cdict[conn_id]
                    if ent[-1] > htm:
                        print 'GOOF conn hdrs #%d pkt_hdrs time order' % (conn_id)
                    ent.append(htm)
                except KeyError:
                    cdict[conn_id] = [htm]

                p0 = hdrs.get_rtm(0)
                for  i in range(hdrs.nheld)[1:]:
                    p1 = hdrs.get_rtm(i)
                    if p0 > p1:
                        print 'GOOF conn hdrs #%d hdr time order' % (conn_id)
                    p0 = p1

            elif rectype == REC_TCP_HTTP: #TCP/HTTP
                ntrans = get_http_rec_and_trans(file, connrec, translist)
                conn_id = connrec.get_conn_id()
                connopen = ull2l(connrec.open())
                htm =  ull2l(connrec.get_hdrs_abstm())
                try:
                    ent = cdict[conn_id]
                    if ent[-1] > htm:
                        print 'GOOF conn final #%d pkt_hdrs time order' % (conn_id)
                    ent.append(htm)
                except KeyError:
                    ent = cdict[conn_id] = [htm]

                if connopen != ent[0]:
                        print 'GOOF conn %d open != first packet' % (conn_id)

                
                p0 = connrec.get_rtm(0)
                for  i in range(connrec.get_nhdrs_held())[1:]:
                    p1 = connrec.get_rtm(i)
                    if p0 > p1:
                        print 'GOOF conn hdrs #%d hdr time order' % (conn_id)
                    p0 = p1

            else:
                file.advance()
                continue

    clist = cdict.items()
    clist.sort()

    s1 = op1 = clist[0][1][0]
    for c in clist[1:]:
        if c[1][0] < op1:
            print 'GOOF conn  #%d op time order' % (conn_id)
        op1 = c[1][0]

    end = op1

    print 'Counters'
    print '\topen %d.%.6d close %d.%.6d dur %.6f' % (run_start/1000000,
                    run_start%1000000, run_end/1000000,
                    run_end%1000000, (run_end-run_start)/1000000.0)
    print 'Recs'
    print '\topen %d.%.6d close %d.%.6d dur %.6f' % (s1/1000000,
                    s1%1000000, op1/1000000,
                    op1%1000000, (op1-s1)/1000000.0)
    
	    
##############################################################################


# Call main when run as script
if __name__ == '__main__':
        main()
            
