#! /usr/bin/env python
###############################################################################
#                                                                             #
#   Copyright 2005 University of Cambridge Computer Laboratory.               #
#                                                                             #
#   This file is part of Nprobe.                                              #
#                                                                             #
#   Nprobe is free software; you can redistribute it and/or modify            #
#   it under the terms of the GNU General Public License as published by      #
#   the Free Software Foundation; either version 2 of the License, or         #
#   (at your option) any later version.                                       #
#                                                                             #
#   Nprobe is distributed in the hope that it will be useful,                 #
#   but WITHOUT ANY WARRANTY; without even the implied warranty of            #
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             #
#   GNU General Public License for more details.                              #
#                                                                             #
#   You should have received a copy of the GNU General Public License         #
#   along with Nprobe; if not, write to the Free Software                     #
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA #
#                                                                             #
###############################################################################


from sys import argv
import getopt
import os
import sys

import re


scriptname = os.path.basename(argv[0])

try:
    optlist, args = getopt.getopt(sys.argv[1:], '')

except getopt.error, s:
    print '%s: %s' % (scriptname, s)
    usage(scriptname)
    sys.exit(1)

## RE1 = re.compile('[0-9]*/[0-9]* servers showing delays.*')
## RE2 = re.compile('[0-9]* dupcsyn.*')
## RE3 = re.compile('[0-9]* Pages seen.*')
## RE4 = re.compile('[0-9]* connections.*')

#
# extract from log lines of the form
# '3/5 servers showing delays (1 > 5 pkts) 24/891 conns with all
#  delays 13 with large delays 1 persistent conns'
#
RE1 = re.compile('([0-9]*)/([0-9]*) servers showing delays \(([0-9]*) > ([0-9]*) pkts\) ([0-9]*)/([0-9]*).*all delays ([0-9]*).*delays ([0-9]*) persistent.*')

RE2 = re.compile('[0-9]* dupcsyn.*')
RE3 = re.compile('[0-9]* Pages seen.*')
RE4 = re.compile('[0-9]* connections.*')
RE5 = re.compile('[0-9]* no request - [0-9]* incorporated')
RE6 = re.compile('[0-9]* objects - [0-9]* conns [0-9]* servers not in trees') 


print 'files from', os.path.dirname(args[0]), ':'
for fnm in args:
    print os.path.basename(fnm)
    f = open(fnm, 'r')
    for l in f.readlines():
        s = l[:-1]
        m = RE1.match(s)
        if m:
            print l
            #print m.group(1, 2, 3, 4, 5, 6, 7, 8)
        for r in [RE2, RE3, RE4, RE5]:
            if r.match(s):
                print s
            
