#! /usr/bin/env python
###############################################################################
#                                                                             #
#   Copyright 2005 University of Cambridge Computer Laboratory.               #
#                                                                             #
#   This file is part of Nprobe.                                              #
#                                                                             #
#   Nprobe is free software; you can redistribute it and/or modify            #
#   it under the terms of the GNU General Public License as published by      #
#   the Free Software Foundation; either version 2 of the License, or         #
#   (at your option) any later version.                                       #
#                                                                             #
#   Nprobe is distributed in the hope that it will be useful,                 #
#   but WITHOUT ANY WARRANTY; without even the implied warranty of            #
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             #
#   GNU General Public License for more details.                              #
#                                                                             #
#   You should have received a copy of the GNU General Public License         #
#   along with Nprobe; if not, write to the Free Software                     #
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA #
#                                                                             #
###############################################################################


##############################################################################
## 
## 
## 
## 
##
## 

############################################################################ 
############################################################################ 

from string import *
import sys
import getopt

from sys import exit
from math import *
from minmax import *
	    
############################################################################## 
###########################################################################################################################################################

def usage():

    print 'scaley <-R highest> [-r lowest] [-t tag] <file>'
    sys.exit(1)

##############################################################################

def get_data(files):
    f = open(files[0], 'r')
    data = []
    n = 0
    ymin = float(BIGNUMBER)
    ymax = float(-BIGNUMBER)
    line = 0
    while 1:
	s = f.readline()
	line = line +1
	if not len(s):
	    break
	if s[0] == '#' or s[0] == ' ' or s[0] =='\n':
	    #print 'comment'
	    continue
	vs = split(s)
	try:
	    tag = atoi(vs[2][1:])
	except IndexError:
	    tag = 0
	try:
	    yval = atof(vs[1])
	    data.append([atof(vs[0]), yval, tag, []])
	    ymin = MIN(ymin, yval)
	    ymax = MAX(ymax, yval)
	    n = n + 1
	except IndexError:
	    print 'Malformed data line %d' % (line)
	    sys.exit (1)

    #print 'read %d data points' % (n)

    if files[0][-1] == ' ':
	path = files[0][:-1]
    else:
	path = files[0]

    return (path, data, ymin, ymax)
	    
	     
############################################################################## 


def main():

    low = None
    high = None
    scalef = None
    tagstr = ''

    try:
        optlist, args = getopt.getopt(sys.argv[1:], 'r:R:s:t:h')

    except getopt.error, s:
        print 'np_scale: ' + s
        usage()
        sys.exit(1)

    for opt in optlist:
	if opt[0] == '-r':
	    low = atof(opt[1])
	if opt[0] == '-R':
	    high = atof(opt[1])
	if opt[0] == '-s':
	    scalef = atof(opt[1])
	if opt[0] == '-t':
	    tagstr = '\t#' + opt[1]
	if opt[0] == '-h':
	    usage()
	
	

    if len(args):
	#print args
	path, data, ymin, ymax = get_data(args)
	#print path
    else:
	usage()

    if not scalef:

        if low == None:
            print 'Low defaulting to 0.0'
            low = 0.0

        if high == None:
            print 'Must specify scale factor or highest value of desired range'
            usage()

        reqr = high - low
        r = ymax - ymin
        scalef = reqr/r

    else:

        low = scalef*ymin
        high = scalef*ymax

    print  'scaling by %.6f' % (scalef)

    outfnm = path + '.yscalef.%f-%f' % (low, high)
    f = open(outfnm, 'w')

    f.write('# %s - y axis scaled by a factor of %f\n' % (path, scalef))

    for d in data:
	f.write('%f\t%f%s\n' % (d[0], d[1]*scalef, tagstr))

    f.close()

	

    return
	    
	     
##############################################################################


# Call main when run as script
if __name__ == '__main__':
        main()
