###############################################################################
#                                                                             #
#   Copyright 2005 University of Cambridge Computer Laboratory.               #
#                                                                             #
#   This file is part of Nprobe.                                              #
#                                                                             #
#   Nprobe is free software; you can redistribute it and/or modify            #
#   it under the terms of the GNU General Public License as published by      #
#   the Free Software Foundation; either version 2 of the License, or         #
#   (at your option) any later version.                                       #
#                                                                             #
#   Nprobe is distributed in the hope that it will be useful,                 #
#   but WITHOUT ANY WARRANTY; without even the implied warranty of            #
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             #
#   GNU General Public License for more details.                              #
#                                                                             #
#   You should have received a copy of the GNU General Public License         #
#   along with Nprobe; if not, write to the Free Software                     #
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA #
#                                                                             #
###############################################################################


#
# Values for packet marker field used by np_TCP.py, np_Obnode.py
#

P_FIRST = 0x1 # first this dir'n
P_SEQ_HELD = 0x100 # oo packet held

P_REL_BOSS_CWND = 0x1000 # cwnd limits
P_PHASE_SS = 0x2000 # cwnd < ssthresh

P_SEQ_OLAP = 0x10000
P_SEQ_RTMT = 0x20000
P_BOGUS_ACK = 0x40000

# first of req/resp
P_RFIRST = 0x100000
P_RLAST = 0x200000

##############################################################################
##############################################################################

## Packet despatch triggers (field: trig)

TRIG_RTT_INVALID = 0x1

TRIG_CAUSE_LATER = 0x10

TRIG_ACK         = 0x20  # normal ack
TRIG_SYNACK      = 0x40  # SYNACK
TRIG_FINACK      = 0x80  # FINACK
TRIG_DEL_ACK     = 0x100  # delayed ack
TRIG_REL         = 0x200  # released by ACK arrival
TRIG_PREV        = 0x400 # just follows previous

TRIG_RESP_FIRST  = 0x1000 # first response
TRIG_RESP_DEL    = 0x2000 # response released by end of request arriving
TRIG_RESP_Q      = 0x4000 # response queued - released by end of previous response
TRIG_RESP_REL    = 0x8000 # response released by ACK

TRIG_REQ_DEL     = 0x10000 # request released by last response arriving
TRIG_REQ_Q       = 0x20000 # request queued - released by end of previous request
TRIG_REQ_FIRST   = 0x40000
TRIG_REQ_REL     = 0x80000 # request released by ACK

TRIG_SERV_DEL    = 0x100000 # unaccounted server delay
TRIG_CLI_DEL    = 0x200000 # unaccounted client delay

TRIG_NOT_RTT = (TRIG_RTT_INVALID | TRIG_CAUSE_LATER | TRIG_DEL_ACK | TRIG_RESP_FIRST | TRIG_RESP_DEL | TRIG_RESP_Q | TRIG_REQ_DEL | TRIG_REQ_Q | TRIG_REQ_FIRST | TRIG_SERV_DEL | TRIG_CLI_DEL)

# triggers giving a valid prtt
TRIG_RTT = (TRIG_ACK | TRIG_SYNACK | TRIG_FINACK | TRIG_REL | TRIG_RESP_REL | TRIG_REQ_REL)
#TRIG_RTT = (TRIG_ACK | TRIG_FINACK | TRIG_REL | TRIG_RESP_REL | TRIG_REQ_REL)

# triggers involving delay contributing to apparent prtt
TRIG_RTT_DEL = (TRIG_DEL_ACK | TRIG_RESP_FIRST | TRIG_RESP_DEL | TRIG_REQ_DEL)

# triggers involving delay not part of apparent prtt
TRIG_DEL = (TRIG_RESP_Q | TRIG_REQ_Q | TRIG_REQ_FIRST | TRIG_SERV_DEL | TRIG_CLI_DEL)

# ACK triggers
ACK_TRIG = (TRIG_ACK | TRIG_SYNACK | TRIG_FINACK | TRIG_DEL_ACK)

# Segment triggers
SEG_TRIG = (TRIG_RESP_FIRST | TRIG_REL | TRIG_RESP_DEL | TRIG_RESP_Q | TRIG_RESP_REL | TRIG_REQ_DEL | TRIG_REQ_Q | TRIG_REQ_FIRST | TRIG_REQ_REL | TRIG_SERV_DEL | TRIG_CLI_DEL)

# Catch everything
TRIG_ALL = 0xffffffff

##############################################################################

#
#define TCP hdr flags
#

TH_FIN = 0x01
TH_SYN = 0x02
TH_RST = 0x04
TH_PUSH = 0x08
TH_ACK = 0x10
TH_URG = 0x20

##############################################################################
##############################################################################






##############################################################################
