#!/usr/bin/python
#
# Combine CDFs as output from cksumck. Input files listed on command line,
# output on stdout.
#
# $Id: combine-cdf.py,v 1.1 2004/11/09 16:15:47 jrb44 Exp $
#
# $Log: combine-cdf.py,v $
# Revision 1.1  2004/11/09 16:15:47  jrb44
# Initial revision
#

import string, sys

v = {}
count = 0L

for arg in sys.argv[1:]:
    fh = open(arg, "r")
    while 1:
        line = fh.readline()
        if not line: break
        ll = string.split(line)
        val = int(ll[0])
        num = long(ll[2])
        if not v.has_key(val): v[val] = 0L
        v[val] = v[val] + num
        count = count+num
    fh.close();

vkeys = v.keys()
vkeys.sort()
num = 0L
for val in vkeys:
    num = num + v[val]
    print val, float(num)/float(count), v[val]

# End of $RCSfile: combine-cdf.py,v $
