/*
 * A tool to check checksum integrity and gather simple traffic statistics.
 *
 * James Bulpin, October 2004.
 *
 * (C) University of Cambridge 2004.
 *
 * $Id: cksumck.h,v 1.1 2004/11/09 16:15:47 jrb44 Exp $
 *
 * $Log: cksumck.h,v $
 * Revision 1.1  2004/11/09 16:15:47  jrb44
 * Initial revision
 *
 *
 */

#ifndef CKSUMCK_H
#define CKSUMCK_H

#define STOP_ON_CHKSUM_FAIL
#define USE_REASSEMBLED_DATAGRAMS

#define REASSEMBLED_PACKET 0xdeadbeef

#define LL_HDR_LEN ll_hdr_len
#define EXTRACT_IPHDR(_sp) ((ipheader_t *)((_sp) + LL_HDR_LEN))

extern void cksumck_callback(u_char                   *user,
                             const struct pcap_pkthdr *h,
                             const u_char             *sp);

#endif /* CKSUMCK_H */

/* End of $RCSfile: cksumck.h,v $ */
