
############################################################################
# Package database for ccore
#
# This may look like source code, but it is actually the build system
# database format. You may edit this file, but only semantic changes will
# be kept the next time this file is automatically regenerated.
#

from nemclasses import *

items = []
associated_cpp_name = 'associated_cpp_name'
binobject = 'binobject'
bloblist = 'bloblist'
contents = 'contents'
description = 'description'
doctext = 'doctext'
env = 'env'
exports = 'exports'
growrecursive = 'growrecursive'
helptext = 'helptext'
makefileflags = 'makefileflags'
package = 'package'
path = 'path'
qos = 'qos'
requires = 'requires'
section = 'section'
system_interfaces = 'system_interfaces'
tweakability = 'tweakability'
type = 'type'
value = 'value'



#######################################################################
# Busses (1 items)


items = items + [
PureConfiguration('tc_bus', {
  associated_cpp_name : 'TC',
  description : 'TC bus support',
  doctext : 'The TC bus is deemed to be present on AXP3000 targets. It is autoconfigured.',
  package : 'ccore',
  requires : ['axp3000_target'],
  section : 'Busses',
  tweakability : 0,
  type : 'bool',
  value : 1,
}),

]




#######################################################################
# Char (3 items)


items = items + [
AutoModule('ns16550_serial', {
  associated_cpp_name : 'NS16550_SERIAL_ANON',
  contents : {'dev/isa/ns16550':['serial.c', 'readers.c', 'Serial_st.h', 'SerialMod.if'],},
  description : 'Driver for NS16550 serial devices',
  makefileflags : {'libio':1,},
  package : 'ccore',
  path : 'dev/isa/ns16550',
  requires : [],
  section : 'Char',
  system_interfaces : ['SerialMod.if'],
  type : 'quad',
  value : 3,
}),

AutoModule('ps2', {
  associated_cpp_name : 'PS2_ANON',
  contents : {'dev/isa/ps2':['table.c', 'ps2_st.h', 'ps2.c'],},
  description : 'PS2 keyboard and mouse driver',
  makefileflags : {'libio':1,},
  qos : {'extra':1,'latency':'200us','period':'2ms','slice':'200us'},
  package : 'ccore',
  path : 'dev/isa/ps2',
  requires : ['isa'],
  section : 'Char',
  type : 'quad',
  value : 2,
}),

PureConfiguration('serial_mouse', {
  associated_cpp_name : 'SERIALMOUSE',
  description : 'Serial mouse translator support in serial driver',
  helptext : 'Add a module to the system that is used by (some of the) serial drivers to detect and, if found, export a mouse service as dev>mouse_serial. This deos not conflict with the PS2 mouse support in the PS2 driver, as clients can choose between either service if both are available. There is consequently no reason to turn this off unless you never plan to use a serial mouse.',
  package : 'ccore',
  requires : ['ix86_arch'],
  section : 'Char',
  type : 'bool',
  value : 1,
}),

]




#######################################################################
# Kernel (41 items)


items = items + [

PureConfiguration('binder', {
  associated_cpp_name : 'BINDER',
  description : 'Binder IDC mode',
  helptext : 'The standard IDC mode uses custom IDC buffers & connection setup for each domains connection to the Binder. The experimental mode multiplexes other services over this same binding (viz. the stretch allocator and the frame stack). Required for the experimental memory system, optional for others.',
  package : 'ccore',
  requires : [],
  section : 'Kernel',
  tweakability : 1,
  type : [(1, 'Standard', 'STD'), (1, 'Experimental', 'MUX')],
  value : 0,
}),

PureConfiguration('bootloader', {
  associated_cpp_name : 'BOOTLOADER',
  description : 'Build a Nemesis boot loader',
  helptext : 'Build a Nemesis image that can be used as a bootloader',
  package : 'ccore',
  requires : [],
  section : 'Kernel',
  tweakability : 2,
  type : 'bool',
  value : 0,
}),

PureConfiguration('callpriv', {
  associated_cpp_name : 'CALLPRIV',
  description : 'Callpriv support',
  helptext : 'Implements a mechanism to allow trusted code to register pseudo opcodes with the NTSC that may be used by non-trusted applications. Used by the framebuffer device driver and a few other bits and pieces. Highly recommended, as it is necessary for the windowing system.',
  package : 'ccore',
  requires : [],
  section : 'Kernel',
  tweakability : 1,
  type : 'bool',
  value : 1,
}),

PureConfiguration('console_banner', {
  associated_cpp_name : 'CONSOLE_BANNER',
  description : 'Console banner',
  helptext : 'Output kernel messages on to the VGA text mode screen',
  package : 'ccore',
  requires : ['local_echo'],
  section : 'Kernel',
  tweakability : 1,
  type : 'bool',
  value : 1,
}),

PureConfiguration('fp_support', {
  associated_cpp_name : 'FP_SUPPORT',
  description : 'Machine property FP_SUPPORT',
  package : 'ccore',
  requires : [],
  section : 'Kernel',
  tweakability : 1,
  type : 'bool',
  value : 0,
}),

PureConfiguration('isa', {
  associated_cpp_name : 'ISA',
  description : 'Machine property ISA',
  package : 'ccore',
  requires : [],
  section : 'Kernel',
  tweakability : 1,
  type : 'bool',
  value : 1,
}),

PureConfiguration('kgdb', {
  associated_cpp_name : 'KGDB',
  description : 'Kernel Debugging of Apps',
  helptext : 'This option determines the behaviour when an application causes an unrecoverable memory fault. If True, then the kernel debugger will be entered; if False, the domain will receive the fault as an event, and either terminate itself or enter a user-level debugger. Currently defaults to True since user-level debugging requires more work. Should be set to False for demo trees though so that domains simply die rather than halting the machine.',
  package : 'ccore',
  requires : [],
  section : 'Kernel',
  tweakability : 1,
  type : 'bool',
  value : 1,
}),

PureConfiguration('local_echo', {
  associated_cpp_name : 'LOCAL_ECHO',
  description : 'Local VGA text mode output',
  helptext : 'Output kernel messages on to the VGA text mode screen',
  package : 'ccore',
  requires : ['vga_text_mode'],
  section : 'Kernel',
  tweakability : 1,
  type : 'bool',
  value : 1,
}),

PureConfiguration('memctxts', {
  associated_cpp_name : 'MEMCTXTS',
  description : 'Support for proc>meminfo and proc>domains>d0...0x>mem',
  helptext : 'With this option, the stretch allocator maintains information about each stretch created in a publically readable context, proc>meminfo. In addition, the same information is kept per domain in the proc>domains>DOMAINID>mem context. Hence nashmod is able to list the amount of memory each domain is using in the ps command, and (in principle) a GUI interface could also be constructed. The down side: overhead of another 8-12 words space per stretch.',
  package : 'ccore',
  requires : [],
  section : 'Kernel',
  tweakability : 1,
  type : 'bool',
  value : 1,
}),

PureConfiguration('memsys', {
  associated_cpp_name : 'MEMSYS',
  description : 'Memory System',
  helptext : 'Selects memory system to use. STD is the default, with EXPTbeing somewhat experimental.',
  package : 'ccore',
  requires : [],
  section : 'Kernel',
  tweakability : 1,
  type : [(1, 'standard', 'STD'), (1, 'experimental', 'EXPT')],
  value : 0,
}),

PureConfiguration('module_offset_hack', {
  associated_cpp_name : 'MODULE_OFFSET_DATA',
  description : 'Store module offsets at a well known address',
  helptext : 'Used for dynamic debugging. Requires a well known address, at present only avaiable on IX86 and Alpha machines',
  package : 'ccore',
  requires : [],
  section : 'Kernel',
  tweakability : 1,
  type : 'bool',
  value : 1,
}),

PureConfiguration('nopriv_create', {
  associated_cpp_name : 'NOPRIV_CREATE',
  description : 'Allow arbitary creation of priviledeged domains',
  helptext : 'Relaxes an alledged security feature of Nemesis; with this option off, unprivileged domains can create privileged ones. With this option on, they can, so Nash for instance need not have kernel privileges and yet still be able to execute domains with kernel privileges. Highly recommended, as Nemesis is not even vaguley secure with this turned off, just more tricky to use.',
  package : 'ccore',
  requires : [],
  section : 'Kernel',
  tweakability : 1,
  type : 'bool',
  value : 1,
}),

PureConfiguration('ns16550_serial_device', {
  associated_cpp_name : 'NS16550_SERIAL_DEVICE',
  description : 'Machine property NS16550_SERIAL_DEVICE',
  package : 'ccore',
  requires : [],
  section : 'Kernel',
  tweakability : 1,
  type : 'bool',
  value : 1,
}),

PureConfiguration('page_tables', {
  associated_cpp_name : 'PTAB',
  description : 'Page Tables',
  package : 'ccore',
  requires : [('memsys', 1), 'eb164_target'],
  section : 'Kernel',
  tweakability : 1,
  type : [(0, 'off', 'OFF'), (1, 'linear', 'LINEAR'), (1, 'guarded', 'GPT')],
  value : 2,
}),

PureConfiguration('pci', {
  associated_cpp_name : 'PCI',
  description : 'Machine property PCI',
  package : 'ccore',
  requires : [],
  section : 'Kernel',
  tweakability : 0,
  type : 'bool',
  value : 1,
}),

PureConfiguration('qosctl', {
  associated_cpp_name : 'QOSCTL',
  description : 'NTSC CPU Scheduler Qos Control interface',
  helptext : 'Causes running totals to be kept on scheduling domain activity, and exports an interface to the scheduler allowing this information to be retreived and allowing QoS parameters of domains to be selected. QosCtls are also exported by QoSEntrys, allowing similar querying and manipulation of bulk IO. Recommended, as it costs very little and enables qosbars to be used.',
  package : 'ccore',
  requires : [],
  section : 'Kernel',
  tweakability : 1,
  type : 'bool',
  value : 1,
}),

PureConfiguration('rc_outside_kernel', {
  associated_cpp_name : 'RC_OUTSIDE_KERNEL',
  description : 'Read init.rc outside of the Nemesis domain',
  helptext : 'Places the code to read init.rc outside of the Nemesis domain',
  package : 'ccore',
  requires : [],
  section : 'Kernel',
  tweakability : 1,
  type : 'bool',
  value : 0,
}),

PureConfiguration('serial_echo', {
  associated_cpp_name : 'SERIAL_ECHO',
  description : 'Echo console messages on >dev>serial0',
  helptext : 'Causes all output to be sent by default down the serial lines. If you use serial lines for tracing, say yes. You are better off without it if you have some alternative means of getting tracing, as writing to the serial line causes a fair bit of blocking.',
  package : 'ccore',
  requires : [],
  section : 'Kernel',
  tweakability : 1,
  type : 'bool',
  value : 1,
}),

PureConfiguration('startofday_tracing', {
  associated_cpp_name : 'START_OF_DAY_TRACING',
  description : 'Start of day tracing',
  helptext : 'Select this to turn on start of day tracing.',
  package : 'ccore',
  requires : [],
  section : 'Kernel',
  tweakability : 0,
  type : [(0, 'None', '0'), (1, 'Headings', '1'), (1, 'Subheadings', '2'), (1, 'Data', '3'), (1, 'Volumous_data', '4')],
  value : 0,
}),

PureConfiguration('timer_rdtsc', {
  associated_cpp_name : 'TIMER_RDTSC',
  description : 'Machine property TIMER_RDTSC',
  package : 'ccore',
  requires : [],
  section : 'Kernel',
  tweakability : 1,
  type : 'bool',
  value : 0,
}),

PureConfiguration('trader_outside_kernel', {
  associated_cpp_name : 'TRADER_OUTSIDE_KERNEL',
  description : 'Run the trader outside of the Nemesis domain',
  helptext : 'Places the trader outside of the Nemesis domain',
  package : 'ccore',
  requires : [],
  section : 'Kernel',
  tweakability : 1,
  type : 'bool',
  value : 0,
}),

PureConfiguration('vga_text_mode', {
  associated_cpp_name : 'VGA_TEXT_MODE',
  description : 'Machine property VGA_TEXT_MODE',
  package : 'ccore',
  requires : [],
  section : 'Kernel',
  tweakability : 1,
  type : 'bool',
  value : 0,
}),

]




#######################################################################
# Measure (4 items)


items = items + [
PureConfiguration('measure_demo', {
  associated_cpp_name : 'MEASURE_DEMO',
  description : 'Demonstration of Measure',
  helptext : 'Includes the programs qosmeasure, xmarkov & xjd which demonstrate how you can measure domains & set their slice based on the estimated effective service rate',
  package : 'ccore',
  requires : ['measure_kernel_accounting'],
  section : 'Measure',
  tweakability : 2,
  type : 'bool',
  value : 0,
}),

PureConfiguration('measure_kernel_accounting', {
  associated_cpp_name : 'MEASURE_KERNEL_ACCOUNTING',
  description : 'Kernel support for measure',
  helptext : 'Adds a reasonable level of kernel accounting to enable the measure system to function.  Required for the measure demo and also the test rig',
  package : 'ccore',
  requires : [],
  section : 'Measure',
  tweakability : 2,
  type : 'bool',
  value : 0,
}),

PureConfiguration('measure_rpc', {
  associated_cpp_name : 'MEASURE_RPC',
  description : 'Remote control of measure',
  helptext : 'Includes the test domains (CBR, markov, JPEG & while) and the abillity to control these domains remotely (via Austin RPC), as will as control the logs taken.',
  package : 'ccore',
  requires : ['measure_kernel_accounting'],
  section : 'Measure',
  tweakability : 2,
  type : 'bool',
  value : 0,
}),

PureConfiguration('measure_trace', {
  associated_cpp_name : 'MEASURE_TRACE',
  description : 'Measure Trace support',
  helptext : 'Causes detailed accounting logs to be made by the NTSC CPU scheduler. These are were used by the Measure project to figure out exactly what was going on in the system. Not recommended unless you need it as the log taking is rather expensive.',
  package : 'ccore',
  requires : [],
  section : 'Measure',
  tweakability : 2,
  type : 'bool',
  value : 0,
}),

]




#######################################################################
# Services (16 items)


items = items + [
AutoModule('RSSMonitor', {
  associated_cpp_name : 'RSSMONITOR',
  description : 'Routines to monitor the number of stretches in a certain page',
  doctext : 'Resident Set Size monitoring routines',
  package : 'ccore',
  path : 'mod/rssmonitor',
  requires : [('memsys', 1)],
  system_interfaces : ['RSSMonitor.if', 'RSSMonitorMod.if'],
  tweakability : 1,
  type : 'quad',
  value : 3,
  }),

AutoModule('CSIDCTransport', {
  associated_cpp_name : 'CSIDC',
  contents : {'mod/nemesis/csidc':['csidc.c', 'Makefile', 'CSIDCTransport.if', 'CSClientStubMod.if'],},
  description : 'CSIDCTransport',
  doctext : 'Custom-stub IDC transport',
  package : 'ccore',
  path : 'mod/nemesis/csidc',
  requires : [],
  section : 'Services',
  system_interfaces : ['CSIDCTransport.if', 'CSClientStubMod.if'],
  tweakability : 1,
  type : 'quad',
  value : 3,
}),

AutoModule('PCI', {
  associated_cpp_name : 'PCI_CODE',
  contents : {'mod/pci':['pci_st.h', 'pci.c', 'intel_bios32.c', 'bios32.h', 'alpha_bios32.c', 'alcor.c', 'PCIBiosMod.if', 'PCIBiosMod.c', 'PCIBios.if', 'Makefile'],},
  description : 'PCI',
  makefileflags : {'custom':1,},
  package : 'ccore',
  path : 'mod/pci',
  requires : ['pci'],
  section : 'Services',
  system_interfaces : ['PCIBios.if', 'PCIBiosMod.if'],
  tweakability : 1,
  type : 'quad',
  value : 3,
}),

AutoModule('RTC', {
  associated_cpp_name : 'RTC',
  contents : {'dev/isa/mc146818':['RTC.c'],},
  description : 'Driver for Motorola mc146818 and clones',
  makefileflags : {'libio':1,},
  package : 'ccore',
  path : 'dev/isa/mc146818',
  requires : ['isa'],
  section : 'Services',
  tweakability : 1,
  type : 'quad',
  value : 2,
}),

AutoModule('Spawn', {
  associated_cpp_name : 'SPAWN',
  contents : {'mod/nemesis/spawn':['spawn.c', 'SpawnReturn.if', 'SpawnMod.if', 'SpawnMarshal.c', 'Spawn.if'],},
  description : 'Spawn',
  doctext : 'Spawn new domains',
  package : 'ccore',
  path : 'mod/nemesis/spawn',
  requires : [],
  section : 'Services',
  system_interfaces : ['SpawnMod.if', 'Spawn.if', 'SpawnReturn.if'],
  tweakability : 1,
  type : 'quad',
  value : 3,
}),

AutoModule('Stubs', {
  associated_cpp_name : 'STATIC_STUBS',
  contents : {'mod/nemesis/stubs':['stubs.h', 'stubs.c', 'genstubs', 'Makefile', 'IDC_CS_ConsoleWr.c'],},
  description : 'Static stubs',
  helptext : 'Include static stubs',
  makefileflags : {'custom':1,},
  package : 'ccore',
  path : 'mod/nemesis/stubs',
  requires : [],
  section : 'Services',
  tweakability : 1,
  type : 'quad',
  value : 3,
}),

AutoModule('TypeSystem', {
  associated_cpp_name : 'TYPESYSTEM',
  contents : {'sys/typesystem':['TypeSystemMod.if', 'TypeSystemF.if', 'TypeSystem.if', 'TypeSystem.c', 'Type.if', 'Record.if', 'Operation.if', 'Operation.c', 'Interface.if', 'Interface.c', 'IREF.def.c', 'Enumeration.c', 'Enum.if', 'Choice.if'],},
  description : 'TypeSystem',
  helptext : 'The typesystem. Essential (?)',
  package : 'ccore',
  path : 'sys/typesystem',
  requires : [],
  section : 'Services',
  system_interfaces : ['Choice.if', 'Enum.if', 'Interface.if', 'Operation.if', 'Record.if', 'Type.if', 'TypeSystem.if', 'TypeSystemF.if', 'TypeSystemMod.if'],
  tweakability : 0,
  type : 'quad',
  value : 3,
}),

AutoModule('binloader', {
  associated_cpp_name : 'OBJ_LOADER',
  contents : {'mod/loader':['relocation_aout.h', 'relocate_alpha.h', 'relocate_alpha.c', 'load_ix86.c', 'load_alpha.c', 'load.h', 'exec.c', 'Makefile'],},
  description : 'ELF/ECOFF dynamic object file loader',
  helptext : 'This enables a module that implements the Load interface for ELF or ECOFF binaries',
  makefileflags : {'custom':1,},
  package : 'ccore',
  path : 'mod/loader',
  requires : ['loader'],
  section : 'Services',
  tweakability : 1,
  type : 'quad',
  value : 3,
}),

AutoModule('clanger', {
  associated_cpp_name : 'CLANGER',
  contents : {'mod/clanger':['clangermod.c', 'clanger.c', 'cexec_st.h', 'cexec.c', 'bison.nemesis', 'Nodes.c', 'Makefile', 'Lexer.c', 'Interp.c', 'Functions.c', 'Clanger_st.h', 'ClangerMod.if', 'Clanger.if', 'Clammar.y', 'CExec.if'],},
  description : 'clanger, the nemesis interpreted scripting language.',
  helptext : 'This is required for the RC application and nash; it is hard to build a system without it.',
  makefileflags : {'custom':1,},
  package : 'ccore',
  path : 'mod/clanger',
  requires : [],
  section : 'Services',
  system_interfaces : ['Clanger.if', 'ClangerMod.if', 'CExec.if'],
  tweakability : 1,
  type : 'quad',
  value : 3,
}),

AutoModule('cline', {
  associated_cpp_name : 'CLINE',
  contents : {'mod/cline':['cline.c', 'CLineCtl.if', 'CLine.if'],},
  description : 'cline',
  package : 'ccore',
  path : 'mod/cline',
  requires : [],
  section : 'Services',
  system_interfaces : ['CLine.if', 'CLineCtl.if'],
  tweakability : 1,
  type : 'quad',
  value : 2,
}),

PureConfiguration('heap_paranoia', {
  associated_cpp_name : 'HEAP_PARANOIA',
  description : 'Support for catching heap trashing',
  package : 'ccore',
  requires : [],
  section : 'Services',
  tweakability : 2,
  type : [(0, 'None', 'NONE'), (1, 'Allocation PC', 'PC'), (1, 'Headers', 'HEADERS'), (1, 'Free Blocks', 'FREE')],
  value : 2,
}),

PureConfiguration('loader', {
  associated_cpp_name : 'LOADER',
  description : 'Loading support',
  helptext : 'This enables dynamic loading support.',
  package : 'ccore',
  requires : [],
  section : 'Services',
  tweakability : 1,
  type : 'bool',
  value : 1,
}),

PureConfiguration('nashlogin', {
  associated_cpp_name : 'NASHLOGIN',
  description : 'Use nash as a login',
  helptext : 'Enable this to cause nash to ask you for a login and password',
  package : 'ccore',
  requires : [],
  section : 'Services',
  tweakability : 2,
  type : 'bool',
  value : 0,
}),

AutoModule('nashmod', {
  associated_cpp_name : 'NASHMOD',
  contents : {'mod/nashmod':['profile.nash', 'nashst.h', 'commands.c', 'boot.c', 'autoexec.nash', 'NashMod.if', 'NashMod.c', 'Nash.if', 'Nash.c'],},
  description : 'nash, the NAsty Shell, interpreter module',
  helptext : 'invoked by standard.rc to execute autoexec.nash',
  makefileflags : {'install':['profile.nash', 'autoexec.nash'],},
  package : 'ccore',
  path : 'mod/nashmod',
  requires : [],
  section : 'Services',
  system_interfaces : ['Nash.if', 'NashMod.if'],
  tweakability : 1,
  type : 'quad',
  value : 3,
}),

AutoModule('rpc', {
  associated_cpp_name : 'RPC',
  contents : {'mod/nemesis/rpc':['RPCTransport.if', 'RPCTransport.h', 'RPCTransport.c', 'RPCMod.if', 'RPCMarshal.c', 'Bouncer.if'],},
  description : 'rpc',
  package : 'ccore',
  path : 'mod/nemesis/rpc',
  requires : ['stubgen'],
  section : 'Services',
  system_interfaces : ['RPCMod.if', 'RPCTransport.if', 'Bouncer.if'],
  tweakability : 2,
  type : 'quad',
  value : 0,
}),

PureConfiguration('serial_split', {
  associated_cpp_name : 'SERIAL_SPLIT',
  description : 'Set high bit on user output',
  helptext : 'Emulate two serial lines over serial0 by setting the top bit on user-level output. Intel only, for the moment.',
  package : 'ccore',
  requires : ['intel_target'],
  section : 'Services',
  tweakability : 2,
  type : 'bool',
  value : 0,
}),

AutoModule('stubgen', {
  associated_cpp_name : 'STUBGEN',
  contents : {'mod/nemesis/sgen':['synthgen.c', 'stubgen.h', 'stubgen.c', 'stackframe.h', 'ix86_synth.c', 'ix86_stubs.S', 'engine.c', 'canned_stubs.c', 'arm_stubs.S', 'alpha_synth.c', 'alpha_stubs.S', 'StubGen.if', 'Makefile', 'IDCMarshalCtl.if'],},
  description : 'stubgen',
  makefileflags : {'custom':1,},
  package : 'ccore',
  path : 'mod/nemesis/sgen',
  requires : [],
  section : 'Services',
  system_interfaces : ['StubGen.if', 'IDCMarshalCtl.if'],
  tweakability : 1,
  type : 'quad',
  value : 3,
}),

]




#######################################################################
# Standard (27 items)


items = items + [
AutoModule('Builder', {
  associated_cpp_name : 'BUILDER',
  contents : {'mod/nemesis/builder':['Builder.c'],},
  description : 'Builder',
  doctext : 'The domain builder.',
  package : 'ccore',
  path : 'mod/nemesis/builder',
  requires : [],
  section : 'Standard',
  tweakability : 1,
  type : 'quad',
  value : 3,
}),

AutoModule('Context', {
  associated_cpp_name : 'CONTEXT',
  contents : {'mod/nemesis/context':['util.c', 'MergedContext.if', 'ContextUtil.if', 'ContextMod.if', 'Context.c'],},
  description : 'Context',
  doctext : 'Various implementations of the Context module.',
  package : 'ccore',
  path : 'mod/nemesis/context',
  requires : [],
  section : 'Standard',
  system_interfaces : ['ContextUtil.if', 'ContextMod.if', 'MergedContext.if'],
  tweakability : 1,
  type : 'quad',
  value : 3,
}),

AutoModule('Domains', {
  associated_cpp_name : 'DOMAINS',
  contents : {'sys/domains':['security.c', 'sched_intel.c', 'sched_intel-smp.c', 'sched_arm.c', 'sched_alpha.c', 'sched.c', 'Plumber.c', 'Makefile', 'DomainMgr_st.h', 'DomainMgrMod.if', 'DomainMgr.if', 'DomainMgr.c', 'Domain.if', 'Binder.c'],},
  description : 'Domains',
  makefileflags : {'custom':1,},
  package : 'ccore',
  path : 'sys/domains',
  requires : [],
  section : 'Standard',
  system_interfaces : ['Domain.if', 'DomainMgr.if', 'DomainMgrMod.if'],
  tweakability : 1,
  type : 'quad',
  value : 3,
}),

AutoModule('Exception', {
  associated_cpp_name : 'EXCEPTION',
  contents : {'mod/nemesis/exception':['ExnSetjmpMod.c'],},
  description : 'Exception',
  doctext : 'Exception handling library routines.',
  package : 'ccore',
  path : 'mod/nemesis/exception',
  requires : [],
  section : 'Standard',
  tweakability : 1,
  type : 'quad',
  value : 3,
}),

AutoModule('HeapMod', {
  associated_cpp_name : 'HEAPMOD',
  contents : {'mod/nemesis/heap':['heapmod.c'],},
  description : 'HeapMod',
  doctext : 'A decent Heap implementation.',
  package : 'ccore',
  path : 'mod/nemesis/heap',
  requires : [],
  section : 'Standard',
  tweakability : 1,
  type : 'quad',
  value : 3,
}),

AutoModule('IDC', {
  associated_cpp_name : 'IDC',
  contents : {'mod/nemesis/idc':['callback.c', 'ShmTransport.c', 'ShmMarshal.c', 'ObjectTbl.c', 'IDCOfferMod.c'],},
  description : 'IDC',
  doctext : 'Various IDC transports and associated routines.',
  package : 'ccore',
  path : 'mod/nemesis/idc',
  requires : [],
  section : 'Standard',
  tweakability : 1,
  type : 'quad',
  value : 3,
}),

AutoModule('IO', {
  associated_cpp_name : 'IO',
  contents : {'mod/nemesis/io':['fifo.h', 'IOTransport.c', 'IOMod.c', 'IOEntry.c', 'FIFOMod.c'],},
  description : 'IO',
  package : 'ccore',
  path : 'mod/nemesis/io',
  requires : [],
  section : 'Standard',
  tweakability : 1,
  type : 'quad',
  value : 3,
}),

AutoModule('IntfTypes', {
  associated_cpp_name : 'INTFTYPES',
  contents : {'repo':['Makefile'],},
  description : 'IntfTypes',
  makefileflags : {'custom':1,},
  package : 'ccore',
  path : 'repo',
  requires : [],
  section : 'Standard',
  tweakability : 1,
  type : 'quad',
  value : 3,
}),

AutoModule('Nemesis', {
  associated_cpp_name : 'NEMESIS',
  contents : {'sys/nemesis':['schedctl.c', 'misc.h', 'klogd.h', 'klogd.c', 'Trader.c', 'Nemesis.c', 'NTSC.if', 'NTSC.c', 'ModData.if', 'ModData.c', 'IntAlloc.c', 'ConsoleControl.if', 'Console.h', 'Console.c', 'CallPriv.c'],},
  description : 'Nemesis',
  makefileflags : {'libdebug':1,},
  package : 'ccore',
  path : 'sys/nemesis',
  requires : [],
  section : 'Standard',
  system_interfaces : ['NTSC.if', 'ConsoleControl.if', 'ModData.if'],
  tweakability : 1,
  type : 'quad',
  value : 3,
}),

AutoModule('RdWr', {
  associated_cpp_name : 'RDWR',
  contents : {'mod/nemesis/rdwr':['pipe.c', 'null.c', 'mod.c', 'join.c', 'RdWrMod.if', 'MemRd.c'],},
  description : 'Tools for manipulating readers and writers',
  package : 'ccore',
  path : 'mod/nemesis/rdwr',
  requires : [],
  section : 'Standard',
  system_interfaces : ['RdWrMod.if'],
  tweakability : 1,
  type : 'quad',
  value : 3,
}),

AutoModule('RedirRdWr', {
  associated_cpp_name : 'REDIRRDWR',
  contents : {'mod/nemesis/redir':['wr.c', 'rd.c'],},
  description : 'RedirRdWr',
  package : 'ccore',
  path : 'mod/nemesis/redir',
  requires : ['net_console'],
  section : 'Standard',
  tweakability : 1,
  type : 'quad',
  value : 3,
}),

AutoModule('Tables', {
  associated_cpp_name : 'TABLES',
  contents : {'mod/nemesis/tables':['WordTblMod.if', 'WordTblMod.c', 'WordTblIter.if', 'WordTbl.if', 'StringTblMod.if', 'StringTblMod.c', 'StringTblIter.if', 'StringTbl.if', 'StretchTblMod.if', 'StretchTblMod.c', 'StretchTbl.if', 'LongCardTblMod.if', 'LongCardTblMod.c', 'LongCardTblIter.if', 'LongCardTbl.if'],},
  description : 'Tables',
  doctext : 'Various kinds of hash table implementations.',
  package : 'ccore',
  path : 'mod/nemesis/tables',
  requires : [],
  section : 'Standard',
  system_interfaces : ['LongCardTbl.if', 'LongCardTblIter.if', 'LongCardTblMod.if', 'StretchTblMod.if', 'StretchTbl.if', 'StringTbl.if', 'StringTblIter.if', 'StringTblMod.if', 'WordTbl.if', 'WordTblIter.if', 'WordTblMod.if'],
  tweakability : 1,
  type : 'quad',
  value : 3,
}),

AutoModule('activations', {
  associated_cpp_name : 'ACTIVATIONS',
  contents : {'mod/nemesis/activations':['activations.c'],},
  description : 'activations',
  doctext : 'Activation handling routines.',
  package : 'ccore',
  path : 'mod/nemesis/activations',
  requires : [],
  section : 'Standard',
  tweakability : 1,
  type : 'quad',
  value : 3,
}),

AutoModule('entry', {
  associated_cpp_name : 'ENTRY',
  contents : {'mod/nemesis/entry':['entry.c'],},
  description : 'entry',
  doctext : 'ANSA style entries',
  package : 'ccore',
  path : 'mod/nemesis/entry',
  requires : [],
  section : 'Standard',
  tweakability : 1,
  type : 'quad',
  value : 3,
}),

AutoModule('events', {
  associated_cpp_name : 'EVENTS',
  contents : {'mod/nemesis/events':['events.c'],},
  description : 'events',
  doctext : 'Event handling routines.',
  package : 'ccore',
  path : 'mod/nemesis/events',
  requires : [],
  section : 'Standard',
  tweakability : 1,
  type : 'quad',
  value : 3,
}),

AutoModule('gatekeeper', {
  associated_cpp_name : 'GATEKEEPER',
  contents : {'mod/nemesis/gatekeeper':['gatekeeper.c', 'GatekeeperMod.if', 'Gatekeeper.if'],},
  description : 'gatekeeper',
  package : 'ccore',
  path : 'mod/nemesis/gatekeeper',
  requires : [],
  section : 'Standard',
  system_interfaces : ['Gatekeeper.if', 'GatekeeperMod.if'],
  tweakability : 1,
  type : 'quad',
  value : 3,
}),

AutoModule('libc', {
  associated_cpp_name : 'LIBC',
  contents : {'mod/venimpl/c':['jmptbl.c', 'Makefile'],'mod/venimpl/c/math':['sqrt.c', 'pow.c', 'logb.c', 'log__L.c', 'ldexp.c', 'isnan.c', 'isinf.c', 'intmath.c', 'finite.c', 'exp__E.c', 'drem.c', 'copysign.c', 'Makefile'],'mod/venimpl/c/stdio':['vprintf.c', 'sscanf.c', 'sprintf.c', 'scanf.c', 'printf.c', 'fwrite.c', 'fscanf.c', 'fread.c', 'fputs.c', 'fputc.c', 'fprintf.c', 'fopen.c', 'fgets.c', 'fgetc.c', 'fflush.c', 'ferror.c', 'fclose.c', 'doscan.c', 'doprnt.c', 'common-fs.h', 'common-fs.c', 'Makefile'],'mod/venimpl/c/stdlib':['strtoul.c', 'strtou64.c', 'strtol.c', 'strtod.c', 'strto64.c', 'qsort.c', 'malloc.c', 'getenv.c', 'exit.c', 'div.c', 'ctype.c', 'bsearch.c', 'atol.c', 'atoi.c', 'atof.c', 'assert.c', 'abs.c', 'abort.c', 'Makefile'],'mod/venimpl/c/str':['strstr.c', 'strspn.c', 'strsep.c', 'strrchr.c', 'strpbrk.c', 'strncpy.c', 'strncmp.c', 'strncat.c', 'strlen.c', 'strdup.c', 'strcspn.c', 'strcpy.c', 'strcmp.c', 'strchr.c', 'strcat.c', 'memset.c', 'memmove.c', 'memcpy.c', 'memcmp.c', 'memchr.c', '_wordcopy.c', 'Makefile'],},
  description : 'libc',
  makefileflags : {'custom':1,},
  package : 'ccore',
  path : 'mod/venimpl/c',
  requires : [],
  section : 'Standard',
  tweakability : 1,
  type : 'quad',
  value : 3,
}),

AutoModule('memfile', {
  associated_cpp_name : 'MEMFILE',
  contents : {'mod/nemesis/memfile':['MemFileMod.if', 'MemFileMod.c', 'MemFile.if'],},
  description : 'memfile',
  package : 'ccore',
  path : 'mod/nemesis/memfile',
  requires : ['memfile'],
  section : 'Standard',
  system_interfaces : ['MemFileMod.if', 'MemFile.if'],
  tweakability : 1,
  type : 'quad',
  value : 0,
}),

AutoModule('qosentry', {
  associated_cpp_name : 'QOSENTRY',
  contents : {'mod/nemesis/qosentry':['qosentry.c'],},
  description : 'qosentry',
  package : 'ccore',
  path : 'mod/nemesis/qosentry',
  requires : [],
  section : 'Standard',
  tweakability : 1,
  type : 'quad',
  value : 3,
}),

AutoModule('sdriver', {
  associated_cpp_name : 'SDRIVER',
  contents : {'mod/nemesis/sdriver':['stretchdriver.c'],},
  description : 'sdriver',
  package : 'ccore',
  path : 'mod/nemesis/sdriver',
  requires : [('memsys', 1)],
  section : 'Standard',
  tweakability : 1,
  type : 'quad',
  value : 3,
}),

AutoModule('srcthreads', {
  associated_cpp_name : 'SRCTHREADS',
  contents : {'mod/nemesis/srcthreads':['srcthread.c'],},
  description : 'srcthreads',
  doctext : 'More advanced, DEC SRC style threads support',
  package : 'ccore',
  path : 'mod/nemesis/srcthreads',
  requires : [],
  section : 'Standard',
  tweakability : 1,
  type : 'quad',
  value : 3,
}),

AutoModule('stringutil', {
  associated_cpp_name : 'STRINGUTIL',
  contents : {'mod/stringutil':['stringutil.c', 'StringUtil.if'],},
  description : 'stringutil',
  package : 'ccore',
  path : 'mod/stringutil',
  requires : [],
  section : 'Standard',
  system_interfaces : ['StringUtil.if'],
  tweakability : 1,
  type : 'quad',
  value : 3,
}),

AutoModule('threads', {
  associated_cpp_name : 'THREADS',
  contents : {'mod/nemesis/threads':['threads.c', 'thead_mips.S', 'thead_intel.S', 'thead_intel-smp.S', 'thead_arm.S', 'thead_alpha.S', 'stack.h', 'Makefile'],},
  description : 'threads',
  doctext : 'Basic thread handling support',
  makefileflags : {'custom':1,},
  package : 'ccore',
  path : 'mod/nemesis/threads',
  requires : [],
  section : 'Standard',
  tweakability : 1,
  type : 'quad',
  value : 3,
}),

AutoModule('WTime', {
  associated_cpp_name : 'WTIME',
  contents : {'mod/wtime':['Wall_Clock.c'],},
  description : 'WTime.if implementation.',
  package : 'ccore',
  path : 'mod/wtime',
  requires : [],
  section : 'Standard',
  tweakability : 1,
  type : 'quad',
  value : 2,
}),

]




#######################################################################
# Tree (2 items)


items = items + [
PureConfiguration('build_image', {
  associated_cpp_name : 'BUILD_IMAGE',
  description : 'Build a kernel image',
  helptext : 'Deselect this option to disable the construction of a boot image ',
  package : 'ccore',
  requires : [],
  section : 'Tree',
  tweakability : 1,
  type : 'bool',
  value : 1,
}),

Directory('app_test', {
    associated_cpp_name : 'APP_TEST',
    description : 'Test applications',
    growrecursive : 0,
    package : 'ccore',
    requires : [],
    section : 'Tree',
    tweakability : 1,
    type : 'bool',
    value : 1,
    path : 'app/test',
}),

Directory('glue', {
  associated_cpp_name : 'GLUE_ANON',
  contents : {'glue':['tagstodb.py', 'sourcemanager.py', 'regenerate_blueprint.py', 'qosutil.py', 'plumbtree.py', 'nemclasses.py', 'livedbstart', 'livedbend', 'layfoundations.py', 'ifbuildercachetodb.py', 'intfbuilder.py', 'guicompiler.py', 'growtree.py', 'gennbf.py', 'genmakefile.py', 'geninstalllinks.py', 'geninfrastructure.py', 'gengraph.py', 'generic_blueprint.py', 'gendirs.py', 'gendetails.py', 'depsshow.py', 'customizer.py', 'createiflinks.py', 'configutils.py', 'choicesgui.py', 'changeconfig.tcl', 'buildutils.py', 'blueprint.py', 'audit.py', 'regenerate_packages.py'],'glue/packages':['catm.py', 'caudio.py', 'ccore.py', 'cfs.py', 'cnet.py', 'cws.py'],},
  description : 'Holds the build system glue code',
  helptext : 'Never, ever, turn this off',
  package : 'ccore',
  path : 'glue',
  requires : [],
  section : 'Tree',
  tweakability : 0,
  type : 'bool',
  value : 1,
}),
Directory('ntsc_generic', {
  associated_cpp_name : 'NTSC_GENERIC_ANON',
  description : 'Generic Nemesis Trusted Supervisor Code',
  makefileflags : {'custom':1,},
  path : 'ntsc/generic',
  requires : [],
  section : 'unclassified',
  type : 'bool',
  value : 1,
}),

]




#######################################################################
# unclassified (71 items)


items = items + [
InterfaceCollection('Login interfaces', {
  associated_cpp_name : 'LOGIN_IF',
  contents : {'mod/security/interfaces':['Login.if'],},
  package : 'ccore',
  path : 'mod/security/interfaces',
  requires : [],
  section : 'unclassified',
  system_interfaces : ['Login.if'],
  tweakability : 1,
  type : 'bool',
  value : 1,
}),

AutoModule('LoginPrompt', {
  associated_cpp_name : 'LOGIN_PROMPT',
  binobject : 'LoginPrompt',
  contents : {'mod/security/loginprompt':['prompt.c', 'LoginPrompt.if'],},
  description : 'Login Prompt for username and password.',
  package : 'ccore',
  path : 'mod/security/loginprompt',
  requires : ['Login interfaces'],
  section : 'unclassified',
  system_interfaces : ['LoginPrompt.if'],
  tweakability : 1,
  type : 'quad',
  value : 2,
}),

AutoModule('PcnfsLogin', {
  associated_cpp_name : 'PCNFS_LOGIN',
  binobject : 'PcnfsLogin',
  contents : {'mod/security/pcnfs':['pcnfsd_xdr.c', 'pcnfsd.h', 'login.c', 'common.h', 'PcnfsLoginMod.if'],},
  description : 'Login service (Pcnfs based).',
  makefileflags : {'libsocket':1,'libsunrpc':1,},
  package : 'ccore',
  path : 'mod/security/pcnfs',
  requires : [],
  section : 'unclassified',
  system_interfaces : ['PcnfsLoginMod.if'],
  tweakability : 1,
  type : 'quad',
  value : 2,
}),

AutoModule('TradedContext', {
  associated_cpp_name : 'TRADEDCONTEXT_ANON',
  contents : {'mod/nemesis/tradedcontext':['TradedContextMod.if', 'TradedContext.if', 'TradedContext.c'],},
  description : 'Context IDC service',
  package : 'ccore',
  path : 'mod/nemesis/tradedcontext',
  requires : [],
  section : 'unclassified',
  system_interfaces : ['TradedContext.if', 'TradedContextMod.if'],
  type : 'quad',
  value : 3,
}),

AutoModule('UnixLogin', {
  associated_cpp_name : 'UNIX_LOGIN',
  binobject : 'UnixLogin',
  contents : {'mod/security/unix':['login.c', 'UnixLoginMod.if'],},
  description : 'Login service(/etc/passwd based).',
  package : 'ccore',
  path : 'mod/security/unix',
  requires : [],
  section : 'unclassified',
  system_interfaces : ['UnixLoginMod.if'],
  tweakability : 1,
  type : 'quad',
  value : 2,
}),

Directory('app', {
  associated_cpp_name : 'APP_ANON',
  contents : {'app':[],},
  description : 'Applications',
  growrecursive : 0,
  package : 'ccore',
  path : 'app',
  requires : [],
  section : 'unclassified',
  type : 'bool',
  value : 1,
}),

AutoModule('beep', {
  associated_cpp_name : 'BEEP',
  contents : {'dev/isa/beep':['beep.c', 'Beep.if'],},
  description : 'Drives internal PC loudspeaker',
  makefileflags : {'libio':1,},
  package : 'ccore',
  path : 'dev/isa/beep',
  requires : [],
  section : 'unclassified',
  system_interfaces : ['Beep.if'],
  type : 'quad',
  value : 3,
}),

AutoModule('benchmarks', {
  associated_cpp_name : 'BENCHMARKS_ANON',
  contents : {'mod/nemesis/benchmarks':['bm.c'],},
  description : 'Nemesis application benchmarks',
  package : 'ccore',
  path : 'mod/nemesis/benchmarks',
  requires : [],
  section : 'unclassified',
  type : 'quad',
  value : 2,
}),

Directory('boot', {
  associated_cpp_name : 'BOOT_ANON',
  contents : {'boot':['Makefile'],},
  description : 'boot stuff',
  growrecursive : 0,
  makefileflags : {'custom':1,},
  package : 'ccore',
  path : 'boot',
  requires : ['build_image'],
  section : 'unclassified',
  type : 'bool',
  value : 1,
}),

Directory('boot_images', {
  associated_cpp_name : 'BOOT_IMAGES_ANON',
  contents : {'boot/images':['gensrc'],},
  description : 'boot images stuff',
  growrecursive : 0,
  package : 'ccore',
  path : 'boot/images',
  requires : ['build_image'],
  section : 'unclassified',
  type : 'bool',
  value : 1,
}),

BlobDirectory('boot_initscripts', {
  associated_cpp_name : 'BOOT_INITSCRIPTS_ANON',
  bloblist : [('init.rc', 'initrc', 'initrc'), ('banner', 'banner', 'banner')],

  contents : {'boot/initscripts':['init.rc.py', 'banner', 'Makefile'],},
  description : 'initialisation scripts',
  makefileflags : {'custom':1, 'install':['standard.rc'],},
  package : 'ccore',
  path : 'boot/initscripts',
  requires : ['build_image'],
  section : 'unclassified',
  type : 'bool',
  value : 1,
}),

Directory('boot_loader', {
  associated_cpp_name : 'BOOT_LOADER_ANON',
  contents : {'boot/loader':[],},
  description : 'boot loaders',
  growrecursive : 0,
  package : 'ccore',
  path : 'boot/loader',
  requires : ['build_image'],
  section : 'unclassified',
  type : 'bool',
  value : 1,
}),

InterfaceCollection('callpriv_interfaces', {
  associated_cpp_name : 'CALLPRIV_INTERFACES_ANON',
  contents : {'sys/interfaces/callpriv':['IOCallPriv.if', 'CallPriv.if'],},
  description : 'Callpriv interfaces',
  package : 'ccore',
  path : 'sys/interfaces/callpriv',
  requires : [],
  section : 'unclassified',
  system_interfaces : ['CallPriv.if', 'IOCallPriv.if'],
  type : 'bool',
  value : 1,
}),

InterfaceCollection('central_interfaces', {
  associated_cpp_name : 'CENTRAL_INTERFACES_ANON',
  contents : {'sys/interfaces/central':['Wr.if', 'VP.if', 'TimeNotify.if', 'Time.if', 'ThreadsPackage.if', 'Threads.if', 'ThreadHooks.if', 'ThreadF.if', 'Thread.if', 'Tasks.if', 'Security.if', 'SRCThreadMod.if', 'SRCThread.if', 'Rd.if', 'QoSCtl.if', 'ProtectionDomain.if', 'Plumber.if', 'Pervasives.if', 'LockedHeap.if', 'Load.if', 'Interrupt.if', 'HeapMod.if', 'Heap.if', 'FileIO.if', 'File.if', 'FIFOMod.if', 'FIFO.if', 'ExnSystem.if', 'ExnSupport.if', 'ExnSetjmp.if', 'ExnRegistry.if', 'Exec.if', 'Exception.if', 'EventsMod.if', 'Events.if', 'Event.if', 'Directory.if', 'Context.if', 'ConsoleWr.if', 'Closure.if', 'Clock.if', 'ChannelNotify.if', 'Channel.if', 'ChainedHandler.if', 'Builder.if', 'BootDomain.if', 'BinderCallback.if', 'Binder.if', 'ActivationMod.if', 'ActivationF.if', 'Activation.if'],},
  description : 'Nemesis central interfaces',
  package : 'ccore',
  path : 'sys/interfaces/central',
  requires : [],
  section : 'unclassified',
  system_interfaces : ['ChainedHandler.if', 'Builder.if', 'Event.if', 'Time.if', 'QoSCtl.if', 'Wr.if', 'Heap.if', 'Context.if', 'ThreadHooks.if', 'Channel.if', 'Rd.if', 'ThreadsPackage.if', 'Clock.if', 'Tasks.if', 'ConsoleWr.if', 'Thread.if', 'Plumber.if', 'Exec.if', 'ExnRegistry.if', 'SRCThreadMod.if', 'ExnSystem.if', 'EventsMod.if', 'FileIO.if', 'ActivationMod.if', 'Activation.if', 'Pervasives.if', 'ThreadF.if', 'ActivationF.if', 'TimeNotify.if', 'LockedHeap.if', 'Interrupt.if', 'ProtectionDomain.if', 'Security.if', 'VP.if', 'Closure.if', 'Events.if', 'Load.if', 'SRCThread.if', 'FIFOMod.if', 'FIFO.if', 'HeapMod.if', 'ChannelNotify.if', 'ExnSetjmp.if', 'BinderCallback.if', 'Threads.if', 'ExnSupport.if', 'BootDomain.if', 'Binder.if', 'Exception.if'],
  type : 'bool',
  value : 1,
}),

InterfaceCollection('common_memory_interfaces', {
  associated_cpp_name : 'COMMON_MEMORY_INTERFACES_ANON',
  contents : {'sys/interfaces/common_memory':['StretchAllocator.if', 'Stretch.if', 'RamTab.if', 'Mem.if', 'MMUMod.if', 'MMU.if', 'MMNotifyMod.if', 'MMNotify.if', 'MMEntryMod.if', 'MMEntry.if', 'GDBMod.if', 'GDB.if', 'FramesMod.if', 'FramesF.if', 'Frames.if'],},
  package : 'ccore',
  path : 'sys/interfaces/common_memory',
  requires : [],
  section : 'unclassified',
  system_interfaces : ['FramesMod.if', 'MMU.if', 'MMUMod.if', 'MMEntryMod.if', 'MMEntry.if', 'MMNotifyMod.if', 'MMNotify.if', 'RamTab.if', 'GDBMod.if', 'GDB.if', 'Mem.if', 'Frames.if', 'FramesF.if', 'Stretch.if', 'StretchAllocator.if'],
  type : 'bool',
  value : 1,
}),

Directory('dev', {
  associated_cpp_name : 'DEV_ANON',
  contents : {'dev':[],},
  description : 'The collection of device drivers',
  growrecursive : 0,
  package : 'ccore',
  path : 'dev',
  requires : [],
  section : 'unclassified',
  type : 'bool',
  value : 1,
}),

Directory('dev_isa', {
  associated_cpp_name : 'DEV_ISA_ANON',
  contents : {'dev/isa':[],},
  description : 'ISA device drivers',
  growrecursive : 0,
  package : 'ccore',
  path : 'dev/isa',
  requires : ['isa'],
  section : 'unclassified',
  type : 'bool',
  value : 1,
}),

Directory('dev_pci', {
  associated_cpp_name : 'DEV_PCI_ANON',
  contents : {'dev/pci':[],},
  description : 'PCI device drivers',
  growrecursive : 0,
  package : 'ccore',
  path : 'dev/pci',
  requires : ['pci'],
  section : 'unclassified',
  type : 'bool',
  value : 1,
}),

InterfaceCollection('device_interfaces', {
  associated_cpp_name : 'DEVICE_INTERFACES_ANON',
  contents : {'dev/interfaces':['WTimeUpdate.if', 'WTime.if', 'Timer.if', 'Serial.if', 'RTC.if', 'Mouse.if', 'Kbd.if', 'AuPlaybackWriter.if', 'AuMod.if', 'Au.if'],},
  description : 'Interfaces that device drivers might export',
  package : 'ccore',
  path : 'dev/interfaces',
  requires : [],
  section : 'unclassified',
  system_interfaces : ['Timer.if', 'Mouse.if', 'WTimeUpdate.if', 'RTC.if', 'WTime.if', 'AuPlaybackWriter.if', 'Au.if', 'AuMod.if', 'Serial.if', 'Kbd.if'],
  type : 'bool',
  value : 1,
}),

Directory('doc', {
  associated_cpp_name : 'DOC_ANON',
  contents : {},
  description : 'Documentation directory',
  growrecursive : 0,
  package : 'ccore',
  path : 'doc',
  requires : [],
  section : 'unclassified',
  type : 'bool',
  value : 1,
}),

InterfaceCollection('entry_interfaces', {
  associated_cpp_name : 'ENTRY_INTERFACES_ANON',
  contents : {'sys/interfaces/entries':['QoSEntryMod.if', 'QoSEntry.if', 'IOEntryMod.if', 'IOEntry.if', 'EntryMod.if', 'Entry.if'],},
  description : 'Various kinds of entries',
  package : 'ccore',
  path : 'sys/interfaces/entries',
  requires : [],
  section : 'unclassified',
  system_interfaces : ['Entry.if', 'EntryMod.if', 'QoSEntry.if', 'QoSEntryMod.if', 'IOEntry.if', 'IOEntryMod.if'],
  type : 'bool',
  value : 1,
}),

Directory('h', {
  associated_cpp_name : 'H_ANON',
  contents : {'h':['unistd.h', 'time.h', 'string.h', 'stdlib.h', 'stdio.h', 'stddef.h', 'socket.h', 'slab.h', 'slab.c', 'setjmp.h', 'sequence.h', 'sdom.h', 'salloc.h', 'resolver.h', 'regionstr.h', 'pqueues.h', 'pktcx.h', 'pervasives.h', 'ntsc.h', 'nexus.h', 'nettrace.h', 'netorder.h', 'netdb.h', 'nemesis_types.h', 'nemesis.h', 'nan.h', 'mutex.h', 'mod_data.h', 'memcopy.h', 'math.h', 'littleEndian.h', 'links.h', 'keysym.h', 'kernel.h', 'iana.h', 'huge_val.h', 'frames.h', 'exit.h', 'exceptions.h', 'ether.h', 'environment.h', 'ecs.h', 'domid.h', 'ctype.h', 'contexts.h', 'compat.h', 'bstring.h', 'assert.h', 'WS.h', 'TypeSystem_st.h', 'ShmTransport.h', 'IOMacros.h', 'IDCMarshal.h', 'IDCMacros.h'],},
  description : 'System headers files',
  growrecursive : 0,
  package : 'ccore',
  path : 'h',
  requires : [],
  section : 'unclassified',
  type : 'bool',
  value : 1,
}),

Directory('h_dev', {
  associated_cpp_name : 'H_DEV_ANON',
  contents : {'h/dev':['pckbd.h', 'pci.h', 'ns16550.h', 'mc146818rtc.h', 'ide.h', 'i8259.h', 'i8254.h', 'ds1287a.h', 'ansicolour.h'],},
  description : 'Device driver specific header files',
  package : 'ccore',
  path : 'h/dev',
  requires : [],
  section : 'unclassified',
  type : 'bool',
  value : 1,
}),

Directory('hash', {
  associated_cpp_name : 'HASH_ANON',
  contents : {'mod/hash':[],},
  description : 'Hash functions',
  growrecursive : 0,
  package : 'ccore',
  path : 'mod/hash',
  requires : [],
  section : 'unclassified',
  type : 'quad',
  value : 3,
}),

InterfaceCollection('hash_interfaces', {
  associated_cpp_name : 'HASH_INTERFACES_ANON',
  contents : {'mod/hash/interfaces':['HashMod.if', 'Hash.if'],},
  description : 'Hash interaces',
  package : 'ccore',
  path : 'mod/hash/interfaces',
  requires : [],
  section : 'unclassified',
  system_interfaces : ['HashMod.if', 'Hash.if'],
  type : 'bool',
  value : 1,
}),

InterfaceCollection('idc_interfaces', {
  associated_cpp_name : 'IDC_INTERFACES_ANON',
  contents : {'sys/interfaces/idc':['ObjectTblMod.if', 'ObjectTbl.if', 'IORConverter.if', 'IDCTransport.if', 'IDCStubs.if', 'IDCService.if', 'IDCServerStubs.if', 'IDCServerBinding.if', 'IDCOfferMod.if', 'IDCOffer.if', 'IDCMod.if', 'IDCClientStubs.if', 'IDCClientBinding.if', 'IDCCallback.if', 'IDCBinding.if', 'IDC.if'],},
  description : 'IDC intefaces',
  package : 'ccore',
  path : 'sys/interfaces/idc',
  requires : [],
  section : 'unclassified',
  system_interfaces : ['IDC.if', 'IDCBinding.if', 'IDCCallback.if', 'IDCClientBinding.if', 'IDCClientStubs.if', 'IDCMod.if', 'IDCOffer.if', 'IDCOfferMod.if', 'IDCServerBinding.if', 'IDCServerStubs.if', 'IDCService.if', 'IDCStubs.if', 'IDCTransport.if', 'IORConverter.if', 'ObjectTbl.if', 'ObjectTblMod.if'],
  type : 'bool',
  value : 1,
}),

InterfaceCollection('io_interfaces', {
  associated_cpp_name : 'IO_INTERFACES_ANON',
  contents : {'sys/interfaces/io':['IOTransport.if', 'IOOffer.if', 'IONotify.if', 'IOMod.if', 'IOData.if', 'IOClosure.if', 'IO.if'],},
  description : 'IO related interfaces',
  package : 'ccore',
  path : 'sys/interfaces/io',
  requires : [],
  section : 'unclassified',
  system_interfaces : ['IO.if', 'IOData.if', 'IOMod.if', 'IOOffer.if', 'IOTransport.if'],
  type : 'bool',
  value : 1,
}),

Directory('lib', {
  associated_cpp_name : 'LIB_ANON',
  contents : {'lib':['README', 'Makefile'],},
  description : 'The collection of linked libraries',
  growrecursive : 0,
  makefileflags : {'custom':1,},
  package : 'ccore',
  path : 'lib',
  requires : [],
  section : 'unclassified',
  type : 'bool',
  value : 1,
}),

Directory('lib_static', {
  associated_cpp_name : 'LIB_STATIC_ANON',
  contents : {'lib/static':['h', 'README'],},
  description : 'Static libraries',
  growrecursive : 0,
  package : 'ccore',
  path : 'lib/static',
  requires : [],
  section : 'unclassified',
  type : 'bool',
  value : 1,
}),

Directory('lib_static_debug', {
  associated_cpp_name : 'LIB_STATIC_DEBUG_ANON',
  contents : {'lib/static/debug':['triv_wr.c', 'Makefile'],},
  description : 'Debugging output library',
  makefileflags : {'custom':1,},
  package : 'ccore',
  path : 'lib/static/debug',
  requires : [],
  section : 'unclassified',
  type : 'bool',
  value : 1,
}),

Directory('lib_static_io', {
  associated_cpp_name : 'LIB_STATIC_IO_ANON',
  contents : {'lib/static/io':['io.c', 'Makefile'],},
  description : 'IO library',
  makefileflags : {'custom':1,},
  package : 'ccore',
  path : 'lib/static/io',
  requires : [],
  section : 'unclassified',
  type : 'bool',
  value : 1,
}),

Directory('lib_static_posix', {
  associated_cpp_name : 'LIB_STATIC_POSIX_ANON',
  contents : {'lib/static/posix':['posixmain.c', 'Makefile'],},
  description : 'Posix personality libraries',
  makefileflags : {'custom':1,},
  package : 'ccore',
  path : 'lib/static/posix',
  requires : [],
  section : 'unclassified',
  type : 'bool',
  value : 1,
}),

Directory('lib_static_system', {
  associated_cpp_name : 'LIB_STATIC_SYSTEM_ANON',
  contents : {'lib/static/system':['syscall_intel_inline.h', 'syscall_intel.S', 'syscall_arm.S', 'syscall_alpha.S', 'stub_ix86.c', 'stub_arm.c', 'stub_alpha.S', 'setjmp_intel.S', 'setjmp_intel-smp.S', 'setjmp_arm.S', 'setjmp_alpha.S', 'main.c', 'divide_alpha.S', 'crt0_ix86.S', 'crt0_arm.S', 'crt0_alpha.S', 'Makefile'],},
  description : 'System library',
  makefileflags : {'custom':1,},
  package : 'ccore',
  path : 'lib/static/system',
  requires : [],
  section : 'unclassified',
  type : 'bool',
  value : 1,
}),

Directory('lib_veneer', {
  associated_cpp_name : 'LIB_VENEER_ANON',
  contents : {'lib/veneer':[],},
  description : 'The collection of library veneers',
  growrecursive : 0,
  package : 'ccore',
  path : 'lib/veneer',
  requires : [],
  section : 'unclassified',
  type : 'bool',
  value : 1,
}),

StaticLibrary('libc_veneer', {
  associated_cpp_name : 'LIBC_VENEER_ANON',
  contents : {'lib/veneer/c':['libc.ven', 'Makefile'],},
  description : 'libc veneer',
  makefileflags : {'custom':1,},
  package : 'ccore',
  path : 'lib/veneer/c',
  requires : [],
  section : 'unclassified',
  type : 'bool',
  value : 1,
}),

Directory('links', {
  associated_cpp_name : 'LINKS_ANON',
  contents : {'links':['Makefile'],},
  description : 'Directory for links to appear in',
  makefileflags : {'custom':1,},
  package : 'ccore',
  path : 'links',
  requires : [],
  section : 'unclassified',
  type : 'bool',
  value : 1,
}),

AutoModule('md5', {
  associated_cpp_name : 'MD5_ANON',
  contents : {'mod/hash/md5':['md5.h', 'md5.c'],},
  description : 'MD5 hash function',
  package : 'ccore',
  path : 'mod/hash/md5',
  requires : [],
  section : 'unclassified',
  type : 'quad',
  value : 2,
}),

AutoModule('memory', {
  associated_cpp_name : 'MEMORY_ANON',
  binobject : 'memory',
  contents : {'sys/memory':['shark_mmu.c', 'salloc_std.c', 'salloc_expt.c', 'mmu.h', 'intel_mmu.c', 'frames.c', 'eb164_mmu_linear.c', 'eb164_mmu_gpt.c', 'eb164_mmu_121.c', 'Makefile'],'sys/memory/ifaces_expt':['StretchDriver.if', 'StretchAllocatorF.if', 'SDriverMod.if', 'SAllocMod.if', 'FaultHandler.if'],'sys/memory/ifaces_std':['StretchDriver.if', 'StretchAllocatorF.if', 'SAllocMod.if'],},
  makefileflags : {'custom':1,},
  package : 'ccore',
  path : 'sys/memory',
  requires : [],
  section : 'unclassified',
  type : 'quad',
  value : 3,
}),

InterfaceCollection('memory_expt_interfaces', {
  associated_cpp_name : 'MEMORY_EXPT_INTERFACES_ANON',
  contents : {'sys/memory/ifaces_expt':['StretchDriver.if', 'StretchAllocatorF.if', 'SDriverMod.if', 'SAllocMod.if', 'FaultHandler.if'],},
  package : 'ccore',
  path : 'sys/memory/ifaces_expt',
  requires : [('memsys', 1)],
  section : 'unclassified',
  system_interfaces : ['FaultHandler.if', 'SAllocMod.if', 'StretchAllocatorF.if', 'SDriverMod.if', 'StretchDriver.if'],
  type : 'bool',
  value : 1,
}),

InterfaceCollection('memory_std_interfaces', {
  associated_cpp_name : 'MEMORY_STD_INTERFACES_ANON',
  contents : {'sys/memory/ifaces_std':['StretchDriver.if', 'StretchAllocatorF.if', 'SAllocMod.if'],},
  package : 'ccore',
  path : 'sys/memory/ifaces_std',
  requires : [('memsys', 0)],
  section : 'unclassified',
  system_interfaces : ['SAllocMod.if', 'StretchAllocatorF.if', 'StretchDriver.if'],
  type : 'bool',
  value : 1,
}),

Directory('mk', {
  associated_cpp_name : 'MK_ANON',
  contents : {'mk':['srcit.tgt.mk', 'shark.tgt.mk', 'rules.mk', 'riscpc.tgt.mk', 'pc164.tgt.mk', 'mips_target.mk', 'local.rules.mk.sample', 'maxine.tgt.mk', 'local.rules.mk', 'linux_for_arm.pfm.mk', 'ix86_target.mk', 'ix86_linux.pfm.mk', 'intel.tgt.mk', 'intel-smp.tgt.mk', 'hpux_for_arm.pfm.mk', 'fpc3.tgt.mk', 'etags.mk', 'eb64.tgt.mk', 'eb164.tgt.mk', 'config.mk', 'config.awk', 'axp3000.tgt.mk', 'arm_target.mk', 'alpha_target.mk', 'alpha_osf1_4.0.pfm.mk', 'alpha_osf1_3.2.pfm.mk', 'README'],},
  description : 'Make system directories',
  growrecursive : 0,
  package : 'ccore',
  path : 'mk',
  requires : [],
  section : 'unclassified',
  type : 'bool',
  value : 1,
}),

AutoModule('mmentry', {
  associated_cpp_name : 'MMENTRY_ANON',
  contents : {'mod/nemesis/mmentry':['mmnotify.c', 'mmentry.c', 'mm_st.h'],},
  description : 'User space handler for dealing with memory faults; essentially works as a dispatcher for stretchdrivers and/or user-space debuggers.',
  package : 'ccore',
  path : 'mod/nemesis/mmentry',
  requires : [],
  section : 'unclassified',
  type : 'quad',
  value : 3,
}),

Directory('mod', {
  associated_cpp_name : 'MOD_ANON',
  contents : {'mod':[],},
  description : 'The collection of stateless modules',
  growrecursive : 0,
  package : 'ccore',
  path : 'mod',
  requires : [],
  section : 'unclassified',
  type : 'bool',
  value : 1,
}),

Directory('mod_fs', {
  associated_cpp_name : 'MOD_FS_ANON',
  contents : {'mod/fs':[],},
  description : 'Filing system modules',
  growrecursive : 0,
  package : 'ccore',
  path : 'mod/fs',
  requires : [],
  section : 'unclassified',
  type : 'bool',
  value : 1,
}),

Directory('mod_nemesis', {
  associated_cpp_name : 'MOD_NEMESIS_ANON',
  contents : {'mod/nemesis':[],},
  description : 'System modules',
  growrecursive : 0,
  package : 'ccore',
  path : 'mod/nemesis',
  requires : [],
  section : 'unclassified',
  type : 'bool',
  value : 1,
}),

Directory('mod_security', {
  associated_cpp_name : 'MOD_SECURITY_ANON',
  contents : {'mod/security':[],},
  description : 'Security modules',
  growrecursive : 0,
  package : 'ccore',
  path : 'mod/security',
  requires : [],
  section : 'unclassified',
  type : 'bool',
  value : 1,
}),

Directory('mod_venimpl', {
  associated_cpp_name : 'MOD_VENIMPL_ANON',
  contents : {'mod/venimpl':[],},
  description : 'The collection of veneer implementation modules',
  growrecursive : 0,
  package : 'ccore',
  path : 'mod/venimpl',
  requires : [],
  section : 'unclassified',
  type : 'bool',
  value : 1,
}),

Directory('ntsc', {
  associated_cpp_name : 'NTSC_ANON',
  contents : {'ntsc':['README', 'Makefile'],},
  description : 'NTSC directory',
  growrecursive : 0,
  makefileflags : {'custom':1,},
  package : 'ccore',
  path : 'ntsc',
  requires : [],
  section : 'unclassified',
  type : 'bool',
  value : 1,
}),

Primal('primal', {
  associated_cpp_name : 'PRIMAL_ANON',
  binobject : 'primal',
  contents : {'sys/primal':['pcrt0_ix86.S', 'pcrt0_arm.S', 'pcrt0_alpha.S', 'nexus_util.c', 'addr_init_shark.c', 'addr_init_intel.c', 'addr_init_eb164.c', 'addr_init.h', 'NemesisPrimal.c', 'Makefile'],},
  env : {'autostart':1,'contexts':32,'defstack':'6k','endpoints':1024,'frames':128,'heap':'64k','kernel':1,'sysheap':'64k',},
  makefileflags : {'custom':1,},
  package : 'ccore',
  path : 'sys/primal',
  qos : {'extra':1,'latency':'10ms','period':'10ms','slice':'5us',},
  requires : [],
  section : 'unclassified',
  type : 'bool',
  value : 1,
}),

AutoModule('pvscx', {
  associated_cpp_name : 'PVSCX_ANON',
  contents : {'mod/nemesis/pvscx':['PvsContext.c'],},
  description : 'Active context that accesses pervasives',
  package : 'ccore',
  path : 'mod/nemesis/pvscx',
  requires : [],
  section : 'unclassified',
  type : 'quad',
  value : 3,
}),

Directory('root', {
  associated_cpp_name : 'ROOT_ANON',
  contents : {'':['Makefile'],},
  description : 'Root of the build tree',
  growrecursive : 0,
  makefileflags : {'custom':1,},
  package : 'ccore',
  path : '',
  requires : [],
  section : 'unclassified',
  type : 'bool',
  value : 1,
}),

Directory('sys', {
  associated_cpp_name : 'SYS_ANON',
  contents : {'sys':[],},
  description : 'The collection of system services which are not modules',
  growrecursive : 0,
  package : 'ccore',
  path : 'sys',
  requires : [],
  section : 'unclassified',
  type : 'bool',
  value : 1,
}),

Directory('sys_interfaces', {
  associated_cpp_name : 'SYS_INTERFACES_ANON',
  contents : {'sys/interfaces':[],},
  description : 'System interfaces',
  growrecursive : 0,
  package : 'ccore',
  path : 'sys/interfaces',
  requires : [],
  section : 'unclassified',
  type : 'bool',
  value : 1,
}),

AutoModule('ttyterm', {
  associated_cpp_name : 'TTYTERM_ANON',
  contents : {'mod/ttyterm':['ttyterm.c', 'KbdtoRd.c'],},
  description : 'VGA TTY terminal',
  package : 'ccore',
  path : 'mod/ttyterm',
  requires : [],
  section : 'unclassified',
  type : 'quad',
  value : 3,
}),

AutoModule('ugdb', {
  associated_cpp_name : 'UGDB_ANON',
  contents : {'mod/nemesis/ugdb':['ugdb.c', 'stub_ix86.c', 'stub_arm.c', 'stub_alpha.c', 'Makefile', 'GDB_st.h'],},
  description : 'User space GDB support.',
  makefileflags : {'custom':1,},
  package : 'ccore',
  path : 'mod/nemesis/ugdb',
  requires : [],
  section : 'unclassified',
  type : 'quad',
  value : 3,
}),

AutoModule('vgaconsole', {
  associated_cpp_name : 'VGACONSOLE',
  contents : {'dev/isa/vgaconsole':['console.c', 'VGATextMod.if'],},
  description : 'Primitive driver for PC VGA text mode display',
  makefileflags : {'libio':1,},
  package : 'ccore',
  path : 'dev/isa/vgaconsole',
  requires : [],
  section : 'unclassified',
  system_interfaces : ['VGATextMod.if'],
  type : 'quad',
  value : 3,
}),

PosixProgram('isapnp', {
  associated_cpp_name : 'ISAPNP',
  description : 'Port of linux isapnp for munging pnp into readiness.',
  env : {'contexts':32,'defstack':'16k','endpoints':128,'frames':96,'heap':'256k','kernel':1,'sysheap':'64k',},
  makefileflags : {'libio':1,},
  package : 'ccore',
  path : 'app/isapnp',
  qos : {'extra':1,'latency':'20ms','period':'20ms','slice':'0ns',},
  requires : [],
  section : '',
  tweakability : 2,
  type : 'quad',
  value : 2,
}),

]


######################################################################
files = {
	'' : ['Makefile'],
	'app' : [],
        'app/isapnp' : ['isapnp.c', 'pnp.h'],
	'boot' : ['Makefile'],
	'boot/images' : ['gensrc', 'standard.rc'],
	'boot/images/eb164' : ['Makefile'],
	'boot/images/intel' : ['Makefile', 'bootsect.S', 'head.S', 'inflate.c', 'io.h', 'linkage.h', 'misc.c', 'nemesis.gdb', 'setup.S', 'video.S'],
	'boot/images/shark' : ['Makefile'],
	'boot/initscripts' : ['Makefile', 'banner', 'init.rc.py'],
	'boot/loader' : [],
	'boot/loader/eb164' : ['Makefile', 'loader.S'],
	'dev' : [],
	'dev/interfaces' : ['Au.if', 'AuMod.if', 'AuPlaybackWriter.if', 'Kbd.if', 'Mouse.if', 'RTC.if', 'Serial.if', 'Timer.if', 'WTime.if', 'WTimeUpdate.if'],
	'dev/isa' : [],
	'dev/isa/beep' : ['Beep.if', 'beep.c'],
	'dev/isa/mc146818' : ['RTC.c'],
	'dev/isa/ns16550' : ['SerialMod.if', 'Serial_st.h', 'readers.c', 'serial.c'],
	'dev/isa/ps2' : ['ps2.c', 'ps2_st.h', 'table.c'],
	'dev/isa/vgaconsole' : ['VGATextMod.if', 'console.c'],
	'dev/pci' : [],
	'glue' : ['audit.py', 'blueprint.py', 'buildutils.py', 'changeconfig.tcl', 'choicesgui.py', 'configutils.py', 'createiflinks.py', 'customizer.py', 'depsshow.py', 'gendetails.py', 'gendirs.py', 'generic_blueprint.py', 'gengraph.py', 'geninfrastructure.py', 'geninstalllinks.py', 'genmakefile.py', 'gennbf.py', 'growtree.py', 'guicompiler.py', 'ifbuildercachetodb.py', 'intfbuilder.py', 'layfoundations.py', 'livedbend', 'livedbstart', 'nemclasses.py', 'plumbtree.py', 'qosutil.py', 'regenerate_blueprint.py', 'regenerate_packages.py', 'sourcemanager.py', 'tagstodb.py'],
	'glue/packages' : ['catm.py', 'caudio.py', 'ccore.py', 'cfs.py', 'cnet.py', 'cws.py'],
	'h' : ['IDCMacros.h', 'IDCMarshal.h', 'IOMacros.h', 'ShmTransport.h', 'TypeSystem_st.h', 'WS.h', 'assert.h', 'bstring.h', 'compat.h', 'contexts.h', 'ctype.h', 'domid.h', 'ecs.h', 'environment.h', 'ether.h', 'exceptions.h', 'exit.h', 'frames.h', 'huge_val.h', 'iana.h', 'kernel.h', 'keysym.h', 'links.h', 'littleEndian.h', 'math.h', 'memcopy.h', 'mod_data.h', 'mutex.h', 'nan.h', 'nemesis.h', 'nemesis_types.h', 'netdb.h', 'netorder.h', 'nettrace.h', 'nexus.h', 'ntsc.h', 'pervasives.h', 'pktcx.h', 'pqueues.h', 'regionstr.h', 'resolver.h', 'salloc.h', 'sdom.h', 'sequence.h', 'setjmp.h', 'slab.c', 'slab.h', 'socket.h', 'stddef.h', 'stdio.h', 'stdlib.h', 'string.h', 'time.h', 'unistd.h'],
	'h/alpha' : ['VPMacros.h', 'asm.h', 'bitops.h', 'context.h', 'dcb.h', 'jmp_buf.h', 'kernel_config.h', 'kernel_st.h', 'limits.h', 'mmu_tgt.h', 'nemesis_tgt.h', 'ntsc_tgt.h', 'regdef.h', 'stdarg.h', 'veneer.h'],
	'h/alpha/ev5' : ['alcor.h', 'dc21164.h'],
	'h/alpha/ev5/pal' : ['cserve.h', 'impure.h', 'macros.h', 'nempal.h', 'platform.h'],
	'h/alpha/pal' : ['nempal_priv.h', 'nempal_unpriv.h'],
	'h/arm' : ['memc2.h'],
	'h/dev' : ['ansicolour.h', 'ds1287a.h', 'i8254.h', 'i8259.h', 'ide.h', 'mc146818rtc.h', 'ns16550.h', 'pci.h', 'pckbd.h'],
	'h/eb164' : ['dma.h', 'interrupt.h', 'io.h', 'irq.h', 'kernel_tgt.h', 'pip.h', 'platform.h'],
	'h/intel' : ['Type.ih', 'VPMacros.h', 'dcb.h', 'dcb.off.h', 'io.h', 'irq.h', 'jmp_buf.h', 'kernel_config.h', 'kernel_st.h', 'kernel_tgt.h', 'math_inline.h', 'nemesis_tgt.h', 'ntsc_tgt.h', 'pip.h', 'syscall.h', 'timer.h', 'veneer_tgt.h'],
	'h/ix86' : ['bitops.h', 'context.h', 'elf.h', 'float.h', 'interrupt.h', 'limits.h', 'mmu_tgt.h', 'multiboot.h', 'platform.h', 'processor.h', 'stdarg.h', 'veneer.h'],
	'h/ix86/asm' : ['elf.h', 'ptrace.h', 'stackframe.h'],
	'lib' : ['Makefile', 'README'],
	'lib/static' : ['README', 'h'],
	'lib/static/debug' : ['Makefile', 'triv_wr.c'],
	'lib/static/io' : ['Makefile', 'io.c'],
	'lib/static/posix' : ['Makefile', 'posixmain.c'],
	'lib/static/system' : ['Makefile', 'crt0_alpha.S', 'crt0_arm.S', 'crt0_ix86.S', 'divide_alpha.S', 'main.c', 'setjmp_alpha.S', 'setjmp_arm.S', 'setjmp_intel-smp.S', 'setjmp_intel.S', 'stub_alpha.S', 'stub_arm.c', 'stub_ix86.c', 'syscall_alpha.S', 'syscall_arm.S', 'syscall_intel.S', 'syscall_intel_inline.h'],
	'lib/veneer' : [],
	'lib/veneer/c' : ['Makefile', 'libc.ven'],
	'links' : ['Makefile'],
	'mk' : ['README', 'alpha_osf1_3.2.pfm.mk', 'alpha_osf1_4.0.pfm.mk', 'alpha_target.mk', 'arm_target.mk', 'axp3000.tgt.mk', 'config.awk', 'config.mk', 'eb164.tgt.mk', 'eb64.tgt.mk', 'etags.mk', 'fpc3.tgt.mk', 'hpux_for_arm.pfm.mk', 'intel-smp.tgt.mk', 'intel.tgt.mk', 'ix86_linux.pfm.mk', 'ix86_target.mk', 'linux_for_arm.pfm.mk', 'local.rules.mk', 'local.rules.mk.sample', 'maxine.tgt.mk', 'mips_target.mk', 'pc164.tgt.mk', 'riscpc.tgt.mk', 'rules.mk', 'shark.tgt.mk', 'srcit.tgt.mk'],
	'mod' : [],
	'mod/clanger' : ['CExec.if', 'Clammar.y', 'Clanger.if', 'ClangerMod.if', 'Clanger_st.h', 'Functions.c', 'Interp.c', 'Lexer.c', 'Makefile', 'Nodes.c', 'bison.nemesis', 'cexec.c', 'cexec_st.h', 'clanger.c', 'clangermod.c'],
	'mod/cline' : ['CLine.if', 'CLineCtl.if', 'cline.c'],
	'mod/fs' : [],
	'mod/hash' : [],
	'mod/hash/interfaces' : ['Hash.if', 'HashMod.if'],
	'mod/hash/md5' : ['md5.c', 'md5.h'],
	'mod/loader' : ['Makefile', 'exec.c', 'load.h', 'load_alpha.c', 'load_ix86.c', 'relocate_alpha.c', 'relocate_alpha.h', 'relocation_aout.h'],
	'mod/nashmod' : ['Nash.c', 'Nash.if', 'NashMod.c', 'NashMod.if', 'autoexec.nash', 'boot.c', 'commands.c', 'nashst.h', 'profile.nash'],
	'mod/nemesis' : [],
	'mod/nemesis/activations' : ['activations.c'],
	'mod/nemesis/alpha' : ['Time.c', 'VP.c'],
	'mod/nemesis/arm' : ['Makefile', 'Time.c', 'VP.c', 'time_viantsc.c'],
	'mod/nemesis/benchmarks' : ['bm.c'],
	'mod/nemesis/builder' : ['Builder.c'],
	'mod/nemesis/context' : ['Context.c', 'ContextMod.if', 'ContextUtil.if', 'MergedContext.if', 'util.c'],
	'mod/nemesis/csidc' : ['CSClientStubMod.if', 'CSIDCTransport.if', 'Makefile', 'csidc.c'],
	'mod/nemesis/entry' : ['entry.c'],
	'mod/nemesis/events' : ['events.c'],
	'mod/nemesis/exception' : ['ExnSetjmpMod.c'],
	'mod/nemesis/gatekeeper' : ['Gatekeeper.if', 'GatekeeperMod.if', 'gatekeeper.c'],
	'mod/nemesis/heap' : ['heapmod.c'],
	'mod/nemesis/idc' : ['IDCOfferMod.c', 'ObjectTbl.c', 'ShmMarshal.c', 'ShmTransport.c', 'callback.c'],
	'mod/nemesis/io' : ['FIFOMod.c', 'IOEntry.c', 'IOMod.c', 'IOTransport.c', 'fifo.h'],
	'mod/nemesis/ix86' : ['Time.c', 'VP.c'],
	'mod/nemesis/memfile' : ['MemFile.if', 'MemFileMod.c', 'MemFileMod.if'],
	'mod/nemesis/mmentry' : ['mm_st.h', 'mmentry.c', 'mmnotify.c'],
	'mod/nemesis/pvscx' : ['PvsContext.c'],
	'mod/nemesis/qosentry' : ['qosentry.c'],
	'mod/nemesis/rdwr' : ['MemRd.c', 'RdWrMod.if', 'join.c', 'mod.c', 'null.c', 'pipe.c'],
	'mod/nemesis/redir' : ['rd.c', 'wr.c'],
	'mod/nemesis/rpc' : ['Bouncer.if', 'RPCMarshal.c', 'RPCMod.if', 'RPCTransport.c', 'RPCTransport.h', 'RPCTransport.if'],
	'mod/nemesis/sdriver' : ['stretchdriver.c'],
	'mod/nemesis/sgen' : ['IDCMarshalCtl.if', 'Makefile', 'StubGen.if', 'alpha_stubs.S', 'alpha_synth.c', 'arm_stubs.S', 'canned_stubs.c', 'engine.c', 'ix86_stubs.S', 'ix86_synth.c', 'stackframe.h', 'stubgen.c', 'stubgen.h', 'synthgen.c'],
	'mod/nemesis/spawn' : ['Spawn.if', 'SpawnMarshal.c', 'SpawnMod.if', 'SpawnReturn.if', 'spawn.c'],
	'mod/nemesis/srcthreads' : ['srcthread.c'],
	'mod/nemesis/stubs' : ['IDC_CS_ConsoleWr.c', 'Makefile', 'genstubs', 'stubs.c', 'stubs.h'],
	'mod/nemesis/tables' : ['LongCardTbl.if', 'LongCardTblIter.if', 'LongCardTblMod.c', 'LongCardTblMod.if', 'StretchTbl.if', 'StretchTblMod.c', 'StretchTblMod.if', 'StringTbl.if', 'StringTblIter.if', 'StringTblMod.c', 'StringTblMod.if', 'WordTbl.if', 'WordTblIter.if', 'WordTblMod.c', 'WordTblMod.if'],
	'mod/nemesis/threads' : ['Makefile', 'stack.h', 'thead_alpha.S', 'thead_arm.S', 'thead_intel-smp.S', 'thead_intel.S', 'thead_mips.S', 'threads.c'],
	'mod/nemesis/tradedcontext' : ['TradedContext.c', 'TradedContext.if', 'TradedContextMod.if'],
	'mod/nemesis/ugdb' : ['GDB_st.h', 'Makefile', 'stub_alpha.c', 'stub_arm.c', 'stub_ix86.c', 'ugdb.c'],
	'mod/pci' : ['Makefile', 'PCIBios.if', 'PCIBiosMod.c', 'PCIBiosMod.if', 'alcor.c', 'alpha_bios32.c', 'bios32.h', 'intel_bios32.c', 'pci.c', 'pci_st.h'],
	'mod/security' : [],
	'mod/security/interfaces' : ['Login.if'],
	'mod/security/loginprompt' : ['LoginPrompt.if', 'prompt.c'],
	'mod/security/pcnfs' : ['PcnfsLoginMod.if', 'common.h', 'login.c', 'pcnfsd.h', 'pcnfsd_xdr.c'],
	'mod/security/unix' : ['UnixLoginMod.if', 'login.c'],
	'mod/stringutil' : ['StringUtil.if', 'stringutil.c'],
	'mod/ttyterm' : ['KbdtoRd.c', 'ttyterm.c'],
	'mod/venimpl' : [],
	'mod/venimpl/c' : ['Makefile', 'jmptbl.c'],
	'mod/venimpl/c/math' : ['Makefile', 'copysign.c', 'drem.c', 'exp__E.c', 'finite.c', 'intmath.c', 'isinf.c', 'isnan.c', 'ldexp.c', 'log__L.c', 'logb.c', 'pow.c', 'sqrt.c'],
	'mod/venimpl/c/stdio' : ['Makefile', 'common-fs.c', 'common-fs.h', 'doprnt.c', 'doscan.c', 'fclose.c', 'ferror.c', 'fflush.c', 'fgetc.c', 'fgets.c', 'fopen.c', 'fprintf.c', 'fputc.c', 'fputs.c', 'fread.c', 'fscanf.c', 'fwrite.c', 'printf.c', 'scanf.c', 'sprintf.c', 'sscanf.c', 'vprintf.c'],
	'mod/venimpl/c/stdlib' : ['Makefile', 'abort.c', 'abs.c', 'assert.c', 'atof.c', 'atoi.c', 'atol.c', 'bsearch.c', 'ctype.c', 'div.c', 'exit.c', 'getenv.c', 'malloc.c', 'qsort.c', 'strto64.c', 'strtod.c', 'strtol.c', 'strtou64.c', 'strtoul.c'],
	'mod/venimpl/c/str' : ['Makefile', '_wordcopy.c', 'memchr.c', 'memcmp.c', 'memcpy.c', 'memmove.c', 'memset.c', 'strcat.c', 'strchr.c', 'strcmp.c', 'strcpy.c', 'strcspn.c', 'strdup.c', 'strlen.c', 'strncat.c', 'strncmp.c', 'strncpy.c', 'strpbrk.c', 'strrchr.c', 'strsep.c', 'strspn.c', 'strstr.c'],
        'mod/wtime' : ['Wall_Clock.c'],
	'ntsc' : ['Makefile', 'README'],
	'ntsc/alpha' : ['Makefile', 'gdb-stub.c', 'kernel.c', 'khead.S', 'ksched.S', 'mmgmt.c'],
	'ntsc/alpha/eb164' : ['Clock.c', 'Makefile', 'Timer.c', 'cserve.S', 'io.c', 'kernel_mc.c', 'local.c', 'primouts.c', 'serial.c', 'tstub.S'],
	'ntsc/alpha/pal' : ['CONFIDENTIAL', 'Makefile', 'Precompiled.mk'],
	'ntsc/alpha/pal/eb164' : ['Makefile', 'sys-cflush.S', 'sys-cserve.S', 'sys-enter-console.S', 'sys-interrupt.S', 'sys-mchk.S', 'sys-reset.S', 'sys-wripir.S'],
	'ntsc/alpha/pal/ev5' : ['121P_lookup.S', 'Makefile', 'actdom.S', 'akevent.S', 'arith.S', 'block.S', 'bpt.S', 'bugchk.S', 'call_pal.S', 'callpriv.S', 'cflush.S', 'cserve.S', 'dbgstop.S', 'draina.S', 'dtb-fault.S', 'entkern.S', 'fen.S', 'gentrap.S', 'gprot_121P.S', 'gprot_GPT.S', 'gprot_linear.S', 'gpt_lookup.S', 'halt.S', 'imb.S', 'interrupt.S', 'itb-acv.S', 'itb-miss-121P.S', 'itb-miss-GPT.S', 'itb-miss-linear.S', 'kevent.S', 'leavekern.S', 'linear_lookup.S', 'main.S', 'map_121P.S', 'map_GPT.S', 'map_linear.S', 'mask_irq.S', 'mchk.S', 'mm-fault.S', 'mtpr_sirr.S', 'nail_GPT.S', 'nail_linear.S', 'ndtb-miss-121P.S', 'ndtb-miss-GPT.S', 'ndtb-miss-linear.S', 'opcdec.S', 'pdtb-miss-121P.S', 'pdtb-miss-GPT.S', 'pdtb-miss-linear.S', 'pdtb-miss-linear.S.orig', 'prot_121P.S', 'prot_GPT.S', 'prot_linear.S', 'rdps.S', 'rdusp.S', 'resdom.S', 'reset.S', 'rfa.S', 'rfa_block.S', 'rfa_resume.S', 'rti.S', 'send.S', 'state.S', 'swpipl.S', 'swppal.S', 'tbi.S', 'trans_121P.S', 'trans_GPT.S', 'trans_linear.S', 'unalign.S', 'unmask_irq.S', 'wrent.S', 'wrksp.S', 'wrmces.S', 'wrpdom.S', 'wrptbr.S', 'yield.S'],
	'ntsc/arm' : ['Makefile', 'as.S', 'asmchecks.h', 'bos.S', 'gdb-stub.c', 'kernel.c', 'khead_shark.S', 'mmgmt.c'],
	'ntsc/arm/shark' : ['Makefile', 'irq.S', 'kernel_mc.c', 'sequoia.c', 'serial.c', 'timer_fiq.c', 'timer_rtc.c'],
	'ntsc/generic' : ['Makefile', 'atropos.c', 'console.c', 'console.h', 'crash.c', 'crash.h', 'kprintf.c', 'readnexus.c', 'string.c', 'string.h'],
	'ntsc/ix86' : ['Makefile'],
	'ntsc/ix86/intel' : ['Makefile', 'asm.h', 'gdb-asm.S', 'i386-stub.c', 'i386-stub.h', 'idt.S', 'inline.h', 'kernel.c', 'khead.S', 'local.c', 'mmgmt.c', 'pagesetup.c', 'segment.h', 'serial.c', 'stub-support.c', 'syscalls.c', 'timer.c', 'timer_rdtsc.c'],
	'repo' : ['Makefile'],
	'sys' : [],
	'sys/domains' : ['Binder.c', 'Domain.if', 'DomainMgr.c', 'DomainMgr.if', 'DomainMgrMod.if', 'DomainMgr_st.h', 'Makefile', 'Plumber.c', 'sched.c', 'sched_alpha.c', 'sched_arm.c', 'sched_intel-smp.c', 'sched_intel.c', 'security.c'],
	'sys/interfaces' : [],
	'sys/interfaces/alpha' : ['CmosRam.if'],
	'sys/interfaces/callpriv' : ['CallPriv.if', 'IOCallPriv.if'],
	'sys/interfaces/central' : ['Activation.if', 'ActivationF.if', 'ActivationMod.if', 'Binder.if', 'BinderCallback.if', 'BootDomain.if', 'Builder.if', 'ChainedHandler.if', 'Channel.if', 'ChannelNotify.if', 'Clock.if', 'Closure.if', 'ConsoleWr.if', 'Context.if', 'Directory.if', 'Event.if', 'Events.if', 'EventsMod.if', 'Exception.if', 'Exec.if', 'ExnRegistry.if', 'ExnSetjmp.if', 'ExnSupport.if', 'ExnSystem.if', 'FIFO.if', 'FIFOMod.if', 'File.if', 'FileIO.if', 'Heap.if', 'HeapMod.if', 'Interrupt.if', 'Load.if', 'LockedHeap.if', 'Pervasives.if', 'Plumber.if', 'ProtectionDomain.if', 'QoSCtl.if', 'Rd.if', 'SRCThread.if', 'SRCThreadMod.if', 'Security.if', 'Tasks.if', 'Thread.if', 'ThreadF.if', 'ThreadHooks.if', 'Threads.if', 'ThreadsPackage.if', 'Time.if', 'TimeNotify.if', 'VP.if', 'Wr.if'],
	'sys/interfaces/common_memory' : ['Frames.if', 'FramesF.if', 'FramesMod.if', 'GDB.if', 'GDBMod.if', 'MMEntry.if', 'MMEntryMod.if', 'MMNotify.if', 'MMNotifyMod.if', 'MMU.if', 'MMUMod.if', 'Mem.if', 'RamTab.if', 'Stretch.if', 'StretchAllocator.if'],
	'sys/interfaces/entries' : ['Entry.if', 'EntryMod.if', 'IOEntry.if', 'IOEntryMod.if', 'QoSEntry.if', 'QoSEntryMod.if'],
	'sys/interfaces/idc' : ['IDC.if', 'IDCBinding.if', 'IDCCallback.if', 'IDCClientBinding.if', 'IDCClientStubs.if', 'IDCMod.if', 'IDCOffer.if', 'IDCOfferMod.if', 'IDCServerBinding.if', 'IDCServerStubs.if', 'IDCService.if', 'IDCStubs.if', 'IDCTransport.if', 'IORConverter.if', 'ObjectTbl.if', 'ObjectTblMod.if'],
	'sys/interfaces/io' : ['IO.if', 'IOClosure.if', 'IOData.if', 'IOMod.if', 'IONotify.if', 'IOOffer.if', 'IOTransport.if'],
	'sys/memory' : ['Makefile', 'eb164_mmu_121.c', 'eb164_mmu_gpt.c', 'eb164_mmu_linear.c', 'frames.c', 'intel_mmu.c', 'mmu.h', 'salloc_expt.c', 'salloc_std.c', 'shark_mmu.c'],
	'sys/memory/ifaces_expt' : ['FaultHandler.if', 'SAllocMod.if', 'SDriverMod.if', 'StretchAllocatorF.if', 'StretchDriver.if'],
	'sys/memory/ifaces_std' : ['SAllocMod.if', 'StretchAllocatorF.if', 'StretchDriver.if'],
	'sys/nemesis' : ['CallPriv.c', 'Console.c', 'Console.h', 'ConsoleControl.if', 'IntAlloc.c', 'ModData.c', 'ModData.if', 'NTSC.c', 'NTSC.if', 'Nemesis.c', 'Trader.c', 'klogd.c', 'klogd.h', 'misc.h', 'schedctl.c'],
	'sys/primal' : ['Makefile', 'NemesisPrimal.c', 'addr_init.h', 'addr_init_eb164.c', 'addr_init_intel.c', 'addr_init_shark.c', 'nexus_util.c', 'pcrt0_alpha.S', 'pcrt0_arm.S', 'pcrt0_ix86.S'],
	'sys/typesystem' : ['Choice.if', 'Enum.if', 'Enumeration.c', 'IREF.def.c', 'Interface.c', 'Interface.if', 'Operation.c', 'Operation.if', 'Record.if', 'Type.if', 'TypeSystem.c', 'TypeSystem.if', 'TypeSystemF.if', 'TypeSystemMod.if'],
}
