/*
 * isapnp for Nemesis. Ported from the linux version by Michael Dales 
 * (michael@dcs.gla.ac.uk) and Rolf Neugebauer (neugebar@dcs.gla.ac.uk).
 *
 * This program is for use on machines that don't have a BIOS which will
 * correctly configure PnP hardware. It takes in a config file generated
 * using pnpdump (we generated it under Linux) on the same machine.
 *
 * Important: Read the README.Nemesis for info on how to use this program. 
 *
 * This has benn compiled and tested successfully on x86. There are some
 * #define EB164 from the original code, but there have not been tested
 * yet. There is a chunck of hac.., erm, tweaks, in a section called 
 * #define NEMESIS which allow it to compile properly on that
 * platform.
 *
 * For the curious isapnp.c.diff shows what we changed to get from the
 * standard version to this version.
 *
 * Last modified: 4th June 1999
 */

/* A lexical scanner generated by flex */

/* Scanner skeleton version:
 * $Header: /home/daffy/u0/vern/flex/RCS/flex.skl,v 2.91 96/09/10 16:58:48 vern Exp $
 */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5

#include <stdio.h>


/* cfront 1.2 defines "c_plusplus" instead of "__cplusplus" */
#ifdef c_plusplus
#ifndef __cplusplus
#define __cplusplus
#endif
#endif


#ifdef __cplusplus

#include <stdlib.h>
#include <unistd.h>

/* Use prototypes in function declarations. */
#define YY_USE_PROTOS

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

#if __STDC__

#define YY_USE_PROTOS
#define YY_USE_CONST

#endif	/* __STDC__ */
#endif	/* ! __cplusplus */

#ifdef __TURBOC__
 #pragma warn -rch
 #pragma warn -use
#include <io.h>
#include <stdlib.h>
#define YY_USE_CONST
#define YY_USE_PROTOS
#endif

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif


#ifdef YY_USE_PROTOS
#define YY_PROTO(proto) proto
#else
#define YY_PROTO(proto) ()
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN yy_start = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START ((yy_start - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart( yyin )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#define YY_BUF_SIZE 16384

typedef struct yy_buffer_state *YY_BUFFER_STATE;

extern int yyleng;
extern FILE *yyin, *yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

/* The funky do-while in the following #define is used to turn the definition
 * int a single C statement (which needs a semi-colon terminator).  This
 * avoids problems with code like:
 *
 * 	if ( condition_holds )
 *		yyless( 5 );
 *	else
 *		do_something_else();
 *
 * Prior to using the do-while the compiler would get upset at the
 * "else" because it interpreted the "if" statement as being all
 * done when it reached the ';' after the yyless() call.
 */

/* Return all but the first 'n' matched characters back to the input stream. */

#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
		*yy_cp = yy_hold_char; \
		YY_RESTORE_YY_MORE_OFFSET \
		yy_c_buf_p = yy_cp = yy_bp + n - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, yytext_ptr )

/* The following is because we cannot portably get our hands on size_t
 * (without autoconf's help, which isn't available because we want
 * flex-generated scanners to compile on their own).
 */
typedef unsigned int yy_size_t;


struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;
#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2
	};

static YY_BUFFER_STATE yy_current_buffer = 0;

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 */
#define YY_CURRENT_BUFFER yy_current_buffer


/* yy_hold_char holds the character lost when yytext is formed. */
static char yy_hold_char;

static int yy_n_chars;		/* number of characters read into yy_ch_buf */


int yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = (char *) 0;
static int yy_init = 1;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void yyrestart YY_PROTO(( FILE *input_file ));

void yy_switch_to_buffer YY_PROTO(( YY_BUFFER_STATE new_buffer ));
void yy_load_buffer_state YY_PROTO(( void ));
YY_BUFFER_STATE yy_create_buffer YY_PROTO(( FILE *file, int size ));
void yy_delete_buffer YY_PROTO(( YY_BUFFER_STATE b ));
void yy_init_buffer YY_PROTO(( YY_BUFFER_STATE b, FILE *file ));
void yy_flush_buffer YY_PROTO(( YY_BUFFER_STATE b ));
#define YY_FLUSH_BUFFER yy_flush_buffer( yy_current_buffer )

YY_BUFFER_STATE yy_scan_buffer YY_PROTO(( char *base, yy_size_t size ));
YY_BUFFER_STATE yy_scan_string YY_PROTO(( yyconst char *yy_str ));
YY_BUFFER_STATE yy_scan_bytes YY_PROTO(( yyconst char *bytes, int len ));

static void *yy_flex_alloc YY_PROTO(( yy_size_t ));
static void *yy_flex_realloc YY_PROTO(( void *, yy_size_t ));
static void yy_flex_free YY_PROTO(( void * ));

#define yy_new_buffer yy_create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! yy_current_buffer ) \
		yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE ); \
	yy_current_buffer->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! yy_current_buffer ) \
		yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE ); \
	yy_current_buffer->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (yy_current_buffer->yy_at_bol)

typedef unsigned char YY_CHAR;
FILE *yyin = (FILE *) 0, *yyout = (FILE *) 0;
typedef int yy_state_type;
extern char *yytext;
#define yytext_ptr yytext

static yy_state_type yy_get_previous_state YY_PROTO(( void ));
static yy_state_type yy_try_NUL_trans YY_PROTO(( yy_state_type current_state ));
static int yy_get_next_buffer YY_PROTO(( void ));
static void yy_fatal_error YY_PROTO(( yyconst char msg[] ));

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	yytext_ptr = yy_bp; \
	yyleng = (int) (yy_cp - yy_bp); \
	yy_hold_char = *yy_cp; \
	*yy_cp = '\0'; \
	yy_c_buf_p = yy_cp;

#define YY_NUM_RULES 76
#define YY_END_OF_BUFFER 77
static yyconst short int yy_accept[326] =
    {   0,
       72,   72,   72,   72,   72,   72,   72,   72,   72,   72,
       72,   72,   72,   72,   72,   72,   72,   72,   72,   72,
       72,   72,   72,   72,   72,   72,   72,   72,   72,   72,
       72,   72,   72,   72,   72,   72,   72,   72,   72,   72,
       72,   72,   72,   72,   72,   72,   77,   74,   72,   73,
       71,    1,    2,   74,   74,   74,   74,   74,   74,   19,
       74,   23,   74,   74,   74,   74,   74,   44,   74,   46,
       74,   74,   50,   74,   74,   74,   74,   57,   74,   74,
       60,   74,   74,   63,   74,   69,   74,   16,   32,   18,
       17,   22,   21,   34,   33,   36,   35,   38,   37,   31,

       30,   40,   39,   43,   42,   42,   68,   67,   74,   72,
       73,   71,   72,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,   24,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,   33,   35,   37,   39,   42,    0,    0,
       75,   72,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,   20,   29,   26,   27,   25,   28,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,   41,    0,    0,   14,    0,    0,    0,    0,
        0,    0,    0,   45,    0,   49,    0,    0,   56,    0,

        0,   59,    0,   61,   62,   66,    0,    0,    0,    3,
        0,    0,    0,    0,    0,    0,    0,   48,   48,    0,
       52,   52,    0,    0,    0,    0,    0,   65,   65,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
       55,    0,   54,   54,    0,    0,   70,    0,    0,    0,
       12,    0,    0,    0,   47,   51,    0,    0,   64,    0,
        0,    0,    0,    0,    0,    0,    5,    0,   53,    0,
       58,    0,    0,    9,    0,   11,   11,    4,    0,    0,
        0,    8,    8,    0,    5,    0,    0,    0,    0,    0,
        0,    0,    0,   15,    0,    0,   10,    0,    0,    7,

        0,    0,   12,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    6,    0,    0,
       13,    0,    6,    0,    0
    } ;

static yyconst int yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    1,    4,    5,    1,    1,    1,    1,    6,
        7,    8,    9,    1,   10,    1,   11,   12,   13,   13,
       13,   13,   13,   13,   13,   13,   13,    1,    1,    1,
        1,    1,    1,   14,   16,   17,   18,   19,   20,   21,
       22,   23,   24,   14,   25,   26,   27,   28,   29,   30,
       31,   32,   33,   34,   35,   36,   37,   38,   39,   14,
       14,   15,   14,   14,   14,    1,   16,   17,   18,   19,

       20,   21,   22,   23,   24,   14,   25,   26,   27,   28,
       29,   30,   31,   32,   33,   34,   35,   36,   37,   38,
       39,   14,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst int yy_meta[40] =
    {   0,
        1,    2,    2,    1,    1,    1,    1,    1,    1,    1,
        1,    3,    3,    4,    4,    5,    5,    5,    5,    5,
        5,    4,    4,    4,    4,    4,    4,    4,    4,    4,
        4,    4,    4,    4,    4,    4,    4,    4,    4
    } ;

static yyconst short int yy_base[345] =
    {   0,
        0,    5,   10,    0,   17,   28,   53,    0,   34,   46,
       84,  113,  142,    0,  171,  200,  229,  258,   67,   76,
       92,  106,   60,   68,   93,  105,  132,  148,  155,  161,
      292,  304,  316,  328,  340,  352,  364,  402,  440,  452,
      464,  476,  168,  177,   76,  123,  661,  662,  658,  662,
      662,  662,  662,   11,  639,  171,  638,  637,  640,  662,
      636,  662,  636,  626,   76,  632,  631,  662,  630,  662,
      633,  628,  662,  631,  617,  625,  614,  662,  620,  622,
      662,  609,  620,  662,    3,  662,  610,  662,  662,  662,
      662,  662,  662,  662,   13,  662,  119,  662,  173,  662,

      662,  662,  179,  662,  182,  184,  662,  662,  635,  197,
      662,  634,  634,  607,  606,  616,  612,  603,  601,  613,
      596,  603,  200,  592,  609,  590,  662,  596,  600,  601,
      587,  599,  585,  598,  585,  572,  583,  576,  560,  568,
      562,  554,  557,  196,  198,  202,  209,  211,    0,  570,
      662,  223,  549,  226,  532,  521,  518,  520,  526,  520,
      509,  229,  221,  662,  662,  662,  662,  662,  517,  521,
      515,  511,  491,  484,  482,  469,  470,  242,  467,  455,
      455,  448,    0,  438,  245,  237,  434,  415,  412,  423,
      401,  408,  406,  662,  249,  662,  264,  266,  662,  387,

      386,  662,  268,  260,  662,  662,  288,  370,  384,  662,
      378,  371,  351,  349,  329,  327,  312,  274,  266,  324,
      336,  326,  358,   89,  374,  324,  381,  350,  338,  387,
        1,  297,  299,  295,  288,  270,  270,  260,    0,    0,
      662,  398,  386,  369,  263,    0,  662,  252,  235,  231,
      410,  226,  224,  215,    0,    0,    0,  413,    0,  217,
      488,  201,  418,  190,  173,  420,  435,  167,    0,  448,
      405,  432,  491,  662,  160,  472,  460,  662,  136,  132,
      503,  474,  495,  511,  662,  109,  515,    0,  117,    0,
      126,   84,    0,  662,    0,   60,    0,   58,   68,    0,

        0,   55,  662,   34,    0,   43,   16,    0,   11,   18,
        0,  517,    3,  520,   46,  520,   53,  662,  523,  516,
      522,  125,  161,  533,  662,  550,  555,  560,  563,  566,
      569,  572,  575,  579,  581,  584,  587,  589,  592,  595,
      598,  601,  606,  611
    } ;

static yyconst short int yy_def[345] =
    {   0,
      326,  326,  326,    3,  326,  326,  326,    7,  326,  326,
      326,  326,  326,   13,   13,   13,   13,   13,   13,   13,
       13,   13,  326,  326,  326,  326,  326,  326,  326,  326,
      326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
      326,  326,  326,  326,  327,  327,  325,  325,  325,  325,
      325,  325,  325,  325,  325,  325,  325,  325,  325,  325,
      325,  325,  325,  325,  325,  325,  325,  325,  325,  325,
      325,  325,  325,  325,  325,  325,  325,  325,  325,  325,
      325,  325,  325,  325,  325,  325,  325,  325,  325,  325,
      325,  325,  325,  325,  325,  325,  325,  325,  325,  325,

      325,  325,  325,  325,  325,  325,  325,  325,  328,  328,
      325,  328,  325,  325,  325,  325,  325,  325,  325,  325,
      325,  325,  325,  325,  325,  325,  325,  325,  325,  325,
      325,  325,  325,  325,  325,  325,  325,  325,  325,  325,
      325,  325,  325,  325,  325,  325,  325,  325,  329,  328,
      325,  328,  325,  325,  325,  325,  325,  325,  325,  325,
      325,  325,  325,  325,  325,  325,  325,  325,  325,  325,
      325,  325,  325,  325,  325,  325,  325,  325,  325,  325,
      325,  325,  329,  325,  325,  325,  325,  325,  325,  325,
      325,  325,  325,  325,  325,  325,  325,  325,  325,  325,

      325,  325,  325,  325,  325,  325,  325,  325,  325,  325,
      325,  325,  325,  325,  325,  325,  325,  325,  325,  325,
      325,  325,  325,  325,  325,  325,  325,  325,  325,  325,
      325,  325,  325,  325,  325,  325,  325,  325,  330,  331,
      325,  325,  325,  325,  325,  332,  325,  325,  325,  325,
      325,  325,  325,  325,  330,  331,  333,  325,  332,  325,
      325,  325,  325,  325,  325,  325,  325,  325,  333,  325,
      325,  334,  325,  325,  325,  325,  325,  325,  325,  325,
      325,  325,  325,  325,  325,  325,  334,  335,  325,  336,
      325,  325,  337,  325,  338,  325,  336,  325,  325,  337,

      339,  325,  325,  325,  340,  325,  325,  341,  325,  325,
      342,  325,  325,  325,  343,  325,  343,  325,  344,  325,
      325,  343,  343,  344,    0,  325,  325,  325,  325,  325,
      325,  325,  325,  325,  325,  325,  325,  325,  325,  325,
      325,  325,  325,  325
    } ;

static yyconst short int yy_nxt[702] =
    {   0,
      325,   49,   50,  325,   51,   52,   49,   50,  325,   51,
       52,   49,   50,  316,   51,  325,   53,  325,   49,   50,
      247,   51,  141,   60,  144,  144,  247,   54,   55,   49,
       50,  142,   51,   56,   60,   49,   50,  303,   51,  114,
       68,   57,   61,  115,  312,   58,   59,   49,   50,  318,
       51,  310,   68,   61,   49,   50,  318,   51,  309,   62,
      319,   49,   50,   69,   51,  307,   88,  319,   63,   49,
       50,   64,   51,   84,   88,   69,   65,  110,  111,   66,
      112,  306,   84,   48,   67,   49,   50,  304,   51,  303,
       70,  302,   48,   48,   49,   50,   85,   51,   86,   89,

       71,   48,   48,  126,  127,   85,   49,   50,   48,   51,
       48,   89,   86,   72,   49,   50,  299,   51,   87,   70,
      241,   48,   48,  241,  110,  111,   48,  112,  318,   71,
      145,  145,   87,   49,   50,   48,   51,   90,   91,  319,
       48,  298,   72,   49,   50,  296,   51,  294,   73,   49,
       50,  292,   51,   90,   91,  291,   49,   50,   74,   51,
       92,   93,   49,   50,  318,   51,   92,   93,   75,   49,
       50,   76,   51,  107,  108,  319,   77,   78,   49,   50,
      289,   51,  107,  108,  146,  146,  286,   48,   79,  117,
      147,  147,  118,  148,  148,  148,  148,   48,  152,  151,

       80,  162,  162,  119,  280,   48,   78,  144,  144,  145,
      145,  163,  163,  146,  146,  279,   48,   79,  278,  149,
      147,  147,  148,  148,  152,  151,   48,  185,  185,   80,
      162,  162,  163,  163,   48,   81,  272,  186,  186,  268,
      163,  163,  267,  203,  203,   48,  185,  185,  186,  186,
      217,  217,   82,  204,  204,   48,  186,  186,   83,  266,
      218,  219,  262,   48,   81,  220,  220,  223,  223,  203,
      203,  204,  204,  261,   48,  221,  222,  219,  219,  204,
      204,   82,  224,  260,   48,  219,  219,   83,  258,  227,
      227,  254,   48,   49,   50,  253,   51,   94,   89,  228,

      229,  252,  224,   95,   95,   49,   50,  251,   51,   94,
       89,  239,  250,  217,  217,   95,   95,   49,   50,  249,
       51,   96,   89,  218,  219,  220,  220,   97,   97,   49,
       50,  248,   51,   96,   89,  221,  222,  222,  222,   97,
       97,   49,   50,  245,   51,   98,   89,  222,  222,  229,
      229,   99,   99,   49,   50,  238,   51,   98,   89,  223,
      223,  229,  229,   99,   99,   49,   50,  237,   51,  100,
       89,  230,  230,  240,  224,  242,  242,  236,  231,  231,
      244,  244,  227,  227,  235,  243,  244,  246,  230,  230,
      234,  101,  228,  229,  224,  231,  231,  244,  244,  242,

      242,  233,  101,   49,   50,  232,   51,  100,   89,  243,
      244,  263,  263,  226,  270,  270,  271,  271,  225,  263,
      263,  281,  281,  257,  271,  271,  216,  264,  215,  101,
      214,  282,  283,  287,  287,  264,  284,  284,  213,  265,
      101,   49,   50,  212,   51,  102,   89,  265,  211,  270,
      270,  103,  103,   49,   50,  210,   51,  102,   89,  271,
      271,  209,  285,  103,  103,   49,   50,  208,   51,  104,
       89,  277,  277,  285,  207,  105,  106,   49,   50,  206,
       51,  104,   89,  277,  277,  283,  283,  105,  106,  273,
      273,  205,  273,  273,  202,  274,  201,  275,  274,  276,

      277,  200,  276,  277,  281,  281,  283,  283,  199,  290,
      198,  293,  284,  284,  282,  283,  287,  287,  314,  314,
      315,  314,  314,  315,  320,  317,  323,  321,  321,  320,
      197,  321,  321,  321,  321,  317,  323,  324,  285,  196,
      195,  194,  193,  192,  191,  190,  189,  324,  188,  285,
       48,   48,   48,   48,   48,  109,  109,  109,  109,  109,
      150,  150,  150,  150,  150,  183,  187,  183,  255,  184,
      255,  256,  151,  256,  259,  182,  259,  269,  181,  269,
      288,  180,  288,  288,  295,  295,  297,  179,  297,  300,
      178,  300,  301,  301,  305,  177,  305,  308,  176,  308,

      311,  175,  311,  313,  174,  313,  317,  317,  317,  317,
      317,  322,  322,  322,  322,  322,  173,  172,  171,  170,
      169,  168,  167,  166,  165,  164,  161,  160,  159,  158,
      157,  156,  155,  154,  153,  113,  151,  151,  143,  140,
      139,  138,  137,  136,  135,  134,  133,  132,  131,  130,
      129,  128,  125,  124,  123,  122,  121,  120,  116,  113,
      325,   47,  325,  325,  325,  325,  325,  325,  325,  325,
      325,  325,  325,  325,  325,  325,  325,  325,  325,  325,
      325,  325,  325,  325,  325,  325,  325,  325,  325,  325,
      325,  325,  325,  325,  325,  325,  325,  325,  325,  325,

      325
    } ;

static yyconst short int yy_chk[702] =
    {   0,
        0,    1,    1,    0,    1,    1,    2,    2,    0,    2,
        2,    3,    3,  313,    3,    0,    3,    0,    5,    5,
      231,    5,   85,    5,   95,   95,  231,    3,    3,    6,
        6,   85,    6,    3,    6,    9,    9,  310,    9,   54,
        9,    3,    5,   54,  309,    3,    3,   10,   10,  315,
       10,  307,   10,    6,    7,    7,  317,    7,  306,    7,
      315,   23,   23,    9,   23,  304,   23,  317,    7,   24,
       24,    7,   24,   19,   24,   10,    7,   45,   45,    7,
       45,  302,   20,   19,    7,   11,   11,  299,   11,  298,
       11,  296,   20,   19,   25,   25,   19,   25,   21,   25,

       11,   19,   20,   65,   65,   20,   26,   26,   21,   26,
       20,   26,   22,   11,   12,   12,  292,   12,   21,   12,
      224,   21,   22,  224,   46,   46,   21,   46,  322,   12,
       97,   97,   22,   27,   27,   22,   27,   27,   27,  322,
       22,  291,   12,   13,   13,  289,   13,  286,   13,   28,
       28,  280,   28,   28,   28,  279,   29,   29,   13,   29,
       29,   29,   30,   30,  323,   30,   30,   30,   13,   43,
       43,   13,   43,   43,   43,  323,   13,   15,   44,   44,
      275,   44,   44,   44,   99,   99,  268,   15,   15,   56,
      103,  103,   56,  105,  105,  106,  106,   15,  110,  110,

       15,  123,  123,   56,  265,   15,   16,  144,  144,  145,
      145,  123,  123,  146,  146,  264,   16,   16,  262,  105,
      147,  147,  148,  148,  152,  152,   16,  154,  154,   16,
      162,  162,  163,  163,   16,   17,  260,  154,  154,  254,
      162,  162,  253,  178,  178,   17,  185,  185,  186,  186,
      195,  195,   17,  178,  178,   17,  185,  185,   17,  252,
      195,  195,  250,   17,   18,  197,  197,  198,  198,  203,
      203,  204,  204,  249,   18,  197,  197,  219,  219,  203,
      203,   18,  198,  248,   18,  218,  218,   18,  245,  207,
      207,  238,   18,   31,   31,  237,   31,   31,   31,  207,

      207,  236,  198,   31,   31,   32,   32,  235,   32,   32,
       32,  218,  234,  217,  217,   32,   32,   33,   33,  233,
       33,   33,   33,  217,  217,  220,  220,   33,   33,   34,
       34,  232,   34,   34,   34,  220,  220,  222,  222,   34,
       34,   35,   35,  226,   35,   35,   35,  221,  221,  229,
      229,   35,   35,   36,   36,  216,   36,   36,   36,  223,
      223,  228,  228,   36,   36,   37,   37,  215,   37,   37,
       37,  208,  208,  221,  223,  225,  225,  214,  208,  208,
      244,  244,  227,  227,  213,  225,  225,  228,  230,  230,
      212,   37,  227,  227,  223,  230,  230,  243,  243,  242,

      242,  211,   37,   38,   38,  209,   38,   38,   38,  242,
      242,  251,  251,  201,  258,  258,  271,  271,  200,  263,
      263,  266,  266,  243,  258,  258,  193,  251,  192,   38,
      191,  266,  266,  272,  272,  263,  267,  267,  190,  251,
       38,   39,   39,  189,   39,   39,   39,  263,  188,  270,
      270,   39,   39,   40,   40,  187,   40,   40,   40,  270,
      270,  184,  267,   40,   40,   41,   41,  182,   41,   41,
       41,  277,  277,  267,  181,   41,   41,   42,   42,  180,
       42,   42,   42,  276,  276,  282,  282,   42,   42,  261,
      261,  179,  273,  273,  177,  261,  176,  261,  273,  261,

      261,  175,  273,  273,  281,  281,  283,  283,  174,  276,
      173,  282,  284,  284,  281,  281,  287,  287,  312,  312,
      312,  314,  314,  314,  316,  319,  319,  320,  320,  316,
      172,  316,  316,  321,  321,  324,  324,  319,  284,  171,
      170,  169,  161,  160,  159,  158,  157,  324,  156,  284,
      326,  326,  326,  326,  326,  327,  327,  327,  327,  327,
      328,  328,  328,  328,  328,  329,  155,  329,  330,  153,
      330,  331,  150,  331,  332,  143,  332,  333,  142,  333,
      334,  141,  334,  334,  335,  335,  336,  140,  336,  337,
      139,  337,  338,  338,  339,  138,  339,  340,  137,  340,

      341,  136,  341,  342,  135,  342,  343,  343,  343,  343,
      343,  344,  344,  344,  344,  344,  134,  133,  132,  131,
      130,  129,  128,  126,  125,  124,  122,  121,  120,  119,
      118,  117,  116,  115,  114,  113,  112,  109,   87,   83,
       82,   80,   79,   77,   76,   75,   74,   72,   71,   69,
       67,   66,   64,   63,   61,   59,   58,   57,   55,   49,
       47,  325,  325,  325,  325,  325,  325,  325,  325,  325,
      325,  325,  325,  325,  325,  325,  325,  325,  325,  325,
      325,  325,  325,  325,  325,  325,  325,  325,  325,  325,
      325,  325,  325,  325,  325,  325,  325,  325,  325,  325,

      325
    } ;

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *yytext;
// #line 1 "isapnp.y"
#define INITIAL 0
// #line 3 "isapnp.y"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>

#ifdef __DJGPP__
#undef REALTIME
#include <inlines/pc.h>
#include <dos.h>
#else
#ifndef _OS2_
//#include <sys/types.h>
#  if defined __GLIBC__ && __GLIBC__ >= 2
#    include <sys/io.h>
#  else
#    ifdef EB164
#       include <eb164/io.h>
#    else
#       include <io.h>
#    endif
#  endif /* __GLIBC__ */
#else
#include <sys/hw.h>
#endif /* _OS2_ */
#endif

#include "pnp.h"

static char rcsid[] = "$Id: isapnp.c 1.1 Tue, 08 Jun 1999 13:55:55 +0100 dr10009 $";

#ifdef REALTIME
/*
 * Code to set scheduler to Realtime, Round-Robin, so usleeps right etc
 */
#if defined __GLIBC__ && __GLIBC__ >= 2
#  include <sched.h>
#else
#  include <linux/unistd.h>
#  include <linux/sched.h>
#  include <sys/time.h>

#  ifdef NEEDSETSCHEDULER
   _syscall3(int, sched_setscheduler, pid_t, pid, int, policy, struct sched_param *, sched_p)
#  endif
#  ifdef NEEDNANOSLEEP
   _syscall2(int, nanosleep, struct timespec *, rqtp, struct timespec *, rmtp)
#  endif
#endif /* __GLIBC__ */

int realtimeok = 0;

void
setroundrobin(void)
{
	pid_t mypid = getpid();
	struct sched_param sched_p = { 50 };
	/* Use the syscall, as my library not up todate */
	if(sched_setscheduler( mypid, SCHED_RR, &sched_p) < 0)
	{
		perror("Couldn't set real-time scheduling, may be a bit slow");
	}
	else
		realtimeok = 1;
}

/*
 * Use nanosleep for realtime delays
 */
void
delaynus(long del)
{
	struct timespec t;
	t.tv_sec = 0;
	t.tv_nsec = del * 1000;
	/*
	 * Need to handle case where binary for later kernel run on an
	 * earlier one, which doesn't support nanosleep (emergency backup spare !)
	 */
	if(realtimeok)
	{
		if(nanosleep(&t, (struct timespec *) 0) < 0)
		{
			perror("nanosleep failed");
			realtimeok = 0;
		}
	}
	else
		usleep(del);
}
#else
#define delaynus(x) usleep(x)
#undef NEEDSETSCHEDULER
#undef NEEDNANOSLEEP
#endif /* REALTIME */

int ignorecrc = 0;
int read_port = 0;
int debug = 0;
int linenumber = 1;
int initiated = 0;
char * identifyformat = "Board %b has Identity %8 %7 %6 %5 %4 %3 %2 %1 %0:  %v Serial No %s [checksum %8]\n";

/*
 * The scanner produces a list of actions, in the form of a function
 * pointer and a string argument
 */
typedef struct action
{
	int (*fn)(char *);
	char *name;
	char *arg;
	int linenum;
	int jumponerror;
} ACTION, *ACTIONPTR;

#define ADDACTIONS 100

ACTION *actions = (ACTION *)0;
int maxactions = 0;
int nextaction = 0;
int configureaction = 0; /* Backwards reference to skip missing boards */

int parseerror = 0;

/* -------------------------------------------------------------
 * This is needed to get the code to compile under nemesis
 */
#if NEMESIS

// Permission? Who needs permission...
#ifdef EB164
int  ioperm(unsigned  long  from,  unsigned  long num, int turn_on) { return 0;}
#else
unsigned iopl(unsigned port){return(0);}
#endif


#if 1 // If not using posix lib
int fileno( FILE *stream) {return 0;}
int isatty(int desc) { return 0;}
void perror(const char *s) {eprintf("ERROR: %s\n", s);}
#define getc(_x) fgetc(_x)
#define putchar(_c) fputc(_c, stdout)
#endif 

#include <../time.h>
#include <ecs.h>

void usleep(unsigned wait) { PAUSE(MICROSECS(wait));}

int strncasecmp(char *str1, char *str2, unsigned length)
{
  char *buffer1, *buffer2;
  int  counter, return_value;

  /* Allocate space for temp buffer */
  if((buffer1 = malloc(strlen(str1)+1)) == (char *)0) {
    perror("Allocating spare memory");
    exit(1);
  }
  else {
    (void)strcpy(buffer1, str1);
  }
  if((buffer2 = malloc(strlen(str2)+1)) == (char *)0) {
    perror("Allocating spare memory");
    exit(1);
  }
  else {
    (void)strcpy(buffer2, str2);
  }

  /* Decase letters to lower case */
  for(counter = 0 ; counter < strlen(str1) ; counter++)
    if(str1[counter] >= 'a')
      buffer1[counter] = (char)('A' + (str1[counter]-'a'));
  for(counter = 0 ; counter < strlen(str2) ; counter++)
    if(str2[counter] >= 'a')
      buffer2[counter] = (char)('A' + (str2[counter]-'a'));

  /* Now calculate the return value */
  return_value = strncmp(str1, str2, length);

  /* Free up the space */
  (void)free(str1);
  (void)free(str2);

  /* Now give the return value */
  return(return_value);
}
#endif // NEMESIS
/* ------------------------------------------------------------- */

#ifdef _OS2_
unsigned inb(unsigned port){return(_inp8(port));}
unsigned inw(unsigned port){return(_inp16(port));}
unsigned inl(unsigned port){return(_inp32(port));}
void outb(unsigned value, unsigned port){_outp8(port, value);}
/* void outw(unsigned port, unsigned value){_outp16(port, value);} */
/* void outl(unsigned port, unsigned value){_outp32(port, value);} */
unsigned iopl(unsigned port){return(0);}
unsigned usleep(unsigned wait){return(_sleep2(wait/1000));}
int strncasecmp(char *str1, char *str2, unsigned length)
{
  char *buffer1, *buffer2;
  int  counter, return_value;

  /* Allocate space for temp buffer */
  if((buffer1 = malloc(strlen(str1)+1)) == (char *)0) {
    perror("Allocating spare memory");
    exit(1);
  }
  else {
    (void)strcpy(buffer1, str1);
  }
  if((buffer2 = malloc(strlen(str2)+1)) == (char *)0) {
    perror("Allocating spare memory");
    exit(1);
  }
  else {
    (void)strcpy(buffer2, str2);
  }

  /* Decase letters to lower case */
  for(counter = 0 ; counter < strlen(str1) ; counter++)
    if(str1[counter] >= 'a')
      buffer1[counter] = (char)('A' + (str1[counter]-'a'));
  for(counter = 0 ; counter < strlen(str2) ; counter++)
    if(str2[counter] >= 'a')
      buffer2[counter] = (char)('A' + (str2[counter]-'a'));

  /* Now calculate the return value */
  return_value = strncmp(str1, str2, length);

  /* Free up the space */
  (void)free(str1);
  (void)free(str2);

  /* Now give the return value */
  return(return_value);
}
void *yy_flex_alloc(int size) 
{
  void *ptr;

  /* Allocate the space */
  if((ptr = malloc(size)) == (void *)0) {
    perror("Allocating Flex Buffer");
    exit(1);
  }

  /* Return the pointer */
  return(ptr);
}
void *yy_flex_realloc(void *ptr, int size)
{
  void *nptr;

  /* Reallocate space */
  if((nptr = realloc(ptr, size)) == (void *)0) {
    perror("ReAllocating Flex Buffer");
    exit(1);
  }

  /* Return the new pointer */
  return(nptr);
}
void yy_flex_free(void *ptr){(void)free(ptr);}
#endif /* _OS2_ */

#ifdef __DJGPP__
unsigned iopl(unsigned port){return(0);}
unsigned usleep(unsigned wait){return(delay((wait+990)/1000),0);}
#endif /* __DJGPP__ */

int
addaction(int (*fn)(char*), int skip)
{
	char *sptr = yytext+skip;
	/* Make sure there is some room */
	if(nextaction == maxactions)
	{
		maxactions += ADDACTIONS;
		actions = (ACTION *)realloc((void *)actions, sizeof(ACTION) * maxactions);
		if(!actions)
		{
			/* This is, like, fatal */
			eprintf("Unable to allocate memory for action list processing line %d\n", linenumber);
			parseerror = 1;
			return 0;
		}
	}
	actions[nextaction].fn = fn;
	actions[nextaction].name = strdup(yytext);
	actions[nextaction].linenum = linenumber;
	actions[nextaction].jumponerror = 0;
	while((*sptr) && isspace(*sptr))
	{
		if(*sptr == '\n')
			linenumber++;
		sptr++;
	}
	if(*sptr)
		actions[nextaction].arg = strdup(sptr);
	else
		actions[nextaction].arg = "";
	nextaction++;
	return 1;
}

int
IgnoreCRC(char *s)
{
	ignorecrc = 1;
	return 0;
}

int
Read_Port(char *s)
{
	/* Read decimal or hex number */
	read_port = (int)strtol(s, (char**)NULL, 0);
	if((read_port < MIN_READ_ADDR)||(read_port > MAX_READ_ADDR))
	{
		eprintf("Port address %s (0x%04x) out of range 0x203..0x3ff\n", s, read_port);
		return 1;
	}
	read_port |= 3;
	return 0;
}

int
checkreadport(void)
{
	if(!read_port)
	{
		eprintf("READPORT not set\n");
		return(1);
	}
	return(0);
}

#define IDENT_LEN 9
#define TMP_LEN 16
#define LARGE_LEN 65536
#define MAXSLOTS 32

unsigned char serial_identifier[MAXSLOTS+1][IDENT_LEN];
char *boardid[MAXSLOTS+1];
unsigned long serno[MAXSLOTS+1];
unsigned char tmp[TMP_LEN];
unsigned char large[LARGE_LEN];

int boards_found = 0;

int do_isolate(void);
char * devidstr(unsigned char, unsigned char, unsigned char, unsigned char);
char * sernostr(unsigned long serno);

static char initdata[INIT_LENGTH] = INITDATA;

void
initiate(void)
{
	int i;
	CONFIGCONTROL;
	WRITE_DATA(CONFIG_WAIT_FOR_KEY);
	ADDRESS(0);
	ADDRESS(0);
	for(i = 0; i < INIT_LENGTH; i++)
		ADDRESS(initdata[i]);
	delaynus(2000L);
	initiated = 1;
}

int
Isolate(char *s)
{
	int i;

	initiate();
	/* Reset the cards */
	CONFIGCONTROL;
	if(toupper(*s) == 'C') /* CLEAR */
		WRITE_DATA(CONFIG_RESET_DRV);
	else /* PRESERVE */
		WRITE_DATA(CONFIG_RESET_CSN | CONFIG_WAIT_FOR_KEY);
	delaynus(2000L);
	/* Send the key again */
	initiate();
	if(boards_found)
	{
		printf("Warning - ISOLATE called twice, or after CSN - clearing board count\n");
		boards_found = 0;
	}
	/* All cards now isolated, read the first one */
	if(read_port) /* Port specified */
	{
		do_isolate();
	}
	else
	{
		for(read_port = MIN_READ_ADDR; read_port <= MAX_READ_ADDR; read_port += READ_ADDR_STEP)
		{
			if(debug)
				printf("Trying port address %04x\n", read_port);
			if(do_isolate())
				break;
			/* Reset the cards */
			CONFIGCONTROL;
			WRITE_DATA(CONFIG_RESET_DRV);
			delaynus(2000L);
			/* Send the key again */
			initiate();
		}
	}
	if(!boards_found)
		return 1; /* Error */
	if(debug)
	{
		printf("Board %d has serial identifier", boards_found);
		for(i = IDENT_LEN; i-- ; )
			printf(" %02x", serial_identifier[boards_found][i]);
		printf(" (%s/%s)\n", boardid[boards_found], sernostr(serno[boards_found]));
	}
	while(do_isolate())
	{
		if(debug)
		{
			printf("Board %d has serial identifier", boards_found);
			for(i = IDENT_LEN; i--; )
				printf(" %02x", serial_identifier[boards_found][i]);
			printf(" (%s/%s)\n", boardid[boards_found], sernostr(serno[boards_found]));
		}
	}
	return 0;
}

int
do_isolate(void)
{
	int csum;
	int i;
	int index;
	int newbit;
	int goodaddress = 0;
	int nextboard = boards_found + 1;
	unsigned char c1, c2;
	csum = 0x6a;
	Wake(0);
	SetRdPort(read_port);
	delaynus(1000L);
	SERIALISOLATION;
	delaynus(1000L);
	for(index = 0; index < IDENT_LEN - 1; index++)
	{
		for(i = 0; i < 8; i++)
		{
			newbit = 0x00;
			/* Two reads per identifier bit */
			delaynus(250L);
			c1 = READ_DATA;
			delaynus(250L);
			c2 = READ_DATA;
			if(c1 == 0x55)
			{
				if(c2 == 0xAA)
				{
					goodaddress = 1;
					newbit = 0x80;
				}
				else
				{
					goodaddress = 0;
				}
			}
			serial_identifier[nextboard][index] >>= 1;
			serial_identifier[nextboard][index] |= newbit;
			/* Update checksum */
			if(((csum >> 1) ^ csum) & 1)
				newbit ^= 0x80;
			csum >>= 1;
			csum |= newbit;
		}
		
		eprintf("%02x ", serial_identifier[nextboard][index]);
		
	}
	
	eprintf("csum is %02x\n", csum);
	
	for(i = 0; i < 8; i++)
	{
		newbit = 0x00;
		/* Two reads per identifier bit */
		delaynus(250L);
		c1 = READ_DATA;
		delaynus(250L);
		c2 = READ_DATA;
		if(c1 == 0x55)
		{
			if(c2 == 0xAA)
			{
				goodaddress = 1;
				newbit = 0x80;
			}
		}
		serial_identifier[nextboard][index] >>= 1;
		serial_identifier[nextboard][index] |= newbit;
	}
	if(goodaddress && (ignorecrc || (serial_identifier[nextboard][8] == csum)))
	{
		boardid[nextboard] = strdup(devidstr(serial_identifier[nextboard][0],
				serial_identifier[nextboard][1], serial_identifier[nextboard][2],
				serial_identifier[nextboard][3])); 
		serno[nextboard] = serial_identifier[nextboard][7] << 24;
		serno[nextboard] |= serial_identifier[nextboard][6] << 16;
		serno[nextboard] |= serial_identifier[nextboard][5] << 8;
		serno[nextboard] |= serial_identifier[nextboard][4];
		boards_found = nextboard;
		CARDSELECTNUMBER;
		WRITE_DATA(nextboard);
		return(1);
	}
	
	else
	{
		eprintf("csum = %02x\n", csum);
	}
	
	return(0);
}

char *
devidstr(unsigned char d1, unsigned char d2, unsigned char d3, unsigned char d4)
{
	static char resstr[] = "PNP0000";
	if(d1 & 0x80)
		return("-------");
	sprintf(resstr, "%c%c%c%x%x%x%x", 'A' + (d1 >> 2) - 1, 'A' + (((d1 & 3) << 3) | (d2 >> 5)) - 1,
	       'A' + (d2 & 0x1f) - 1, d3 >> 4, d3 & 0x0f, d4 >> 4, d4 & 0x0f);
	return resstr;
}

char *
sernostr(unsigned long serno)
{
	static char serstr[] = "4294967294"; /* 2^32 - 2 is the max possible */
	if(serno == 0xffffffffUL)
		return "-1";
	sprintf(serstr, "%lu", serno);
	return serstr;
}

int
statuswait(void)
{
#ifdef REALTIME
#define TIMEOUTLOOPS 100
	int to; /* For timeout */
	/*
	 * Try for up to 1ms
	 */
	for(to = 0; to < TIMEOUTLOOPS; to++)
	{
		if(STATUS & 1)
			break;
		delaynus(10L);
	}
	if(to >= TIMEOUTLOOPS)
	{
		eprintf("Timeout attempting to read ident - is READPORT correct ?\n");
		return(1);
	}
#else /* !REALTIME */
#if defined _OS2_ || defined __DJGPP__
#define TIMEOUTLOOPS 2
	int to; /* For timeout */
	/*
	 * Try for up to 2ms
	 */
	for(to = 0; to < TIMEOUTLOOPS; to++)
	{
	    usleep(1000);
	    if(STATUS & 1)
		break;
	}
	if(to >= TIMEOUTLOOPS)
	{
	    eprintf("Timeout attempting to read resource data - is READPORT correct ?\n");
	    return(1);
	}
#else /* !(OS2 or DJGPP) */
	/*
	 * Infinite loop potentially, but if we usleep, we may lose 10ms
	 */
	while(!(STATUS & 1))
		;
#endif /* !(OS2 or DJGPP) */
#endif /* !REALTIME */
	return(0);
}

int
ident(int csn)
{
	int i;
	unsigned char id[IDENT_LEN];
	char *fptr;
	if((csn < 1)||(csn > boards_found))
		return(1);
	fflush(stdout);
	if(checkreadport())
		return(1);
	Wake(csn);
	delaynus(250L);
	for(i = 0; i < IDENT_LEN; i++)
	{
		if(statuswait())
			return(1);
		id[i] = RESOURCEDATA;
	}
	strcpy(boardid[csn],devidstr(id[0],id[1],id[2],id[3]));
	serno[csn] = (unsigned long) id[4] + (id[5] << 8) +  (id[6] << 16) + (id[7] << 24);
	/* Display result according to format string */
	for(fptr = identifyformat; *fptr; fptr++)
	{
		switch(*fptr)
		{
		case '%':
		{
			fptr++;
			switch(*fptr)
			{
			case 'b': /* Board */ printf("%d", csn); break;
			case 'v': /* Vendor Id */ printf("%s", boardid[csn]); break;
			case 's': /* Serial number */ printf("%s", sernostr(serno[csn])); break;
			default:
				if(((i = *fptr - '0') >= 0)&&(i < 9))
					printf("%02x", id[i]);
				else
					putchar(*fptr);
				break;
			}
			break;
		}
		case '\\':
		{
			fptr++;
			switch(*fptr)
			{
			case 't': putchar('\t'); break;
			case 'n': putchar('\n'); break;
			default:  putchar(*fptr); break;
			}
			break;
		}
		default:
			putchar(*fptr);
			break;
		}
	}
	fflush(stdout);
	return(0);
}

int
Identify(char *s)
{
	int err = 0;
	int csn;
	if(*s == '*')
	{
		for(csn = 1; (!err) && (csn <= boards_found); csn++)
			err |= ident(csn);
	}
	else
	{
		csn = (int)strtol(s, (char**)NULL, 0);
		err = ident(csn);
	}
	return err;
}

int
IdentifyFormat(char *s)
{
	identifyformat = strdup(s+1);                 /* Flex rule guarantees this removes leading " */
	identifyformat[strlen(identifyformat)-1] = 0; /* Flex rule guarantees this removes trailing " */
	return 0;
}

int
WaitForKey(char *s)
{
	CONFIGCONTROL;
	WRITE_DATA(CONFIG_WAIT_FOR_KEY);
	return 0;
}

int csn;

int
SelectCSN(char *s)
{
	if(!initiated)
		initiate();
	csn = (unsigned int)strtol(s, (char**)NULL, 0);
	/* Check it's sensible, and we won't have array problems */
	if((csn < 1)||(csn > MAXSLOTS))
		return 1;
	if(csn > boards_found)
	{
		for(boards_found++; csn >= boards_found; boards_found++)
			boardid[boards_found] = strdup("-------");
		boards_found = csn;
	}
	if(checkreadport())
		return(1);
	Wake(csn);
	return 0;
}

int
SelectIdent(char *s)
{
	unsigned long sn;
	if(s[8] == '#')
	{
		/* Specify nth card, rather than serial number */
		sn = (unsigned int)strtol(s+9, (char**)NULL, 0);
		for(csn = 1; csn <= boards_found; csn++)
			if((strncasecmp(s, boardid[csn], 7) == 0)&&(!(--sn)))
				break;
	}
	else
	{
		if(s[8] == '-') /* For the special case -1 */
			sn = (unsigned long)strtol(s+8, (char**)NULL, 0);
		else
			sn = strtoul(s+8, (char**)NULL, 0);
		for(csn = 1; csn <= boards_found; csn++)
			if((serno[csn] == sn)&&(strncasecmp(s, boardid[csn], 7) == 0))
				break;
	}
	if((csn < 1)||(csn > boards_found))
	{
		printf("Board %s not found - skipping\n", s);
		return(1);
	}
	if(debug)
		printf("Found board %s as Card Select Number %d\n", s, csn);
	if(checkreadport())
		return(1);
	Wake(csn);
	return 0;
}

/*
 * Misc global register setting
 */

int verifyld = 1;
int LogDev;

int
SetLogicalDevice(char *s)
{
	int retval;
	LogDev = (int)strtol(s, (char**)NULL, 0);
	LOGICALDEVICENUMBER;
	WRITE_DATA(LogDev);
	retval = (verifyld)&&(READ_DATA != LogDev);
	if(retval)
		eprintf("LD setting verify failed, this may not be a problem\n"
			"Try adding (VERIFYLD N) to the top of your script\n");
	return retval;
}

int
VerifyLD(char *s)
{
	while((*s)&&(isspace(*s)))
		s++;
	if((*s)&&(toupper(*s) == 'N'))
		verifyld = 0;
	else
		verifyld = 1;
	return 0;
}

/*
 * Register address, etc, for peek and poke
 */
#define MAXNAMELEN 16
#define MAXREGSIZE 8 /* MemReg */

int Reg = 0;
int RegSize = 0;
char RegName[MAXNAMELEN] = {0};

int
Activate(char *s)
{
	ACTIVATE;
	if(toupper(*s) == 'Y')
		WRITE_DATA(1);
	else
		WRITE_DATA(0);
	return 0;
}

int
SelectAct(char *s)
{
	Reg = 0x30;
	RegSize = 1;
	strcpy(RegName, "ACT  ");
	return 0;
}

/*
 * Interrupt resource setting
 */

int INTReg = 0;

int
SelectINTReg(char *s)
{
	int n;
	n = (int)strtol(s, (char**)NULL, 0);
	if((n < 0)||(n > 1))
		return 1;
	INTReg = n;
	Reg = 0x70 + (n << 1);
	RegSize = 2;
	strcpy(RegName, "INT 0");
	RegName[4] = n + '0';
	return 0;
}

int
SetIRQLine(char *s)
{
	int n;
	n = (int)strtol(s, (char**)NULL, 0);
	if((n < 0)||(n > 15))
		return 1;
	if(n == 2)
	{
		eprintf("Warning - IRQ2 is not a valid selection, changing it to IRQ9 (See clarifications 4.6.2)\n");
		n = 9;
	}
	ADDRESS(0x70 + (INTReg << 1));
	WRITE_DATA(n);
	return 0;
}

int
SetIRQMode(char *s)
{
	int n = 0;
	if(*s++ == '+')
		n |= 2;
	if(toupper(*s) == 'L')
		n |= 1;
	ADDRESS(0x71 + (INTReg << 1));
	WRITE_DATA(n);
	return 0;
}

/*
 * I/O resource setting
 */

int IOReg = 0;

int
SelectIOReg(char *s)
{
	int n;
	n = (int)strtol(s, (char**)NULL, 0);
	if((n < 0)||(n > 7))
		return 1;
	IOReg = n;
	Reg = 0x60 + (n << 1);
	RegSize = 2;
	strcpy(RegName, "IO  0");
	RegName[4] = n + '0';
	return 0;
}

int
SetIOBaseReg(char *s)
{
	int n;
	n = (int)strtol(s, (char**)NULL, 0);
	if((n < 0)||(n > 0xffff))
		return 1;
	ADDRESS(0x60 + (IOReg << 1));
	WRITE_DATA(n >> 8);
	ADDRESS(0x61 + (IOReg << 1));
	WRITE_DATA(n & 0xff);
	return 0;
}

/*
 * DMA resource setting
 */

int DMAReg = 0;

int
SelectDMAReg(char *s)
{
	int n;
	n = (int)strtol(s, (char**)NULL, 0);
	if((n < 0)||(n > 1))
		return 1;
	DMAReg = n;
	Reg = 0x74 + n;
	RegSize = 1;
	strcpy(RegName, "DMA 0");
	RegName[4] = n + '0';
	return 0;
}

int
SetDMAChannelReg(char *s)
{
	int n;
	n = (int)strtol(s, (char**)NULL, 0);
	if((n < 0)||(n > 7))
		return 1;
	ADDRESS(0x74 + DMAReg);
	WRITE_DATA(n);
	return 0;
}

/*
 * Memory resource setting stuff
 */

int MemReg = 0;

int
SelectMemReg(char *s)
{
	int n;
	n = (int)strtol(s, (char**)NULL, 0);
	if((n < 0)||(n > 3))
		return 1;
	MemReg = n;
	Reg = 0x40 + (n << 3);
	RegSize = 8;
	strcpy(RegName, "MEM 0");
	RegName[4] = n + '0';
	return 0;
}

int
SetMemBaseReg(char *s)
{
	unsigned long n;
	n = strtoul(s, (char**)NULL, 0);
	/* Specify as absolute address, check for bits not programable */
	if(n & 0xff0000ff)
		return 1;
	ADDRESS(0x40 + (MemReg << 3));
	WRITE_DATA(n >> 16);
	ADDRESS(0x41 + (MemReg << 3));
	WRITE_DATA((n >> 8) & 0xff);
	return 0;
}

/*
 * Modes [wb][ru]
 * w = 16 bit
 * b = 8 bit
 * r = upper is range length
 * u = upper is upper limit
 * Note that R/U is a read only bit, so verify
 */
int
SetMemModeReg(char *s)
{
	int n = 0;
	if(toupper(*s) == 'W')
		n |= 2;
	s++;
	if(toupper(*s) == 'U')
		n |= 1;
	ADDRESS(0x42 + (MemReg << 3));
	WRITE_DATA(n);
	if((READ_DATA ^ n) & 3)	/* Verify */
		return 1;
	return 0;
}

int
SetMemUpperReg(char *s)
{
	unsigned long n;
	n = strtoul(s, (char**)NULL, 0);
	/* Specify as absolute address, check for bits not programable */
	if(n & 0xff0000ff)
		return 1;
	ADDRESS(0x43 + (MemReg << 3));
	WRITE_DATA(n >> 16);
	ADDRESS(0x44 + (MemReg << 3));
	WRITE_DATA((n >> 8) & 0xff);
	return 0;
}

/*
 * General purpose logical device peek and poke
 */

int
SelectReg(char *s)
{
	int n;
	n = (int)strtol(s, (char**)NULL, 0);
	if((n < 0)||(n > 0xff))
		return 1;
	Reg = n;
	RegSize = 1;
	strcpy(RegName, "-REG-");
	return 0;
}

int
PokeReg(char *s)
{
	int n;
	n = (int)strtol(s, (char**)NULL, 0);
	/* Can only poke bytes */
	if(RegSize > 1)
	{
		eprintf("Can only poke bytes\n");
		return(1);
	}
	if((n < 0)||(n > 0xff))
		return 1;
	ADDRESS(Reg);
	WRITE_DATA(n);
	return 0;
}

/*
 * Peek will work for named stuff too
 */
int
PeekReg(char *s)
{
	int i;
	int data[MAXREGSIZE];
	ADDRESS(Reg);
	data[0] = READ_DATA;
	printf("Peek(%s/%s)[%u][0x%02x](%s) is 0x%02X", boardid[csn], sernostr(serno[csn]), LogDev, Reg, RegName, data[0]);
	for(i = 1; i < RegSize; i++)
	{
		ADDRESS(Reg + i);
		data[i] = READ_DATA;
		printf("%02X", data[i]);
	}
	printf(", (%d", data[0]);
	for(i = 1; i < RegSize; i++)
	{
		ADDRESS(Reg + i);
		printf(",%d", data[i]);
	}
	printf(")\n");
	return 0;
}

void
printgot(void)
{
	if(debug) printf("Got %s\n", yytext);
}

#define ONDEBUG() if (debug) printgot()
#define ADDACTION(x, y) if(!addaction(x, y)) yyterminate()
/*
# LD n      = Logical device, ie write to reg 7
# IO n      = IO descriptor n
# MEM n     = MEM descriptor n (24bit descriptors only for ISA)
# DMA n     = DMA descriptor n
# REG n     = Select register n
# POKE n    = Poke a value
# PEEK      = Read a value and print on stdout
# BASE n    = IO/Mem address n
# UPPER n   = Mem upper address/range n
# INT n     = Interrupt req n
# IRQ n     = Interrupt level n
# MODE      = IRQ line levels etc/Memory width etc
# CHANNEL n = DMA channel
# ACT       = Activate

(IGNORECRC)
(READPORT 0x207)
(ISOLATE3
(CSN 1 (LD 0 (REG 0x42 (POKE 0x00) (PEEK))))
(CONFIGURE DFX0000/1493 (LD 0 (REG 0x42 (POKE 0x00) (PEEK))))
(CONFIGURE DFX0000/1493 (LD 0 (MEM 0 (BASE 0x400000) (MODE wu) (UPPER 0x800000)) (DMA 0 (CHANNEL 1))))
(CONFIGURE DFX0000/1493 (LD 0 (IO 0 (BASE 0x3e8)) (INT 0 (IRQ 12 (MODE +E))) (ACT Y)))
(WAITFORKEY)
*/
#define LEVEL1 1

#define LEVEL2 2

#define LEVEL3 3

#define LEVEL4ACT 4

#define LEVEL4IO 5

#define LEVEL4MEM 6

#define LEVEL4DMA 7

#define LEVEL4INT 8

#define LEVEL4REG 9

#define LEVEL5INT 10

#define NOMORE 11

#define NOMLEVEL3 12

#define CONFIG 13

#define LOGDEV 14

#define IOSET 15

#define MEMSET 16

#define DMASET 17

#define ACTSET 18

#define INTSET 19

#define REGSET 20

#define IRQSET 21

#define PEARSHAPED 22


/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap YY_PROTO(( void ));
#else
extern int yywrap YY_PROTO(( void ));
#endif
#endif

#ifndef YY_NO_UNPUT
static void yyunput YY_PROTO(( int c, char *buf_ptr ));
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy YY_PROTO(( char *, yyconst char *, int ));
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen YY_PROTO(( yyconst char * ));
#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int yyinput YY_PROTO(( void ));
#else
static int input YY_PROTO(( void ));
#endif
#endif

#if YY_STACK_USED
static int yy_start_stack_ptr = 0;
static int yy_start_stack_depth = 0;
static int *yy_start_stack = 0;
#ifndef YY_NO_PUSH_STATE
static void yy_push_state YY_PROTO(( int new_state ));
#endif
#ifndef YY_NO_POP_STATE
static void yy_pop_state YY_PROTO(( void ));
#endif
#ifndef YY_NO_TOP_STATE
static int yy_top_state YY_PROTO(( void ));
#endif

#else
#define YY_NO_PUSH_STATE 1
#define YY_NO_POP_STATE 1
#define YY_NO_TOP_STATE 1
#endif

#ifdef YY_MALLOC_DECL
YY_MALLOC_DECL
#else
#if __STDC__
#ifndef __cplusplus
#include <stdlib.h>
#endif
#else
/* Just try to get by without declaring the routines.  This will fail
 * miserably on non-ANSI systems for which sizeof(size_t) != sizeof(int)
 * or sizeof(void*) != sizeof(int).
 */
#endif
#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */

#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO (void) fwrite( yytext, yyleng, 1, yyout )
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( yy_current_buffer->yy_is_interactive ) \
		{ \
		int c = '*', n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else if ( ((result = fread( buf, 1, max_size, yyin )) == 0) \
		  && ferror( yyin ) ) \
		YY_FATAL_ERROR( "input in flex scanner failed" );
#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL int yylex YY_PROTO(( void ))
#endif

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

YY_DECL
	{
	register yy_state_type yy_current_state;
	register char *yy_cp, *yy_bp;
	register int yy_act;

// #line 1075 "isapnp.y"



	if ( yy_init )
		{
		yy_init = 0;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! yy_start )
			yy_start = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! yy_current_buffer )
			yy_current_buffer =
				yy_create_buffer( yyin, YY_BUF_SIZE );

		yy_load_buffer_state();
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = yy_c_buf_p;

		/* Support of yytext. */
		*yy_cp = yy_hold_char;

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = yy_start;
yy_match:
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				yy_last_accepting_state = yy_current_state;
				yy_last_accepting_cpos = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 326 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 662 );

yy_find_action:
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = yy_last_accepting_cpos;
			yy_current_state = yy_last_accepting_state;
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;


do_action:	/* This label is used only to access EOF actions. */


		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = yy_hold_char;
			yy_cp = yy_last_accepting_cpos;
			yy_current_state = yy_last_accepting_state;
			goto yy_find_action;

case 1:
YY_RULE_SETUP
// #line 1077 "isapnp.y"
BEGIN(LEVEL1);
	YY_BREAK
case 2:
YY_RULE_SETUP
// #line 1079 "isapnp.y"
BEGIN(INITIAL);
	YY_BREAK
case 3:
YY_RULE_SETUP
// #line 1080 "isapnp.y"
BEGIN(NOMORE); debug = 1; ONDEBUG();
	YY_BREAK
case 4:
YY_RULE_SETUP
// #line 1081 "isapnp.y"
BEGIN(NOMORE); ADDACTION(IgnoreCRC, 9); ONDEBUG();
	YY_BREAK
case 5:
YY_RULE_SETUP
// #line 1082 "isapnp.y"
BEGIN(NOMORE); ADDACTION(VerifyLD, 8); ONDEBUG();
	YY_BREAK
case 6:
YY_RULE_SETUP
// #line 1083 "isapnp.y"
BEGIN(NOMORE); ADDACTION(IdentifyFormat, 15); ONDEBUG();
	YY_BREAK
case 7:
// #line 1085 "isapnp.y"
case 8:
YY_RULE_SETUP
// #line 1085 "isapnp.y"
{ BEGIN(NOMORE); ADDACTION(Read_Port, 8); ONDEBUG(); }
	YY_BREAK
case 9:
// #line 1087 "isapnp.y"
case 10:
// #line 1088 "isapnp.y"
case 11:
YY_RULE_SETUP
// #line 1088 "isapnp.y"
{ BEGIN(NOMORE); ADDACTION(Identify, 8); ONDEBUG(); }
	YY_BREAK
case 12:
YY_RULE_SETUP
// #line 1089 "isapnp.y"
BEGIN(NOMORE); ADDACTION(Isolate, 7); ONDEBUG();
	YY_BREAK
case 13:
YY_RULE_SETUP
// #line 1090 "isapnp.y"
BEGIN(CONFIG); configureaction = nextaction; ADDACTION(SelectIdent, 9); ONDEBUG();
	YY_BREAK
case 14:
YY_RULE_SETUP
// #line 1091 "isapnp.y"
BEGIN(CONFIG); ADDACTION(SelectCSN, 3); ONDEBUG();
	YY_BREAK
case 15:
YY_RULE_SETUP
// #line 1092 "isapnp.y"
BEGIN(NOMORE); ADDACTION(WaitForKey, 10); ONDEBUG();
	YY_BREAK
case 16:
YY_RULE_SETUP
// #line 1094 "isapnp.y"
BEGIN(INITIAL);
	YY_BREAK
case 17:
YY_RULE_SETUP
// #line 1096 "isapnp.y"
BEGIN(INITIAL); actions[configureaction].jumponerror = nextaction;
	YY_BREAK
case 18:
YY_RULE_SETUP
// #line 1097 "isapnp.y"
BEGIN(LEVEL2);
	YY_BREAK
case 19:
YY_RULE_SETUP
// #line 1099 "isapnp.y"
BEGIN(CONFIG);
	YY_BREAK
case 20:
YY_RULE_SETUP
// #line 1100 "isapnp.y"
BEGIN(LOGDEV); ADDACTION(SetLogicalDevice, 2); ONDEBUG();
	YY_BREAK
case 21:
YY_RULE_SETUP
// #line 1102 "isapnp.y"
BEGIN(CONFIG);
	YY_BREAK
case 22:
YY_RULE_SETUP
// #line 1103 "isapnp.y"
BEGIN(LEVEL3);
	YY_BREAK
case 23:
YY_RULE_SETUP
// #line 1105 "isapnp.y"
BEGIN(LOGDEV);
	YY_BREAK
case 24:
YY_RULE_SETUP
// #line 1106 "isapnp.y"
BEGIN(IOSET); ONDEBUG();
	YY_BREAK
case 25:
YY_RULE_SETUP
// #line 1107 "isapnp.y"
BEGIN(MEMSET); ONDEBUG();
	YY_BREAK
case 26:
YY_RULE_SETUP
// #line 1108 "isapnp.y"
BEGIN(DMASET); ONDEBUG();
	YY_BREAK
case 27:
YY_RULE_SETUP
// #line 1109 "isapnp.y"
BEGIN(INTSET); ONDEBUG();
	YY_BREAK
case 28:
YY_RULE_SETUP
// #line 1110 "isapnp.y"
BEGIN(REGSET); ONDEBUG();
	YY_BREAK
case 29:
YY_RULE_SETUP
// #line 1111 "isapnp.y"
BEGIN(ACTSET); ONDEBUG();
	YY_BREAK
case 30:
YY_RULE_SETUP
// #line 1113 "isapnp.y"
BEGIN(NOMLEVEL3); ADDACTION(Activate, 0); ONDEBUG();
	YY_BREAK
case 31:
YY_RULE_SETUP
// #line 1114 "isapnp.y"
BEGIN(LEVEL4ACT); ADDACTION(SelectAct, 0); ONDEBUG();
	YY_BREAK
case 32:
YY_RULE_SETUP
// #line 1116 "isapnp.y"
BEGIN(LOGDEV);
	YY_BREAK
case 33:
YY_RULE_SETUP
// #line 1118 "isapnp.y"
ADDACTION(SelectIOReg, 0); ONDEBUG();
	YY_BREAK
case 34:
YY_RULE_SETUP
// #line 1119 "isapnp.y"
BEGIN(LEVEL4IO);
	YY_BREAK
case 35:
YY_RULE_SETUP
// #line 1121 "isapnp.y"
ADDACTION(SelectMemReg, 0); ONDEBUG();
	YY_BREAK
case 36:
YY_RULE_SETUP
// #line 1122 "isapnp.y"
BEGIN(LEVEL4MEM);
	YY_BREAK
case 37:
YY_RULE_SETUP
// #line 1124 "isapnp.y"
ADDACTION(SelectDMAReg, 0); ONDEBUG();
	YY_BREAK
case 38:
YY_RULE_SETUP
// #line 1125 "isapnp.y"
BEGIN(LEVEL4DMA);
	YY_BREAK
case 39:
YY_RULE_SETUP
// #line 1127 "isapnp.y"
ADDACTION(SelectINTReg, 0); ONDEBUG();
	YY_BREAK
case 40:
YY_RULE_SETUP
// #line 1128 "isapnp.y"
BEGIN(LEVEL4INT);
	YY_BREAK
case 41:
// #line 1131 "isapnp.y"
case 42:
YY_RULE_SETUP
// #line 1131 "isapnp.y"
ADDACTION(SelectReg, 0); ONDEBUG();
	YY_BREAK
case 43:
YY_RULE_SETUP
// #line 1132 "isapnp.y"
BEGIN(LEVEL4REG);
	YY_BREAK
case 44:
YY_RULE_SETUP
// #line 1134 "isapnp.y"
BEGIN(ACTSET);
	YY_BREAK
case 45:
YY_RULE_SETUP
// #line 1135 "isapnp.y"
ADDACTION(PeekReg, 4); ONDEBUG();
	YY_BREAK
case 46:
YY_RULE_SETUP
// #line 1137 "isapnp.y"
BEGIN(IOSET);
	YY_BREAK
case 47:
// #line 1139 "isapnp.y"
case 48:
YY_RULE_SETUP
// #line 1139 "isapnp.y"
ADDACTION(SetIOBaseReg, 4); ONDEBUG();
	YY_BREAK
case 49:
YY_RULE_SETUP
// #line 1140 "isapnp.y"
ADDACTION(PeekReg, 4); ONDEBUG();
	YY_BREAK
case 50:
YY_RULE_SETUP
// #line 1142 "isapnp.y"
BEGIN(MEMSET);
	YY_BREAK
case 51:
// #line 1144 "isapnp.y"
case 52:
YY_RULE_SETUP
// #line 1144 "isapnp.y"
ADDACTION(SetMemBaseReg, 4); ONDEBUG();
	YY_BREAK
case 53:
// #line 1146 "isapnp.y"
case 54:
YY_RULE_SETUP
// #line 1146 "isapnp.y"
ADDACTION(SetMemUpperReg, 5); ONDEBUG();
	YY_BREAK
case 55:
YY_RULE_SETUP
// #line 1147 "isapnp.y"
ADDACTION(SetMemModeReg, 4); ONDEBUG();
	YY_BREAK
case 56:
YY_RULE_SETUP
// #line 1148 "isapnp.y"
ADDACTION(PeekReg, 4); ONDEBUG();
	YY_BREAK
case 57:
YY_RULE_SETUP
// #line 1150 "isapnp.y"
BEGIN(DMASET);
	YY_BREAK
case 58:
YY_RULE_SETUP
// #line 1151 "isapnp.y"
ADDACTION(SetDMAChannelReg, 7); ONDEBUG();
	YY_BREAK
case 59:
YY_RULE_SETUP
// #line 1152 "isapnp.y"
ADDACTION(PeekReg, 4); ONDEBUG();
	YY_BREAK
case 60:
YY_RULE_SETUP
// #line 1154 "isapnp.y"
BEGIN(INTSET);
	YY_BREAK
case 61:
YY_RULE_SETUP
// #line 1155 "isapnp.y"
BEGIN(IRQSET); ADDACTION(SetIRQLine, 3); ONDEBUG();
	YY_BREAK
case 62:
YY_RULE_SETUP
// #line 1156 "isapnp.y"
ADDACTION(PeekReg, 4); ONDEBUG();
	YY_BREAK
case 63:
YY_RULE_SETUP
// #line 1158 "isapnp.y"
BEGIN(REGSET);
	YY_BREAK
case 64:
// #line 1160 "isapnp.y"
case 65:
YY_RULE_SETUP
// #line 1160 "isapnp.y"
ADDACTION(PokeReg, 4); ONDEBUG();
	YY_BREAK
case 66:
YY_RULE_SETUP
// #line 1161 "isapnp.y"
ADDACTION(PeekReg, 4); ONDEBUG();
	YY_BREAK
case 67:
YY_RULE_SETUP
// #line 1163 "isapnp.y"
BEGIN(INTSET);
	YY_BREAK
case 68:
YY_RULE_SETUP
// #line 1164 "isapnp.y"
BEGIN(LEVEL5INT);
	YY_BREAK
case 69:
YY_RULE_SETUP
// #line 1166 "isapnp.y"
BEGIN(IRQSET);
	YY_BREAK
case 70:
YY_RULE_SETUP
// #line 1167 "isapnp.y"
ADDACTION(SetIRQMode, 4); ONDEBUG();
	YY_BREAK
case 71:
YY_RULE_SETUP
// #line 1169 "isapnp.y"
{ /* Swallow comment to eol */ register int c; while(((c = input()) != '\n') && (c != EOF)) ; linenumber++; }
	YY_BREAK
case 72:
YY_RULE_SETUP
// #line 1170 "isapnp.y"
/* Swallow whitespace */
	YY_BREAK
case 73:
YY_RULE_SETUP
// #line 1171 "isapnp.y"
{ linenumber++; /* Count these */ }
	YY_BREAK
case 74:
YY_RULE_SETUP
// #line 1172 "isapnp.y"
BEGIN(PEARSHAPED); eprintf("Don't know what to do with %s", yytext); parseerror = 1;
	YY_BREAK
case 75:
*yy_cp = yy_hold_char; /* undo effects of setting up yytext */
yy_c_buf_p = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
// #line 1174 "isapnp.y"
eprintf("%s on or around line %d\n", yytext, linenumber); yyterminate();
	YY_BREAK
case 76:
YY_RULE_SETUP
// #line 1176 "isapnp.y"
ECHO;
	YY_BREAK
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(LEVEL1):
case YY_STATE_EOF(LEVEL2):
case YY_STATE_EOF(LEVEL3):
case YY_STATE_EOF(LEVEL4ACT):
case YY_STATE_EOF(LEVEL4IO):
case YY_STATE_EOF(LEVEL4MEM):
case YY_STATE_EOF(LEVEL4DMA):
case YY_STATE_EOF(LEVEL4INT):
case YY_STATE_EOF(LEVEL4REG):
case YY_STATE_EOF(LEVEL5INT):
case YY_STATE_EOF(NOMORE):
case YY_STATE_EOF(NOMLEVEL3):
case YY_STATE_EOF(CONFIG):
case YY_STATE_EOF(LOGDEV):
case YY_STATE_EOF(IOSET):
case YY_STATE_EOF(MEMSET):
case YY_STATE_EOF(DMASET):
case YY_STATE_EOF(ACTSET):
case YY_STATE_EOF(INTSET):
case YY_STATE_EOF(REGSET):
case YY_STATE_EOF(IRQSET):
case YY_STATE_EOF(PEARSHAPED):
	yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - yytext_ptr) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = yy_hold_char;
		YY_RESTORE_YY_MORE_OFFSET

		if ( yy_current_buffer->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between yy_current_buffer and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			yy_n_chars = yy_current_buffer->yy_n_chars;
			yy_current_buffer->yy_input_file = yyin;
			yy_current_buffer->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( yy_c_buf_p <= &yy_current_buffer->yy_ch_buf[yy_n_chars] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			yy_c_buf_p = yytext_ptr + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state();

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = yytext_ptr + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++yy_c_buf_p;
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = yy_c_buf_p;
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer() )
			{
			case EOB_ACT_END_OF_FILE:
				{
				yy_did_buffer_switch_on_eof = 0;

				if ( yywrap() )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					yy_c_buf_p = yytext_ptr + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				yy_c_buf_p =
					yytext_ptr + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state();

				yy_cp = yy_c_buf_p;
				yy_bp = yytext_ptr + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				yy_c_buf_p =
				&yy_current_buffer->yy_ch_buf[yy_n_chars];

				yy_current_state = yy_get_previous_state();

				yy_cp = yy_c_buf_p;
				yy_bp = yytext_ptr + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of yylex */


/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */

static int yy_get_next_buffer()
	{
	register char *dest = yy_current_buffer->yy_ch_buf;
	register char *source = yytext_ptr;
	register int number_to_move, i;
	int ret_val;

	if ( yy_c_buf_p > &yy_current_buffer->yy_ch_buf[yy_n_chars + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( yy_current_buffer->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( yy_c_buf_p - yytext_ptr - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) (yy_c_buf_p - yytext_ptr) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( yy_current_buffer->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		yy_current_buffer->yy_n_chars = yy_n_chars = 0;

	else
		{
		int num_to_read =
			yy_current_buffer->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */
#ifdef YY_USES_REJECT
			YY_FATAL_ERROR(
"input buffer overflow, can't enlarge buffer because scanner uses REJECT" );
#else

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = yy_current_buffer;

			int yy_c_buf_p_offset =
				(int) (yy_c_buf_p - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yy_flex_realloc( (void *) b->yy_ch_buf,
							 b->yy_buf_size + 2 );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			yy_c_buf_p = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = yy_current_buffer->yy_buf_size -
						number_to_move - 1;
#endif
			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&yy_current_buffer->yy_ch_buf[number_to_move]),
			yy_n_chars, num_to_read );

		yy_current_buffer->yy_n_chars = yy_n_chars;
		}

	if ( yy_n_chars == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart( yyin );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			yy_current_buffer->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	yy_n_chars += number_to_move;
	yy_current_buffer->yy_ch_buf[yy_n_chars] = YY_END_OF_BUFFER_CHAR;
	yy_current_buffer->yy_ch_buf[yy_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

	yytext_ptr = &yy_current_buffer->yy_ch_buf[0];

	return ret_val;
	}


/* yy_get_previous_state - get the state just before the EOB char was reached */

static yy_state_type yy_get_previous_state()
	{
	register yy_state_type yy_current_state;
	register char *yy_cp;

	yy_current_state = yy_start;

	for ( yy_cp = yytext_ptr + YY_MORE_ADJ; yy_cp < yy_c_buf_p; ++yy_cp )
		{
		register YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			yy_last_accepting_state = yy_current_state;
			yy_last_accepting_cpos = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 326 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
	}


/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */

#ifdef YY_USE_PROTOS
static yy_state_type yy_try_NUL_trans( yy_state_type yy_current_state )
#else
static yy_state_type yy_try_NUL_trans( yy_current_state )
yy_state_type yy_current_state;
#endif
	{
	register int yy_is_jam;
	register char *yy_cp = yy_c_buf_p;

	register YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		yy_last_accepting_state = yy_current_state;
		yy_last_accepting_cpos = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 326 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 325);

	return yy_is_jam ? 0 : yy_current_state;
	}


#ifndef YY_NO_UNPUT
#ifdef YY_USE_PROTOS
static void yyunput( int c, register char *yy_bp )
#else
static void yyunput( c, yy_bp )
int c;
register char *yy_bp;
#endif
	{
	register char *yy_cp = yy_c_buf_p;

	/* undo effects of setting up yytext */
	*yy_cp = yy_hold_char;

	if ( yy_cp < yy_current_buffer->yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		register int number_to_move = yy_n_chars + 2;
		register char *dest = &yy_current_buffer->yy_ch_buf[
					yy_current_buffer->yy_buf_size + 2];
		register char *source =
				&yy_current_buffer->yy_ch_buf[number_to_move];

		while ( source > yy_current_buffer->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		yy_current_buffer->yy_n_chars =
			yy_n_chars = yy_current_buffer->yy_buf_size;

		if ( yy_cp < yy_current_buffer->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;


	yytext_ptr = yy_bp;
	yy_hold_char = *yy_cp;
	yy_c_buf_p = yy_cp;
	}
#endif	/* ifndef YY_NO_UNPUT */


#ifdef __cplusplus
static int yyinput()
#else
static int input()
#endif
	{
	int c;

	*yy_c_buf_p = yy_hold_char;

	if ( *yy_c_buf_p == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( yy_c_buf_p < &yy_current_buffer->yy_ch_buf[yy_n_chars] )
			/* This was really a NUL. */
			*yy_c_buf_p = '\0';

		else
			{ /* need more input */
			int offset = yy_c_buf_p - yytext_ptr;
			++yy_c_buf_p;

			switch ( yy_get_next_buffer() )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart( yyin );

					/* fall through */

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap() )
						return EOF;

					if ( ! yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					yy_c_buf_p = yytext_ptr + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) yy_c_buf_p;	/* cast for 8-bit char's */
	*yy_c_buf_p = '\0';	/* preserve yytext */
	yy_hold_char = *++yy_c_buf_p;


	return c;
	}


#ifdef YY_USE_PROTOS
void yyrestart( FILE *input_file )
#else
void yyrestart( input_file )
FILE *input_file;
#endif
	{
	if ( ! yy_current_buffer )
		yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE );

	yy_init_buffer( yy_current_buffer, input_file );
	yy_load_buffer_state();
	}


#ifdef YY_USE_PROTOS
void yy_switch_to_buffer( YY_BUFFER_STATE new_buffer )
#else
void yy_switch_to_buffer( new_buffer )
YY_BUFFER_STATE new_buffer;
#endif
	{
	if ( yy_current_buffer == new_buffer )
		return;

	if ( yy_current_buffer )
		{
		/* Flush out information for old buffer. */
		*yy_c_buf_p = yy_hold_char;
		yy_current_buffer->yy_buf_pos = yy_c_buf_p;
		yy_current_buffer->yy_n_chars = yy_n_chars;
		}

	yy_current_buffer = new_buffer;
	yy_load_buffer_state();

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	yy_did_buffer_switch_on_eof = 1;
	}


#ifdef YY_USE_PROTOS
void yy_load_buffer_state( void )
#else
void yy_load_buffer_state()
#endif
	{
	yy_n_chars = yy_current_buffer->yy_n_chars;
	yytext_ptr = yy_c_buf_p = yy_current_buffer->yy_buf_pos;
	yyin = yy_current_buffer->yy_input_file;
	yy_hold_char = *yy_c_buf_p;
	}


#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_create_buffer( FILE *file, int size )
#else
YY_BUFFER_STATE yy_create_buffer( file, size )
FILE *file;
int size;
#endif
	{
	YY_BUFFER_STATE b;

	b = (YY_BUFFER_STATE) yy_flex_alloc( sizeof( struct yy_buffer_state ) );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yy_flex_alloc( b->yy_buf_size + 2 );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer( b, file );

	return b;
	}


#ifdef YY_USE_PROTOS
void yy_delete_buffer( YY_BUFFER_STATE b )
#else
void yy_delete_buffer( b )
YY_BUFFER_STATE b;
#endif
	{
	if ( ! b )
		return;

	if ( b == yy_current_buffer )
		yy_current_buffer = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yy_flex_free( (void *) b->yy_ch_buf );

	yy_flex_free( (void *) b );
	}


#ifndef YY_ALWAYS_INTERACTIVE
#ifndef YY_NEVER_INTERACTIVE
extern int isatty YY_PROTO(( int ));
#endif
#endif

#ifdef YY_USE_PROTOS
void yy_init_buffer( YY_BUFFER_STATE b, FILE *file )
#else
void yy_init_buffer( b, file )
YY_BUFFER_STATE b;
FILE *file;
#endif


	{
	yy_flush_buffer( b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;
#if 0
#if YY_ALWAYS_INTERACTIVE
	b->yy_is_interactive = 1;
#else
#if YY_NEVER_INTERACTIVE
	b->yy_is_interactive = 0;
#else
	b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
#endif
#endif
#endif 
	b->yy_is_interactive = 0;
	}


#ifdef YY_USE_PROTOS
void yy_flush_buffer( YY_BUFFER_STATE b )
#else
void yy_flush_buffer( b )
YY_BUFFER_STATE b;
#endif

	{
	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == yy_current_buffer )
		yy_load_buffer_state();
	}


#ifndef YY_NO_SCAN_BUFFER
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_scan_buffer( char *base, yy_size_t size )
#else
YY_BUFFER_STATE yy_scan_buffer( base, size )
char *base;
yy_size_t size;
#endif
	{
	YY_BUFFER_STATE b;

	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) yy_flex_alloc( sizeof( struct yy_buffer_state ) );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer( b );

	return b;
	}
#endif


#ifndef YY_NO_SCAN_STRING
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_scan_string( yyconst char *yy_str )
#else
YY_BUFFER_STATE yy_scan_string( yy_str )
yyconst char *yy_str;
#endif
	{
	int len;
	for ( len = 0; yy_str[len]; ++len )
		;

	return yy_scan_bytes( yy_str, len );
	}
#endif


#ifndef YY_NO_SCAN_BYTES
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_scan_bytes( yyconst char *bytes, int len )
#else
YY_BUFFER_STATE yy_scan_bytes( bytes, len )
yyconst char *bytes;
int len;
#endif
	{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;

	/* Get memory for full buffer, including space for trailing EOB's. */
	n = len + 2;
	buf = (char *) yy_flex_alloc( n );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < len; ++i )
		buf[i] = bytes[i];

	buf[len] = buf[len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer( buf, n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
	}
#endif


#ifndef YY_NO_PUSH_STATE
#ifdef YY_USE_PROTOS
static void yy_push_state( int new_state )
#else
static void yy_push_state( new_state )
int new_state;
#endif
	{
	if ( yy_start_stack_ptr >= yy_start_stack_depth )
		{
		yy_size_t new_size;

		yy_start_stack_depth += YY_START_STACK_INCR;
		new_size = yy_start_stack_depth * sizeof( int );

		if ( ! yy_start_stack )
			yy_start_stack = (int *) yy_flex_alloc( new_size );

		else
			yy_start_stack = (int *) yy_flex_realloc(
					(void *) yy_start_stack, new_size );

		if ( ! yy_start_stack )
			YY_FATAL_ERROR(
			"out of memory expanding start-condition stack" );
		}

	yy_start_stack[yy_start_stack_ptr++] = YY_START;

	BEGIN(new_state);
	}
#endif


#ifndef YY_NO_POP_STATE
static void yy_pop_state()
	{
	if ( --yy_start_stack_ptr < 0 )
		YY_FATAL_ERROR( "start-condition stack underflow" );

	BEGIN(yy_start_stack[yy_start_stack_ptr]);
	}
#endif


#ifndef YY_NO_TOP_STATE
static int yy_top_state()
	{
	return yy_start_stack[yy_start_stack_ptr - 1];
	}
#endif

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

#ifdef YY_USE_PROTOS
static void yy_fatal_error( yyconst char msg[] )
#else
static void yy_fatal_error( msg )
char msg[];
#endif
	{
	(void) eprintf("%s\n", msg );
	exit( YY_EXIT_FAILURE );
	}



/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
		yytext[yyleng] = yy_hold_char; \
		yy_c_buf_p = yytext + n; \
		yy_hold_char = *yy_c_buf_p; \
		*yy_c_buf_p = '\0'; \
		yyleng = n; \
		} \
	while ( 0 )


/* Internal utility routines. */

#ifndef yytext_ptr
#ifdef YY_USE_PROTOS
static void yy_flex_strncpy( char *s1, yyconst char *s2, int n )
#else
static void yy_flex_strncpy( s1, s2, n )
char *s1;
yyconst char *s2;
int n;
#endif
	{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
	}
#endif

#ifdef YY_NEED_STRLEN
#ifdef YY_USE_PROTOS
static int yy_flex_strlen( yyconst char *s )
#else
static int yy_flex_strlen( s )
yyconst char *s;
#endif
	{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
	}
#endif


#ifdef YY_USE_PROTOS
static void *yy_flex_alloc( yy_size_t size )
#else
static void *yy_flex_alloc( size )
yy_size_t size;
#endif
	{
	return (void *) malloc( size );
	}

#ifdef YY_USE_PROTOS
static void *yy_flex_realloc( void *ptr, yy_size_t size )
#else
static void *yy_flex_realloc( ptr, size )
void *ptr;
yy_size_t size;
#endif
	{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
	}

#ifdef YY_USE_PROTOS
static void yy_flex_free( void *ptr )
#else
static void yy_flex_free( ptr )
void *ptr;
#endif
	{
	free( ptr );
	}

#if 0
//#if YY_MAIN
int main()
	{
	yylex();
	return 0;
	}
#endif
// #line 1176 "isapnp.y"


int
main(int argc, char **argv)
{
	int i;
	int retval;
	if(argc != 2)
	{
		eprintf("%s\nThis is free software, see the sources for details.\n"
			"For latest information, see http://www.roestock.demon.co.uk/isapnptools/\n"
			"This software has NO WARRANTY, use at your OWN RISK\n\n"
			"Usage: %s configfile\n", rcsid, argv[0]);
		exit(1);
	}
#ifdef EB164
	/* ALPHA only has ioperm, apparently, so cover all with one permission */
	if(ioperm(MIN_READ_ADDR, WRITEDATA_ADDR - MIN_READ_ADDR + 1, 1))
#else
	/* Have to get unrestricted access to io ports, as WRITE_DATA port > 0x3ff */
	if(iopl(3) < 0)
#endif
	{	
		perror("Unable to get io permission for WRITE_DATA");
		exit(1);
	}
	retval = 0;
	yyin = fopen(argv[1], "r");
	yylex();

	eprintf("isapnp: Finished parsing, about to munge registers\n");

	if(parseerror)
	{
		eprintf("Error occurred parsing config file on line %d --- no action taken\n", linenumber);
		retval = 1;
	}
	else
	{
#ifdef REALTIME
		setroundrobin();
#endif /* REALTIME */
		for(i = 0; i < nextaction; i++)
		{
			if(debug)
				printf("Executing %s\n", actions[i].name);
			if(actions[i].fn(actions[i].arg))
			{
				fflush(stdout); /* Make sure peeks etc output first */
				if(actions[i].jumponerror)
				{
					i = actions[i].jumponerror - 1; /* To compensate for the ++ */
					continue;
				}
				eprintf("Error occurred executing request '%s' on or around line %d --- further action aborted\n", actions[i].name, actions[i].linenum);
				retval = 1;
				break;
			}
		}
	}
	/* Release resources */
#ifdef EB164
	ioperm(MIN_READ_ADDR, WRITEDATA_ADDR - MIN_READ_ADDR + 1, 0);
#else
	(void)iopl(0);
#endif
	return retval;
}

int yywrap () { return 1;}

