#!/usr/bin/env python
#
# * CLUless compiler front end
# ***********************************************************************
# * Copyright 1997 University of Cambridge Computer Laboratory          *
# * All Rights Reserved                                                 *
# * Authors: Dickon Reed (Dickon.Reed@cl.cam.ac.uk)                     *
# *          Richard Mortier (rmm1002@cam.ac.uk)                        *
# ***********************************************************************
# CLUless

# gentables.py; script to generate .[ch] table files from .tab files

# Dickon Reed, 1996
# Richard Mortier, 1997

#
# $Id: gentables.py 1.1 Thu, 18 Feb 1999 14:20:06 +0000 dr10009 $
#

import sys,string

basename = string.splitfields(sys.argv[1],".")[0]
#print "Basename is " + basename

inf = open(basename + ".tab", "r")
outc = open(basename + ".c", "w")
outh = open(basename + ".h", "w")
outpy = open(basename + ".py", "w")
outc.write("/* This file automatically generated by script gentables.py */\n\n")
outc.write("/* CODE PASSED THROUGH: */\n")
outh.write("/* This file automatically generated by script gentables.py */\n\n")

data = inf.readlines()

base = 0

while data[base] != "#BEGIN#\n":
        outc.write(data[base])
	base = base + 1
base = base + 1	
desl = string.splitfields(data[base], ",")
size = len(data) - base
nature = string.atoi(string.strip(desl[1]))
nature = 5 # hack 

outc.write("/* CODE GENERATED FROM DEFINITIONS: */\n")
outc.write("/* Code for table " + basename + " */\n")
outc.write("#include \"tables.h\"\n\n")
outc.write("struct t_" + basename + "_entry {\n")
outc.write("  char *name;\n")
outc.write("  int order;\n")
outc.write("  int nature[" + `nature` + "];\n")

outh.write("/* Header definitions for table " + basename + " */\n\n")
outh.write("struct t_" + basename + "_entry {\n")
outh.write("  char *name;\n")
outh.write("  int order;\n")
outh.write("  int nature["+`nature`+"];\n")

ext = 0
n = 2
type = []
while n < len(desl):
	outc.write("  " + desl[n][:-1] + " x" + `n-2` + ";")
	outh.write("  " + desl[n][:-1] + " x" + `n-2` + ";")
	type.append(desl[n][:-1])
	n = n+1
	ext = ext+1

outc.write("\n};\n")
outc.write("\n\nstruct t_" + basename + "_entry t_" + basename + "[" + `size` + "]={\n")

outh.write("\n};\n")
outh.write("#define "+basename+"_size "+`size`+"\n")
outh.write("\n\nextern struct t_" + basename + "_entry t_" + basename + "[" + `size` + "];\n")

outpy.write("list_" + basename + "= [ ('NULL',[]),")

n = 1
while n < size:
	l = string.splitfields(data[base+n], ",")
	here = ((len(l) - 2 - ext)/2)

	outc.write("  {\"" + string.strip(l[1]) + "\"," + `here` + ",{")
	outh.write("#define " + basename + "_" + l[0] + " " + `n-1` + "\n")	
	outpy.write('("'+l[0]+'",[')
	i = 1
	o = 2
	while i <= here and o < len(l):
		if i>1:
			outc.write(",")
			outpy.write(',')
		outc.write(l[o])		
		outpy.write('"'+l[o]+'"')
		o = o + 1		
		if o < len(l):
			outh.write("#define " + basename + "_" + l[0] + "_" + string.strip(l[o]) + " " + `i-1` + "\n")
		else:
			print("Name description missing for entry " + `n`)
			print "In + " + `l`
	
		i = i + 1
		o = o + 1
	while i <= nature:
		if i > 1:
			outc.write(",")
		outc.write("n_empty")
		i = i + 1
	outc.write("} ")
	i = 1
	while i <= ext:
		if len(l) < o:
			outc.write(",0")
		else:
			outc.write(", (" + type[i-1] + ") " + l[o][:-1])
		o = o + 1
		i = i + 1
	outc.write("}")	
	outpy.write('])')
	n = n + 1
	outc.write(',')

	if n < size:
		outpy.write(',')
	outc.write("\n")
outc.write("   { 0 } };\n")
outpy.write(']\n')
inf.close()
outc.close()
outh.close()
