import BE
import sys, string, time

def texstrip(line):
	str = ''
	mode = 0
	prevchar = None
	for char in line:
		nextmode = mode
		if char == '\\':
			mode = 1
			nextmode = 1
		if char == '{':
			char = ' '
			nextmode = 0
		if char == '}':
			char = ' '
		if char == '"':
			if mode == 2:
				nextmode = 0
				char = '\\f1 '
			else:
				nextmode = 2
				#outchar = ''
				#if prevchar != '\n': outchar = '\n'
				#char = outchar + '.I '+char
				char = '\\f2 '
		if mode == '2' and char == '\n':
			nextmode = 0
			char = '"'+char
		if mode in [ 0, 2]:
			str = str + char
		mode = nextmode
		prevchar = char
	return str
class StoringFile:
	def __init__(self): self.str = ''
	def write(self, x): self.str = self.str + x
	def markup(self, markupstart = '.BI "', markupend = '"\n.br\n'):
		
		spl = string.split(self.str, '\n')
		str = ''
		for line in spl:
			str = str +  markupstart+line+markupend
		return str

class Interface(BE.Interface):
	def mandump( self, f, fp ) :
		f.write('.\\" This part Autogenerated by genmandump\n')
		date = time.asctime(time.gmtime(time.time()))
		date = date[:10]+' '+date[-4:]
		f.write('.TH '+string.upper(self.name)+' 3  " ' + date + ' " "Nemesis Interface Manual"\n')

		f.write('.SH INTERFACE\n')
		f.write(self.name+'\n')
		#f.write('.SH OPERATIONS\n')
		opmap = {}
		for i in self.ops :
			pf = StoringFile()
			i.fnDecl( self.name, self.clType,'', pf, 1 )
			#opmap[i.name] ='.SH "OPERATION '+i.name+'"\n' +pf.markup()+'\n'
			opmap[i.name] = '\n'+pf.markup()+'\n'
			#f.write(opmap[i.name])

		f.write('.SH DETAILS\n')

		o = open(self.name+'.if', 'r')
		lines = o.readlines()
		o.close()

		prevmiddl = 0
		firstblank = None
		for line in lines:
			if (not firstblank):
				if line == '\n':
					firstblank = 1
				continue
			spl = string.split(line)
			if len(spl)>1:
				if opmap.has_key(spl[0]) and spl[1] == ':':
					f.write(opmap[spl[0]])
			if len(spl)>=1 and spl[0] == '--':
				if not prevmiddl: f.write('.pp\n')
				f.write(texstrip(string.join(spl[1:]))+'\n')
				prevmiddl = 1
			else:
				if prevmiddl: f.write('.np\n.br\n')
				if len(line)>0:
					f.write('.BI "'+line[:-1]+'"\n.br\n')
				else:
					f.write('\n')
				prevmiddl = 0
		self.code = fp 


		f.write('.SH IMPORTS\n')
		for i in self.imports :
		  f.write('.B '+i.name+ '  \n')
		if self.imports == []:
		  f.write('(none).\n')
		f.write( '\n' )

                f.write('.SH TYPECODE\n')
		f.write('0x'+fp+'\n')
		f.write('\n')
 
		#for i in self.types :
		#  i.typeDef( self.name, f )
		#f.write( '\n' )

		# Operation & Exception typedefs
		#for i in self.excs :
		#	f.write('.SH "EXCEPTION '+i.name+'"\n')
		#	f.write('Arguments\n')
		#	for i2 in i.pars :
		#		if i2 == i.pars[0] : sep = ''
		#		else :                 sep = ';'
		#		i2.typedef (f, sep, '')

		## Method suite struct type
		#if len (self.allOps()) != 0: self.opStruct( f )

		f.write( '\n' )

		return
	# Define the closure type
	def closureDef (self, f):
		f.write( 'typedef ' )
		if self.isModule: f.write ( 'const ' )
		f.write ( 'struct _' + self.clType + ' ' + \
			  self.clType + ';\n' )
		f.write ( 'typedef ' + self.clType + ' *' + \
		          self.clType + 'p;\n')
		f.write ( 'typedef const struct _' + self.opType + ' ' + \
			  self.opType + ';\n\n' )
		f.write ( 'struct _' + self.clType + ' {\n' + \
		    BE.Tab + self.opType + BE.Tab + '*op;\n')
		f.write ( '#ifndef __' + self.name + '_STATE\n' )
		f.write (  BE.Tab + 'addr_t'    + BE.Tab + ' st;\n' )
		f.write ( '#else \n' )
		f.write (  BE.Tab + '__' + self.name + '_STATE' + BE.Tab + ' *st;\n')
		f.write ( '#endif \n' )
		f.write ( '};\n\n' )

		if self.isModule:
		  f.write ( 'extern ' + self.clType + ' * const ' + \
		      self.name + ';\n\n' )

	# Define a null closure type if there are no methods
	def nullClosureDef (self, f):
		f.write( 'typedef const ' )
		f.write ( 'struct _' + self.clType + ' ' + \
			  self.clType + ';\n' )
		f.write ( 'typedef ' + self.clType + ' *' + \
		          self.clType + 'p;\n')
		f.write ( 'struct _' + self.clType + ' {\n' + \
		    BE.Tab + 'addr_t ' + BE.Tab + ' op;\n' + \
		    BE.Tab + 'addr_t ' + BE.Tab + ' st;\n};\n\n' )

class Operation(BE.Operation): pass

class Type(BE.Type):
    pass

class Predefined(BE.Predefined): pass

class Alias(BE.Alias): pass

class Enumeration(BE.Enumeration): pass

class Record(BE.Record): pass

class RecordMember(BE.RecordMember): pass

class Choice(BE.Choice): pass

class ChoiceElement(BE.ChoiceElement): pass

class Array(BE.Array): pass

class BitSet(BE.BitSet): pass

class ByteSequence(BE.ByteSequence): pass

class ByteArray(BE.ByteArray): pass

class Set(BE.Set): pass

class Ref(BE.Ref): pass

class InterfaceRef(BE.InterfaceRef): pass

class Import(BE.Import): pass

def Go(kind, intflist, fp):
  intf = intflist[-1].obj
  t_ih  = open (intf.name + '.man', 'w')
  intf.mandump (t_ih, fp)
  return [intf.name+'.man']
