
	

	.h8300h			; 
	.section	.text
	.set	flash_base,0x200000	
	.set dirty_loc,0x804444

 	;; Serial port 1 is ops and maintenance port
	.set scr1,0xffff82		; serial control reg
	.set rdr1,0xffff85
	.set ssr1,0xffff84		;  rate
 	.set brr1,0xffff81		;  16 for 19200
	.set smr1,0xffff80		;
	.set tdr1,0xffff83	;  transmit data reg

	
entry:		
	mov.b	#' ',r0l
	bsr _putchar
	mov.b	#'A',r0l
	bsr _putchar
	mov.l	#flash_base,er0
	bsr	flash_sector_erase_core

	mov.b	#'B',r0l
	bsr _putchar
	mov.l	#flash_base+1,er0
	bsr	flash_sector_erase_core

	mov.b	#'C',r0l
	bsr _putchar
	jmp	0x82
	
_putchar:	
craft_wrch_1:	
	btst	#7,@(ssr1)	; Bit 7 is a one if we can send
	beq	craft_wrch_1	; the next char.
	mov.b	r0l,@(tdr1)
	bclr	#7,@ssr1
	rts

		;; 	---------------------------------------------------------------
; Flash sector erase
;  er0 = base address of sector
;
flash_sector_erase_core:	
	mov.w 	#0xF0F0,r1	;  Reset
	mov.w	r1,@(flash_base)

	btst	#0,r0l
	bne	erase_odd_low:16
	
	mov.w 	#0xaaff,r1	;  AA to 555
	mov.w	r1,@(flash_base+(0x555<<1))
	
	mov.w	#0x55ff,r1	; 55 to 2AA
	mov.w	r1,@(flash_base+(0x2AA<<1))

	mov.w 	#0x80ff,r1	; 80 to 555
 	mov.w	r1,@(flash_base+(0x555<<1))

	mov.w 	#0xaaff,r1	; AA to 555
	mov.w	r1,@(flash_base+(0x555<<1))
	
	mov.w	#0x55ff,r1	; 55 to 2AA
	mov.w	r1,@(flash_base+(0x2AA<<1))

	bclr	#0,r0l		;  Make even address (is anyway)
	mov.w 	#0x30FF,r1
	mov.w	r1,@er0		; 0x30 is Sector erase (10 is chip erase)
	
	mov.w	#0,r1		; Mini delay
xl1:	mov.w	@(0x202,er0),r2
	mov.w	r2,@(dirty_loc)
	add.w	#(65536-1),r1	; > 80 microseconds.
	bne	xl1

; Must poll in different locations from where we wrote the command  
; Sector erase takes up to 13 seconds so allow a good 20 for time out.
	mov.l	#19000111,er1		; Use R1 as timeout
erase_poll_even:			
	mov.w	@(0x202,er0),r2
	mov.w	r2,@(dirty_loc)
	and.b	#128,r2h	; msb is a one when erased
	bne	ll_eok

	sub.l	#1,er1
	bne	erase_poll_even; Loop again if no timeout
ll_nok:	
	mov.b	#1,r0l
	bra	ll_ret

ll_eok:
	sub.w	r0,r0
ll_ret:
ep_home:	
	mov.w 	#0xF0F0,r1	;  Reset
	mov.w	r1,@(flash_base)
	rts

erase_odd_low:
	mov.w 	#0xFFaa,r1	;  AA to 555
	mov.w	r1,@(flash_base+(0x555<<1))
	mov.w	#0xFF55,r1	; 55 to 2AA
	mov.w	r1,@(flash_base+(0x2AA<<1))
	mov.w 	#0xFF80,r1	; 80 to 555
	mov.w	r1,@(flash_base+(0x555<<1))
	mov.w 	#0xFFAA,r1	; AA to 555
	mov.w	r1,@(flash_base+(0x555<<1))
	mov.w	#0xFF55,r1	; 55 to 2AA
	mov.w	r1,@(flash_base+(0x2AA<<1))

	bclr	#0,r0l		;  Make even address 
	mov.w 	#0xFF30,r1
	mov.w	r1,@er0		; 0x30 is Sector erase (10 is chip erase)


	mov.w	#0,r1		; Mini delay
xl2:	mov.w	@(0x202,er0),r2
	mov.w	r2,@(dirty_loc)
	add.w	#(65536-1),r1	; > 80 microseconds.
	bne	xl2
	

; Sector erase takes up to 20 seconds or so, poll for it.
	mov.l	#0x19000111,er1		; Use R1 as timeout
erase_poll_odd:			
	mov.w	@(0x202,er0),r2
	mov.w	r2,@(dirty_loc)
	and.b	#128,r2l	; msb is a one when erased
	bne	ll_eok:16

	sub.l	#1,er1
	bne	erase_poll_odd; Loop again if no timeout
	mov.b	#1,r0l
;;	xorc.b	#0x80,ccr	; flip interrupt enable bit - bit 7, ints on
	bra	ll_nok:16

