	; 
	.h8300h			; 
	.set	StackTop,0xFFFBF0

	.set dirty_loc,0x804444
	
	.set flash_base,0											
	;; System Control Register
	.set syscr,0xffff39
	
	;; Port 1
	.set p1ddr,0xfffeb0
	.set p1dr,0xffff60

	;; Port 3
	.set p3ddr,0xfffeb2
	.set p3dr,0xffff62
	
	;; Port 5
	.set p5ddr,0xfffeb4
	.set p5dr,0xffff64
	.set p5data,0xffff54
	
 	;; Serial port 0 is PIC control
	.set scr0,0xffff7a		; serial control reg
	.set rdr0,0xffff7d
	.set ssr0,0xffff7c		;  rate
 	.set brr0,0xffff79		;  
	.set smr0,0xffff78		;
	.set tdr0,0xffff7b	;  transmit data reg

 	;; Serial port 1 is ops and maintenance port
	.set scr1,0xffff82		; serial control reg
	.set rdr1,0xffff85
	.set ssr1,0xffff84		;  rate
 	.set brr1,0xffff81		;  16 for 19200
	.set smr1,0xffff80		;
	.set tdr1,0xffff83	;  transmit data reg

	;; Port G
	.set pgddr,0xfffebf	;  Needed for the CSn outputs
	.set mstp,0xffff3c	;  module stop register
	;; Bus Controller Registers
	.set bcrl,0xfffed5
	.set bcrh,0xfffed4
	.set wcrl,0xfffed3
	.set wcrh,0xfffed2
	;;
	;; On chip RAM resources
	
	


	; Sector erase takes up to 13 seconds so allow a good 20 for time out.
	mov.l	#19000111,er1		; Use R1 as timeout
erase_poll_odd:			
	mov.w	@(0x202,er0),r2
	mov.w	r2,@(dirty_loc)
	and.b	#128,r2l	; msb is a one when erased
	bne	ll_eok:16

	sub.l	#1,er1
	bne	erase_poll_odd; Loop again if no timeout
	mov.b	#1,r0l
;;	xorc.b	#0x80,ccr	; flip interrupt enable bit - bit 7, ints on
	bra	ll_nok:16



ll_nok:
ll_eok:	
	
	jmp 0x80	
