/* A wee progam to test the spangling sockets.
 *
 * $Id: udp_multi.c,v 3.2 1999/12/18 16:28:03 kaf24 Exp kaf24 $
 * $Log: udp_multi.c,v $
 * Revision 3.2  1999/12/18 16:28:03  kaf24
 * Performance tweaks
 *
 * Revision 2.4  1999/11/01 15:34:53  kaf24
 * before changing to new tx2 send path
 *
 * Revision 2.3  1999/10/07 10:50:33  kaf24
 * Changed to Gnu pth thread lib.
 *
 * Revision 2.2  1999/10/01 08:14:42  kaf24
 * clean interface to USD details. Bugs in hash code but ready for change to pth threads.
 *
 * Revision 2.1  1999/09/28 13:03:15  kaf24
 * Performance enhancements, before changing thread lib.
 *
 * Revision 2.0  1999/09/23 13:28:58  kaf24
 * Bug fixes, and added SOCK_USER
 *
 * Revision 1.1  1999/08/06 12:17:32  kaf24
 * Initial revision
 *
 * Revision 1.3  1999/07/22 15:02:27  kaf24
 * Removed non-compiled code
 *
 * Revision 1.2  1998/02/26 10:36:13  dbs20
 * Tidying up and simulator support added.
 *
 * Revision 1.1  1998/01/21 11:05:42  dbs20
 * Initial revision
 *
 */

#define _P __P

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <netinet/in.h>
#include <netdb.h>
#include <errno.h>
#include <sys/socket.h>
#include "libusernet.h"
#include <sys/types.h>
#include <sys/wait.h>
#include <signal.h>

#define NUM_CONNECTIONS            4
#define MAX_SIZE                   1400
#define NUM_TO_SEND                100

long      remote_ip;
pid_t send_threads[NUM_CONNECTIONS];
pid_t recv_threads[NUM_CONNECTIONS];

static int send_thread(int);
static int recv_thread(int);

typedef struct {
    int id;
    int length;
} our_header;

int main(int   argc,
	 char *argv[])
{
    int                i;
    struct hostent    *he;
    void              *ret;
    int                val = 0;
    int                timer;

    /*
     * Argument check.
     */
    if(argc != 2)
    {
	fprintf(stderr, "%s: Usage: %s <r. host> <send>\n", 
		argv[0], argv[0]);
	exit(EXIT_FAILURE);
    }

    /*
     * Find the remote IP address.
     */
    he = gethostbyname(argv[1]);
    if(he == NULL)
    {
	fprintf(stderr, "%s: failed to look up host \"%s\", reason: ", 
		argv[0], argv[1]);
	herror(NULL);
	fprintf(stderr, "\n");
	exit(EXIT_FAILURE);	
    }
    if(he->h_addrtype != AF_INET || he->h_length != 4)
    {
	fprintf(stderr, "%s: host \"%s\" has non-IPv4 address.\n", 
		argv[0], argv[3]);
	exit(EXIT_FAILURE);
    }
    remote_ip = *((long *)(he->h_addr_list[0]));

    /*
     * Fork for each connection.
     */
    for ( i = 0; i < NUM_CONNECTIONS; i++ )
    {
        switch ( send_threads[i] = fork() )
        {
        case -1: 
            fprintf(stderr, "Error forking...\n");
            exit(1);
        case 0:
            if ( send_thread(i) )
            {
                fprintf(stderr, "Send thread %d error\n", i);
                exit(1);
            }
            return(0);
        default:
            break;
        }

        switch ( recv_threads[i] = fork() )
        {
        case -1: 
            fprintf(stderr, "Error forking...\n");
            exit(1);
        case 0:
            if ( recv_thread(i) )
            {
                fprintf(stderr, "Receive thread %d error\n", i);
                exit(1);
            }
            return(0);
        default:
            break;
        }
    }

    for ( ;; ) continue;

    /*
     * Now wait for each tx process to complete.
     */
    for ( timer = 0; timer < 5; timer++ )
    {
        for ( i = 0; i < NUM_CONNECTIONS; i++ )
        {
            int j;
            for ( j = 0; j < NUM_CONNECTIONS; j++ )
                if ( send_threads[j] != 0 ) break;
            if ( j == NUM_CONNECTIONS ) break;
            if ( send_threads[i] == 0 ) continue;
            if ( waitpid(send_threads[i], NULL, WNOHANG) == send_threads[i] )
            {
                send_threads[i] = 0;
            }
            else
            {
                sleep(1);
            }
        }
    }

    /*
     * Kill the forked processes.
     */
    for ( i = 0; i < NUM_CONNECTIONS; i++ )
    {
        kill(recv_threads[i], SIGKILL);
        kill(send_threads[i], SIGKILL);
    }
#if 0
    /*
     * Print out statistics.
     */
    for ( i = 0; i < NUM_CONNECTIONS; i++ )
    {
        printf("Sender %d = %d packets\n", send_stats[i]);
        printf("Recver %d = %d packets\n", recv_stats[i]);
    }
#endif
    return(0);
} 


static int send_thread(int mynum)
{
    int        lport = 1030 + mynum;
    int        rport = 1130 + mynum;
    int        ret;
    struct sockaddr_in laddr, raddr;
    int        sock;
    int        i;
    unsigned char buf[MAX_SIZE];
    our_header *header = (our_header *)buf;

    /*
     * Set up address structures.
     */
    raddr.sin_addr.s_addr = remote_ip;
    raddr.sin_port        = htons(rport);
    raddr.sin_family      = AF_INET;
    laddr.sin_addr.s_addr = 0;
    laddr.sin_port        = htons(lport);
    laddr.sin_family      = AF_INET;

    user_init();

    sock = user_socket(AF_INET, SOCK_DGRAM, 0);
    if(sock < 0)
    {
	fprintf(stderr, "socket failed: %s.\n", strerror(errno));
	return(-1);
    }

    ret = user_bind(sock, 
		    (struct sockaddr *)&laddr, 
		    sizeof(struct sockaddr_in));
    if(ret < 0)
    {
	fprintf(stderr, "bind failed: %s.\n", strerror(errno));
	return(-1);
    }


    ret = user_connect(sock, 
                       (struct sockaddr *)&raddr, 
                       sizeof(struct sockaddr_in));
    if(ret < 0)
    {
	fprintf(stderr, "connect failed: %s.\n", strerror(errno));
	return(-1);
    }

    for(i=0; i < MAX_SIZE; i++)
    {
	buf[i] = i;
    }

    for ( i = 0; i < NUM_TO_SEND; i++ )
    {
        header->id = i;
        header->length = (rand() % (MAX_SIZE-sizeof(our_header)))
            + sizeof(our_header);
        ret = user_send(sock,
                        buf,
                        header->length,
                        0);
        if( (ret != header->length) && (errno != ENOMEM) )
        {
            fprintf(stderr, "send failed: %s.\n", strerror(errno));
            return(-1);
        }
    }
    
    ret = user_close(sock);
    if(ret < 0)
    {
	fprintf(stderr, "close failed: %s.\n", strerror(errno));
	return(-1);
    }		       

    return(0);
}


static int recv_thread(int mynum)
{
    int        lport = 1130 + mynum;
    int        rport = 1030 + mynum;
    int        ret;
    struct sockaddr_in laddr, raddr;
    int        sock;
    int        i;
    int        received;
    unsigned char buf[MAX_SIZE];
    our_header *header = (our_header *)buf;
    int        prev_id = -1;

    /*
     * Set up address structures.
     */
    raddr.sin_addr.s_addr = remote_ip;
    raddr.sin_port        = htons(rport);
    raddr.sin_family      = AF_INET;
    laddr.sin_addr.s_addr = 0;
    laddr.sin_port        = htons(lport);
    laddr.sin_family      = AF_INET;

    user_init();

    sock = user_socket(AF_INET, SOCK_DGRAM, 0);
    if(sock < 0)
    {
	fprintf(stderr, "socket failed: %s.\n", strerror(errno));
	return(-1);
    }

    ret = user_bind(sock, 
		    (struct sockaddr *)&laddr, 
		    sizeof(struct sockaddr_in));
    if(ret < 0)
    {
	fprintf(stderr, "bind failed: %s.\n", strerror(errno));
	return(-1);
    }


    ret = user_connect(sock, 
                       (struct sockaddr *)&raddr, 
                       sizeof(struct sockaddr_in));
    if(ret < 0)
    {
	fprintf(stderr, "connect failed: %s.\n", strerror(errno));
	return(-1);
    }

    do
    { 
	received = user_recv(sock,
			     buf,
			     MAX_SIZE,
			     0);
#if 0
        if ( prev_id >= header->id )
        {
            fprintf(stderr, "bad id\n");
            return(-1);
        }
        if ( received != header->length )
        {
            fprintf(stderr, "bad length\n");
            return(-1);
        }
#endif
	if(received < 0)
	{
	    fprintf(stderr, "recv failed: %s.\n", strerror(errno));
	    return(-1);
	}
        printf("RECEIVED...\n");
    } while ( header->id < NUM_TO_SEND );

    ret = user_close(sock);
    if(ret < 0)
    {
	fprintf(stderr, "close failed: %s.\n", strerror(errno));
	return(-1);
    }		       

    return(0);
}

/* End of $RCSFile$ */
