/* A wee progam to test the spangling sockets. */

#define _P __P

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <netinet/in.h>
#include <netdb.h>
#include <errno.h>
#include <sys/socket.h>
#include <unistd.h>
#include <sys/time.h>

#define SOCKBUF 400000 //(64*1024)

#ifdef USER_STACK
#include "libusernet.h"
#else
#define user_init() ((void)0)
#define user_socket(a,b,c) socket(a,b,c)
#define user_bind(a,b,c) bind(a,b,c)
#define user_connect(a,b,c) connect(a,b,c)
#define user_recv(a,b,c,d) recv(a,b,c,d)
#define user_send(a,b,c,d) send(a,b,c,d)
#define user_shutdown(a,b) shutdown(a,b)
#define user_close(a) close(a)
#define user_kill() ((void)0)
#endif

#define SEND_SIZE 8192 /*16384*/
#define MAX_CONNS 30

/* NB. ripped from linux 2.3.29 */
static inline void * __fast_memset(void * s, unsigned long c, size_t count)
{
    int d0, d1;
    __asm__ __volatile__(
        "cld\n\t"
        "rep ; stosl\n\t"
        "testb $2,%b3\n\t"
        "je 1f\n\t"
        "stosw\n"
        "1:\ttestb $1,%b3\n\t"
        "je 2f\n\t"
        "stosb\n"
        "2:"
        : "=&c" (d0), "=&D" (d1)
        :"a" (c), "q" (count), "0" (count/4), "1" ((long) s)
        :"memory");
    return (s);
}

void *sender(void *arg);

/*
 * Variables shared between all threads.
 */
int touch_data;
int             num_to_send;
struct hostent *he;
int             port;
int             frames_sent = 0;
struct timeval  main_timer;

long tvdif2us(struct timeval *t0, struct timeval *t1)
{
  struct timeval tdiff;
  long us;

  tdiff.tv_sec = t1->tv_sec - t0->tv_sec;
  tdiff.tv_usec = t1->tv_usec - t0->tv_usec;
  if (tdiff.tv_usec < 0)
    tdiff.tv_sec--, tdiff.tv_usec += 1000000;

  us = ((long)tdiff.tv_sec*1000000) + tdiff.tv_usec;
  return us;
}

int main(int argc, char *argv[])
{
#ifdef USER_STACK
    pthread_t threads[MAX_CONNS];
#endif
    int       i;
    int       num_conns;

    /*
     * Initialise the stack as early as possible. It does some gross memory
     * mapping that is necessary for us not to crash!
     */

    user_init();

    /*
     * Parse the command line.
     */

    if ( (argc != 5) && (argc != 6) )
    {
	fprintf(stderr, 
                "%s: Usage: %s <r. hostname> <r. port> <# conns> "
                "<# to send> [-t]\n", argv[0], argv[0]);
	exit(EXIT_FAILURE);
    }

    touch_data = (argc == 6);

    num_conns = strtol(argv[3], NULL, 10);
    if ( errno == ERANGE || num_conns > MAX_CONNS || num_conns < 1 )
    {
        fprintf(stderr, "%s: invalid number of connections, %d.\n",
                argv[0], num_conns);
        exit(EXIT_FAILURE);
    }

    num_to_send = strtol(argv[4], NULL, 10);
    if ( errno == ERANGE || num_to_send > 10000000 || num_to_send < 1 )
    {
        fprintf(stderr, "%s: invalid number of sends/conn, %d.\n",
                argv[0], num_to_send);
        exit(EXIT_FAILURE);
    }

    he = gethostbyname(argv[1]);
    if(he == NULL)
    {
	fprintf(stderr, "%s: failed to look up host \"%s\", reason: ", 
		argv[0], argv[1]);
	herror(NULL);
	fprintf(stderr, "\n");
	exit(EXIT_FAILURE);	
    }
    if(he->h_addrtype != AF_INET || he->h_length != 4)
    {
	fprintf(stderr, "%s: host \"%s\" has non-IPv4 address.\n", 
		argv[0], argv[1]);
	exit(EXIT_FAILURE);
    }

    port = strtol(argv[2], NULL, 10);
    if(errno == ERANGE || port > 65535 || port < 0)
    {
	fprintf(stderr, "%s: port \"%s\" invalid.\n", argv[0], argv[2]);
	exit(EXIT_FAILURE);
    }

    /*
     * Spawn threads. Note that we are connection 0.
     */

    gettimeofday(&main_timer, NULL);
#ifdef USER_STACK
    for ( i = 1; i < num_conns; i++ )
    {
        if ( pthread_create(&threads[i], NULL, sender, (void *)i) )
        {
            fprintf(stderr, "error creating thread %d: %d (%s)\n", 
                    i, errno, strerror(errno));
            exit(EXIT_FAILURE);
        }
    }
#endif
    sender(0);

    /* Join with worker threads. */
#ifdef USER_STACK
    for ( i = 1; i < num_conns; i++ )
    {
        pthread_join(threads[i], NULL);
    }
#endif

    /* Kill off the stack, and finish. */

    printf("Killing stack...\n");
    user_kill();
    printf("Stack dead!\n");

    exit(EXIT_SUCCESS);
}
    


void *sender(void *arg)
{
    int                conn = (int)arg;
    int                old_bufs_to_send, bufs_to_send;
    struct timeval     old_time, curr_time;
    struct sockaddr_in raddr;
    unsigned char      buf[SEND_SIZE];
    int                i;
    int                fd;
    int                ret;
    int part_send;

    /* Set up the remote address. */

    printf("Conn %d: sending to %s:%d.\n", conn, he->h_name, port);
    raddr.sin_addr.s_addr = *((long *)(he->h_addr_list[0]));
    raddr.sin_port        = htons(port);
    raddr.sin_family      = AF_INET;

    /* Fill in some realistic data ;-) */

    for ( i = 0; i < SEND_SIZE; i++ ) buf[i] = i+0x3b+conn;

    /* Create an exciting new user-space TCP connection! */

    fd = user_socket(AF_INET, SOCK_STREAM, 0);
    printf("Conn %d socket: \t%d\n", conn, fd);
    if ( fd < 0 )
    {
        fprintf(stderr, "Conn %d: socket failed: %d (%s)\n",
                conn, errno, strerror(errno));
        return((void*)1);
    }

#ifndef USER_STACK
    {
        int newbuf = SOCKBUF;
        if ( setsockopt(fd, SOL_SOCKET, SO_RCVBUF, &newbuf, sizeof(int)) ||
             setsockopt(fd, SOL_SOCKET, SO_SNDBUF, &newbuf, sizeof(int)) )
        {
            fprintf(stderr, "Could not set TCP sockbuf sizes\n");
            return((void*)1);
        }
    }
#endif

    /* Connect to remote address. */

    printf("Connecting...\n");
    if ( (ret = user_connect(fd, 
                             (struct sockaddr *)&raddr, 
                             sizeof(struct sockaddr_in))) < 0 )
    {
        fprintf(stderr, "\nConn %d: connect failed: %d (%s)\n",
                conn, errno, strerror(errno));
        return((void*)1);
    }
    printf("Conn %d connect: \t%d\n", conn, ret);

    old_bufs_to_send = bufs_to_send = num_to_send;
    gettimeofday(&old_time, NULL);

 loop:
    part_send = 0;
    if ( touch_data ) __fast_memset(buf, 0, SEND_SIZE);
    do { 
        ret = user_send(fd, buf + part_send, SEND_SIZE - part_send, 0);
        if ( ret < 0 )
        {
            fprintf(stderr, "Conn %d: send failed: %d (%s)\n",
                    conn, errno, strerror(errno));
            return((void*)1);
        }
    } while ( (part_send += ret) < SEND_SIZE );

    if ( --bufs_to_send == 0 )
    {
        if ( (ret = user_shutdown(fd, 2)) < 0 )
        {
            fprintf(stderr, "\nConn %d: shutdown failed: %d (%s)\n",
                    conn, errno, strerror(errno));
            return((void*)1);
        }
        printf("Conn %d shutdown: \t%d\n", conn, ret);
            
        ret = user_close(fd);
        if ( ret < 0 )
        {
            fprintf(stderr, "Conn %d: close failed: %d (%s)\n",
                    conn, errno, strerror(errno));
            return((void*)1);
        }		
        printf("Conn %d close: \t%d\n", conn, ret);
        return(0);
    }

    if ( (((old_bufs_to_send - bufs_to_send) % 500) == 0) && 
         (tvdif2us(&old_time, (gettimeofday(&curr_time, NULL), &curr_time)) 
          > 1000000) )
    {
        /*
         * This bandwidth estimator should output once a second has passed, and
         * a multiple of 5000 buffers have been sent.
         */
        printf("Conn %d: %.1f Mb/s\n", conn,
               (((float)(old_bufs_to_send-bufs_to_send)*SEND_SIZE*8)/
                ((float)tvdif2us(&old_time, &curr_time))));
        gettimeofday(&old_time, NULL);
        old_bufs_to_send = bufs_to_send;
    }

    goto loop;
} 

/* End of $RCSFile$ */
