/* A wee progam to test the spangling sockets. */

#define _P __P

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <netinet/in.h>
#include <netdb.h>
#include <errno.h>
#include <sys/socket.h>
#include <sys/time.h>

#define SIOCLRP 0x8945

#define SOCKBUF 400000 //(64*1024)

#ifdef USER_STACK
#include "libusernet.h"
#else
#define user_init() ((void)0)
#define user_socket(a,b,c) socket(a,b,c)
#define user_bind(a,b,c) bind(a,b,c)
#define user_connect(a,b,c) connect(a,b,c)
#define user_recv(a,b,c,d) recv(a,b,c,d)
#define user_shutdown(a,b) shutdown(a,b)
#define user_close(a) close(a)
#define user_kill() ((void)0)
#define user_listen(a,b) listen(a,b)
#define user_accept(a,b,c) accept(a,b,c)
#endif

#define RECV_LENGTH 8192 /*16348*/
#define MAX_CONNS   30

void *recver(void *arg);

unsigned int csum_partial(const unsigned char * buff, 
                          int len, unsigned int sum);

/*
 * Variables shared between all threads.
 */
int touch_data;
struct hostent *he;
int             sock;
int             num_conns = 0;
#ifdef USER_STACK
pthread_t       threads[30];
#endif
int                port;

long tvdif2us(struct timeval *t0, struct timeval *t1)
{
  struct timeval tdiff;
  long us;

  tdiff.tv_sec = t1->tv_sec - t0->tv_sec;
  tdiff.tv_usec = t1->tv_usec - t0->tv_usec;
  if (tdiff.tv_usec < 0)
    tdiff.tv_sec--, tdiff.tv_usec += 1000000;

  us = ((long)tdiff.tv_sec*1000000) + tdiff.tv_usec;
  return us;
}


int main(int argc, char *argv[])
{
    char               buf[RECV_LENGTH];
    int                i;
    int                ret;
    struct sockaddr_in laddr;

    /*
     * Initialise the stack as early as possible. It does some gross memory
     * mapping that is necessary for us not to crash!
     */

    user_init();

    /*
     * Parse the command line.
     */

    if((argc != 2)&&(argc!=3))
    {
	fprintf(stderr, "%s: Usage: %s <l. port> [-t]\n", 
		argv[0], argv[0]);
	exit(EXIT_FAILURE);
    }

    touch_data = (argc==3);
    if ( touch_data ) printf("WILL TOUCH THE DATA!\n");

    port = strtol(argv[1], NULL, 10);
    if ( errno == ERANGE || port > 65535 || port < 0 )
    {
	fprintf(stderr, "%s: port \"%s\" invalid.\n", argv[0], argv[1]);
	exit(EXIT_FAILURE);
    }

    /*
     * Create and bind the listener.
     */

    printf("%s: listening on port %d.\n", 
	   argv[0], port);
    laddr.sin_addr.s_addr = 0;
    laddr.sin_port        = htons(port);
    laddr.sin_family      = AF_INET;

    printf("socket: \t");
    sock = user_socket(AF_INET, SOCK_STREAM, 0);
    printf("%d\n", sock);
    if ( sock < 0 )
    {
	fprintf(stderr, "%s: socket failed: %d (%s)\n",
		argv[0], errno, strerror(errno));
	exit(EXIT_FAILURE);
    }

#ifndef USER_STACK
    {
        int newbuf = SOCKBUF;
        if ( setsockopt(sock, SOL_SOCKET, SO_RCVBUF, &newbuf, sizeof(int)) ||
             setsockopt(sock, SOL_SOCKET, SO_SNDBUF, &newbuf, sizeof(int)) )
        {
            fprintf(stderr, "Could not set TCP sockbuf sizes\n");
            return((void*)1);
        }
#if 1
        if ( ioctl(sock, SIOCLRP, 1) )
        {
            fprintf(stderr, "Could not enable LRP\n");
            return((void*)1);
        }
        printf("LRP enabled...\n");      
#endif
    }
#endif

    printf("bind: \t\t");
    ret = user_bind(sock, 
		    (struct sockaddr *)&laddr, 
		    sizeof(struct sockaddr_in));
    printf("%d\n", ret);
    if ( ret < 0 )
    {
	fprintf(stderr, "%s: bind failed: %d (%s)\n",
		argv[0], errno, strerror(errno));
	exit(EXIT_FAILURE);
    }

    printf("listen: \t");
    ret = user_listen(sock, 5);    
    printf("%d\n", ret);
    if ( ret < 0 )
    {
	fprintf(stderr, "%s: listen failed: %d (%s)\n",
		argv[0], errno, strerror(errno));
	exit(EXIT_FAILURE);
    }

    /*
     * We accept() in each thread. After accepting, a thread spawns so that
     * connections can always be accepted.
     */
    recver(0);

#ifdef USER_STACK
    for ( i = 1; i < num_conns; i++ )
    {
        pthread_join(threads[i], NULL);
    }
#endif

    printf("close: \t\t");
    ret = user_close(sock);
    printf("%d\n", ret);

    user_kill();

    exit(EXIT_SUCCESS);
}


void *recver(void *arg)
{
    int                conn = (int)arg;
    struct sockaddr_in raddr;
    int                addrlen = sizeof(struct sockaddr_in);
    int                fd;
    int                old_totals, totals, calls;
    struct timeval     old_time, curr_time;
    int                received, ret;
    char               buf[RECV_LENGTH];

    /*
     * Accept a connection.
     */

    printf("Waiting for accept...\n");
    fd = user_accept(sock, (struct sockaddr *)&raddr, &addrlen);
    printf("Conn %d accept: \t%d\n", conn, fd);
    if ( fd < 0 )
    {
        fprintf(stderr, "Conn %d: accept failed: %d (%s)\n",
                conn, errno, strerror(errno));
        return((void*)1);
    }

    num_conns++; // no race
#if 0
//#ifdef USER_STACK
    pthread_create(&threads[conn+1], NULL, recver, (void *)(conn+1));
#else
    user_close(sock);
#endif
#ifndef USER_STACK
    {
        int newbuf = SOCKBUF;
        if ( setsockopt(fd, SOL_SOCKET, SO_RCVBUF, &newbuf, sizeof(int)) ||
             setsockopt(fd, SOL_SOCKET, SO_SNDBUF, &newbuf, sizeof(int)) )
        {
            fprintf(stderr, "Could not set TCP sockbuf sizes\n");
            return((void*)1);
        }
#if 1
        if ( ioctl(fd, SIOCLRP, 1) )
        {
            fprintf(stderr, "Could not enable LRP\n");
            return((void*)1);
        }
        printf("LRP enabled...\n");      
#endif
    }
#endif

    old_totals = totals = calls = 0;
    gettimeofday(&old_time, NULL);

    for ( ; ; )
    {
        received = user_recv(fd, buf, RECV_LENGTH, 0);

        if ( received < 0 )
        {
            fprintf(stderr, "Conn %d: recv failed: %d (%s)\n",
                    conn, errno, strerror(errno));
            printf("Conn %d total transfer: %d\n", conn, totals);
            return((void*)1);
        }

        if ( received == 0 )
        {
#if 0
            {
                int i;
                FILE *f;
                f = fopen("/homes/kaf24/gnudat", "wb");
#undef fprintf
                for ( i = 0; i < NUM_BUCKETS; i++ ) 
                    fprintf(f, "%d\n", histogram[i]);
                fclose(f);
            }
#endif
            ret = user_close(fd);
            printf("Conn %d close: \t%d\n", conn, ret);
            return((void*)1);
        }
#if 0
        if ( buf[0] != ((char)totals[0]) )
        {
            fprintf(stderr, "expected first byte %d, got %d.\n",
                    (unsigned char)totals[0], 
                    (unsigned char)(buf[0]));
            printf("total transfer: %ld + %d.\n", 
                   totals[0], 
                   received);
            exit(EXIT_FAILURE);
        }
        if ( buf[received-1] != ((char)(totals[0]+received-1)))
        {
            fprintf(stderr, "expected last byte %d, got %d.\n",
                    (unsigned char)(totals[0]+received-1), 
                    (unsigned char)(buf[received-1]));
            printf("total transfer: %ld + %d.\n", 
                   totals[0], 
                   received);
            exit(EXIT_FAILURE);
        }
#endif

        if ( touch_data ) csum_partial(buf, received, 0);

        totals += received;   
        if ( ((calls++ % 500) == 0) && 
             (tvdif2us(&old_time, (gettimeofday(&curr_time, NULL), 
                                   &curr_time)) > 1000000) )
        {
            /*
             * This bandwidth estimator should output once a second has passed,
             * and a multiple of 5000 buffers have been sent.
             */
            printf("(%d) Conn %d: %.1f Mb/s\n", port, conn, 
                   (((float)(totals - old_totals)*8)/
                    ((float)tvdif2us(&old_time, &curr_time))));
            gettimeofday(&old_time, NULL);
            old_totals = totals;
        }
    }
} 

/* End of $RCSFile$ */
