/******************************************************************************
 * lowlevel.h
 * 
 * Interface functions to communicate with the user-safe device. Some of this
 * is inevitably device-dependent.
 * 
 * Copyright (c) 1999-2000, K A Fraser
 * 
 * $Id: $
 */

#ifndef _LOWLEVEL_H_
#define _LOWLEVEL_H_

/******************************************************************************
 * USD connection state is opaque to clients.
 */
typedef struct {} usd_device_conn_t;

/******************************************************************************
 * Interface functions. Descriptions provided in `lowlevel.c'.
 */
int usd_init_callback(void);
void *usd_get_next_connection_with_work(u32 *);

usd_device_conn_t *usd_setup_device_connection(int, pid_t, void *);
void usd_close_device_connection(usd_device_conn_t *);
int usd_get_shared_data_area(usd_device_conn_t *, caddr_t *);
int usd_bind_to_local_address(usd_device_conn_t  *, 
                              struct sockaddr_in *, char *);
int usd_connect_to_remote_address(usd_device_conn_t        *,
                                  const struct sockaddr_in *);
int usd_listen_for_incoming_connections(usd_device_conn_t *, int);
int usd_enable_connection_filtering(usd_device_conn_t *);

int  usd_completed_buffers_in_tx_queue(usd_device_conn_t *);
int  usd_space_in_tx_queue(usd_device_conn_t *);
void usd_add_to_tx_queue(usd_device_conn_t *, void *, int);
void usd_push_new_tx_bufs_to_nic(usd_device_conn_t *);
int  usd_remove_from_tx_queue(usd_device_conn_t *);
void usd_tx_req_callback(usd_device_conn_t *, u32);

void usd_dump_stats(void);

int  usd_completed_buffers_in_rx_queue(usd_device_conn_t *);
int  usd_free_buffers_in_rx_queue(usd_device_conn_t *);
void usd_add_hdr_to_rx_queue(usd_device_conn_t *, void *, int);
void usd_add_data_to_rx_queue(usd_device_conn_t *, void *, int, bool);
void usd_push_new_rx_bufs_to_nic(usd_device_conn_t *);
#define usd_add_to_rx_queue(a,b,c,d) usd_add_data_to_rx_queue(a,b,c,d)
int  usd_remove_from_rx_queue(usd_device_conn_t *,
                              void **, int *, void **, int *);
void usd_rx_req_callback(usd_device_conn_t *, u32);

void wait_for_usd_conns_to_close(void);

void usd_clear_rx_event(usd_device_conn_t *);
void usd_set_rx_event(usd_device_conn_t *);

void usd_clear_tx_event(usd_device_conn_t *);
void usd_set_tx_event(usd_device_conn_t *);

#endif _LOWLEVEL_H_
