/******************************************************************************
 * libusernet.h
 * 
 * Public interface for the user-space TCP/IP stack.
 * 
 * Copyright (c) 1999-2000, K A Fraser
 * 
 * $Id: libusernet.h,v 3.2 1999/12/18 16:27:38 kaf24 Exp kaf24 $
 */

#include <sys/poll.h>
#ifndef INFTIM
#define INFTIM -1
#endif
#include <fcntl.h>

/* This message not defined by Linux */
#undef MSG_WAITALL
#define MSG_WAITALL 0x100

/* The following functions may be implemented here: */
void user_init(void);
void user_kill(void);
int user_accept     (int s,       void *addr, int *addrlen);
int user_bind       (int s, const void *addr, int  addrlen);
int user_connect    (int s,       void *addr, int  addrlen);
int user_getpeername(int s,       void *addr, int *addrlen);
int user_getsockname(int s,       void *addr, int *addrlen);
int user_getsockopt (int         s,
		     int         level,
		     int         optname,
		     void       *optval,
		     int        *optlen);
int user_setsockopt (int         s,
		     int         level,
		     int         optname,
		     void       *optval,
		     int         optlen);
int user_listen     (int s, int backlog);
int user_recv       (int s, void *buf, int len, int flags);
int user_send       (int s, void *msg, int len, int flags);
int user_shutdown   (int s, int how);
int user_socket     (int af, int type, int protocol);
int user_socketpair (int af, int type, int protocol, int sv[2]);
ssize_t user_read   (int s, void       *buf, size_t nbyte);
ssize_t user_write  (int s, const void *buf, size_t nbyte);
int user_close      (int s);
int user_fcntl      (int fd, int cmd, int arg);
int user_poll       (struct pollfd *fdarray, unsigned long nfds, int timeout);


/******************************************************************************
 * Remove nasty blocking stdio...
 */
#include <unistd.h>
#include <pth.h>
#define printf(format, args...) \
    { \
        char __s[50]; \
        sprintf(__s, format, ## args); \
        pth_write(STDOUT_FILENO, __s, strlen(__s)); \
    }
#define fprintf(fp, format, args...) \
    { \
        char __s[50]; \
        sprintf(__s, format, ## args); \
        pth_write(STDERR_FILENO, __s, strlen(__s)); \
    }

/*Fake out a pthread interface for users */
#ifndef pthread_create
typedef pth_t       pthread_t;
typedef pth_mutex_t pthread_mutex_t;
typedef pth_cond_t  pthread_cond_t;

#define pthread_create(__thr, __attr, __start, __arg) \
 ({ *(__thr) = pth_spawn(PTH_ATTR_DEFAULT, __start, __arg); 0; }) 
#define pthread_cancel(__t) (!pth_cancel(__t))
#define pthread_join(__t, __r) (!pth_join(__t, __r))
#define pthread_setcanceltype(__t, __o) \
 pth_cancel_state(PTH_CANCEL_ENABLE|PTH_CANCEL_ASYNCHRONOUS, __o)
#define sched_yield() pth_yield(NULL)

#define PTHREAD_MUTEX_INITIALIZER PTH_MUTEX_INIT
#define pthread_mutex_init(__x, __t) (!pth_mutex_init(__x))
#define pthread_mutex_lock(__x) (!pth_mutex_acquire(__x, FALSE, NULL))
#define pthread_mutex_unlock(__x) (!pth_mutex_release(__x))
#define pthread_mutex_destroy(__x) (!pth_mutex_destroy(__x))

#define PTHREAD_COND_INITIALIZER PTH_COND_INIT
#define pthread_cond_init(__x, __t) (!pth_cond_init(__x))
#define pthread_cond_wait(__c, __m) (!pth_cond_await(__c, __m, NULL))
#define pthread_cond_signal(__c) (!pth_cond_notify(__c, FALSE))
#define pthread_cond_broadcast(__c) (!pth_cond_notify(__c,TRUE))
#define pthread_cond_destroy(__x) ((void)0)
#endif

/* XXX KAF -- test vars */
#define NUM_BUCKETS 500
extern unsigned int histogram[NUM_BUCKETS];
