/******************************************************************************
 * hash.h
 * 
 * Connection hash table.
 * 
 * Copyright (c) 1999-2000, K A Fraser
 * 
 * $Id: hash.h,v 3.2 1999/12/18 16:27:38 kaf24 Exp kaf24 $
 */

#ifndef _HASH_H_
#define _HASH_H_

typedef int   hash_key_t;
typedef void *hash_table_t;
typedef void *hash_entry_t;

hash_table_t init_hash_table(int);
void destroy_hash_table(hash_table_t);
int insert_hash_entry(hash_table_t, hash_key_t, hash_entry_t);
int remove_hash_entry(hash_table_t, hash_key_t);
hash_entry_t element_for_key(hash_table_t, hash_key_t);
void wait_for_table_to_empty(hash_table_t);

#endif _HASH_H_
