/* pth_p.h -- autogenerated from pth_p.h.in, DO NOT EDIT! */
/*
**  pth_p.h -- Pth private API definitions
**
**  Copyright (c) 1999 Ralf S. Engelschall <rse@engelschall.com>
**
**  This file is part of GNU Pth, a non-preemptive thread scheduling
**  library which can be found at http://www.gnu.org/software/pth/.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2 of the License, or (at your option) any later version.
**
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**  Lesser General Public License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
**  USA, or contact Ralf S. Engelschall <rse@engelschall.com>.
*/

#ifndef _PTH_P_H_
#define _PTH_P_H_

/* mandatory system headers */
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <setjmp.h>
#include <signal.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <sys/socket.h>

/* library version */
#define _AS_HEADER
#include "pth_vers.c"
#undef _AS_HEADER

/* public API headers */
#define _PTH_PRIVATE
#include "pth.h"
#undef _PTH_PRIVATE

/* autoconf defines and macros */
#include "pth_acdef.h"
#include "pth_acmac.h"

/* optional system headers */
#ifdef HAVE_SYS_RESOURCE_H
#include <sys/resource.h>
#endif
#ifdef HAVE_NET_ERRNO_H
#include <net/errno.h>
#endif

/* non-blocking flags */
#ifdef  O_NONBLOCK
#define O_NONBLOCKING O_NONBLOCK
#else
#ifdef  O_NDELAY
#define O_NONBLOCKING O_NDELAY
#else
#ifdef  FNDELAY
#define O_NONBLOCKING FNDELAY
#else
#error "No O_NONBLOCK, O_NDELAY or FNDELAY flag available!"
#endif
#endif
#endif

/* compiler happyness: avoid ``empty compiltion unit'' problem */
#define COMPILER_HAPPYNESS(name) \
    int __##name##_unit = 0;

/* generated contents */
BEGIN_DECLARATION
#if !defined(HAVE_STRERROR)
char *_pth_compat_strerror(int);
#define strerror(errnum) _pth_compat_strerror(errnum);
#endif

#ifndef PTH_DEBUG

#define pth_debug1(a1)                     /* NOP */
#define pth_debug2(a1, a2)                 /* NOP */
#define pth_debug3(a1, a2, a3)             /* NOP */
#define pth_debug4(a1, a2, a3, a4)         /* NOP */
#define pth_debug5(a1, a2, a3, a4, a5)     /* NOP */
#define pth_debug6(a1, a2, a3, a4, a5, a6) /* NOP */

#else

#define pth_debug1(a1)                     pth_debug(__FILE__, __LINE__, a1)
#define pth_debug2(a1, a2)                 pth_debug(__FILE__, __LINE__, a1, a2)
#define pth_debug3(a1, a2, a3)             pth_debug(__FILE__, __LINE__, a1, a2, a3)
#define pth_debug4(a1, a2, a3, a4)         pth_debug(__FILE__, __LINE__, a1, a2, a3, a4)
#define pth_debug5(a1, a2, a3, a4, a5)     pth_debug(__FILE__, __LINE__, a1, a2, a3, a4, a5)
#define pth_debug6(a1, a2, a3, a4, a5, a6) pth_debug(__FILE__, __LINE__, a1, a2, a3, a4, a5, a6)

#endif /* PTH_DEBUG */


#if PTH_SYSCALL_HARD
#include <sys/syscall.h>
#define pth_sc(func) PTH_SC_##func
#else
#define pth_sc(func) func
#endif

#if defined(SYS_fork)
#define PTH_SC_fork() ((pid_t)syscall(SYS_fork))
#else
#define PTH_SC_fork fork
#endif
#if defined(SYS_sigprocmask)
#define PTH_SC_sigprocmask(a1,a2,a3) ((int)syscall(SYS_sigprocmask,(a1),(a2),(a3)))
#else
#define PTH_SC_sigprocmask sigprocmask
#endif
#if defined(SYS_waitpid)
#define PTH_SC_waitpid(a1,a2,a3) ((int)syscall(SYS_waitpid,(a1),(a2),(a3)))
#else
#define PTH_SC_waitpid waitpid
#endif
#if defined(SYS_connect)
#define PTH_SC_connect(a1,a2,a3) ((int)syscall(SYS_connect,(a1),(a2),(a3)))
#else
#define PTH_SC_connect connect
#endif
#if defined(SYS_accept)
#define PTH_SC_accept(a1,a2,a3) ((int)syscall(SYS_accept,(a1),(a2),(a3)))
#else
#define PTH_SC_accept accept
#endif
#if defined(SYS_select)
#define PTH_SC_select(a1,a2,a3,a4,a5) ((int)syscall(SYS_select,(a1),(a2),(a3),(a4),(a5)))
#else
#define PTH_SC_select select
#endif
#if defined(SYS_poll)
#define PTH_SC_poll(a1,a2,a3) ((int)syscall(SYS_poll,(a1),(a2),(a3)))
#else
#define PTH_SC_poll poll
#endif
#if defined(SYS_read)
#define PTH_SC_read(a1,a2,a3) ((ssize_t)syscall(SYS_read,(a1),(a2),(a3)))
#else
#define PTH_SC_read read
#endif
#if defined(SYS_write)
#define PTH_SC_write(a1,a2,a3) ((ssize_t)syscall(SYS_write,(a1),(a2),(a3)))
#else
#define PTH_SC_write write
#endif
#if defined(SYS_readv)
#define PTH_SC_readv(a1,a2,a3) ((ssize_t)syscall(SYS_readv,(a1),(a2),(a3)))
#else
#define PTH_SC_readv readv
#endif
#if defined(SYS_writev)
#define PTH_SC_writev(a1,a2,a3) ((ssize_t)syscall(SYS_writev,(a1),(a2),(a3)))
#else
#define PTH_SC_writev writev
#endif

/* enclose errno in a block */
#define errno_shield \
        for ( pth_errno_storage = errno, \
              pth_errno_flag = TRUE; \
              pth_errno_flag; \
              errno = pth_errno_storage, \
              pth_errno_flag = FALSE )

/* return plus setting an errno value */
#if defined(PTH_DEBUG)
#define return_errno(return_val,errno_val) \
        do { errno = (errno_val); \
             pth_debug4("return 0x%lx with errno %d(\"%s\")", \
                        (unsigned long)(return_val), (errno), strerror((errno))); \
             return (return_val); } while (0)
#else
#define return_errno(return_val,errno_val) \
        do { errno = (errno_val); return (return_val); } while (0) 
#endif

#define pth_ring_next(r, rn) \
    (((r) == NULL || (rn) == NULL) ? NULL : (rn)->rn_next)
#define pth_ring_prev(r, rn) \
    (((r) == NULL || (rn) == NULL) ? NULL : (rn)->rn_prev)
#define pth_ring_first(r) \
    ((r) == NULL ? NULL : (r)->rn_hook)
#define pth_ring_push(r, rn) \
    pth_ring_prepend((r), (rn))
#define pth_ring_unshift(r, rn) \
    pth_ring_append((r), (rn))

/* 
 * machine context state structure
 *
 * In `jb' the CPU registers, the program counter, the stack
 * pointer and (usually) the signals mask is stored. When the
 * signal mask cannot be implicitly stored in `jb', it's
 * alternatively stored explicitly in `sigs'. The `error' stores
 * the value of `errno'.
 */

typedef struct pth_mctx_st pth_mctx_t;
struct pth_mctx_st { pth_sigjmpbuf jb; };

/*
** ____ MACHINE STATE SWITCHING ______________________________________
*/

/* save the current machine context */
#define pth_mctx_save(mctx) pth_sigsetjmp((mctx)->jb)

/* restore the current machine context (at the location of the old context) */
#define pth_mctx_restore(mctx) pth_siglongjmp((mctx)->jb, 1)

/* switch from one machine context to another */
#define pth_mctx_switch(old,new) if (pth_mctx_save(old)) pth_mctx_restore(new);


typedef struct pth_cleanup_st pth_cleanup_t;
struct pth_cleanup_st {
    pth_cleanup_t *next;
    void (*func)(void *);
    void *arg;
};


/*
 * ******************** START OF pth_time.c DEFINITIONS *************
 */

/*
 * KAF NEW: more efficient timrs for TCP.
 */
extern pth_time_t pth_time_nearest;
#define pth_time_nearest_exists() \
(pth_time_nearest.tv_sec || pth_time_nearest.tv_usec)

#define PTH_TIME_NOW  (pth_time_t *)(0)
#define PTH_TIME_ZERO &pth_time_zero
#define PTH_TIME(sec,usec) { sec, usec }
#define pth_time_equal(t1,t2) \
        (((t1).tv_sec == (t2).tv_sec) && ((t1).tv_usec == (t2).tv_usec))

#if defined(HAVE_GETTIMEOFDAY_ARGS1)
#define __gettimeofday(t) gettimeofday(t)
#else
#define __gettimeofday(t) gettimeofday(t, NULL)
#endif
#define pth_time_set(t1,t2) \
    do { \
        if ((t2) == PTH_TIME_NOW) \
            __gettimeofday((t1)); \
        else { \
            (t1)->tv_sec  = (t2)->tv_sec; \
            (t1)->tv_usec = (t2)->tv_usec; \
        } \
    } while (0)

#define pth_time_add(t1,t2) \
    (t1)->tv_sec  += (t2)->tv_sec; \
    (t1)->tv_usec += (t2)->tv_usec; \
    if ((t1)->tv_usec > 1000000) { \
        (t1)->tv_sec  += 1; \
        (t1)->tv_usec -= 1000000; \
    }
#define pth_time_sub(t1,t2) \
    (t1)->tv_sec  -= (t2)->tv_sec; \
    (t1)->tv_usec -= (t2)->tv_usec; \
    if ((t1)->tv_usec < 0) { \
        (t1)->tv_sec  -= 1; \
        (t1)->tv_usec += 1000000; \
    }

/*
 * ********************** END OF pth_time.c DEFINITIONS *************
 */

#define PTH_TCB_NAMELEN 40

    /* thread control block */
struct pth_st {
    /* priority queue handling */
    pth_t          q_next;               /* next thread in pool                         */
    pth_t          q_prev;               /* previous thread in pool                     */
    int            q_prio;               /* (relative) priority of thread when queued   */

    /* standard thread control block ingredients */
    int            prio;                 /* base priority of thread                     */
    char           name[PTH_TCB_NAMELEN];/* name of thread (mainly for debugging)       */
    pth_state_t    state;                /* current state indicator for thread          */

    /* timing                                                                           */
    pth_time_t     spawned;              /* time point at which thread was spawned      */
    pth_time_t     lastran;              /* time point at which thread was last running */
    pth_time_t     running;              /* time range the thread was already running   */

    /* event handling */
    pth_event_t    events;               /* events the tread is waiting for             */

    /* per-thread signal handling */
    sigset_t       sigpending;           /* set    of pending signals                   */
    int            sigpendcnt;           /* number of pending signals                   */

    /* machine context */
    pth_mctx_t     mctx;                 /* last saved machine state of thread          */
    char          *stack;                /* pointer to thread stack                     */
    unsigned int   stacksize;            /* size of thread stack                        */
    long          *stackguard;           /* stack overflow guard                        */
    int            stackloan;            /* stack type                                  */
    void        *(*start_func)(void *);  /* start routine                               */
    void          *start_arg;            /* start argument                              */

    /* thread joining */
    int            joinable;             /* whether thread is joinable                  */
    void          *join_arg;             /* joining argument                            */

    /* per-thread specific storage */
    const void   **data_value;           /* thread specific  values                     */
    int            data_count;           /* number of stored values                     */

    /* cancellation support */
    int            cancelreq;            /* cancellation request is pending             */
    unsigned int   cancelstate;          /* cancellation state of thread                */
    pth_cleanup_t *cleanups;             /* stack of thread cleanup handlers            */

    /* mutex ring */
    pth_ring_t     mutexring;            /* ring of aquired mutex structures            */
};

#define pth_util_min(a,b) \
        ((a) > (b) ? (b) : (a))

/* thread priority queue */
struct pth_pqueue_st {
    pth_t q_head;
    int   q_num;
};
typedef struct pth_pqueue_st pth_pqueue_t;

#define pth_pqueue_favorite_prio(q) \
    ((q)->q_head ? (q)->q_head->q_prio + 1 : PTH_PRIO_MAX)
#define pth_pqueue_elements(q) ((q)->q_num)
#define pth_pqueue_head(q) ((q)->q_head)

/* event structure */
struct pth_event_st {
    struct pth_event_st *ev_next;
    struct pth_event_st *ev_prev;
    int ev_occurred;
    int ev_type;
    int ev_goal;
    union {
        struct { int fd; }                                        FD;
        struct { int *n; int nfd; fd_set *rfds, *wfds, *efds; }   SELECT;
        struct { sigset_t *sigs; int *sig; }                      SIGS;
        struct { pth_time_t tv; }                                 TIME;
        struct { pth_msgport_t mp; }                              MSG;
        struct { pth_mutex_t *mutex; }                            MUTEX;
        struct { pth_cond_t *cond; }                              COND;
        struct { pth_t tid; }                                     TID;
        struct { pid_t pid; int *status; int flags; }             PID;
        struct { int (*func)(void*); void *func_arg; }            FUNC;
    } ev_args;
};


/* message port structure */
struct pth_msgport_st {
    pth_ringnode_t mp_node;  /* maintainance node handle */
    const char    *mp_name;  /* optional name of message port */
    pth_t          mp_tid;   /* corresponding thread */
    pth_ring_t     mp_queue; /* queue of messages pending on port */
};


enum {
    PTH_ATTR_GET,
    PTH_ATTR_SET
};

struct pth_attr_st {
    pth_t        a_tid;
    int          a_prio;
    char         a_name[PTH_TCB_NAMELEN];
    int          a_joinable;
    unsigned int a_cancelstate;
    unsigned int a_stacksize;
    char        *a_stackaddr;
};

#define pth_implicit_init() \
    if (!pth_initialized) \
        pth_init();

/* make sure the scpp source extensions are skipped */
#define cpp 0
#define intern /**/

/* move intern variables to hidden namespace */
#define pth_errno_storage __pth_errno_storage
#define pth_errno_flag __pth_errno_flag
#define pth_time_zero __pth_time_zero
#define pth_state_names __pth_state_names
#define pth_main __pth_main
#define pth_sched __pth_sched
#define pth_current __pth_current
#define pth_NQ __pth_NQ
#define pth_RQ __pth_RQ
#define pth_WQ __pth_WQ
#define pth_DQ __pth_DQ
#define pth_loadval __pth_loadval
#define pth_initialized __pth_initialized

/* move intern functions to hidden namespace */
#define pth_debug __pth_debug
#define pth_ring_init __pth_ring_init
#define pth_ring_empty __pth_ring_empty
#define pth_ring_elements __pth_ring_elements
#define pth_ring_last __pth_ring_last
#define pth_ring_insert_after __pth_ring_insert_after
#define pth_ring_insert_before __pth_ring_insert_before
#define pth_ring_remove __pth_ring_remove
#define pth_ring_prepend __pth_ring_prepend
#define pth_ring_append __pth_ring_append
#define pth_ring_pop __pth_ring_pop
#define pth_ring_shift __pth_ring_shift
#define pth_mctx_set __pth_mctx_set
#define pth_cleanup_popall __pth_cleanup_popall
#define pth_time_usleep __pth_time_usleep
#define pth_time_cmp __pth_time_cmp
#define pth_time_div __pth_time_div
#define pth_time_mul __pth_time_mul
#define pth_time_t2d __pth_time_t2d
#define pth_time_t2i __pth_time_t2i
#define pth_time_pos __pth_time_pos
#define pth_tcb_alloc __pth_tcb_alloc
#define pth_tcb_free __pth_tcb_free
#define pth_util_sigdelete __pth_util_sigdelete
#define pth_util_cpystrn __pth_util_cpystrn
#define pth_util_fds_merge __pth_util_fds_merge
#define pth_util_fds_test __pth_util_fds_test
#define pth_util_fds_select __pth_util_fds_select
#define pth_pqueue_init __pth_pqueue_init
#define pth_pqueue_insert __pth_pqueue_insert
#define pth_pqueue_delmax __pth_pqueue_delmax
#define pth_pqueue_delete __pth_pqueue_delete
#define pth_pqueue_favorite __pth_pqueue_favorite
#define pth_pqueue_increase __pth_pqueue_increase
#define pth_pqueue_walk __pth_pqueue_walk
#define pth_pqueue_contains __pth_pqueue_contains
#define pth_scheduler_init __pth_scheduler_init
#define pth_scheduler_drop __pth_scheduler_drop
#define pth_scheduler_kill __pth_scheduler_kill
#define pth_scheduler __pth_scheduler
#define pth_sched_eventmanager __pth_sched_eventmanager
//#define pth_sched_eventmanager_sighandler __pth_sched_eventmanager_sighandler
#define pth_key_destroydata __pth_key_destroydata
#define pth_mutex_releaseall __pth_mutex_releaseall
#define pth_attr_ctrl __pth_attr_ctrl
#define pth_readv_faked __pth_readv_faked
#define pth_writev_iov_bytes __pth_writev_iov_bytes
#define pth_writev_iov_advance __pth_writev_iov_advance
#define pth_writev_faked __pth_writev_faked

/* prototypes for intern variables */
extern int pth_errno_storage;
extern int pth_errno_flag;
extern pth_time_t pth_time_zero;
extern char *pth_state_names[];
extern pth_t pth_main;
extern pth_t pth_sched;
extern pth_t pth_current;
extern pth_pqueue_t pth_NQ;
extern pth_pqueue_t pth_RQ;
extern pth_pqueue_t pth_WQ;
extern pth_pqueue_t pth_DQ;
extern float pth_loadval;
extern int pth_initialized;

/* prototypes for intern functions */
extern void pth_debug(char *, int, char *, ...);
extern void pth_ring_init(pth_ring_t *, pth_ringnode_t *);
extern int pth_ring_empty(pth_ring_t *);
extern int pth_ring_elements(pth_ring_t *);
extern pth_ringnode_t *pth_ring_last(pth_ring_t *);
extern void pth_ring_insert_after(pth_ring_t *, pth_ringnode_t *, pth_ringnode_t *);
extern void pth_ring_insert_before(pth_ring_t *, pth_ringnode_t *, pth_ringnode_t *);
extern void pth_ring_remove(pth_ring_t *, pth_ringnode_t *);
extern void pth_ring_prepend(pth_ring_t *, pth_ringnode_t *);
extern void pth_ring_append(pth_ring_t *, pth_ringnode_t *);
extern pth_ringnode_t *pth_ring_pop(pth_ring_t *);
extern pth_ringnode_t *pth_ring_shift(pth_ring_t *);
extern int pth_mctx_set(pth_mctx_t *, void (*)(void), char *, char *);
extern void pth_cleanup_popall(pth_t, int);
extern void pth_time_usleep(unsigned long);
extern int pth_time_cmp(pth_time_t *, pth_time_t *);
extern void pth_time_div(pth_time_t *, int);
extern void pth_time_mul(pth_time_t *, int);
extern double pth_time_t2d(pth_time_t *);
extern int pth_time_t2i(pth_time_t *);
extern int pth_time_pos(pth_time_t *);
extern pth_t pth_tcb_alloc(unsigned int, void *);
extern void pth_tcb_free(pth_t);
extern int pth_util_sigdelete(int);
extern char *pth_util_cpystrn(char *, const char *, size_t);
extern void pth_util_fds_merge(int, fd_set *, fd_set *, fd_set *, fd_set *, fd_set *, fd_set *);
extern int pth_util_fds_test(int, fd_set *, fd_set *, fd_set *, fd_set *, fd_set *, fd_set *);
extern int pth_util_fds_select(int, fd_set *, fd_set *, fd_set *, fd_set *, fd_set *, fd_set *);
extern void pth_pqueue_init(pth_pqueue_t *);
extern void pth_pqueue_insert(pth_pqueue_t *, int, pth_t);
extern pth_t pth_pqueue_delmax(pth_pqueue_t *);
extern void pth_pqueue_delete(pth_pqueue_t *, pth_t);
extern int pth_pqueue_favorite(pth_pqueue_t *, pth_t);
extern void pth_pqueue_increase(pth_pqueue_t *);
extern pth_t pth_pqueue_walk(pth_pqueue_t *, pth_t);
extern int pth_pqueue_contains(pth_pqueue_t *, pth_t);
extern void pth_scheduler_init(void);
extern void pth_scheduler_drop(void);
extern void pth_scheduler_kill(void);
extern void *pth_scheduler(void *);
extern void pth_sched_eventmanager(pth_time_t *, int);
/*extern void pth_sched_eventmanager_sighandler(int);*/
extern void pth_key_destroydata(pth_t);
extern void pth_mutex_releaseall(pth_t);
extern int pth_attr_ctrl(int, pth_attr_t, int, va_list);
extern ssize_t pth_readv_faked(int, const struct iovec *, int);
extern ssize_t pth_writev_iov_bytes(const struct iovec *, int);
extern void pth_writev_iov_advance(const struct iovec *, int, size_t, struct iovec **, int *);
extern ssize_t pth_writev_faked(int, const struct iovec *, int);
END_DECLARATION

/*
 * XXXXXXXXXXXXXXXXX RIPPED HEINOUSLY FROM asm/siginfo.h!!! XXXXXXXXXXXXXX
 */

#ifndef si_value

typedef union sigval { int sival_int; void *sival_ptr; } sigval_t;

#define SI_PAD_SIZE     ((128/sizeof(int)) - 3)

typedef struct siginfo {
        int si_signo, si_errno, si_code;
        union {
                int _pad[SI_PAD_SIZE];

                /* POSIX.1b signals */
                struct {
                        pid_t _pid;             /* sender's pid */
                        uid_t _uid;             /* sender's uid */
                        sigval_t _sigval;
                } _rt;
        } _sifields;
} siginfo_t;

#define si_value        _sifields._rt._sigval

#endif

/*
 * XXXXXXXXXXXXXXXXXXX END OF HEINOUS CODE RIP!!! XXXXXXXXXXXXXXXXXXXXXX
 */

typedef void sigfunc_rt(int, siginfo_t *, void *);
int set_rt_sighandler(int signum, sigfunc_rt *func);

#endif /* _PTH_P_H_ */

