/*
 * All modifications are copyright (c) 2000, K A Fraser.
 * 
 * Please note the original copyright and license details below.
 */

/*
 * Copyright (C) 1997 Massachusetts Institute of Technology 
 *
 * This software is being provided by the copyright holders under the
 * following license. By obtaining, using and/or copying this software,
 * you agree that you have read, understood, and will comply with the
 * following terms and conditions:
 *
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose and without fee or royalty is
 * hereby granted, provided that the full text of this NOTICE appears on
 * ALL copies of the software and documentation or portions thereof,
 * including modifications, that you make.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE NO
 * REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED. BY WAY OF EXAMPLE,
 * BUT NOT LIMITATION, COPYRIGHT HOLDERS MAKE NO REPRESENTATIONS OR
 * WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR
 * THAT THE USE OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY
 * THIRD PARTY PATENTS, COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS. COPYRIGHT
 * HOLDERS WILL BEAR NO LIABILITY FOR ANY USE OF THIS SOFTWARE OR
 * DOCUMENTATION.
 *
 * The name and trademarks of copyright holders may NOT be used in
 * advertising or publicity pertaining to the software without specific,
 * written prior permission. Title to copyright in this software and any
 * associated documentation will at all times remain with copyright
 * holders. See the file AUTHORS which should have accompanied this software
 * for a list of all copyright holders.
 *
 * This file may be derived from previously copyrighted software. This
 * copyright applies only to those changes made by the copyright
 * holders listed in the AUTHORS file. The rest of this file is covered by
 * the copyright notices, if any, listed below.
 */


#ifndef _DEFS_H_
#define _DEFS_H_

#include <linux/kernel.h>
#include <linux/string.h>
extern void *kmalloc(int, int);
extern void kfree(const void *);
#define malloc(sz) kmalloc(sz, 0x13)
#define free(p) kfree(p)
#define printf printk

#ifndef NULL
#define NULL ((void *) 0)
#endif

#define offsetof(type, member)  ((int)(&((type *)0)->member))

typedef unsigned char		uint8;
typedef unsigned short		uint16;
typedef unsigned		uint32;

#define fatal(s) panic( #s )

#ifdef NDEBUG
#define assert(x) ((void) 0)
#define demand(x,y) ((void) 0)
#else
#define assert(x)                                                       \
do {									\
  if (! (x))								\
    panic ("%s:%d: assertion failed: %s", __FILE__, __LINE__, #x);	\
} while (0)
#define demand(x,y) \
do {									 \
  if (! (x)) {								 \
    panic ("%s:%d: demand %s failed: %s", __FILE__, __LINE__, #x, #y); \
  }									\
} while (0)
#endif

/* Compile-time assertion used in function. */
#define AssertNow(x) switch(1) { case (x): case 0: }

#endif /* !_DEFS_H_ */
