/******************************************************************************
 * af_user.h
 * 
 * Shared definitions between the af_user kernel socket family and user
 * apace.
 * 
 * Copyright (c) 1999-2000, K A Fraser
 */

#ifndef _AF_USER_H_
#define _AF_USER_H_

/******************************************************************************
 * Ensure the AF_USER socket family id is defined here, for convenience.
 */
#ifndef AF_USER
#define AF_USER 30
#endif

/******************************************************************************
 * Callback definitions.
 */
#define AF_USER_CALLBACK_SIGNAL 50
#define RX_EVENT                0x10000

/******************************************************************************
 * Size of physical shared area to allocate
 */
#define AF_USER_PHYSAREA_SIZE (450 * PAGE_SIZE)

/******************************************************************************
 * The index of the ethernet device we wish to use.
 */
#define ETHERNET_DEVICE_NUM                  1

/******************************************************************************
 * ioctl() operations.
 */
#define IOCTL_GET_ROUTE_INFO                  1
#define IOCTL_GET_LOCAL_MAC_ADDRESS           2
#define IOCTL_GET_SHARED_DATA_AREA            3
#define IOCTL_GET_MAILBOX                     4
#define IOCTL_GET_CONTROL_STRUCT              5
#define IOCTL_GET_CONNECTION_ID               6
#define IOCTL_REGISTER_SOCKET_FOR_CALLBACKS   9
#define IOCTL_RX_REQ_CALLBACK                10
#define IOCTL_TX_REQ_CALLBACK                11
#define IOCTL_INSTALL_FILTER                 12
#define IOCTL_MAP_BUFFERS                    13

/******************************************************************************
 * Structure definition for the GET_ROUTE_INFO ioctl.
 */
struct eth_ipv4_route_req_rsp
{
    /* REQUEST -- fields to be provided before caling ioctl(GET_ROUTE_INFO) */
    u32 saddr, daddr;   /* IP addresses of connection end points          */
    int ifindex;        /* Interface index of input/output network device */

    /* RESPONSE -- filled in as result of ioctl(GET_ROUTE_INFO) */
    u32 gateway;               /* IP address of gateway to destination    */
    unsigned char mac_addr[6]; /* Ethernet address of gateway             */
    int pmtu;                  /* Path MTU for saddr->daddr route         */
};

#endif /* _AF_USER_H */
