/*
 *  acenic_proto.h
 *  --------------
 *
 *  Prototypes for the acenic gigabit ethernet card driver, 
 *  Original copyright (C) Jes Sorensen.
 *
 *  Split out of acenic.h by Tim Deegan so that other code could
 *  include acenic.h
 */

#ifndef _ACENIC_PROTO_H_
#define _ACENIC_PROTO_H_

static int ace_init(struct net_device *dev, int board_idx);

static void harvest_tx2(struct net_device *dev);
static int ace_load_rx2_ring(struct net_device *dev);

static void ace_interrupt(int irq, void *dev_id, struct pt_regs *regs);
static int ace_load_firmware(struct net_device *dev);
static int ace_open(struct net_device *dev);
static int ace_start_xmit(struct sk_buff *skb, struct net_device *dev);
static int ace_close(struct net_device *dev);
static void ace_set_multicast_list(struct net_device *dev);
static int ace_change_mtu(struct net_device *dev, int new_mtu);
static int ace_set_mac_addr(struct net_device *dev, void *p);
static struct net_device_stats *ace_get_stats(struct net_device *dev);
static u8 read_eeprom_byte(struct ace_regs *regs, unsigned long offset);
static void add_connection_completion(struct net_device *dev, int id);
static void del_connection_completion(struct net_device *dev, int id);

#ifdef ACENIC_DEBUGGING_IOCTLS

#define MIN(_x, _y) (((_x) <= (_y)) ? (_x) : (_y))
#include "acenic_ioctls.h"
static int ace_do_ioctl(struct net_device *dev, struct ifreq *ifr, int cmd);

#endif /* ACENIC_DEBUGGING_IOCTLS */

#endif /* _ACENIC_PROTO_H_ */
/*
 * EOF
 */
