/******************************************************************************
 * acenic_endpoint.h
 * 
 * All modifications copyright (c) 1999-2000, University of Cambridge,
 * by Ian Pratt and Keir Fraser (iap10@cl.cam.ac.uk, kaf24@cl.cam.ac.uk)
 * 
 * Please note the original copyright and licence in `acenic.c'. 
 */

#ifndef _ACENIC_ENDPOINT_H_
#define _ACENIC_ENDPOINT_H_

#include <asm/types.h>

/*
 *  *Minimum* size of the user's DMA-able area.
 */

#define USD_ENDPOINT_MIN_SIZE 65536




/*
 *  This gets used in user space too - We'd like this not to be dependent on 
 *  whether the user library is built on a 586 or a 686.
 *  Therefore (hanging head in shame...)
 */

#define AT_LEAST_ONE_CACHE_LINE 32


/*
 *  Structure of the user-level's end of the data path
 */

#define TX2_RING_ENTRIES 256   /* Power of 2, indended variable */
#define TX2_DESC_END 0x00010000

typedef struct
{
    u32 buf;
    u32 flagsize;
} tx2_desc_t;


#define RX2_RING_ENTRIES 256   /* Power of 2, indended variable */

#define RX2_DESCR_FLAGS_EOP   0x00010000
#define RX2_DESCR_FLAGS_CONT  0x00020000
#define RX2_DESCR_FLAGS_HDR   0x00040000

#define RX2_DESCR_FLAGS_TRUNC 0x00100000
#define RX2_DESCR_FLAGS_OK    0x00400000
#define RX2_DESCR_FLAGS_DONE  0x00800000

typedef struct
{
    u32 buf;
    u32 flagsize;
} rx2_desc_t;



typedef struct {
	u32 addrhi;
	u32 addrlo;
} aceaddr;

#define TX_RING_ENTRIES	128
#define TX_RING_SIZE	(TX_RING_ENTRIES * sizeof(struct tx_desc))
/* Only used if we want to put the TX ring on the NIC and access it through
 * the shared memory window: */
#define TX_RING_BASE	0x3800

#define RX_STD_RING_ENTRIES	128
#define RX_STD_RING_SIZE	(RX_STD_RING_ENTRIES * sizeof(struct rx_desc))

#define RX_RETURN_RING_ENTRIES	128
#define RX_RETURN_RING_SIZE	(RX_MAX_RETURN_RING_ENTRIES * \
				 sizeof(struct rx_desc))

#define RX_RING_THRESH		128
#define RX_RING_JUMBO_THRESH	48


struct tx_desc{
        aceaddr	addr;
	u32	flagsize; 
	u32	nic_addr;
};

struct rx_desc{
	aceaddr	addr;
#ifdef __LITTLE_ENDIAN
	u16	size;
	u16	idx;
#else
	u16	idx;
	u16	size;
#endif
#ifdef __LITTLE_ENDIAN
	u16	flags;
	u16	type;
#else
	u16	type;
	u16	flags;
#endif
#ifdef __LITTLE_ENDIAN
	u16	tcp_udp_csum;
	u16	ip_csum;
#else
	u16	ip_csum;
	u16	tcp_udp_csum;
#endif
#ifdef __LITTLE_ENDIAN
	u16	reserved;
	u16	err_flags;
#else
	u16	err_flags;
	u16	reserved;
#endif
	u32	nic_addr;
	u32	pad[1];
};



typedef struct usd_endpoint usd_endpoint_t;
struct usd_endpoint {
    tx2_desc_t  tx2_ring[TX2_RING_ENTRIES] 
             __attribute__ ((aligned (AT_LEAST_ONE_CACHE_LINE)));
    rx2_desc_t  rx2_ring[RX2_RING_ENTRIES] 
             __attribute__ ((aligned (AT_LEAST_ONE_CACHE_LINE)));
};

#undef AT_LEAST_ONE_CACHE_LINE


#endif /* _ACENIC_ENDPOINT_H_ */

/*
 *  EOF (acenic_usd.h)
 */
