/*
 *  acenic_ioctls.h
 *  ---------------
 *
 *  tjd 25.03.99
 *
 *  Definitions for using the SIOCDEVPRIVATE ioctls to debug the firmware in
 *  Alteon's Tigon II chipset Gigabit Ethernet cards.
 *
 */

#include <asm/types.h>

/* 
 * If we provide methods to read & write data to and from the card, 
 * we can do anything we want on top of that.
 */

#define ACENIC_IOCTL_READ_SMEM  SIOCDEVPRIVATE
#define ACENIC_IOCTL_WRITE_SMEM (SIOCDEVPRIVATE + 1)

/* The structures we pass in as the arguments */
struct acenic_ioc_req {
    unsigned long int cardoffset; 
    /* Where on the card - must be a multiple of 4 and < 0x3FFc */
    __u32  data;  
    /* What to put there (read ioctl puts return val here) */
};

/*
 *  EOF
 */
