/*
 * COPYRIGHT NOTICE
 * Copyright (c) Alteon Networks, Inc. 1996
 * All rights reserved
 */
/*
 * HISTORY
 * $Log: usd2_util.h,v $
 * Revision 1.4  2000/03/17 09:22:09  iap10
 * *** empty log message ***
 *
 * Revision 1.3  2000/01/26 14:16:21  iap10
 * *** empty log message ***
 *
 * Revision 1.2  2000/01/21 17:30:45  iap10
 * *** empty log message ***
 *
 * Revision 1.1  1999/12/01 10:55:01  iap10
 * Initial revision
 *
 */
/*
 * FILE usd2_util.h
 *
 * COPYRIGHT (c) Essential Communication Corp. 1995
 * $Source: /Nfs/stives/grp56/gige/src-current/acenic-fw-12.3.10/nic/fw2/common/RCS/usd2_util.h,v $
 * $Revision: 1.4 $
 * $Date: 2000/03/17 09:22:09 $ $State: Exp $
 */

#ifndef _USD2_UTIL_H_
#define _USD2_UTIL_H_

/*
 * prototypes for all the routines
 */

static U32 pri(const U32 a, const U32 b);
static void set_bit( U32 * arr, const int idx );
static void clear_bit( U32 * arr, const int idx );
static int find_first_set( U32 * arr, const int max );
static int find_first_set_with_mask( U32 * arr, U32 * mask, const int max );
static int find_first_set_and_clear( U32 * arr, const int max );
static int is_bit_set( U32 * arr, const int idx );
static int is_bit_set_and_clear( U32 * arr, const int idx );
static int is_bit_set_and_set( U32 * arr, const int idx );
static U32 pop_count(U32 w);

/*
 * The routines
 */

/* Returns the most sig set +1 */
static inline U32 pri(const U32 a, const U32 b)
{
  U32 r;
      __asm__ volatile
    ("
        pri     %0,%1,%2  
        " : "=r" (r) : "r" (a), "r" (b) );

  return r;
}

#define MIN_first_likely(x,a,b) {x=(b); if((a)<(b)) x=(a); }

static inline void
set_bit( U32 * arr, const int idx )
{
  arr[idx/32] |= (1<<(idx%32));
}

static inline int
is_bit_set_and_clear( U32 * arr, const int idx )
{
  U32 x = arr[idx/32] & (1<<(idx%32));
  arr[idx/32] &= ~(1<<(idx%32));
  return x;
}

static inline int
is_bit_set_and_set( U32 * arr, const int idx )
{
  U32 x = arr[idx/32] & (1<<(idx%32));
  arr[idx/32] |= (1<<(idx%32));
  return x;
}

static inline int
is_bit_set( U32 * arr, const int idx )
{
  U32 x = arr[idx/32] & (1<<(idx%32));
  return x;
}

static inline void
clear_bit( U32 * arr, const int idx )
{
  arr[idx/32] &= (~(1<<(idx%32)));
}

// return 1+ the index of the first set bit. (msb has priority)
static inline int
find_first_set( U32 * arr, const int max )
{
  int i;

  for( i=0; i <= (max/32); i++ )
    {
      U32 x, y;
      
      x = arr[i];
      y = pri( x, ~0 );
      
      if( y > 0 )
	return (i*32) + y ;  // pri returns 1+foo
      
    }
  return 0;
}

// return 1+ the index of the first set bit. (msb has priority)
static inline int
find_first_set_with_mask( U32 * arr, U32 * mask, const int max )
{
  int i;

  for( i=0; i <= (max/32); i++ )
    {
      U32 x, y;
      
      x = arr[i];
      y = pri( x, mask[i] );
      
      if( y > 0 )
	return (i*32) + y ;  // pri returns 1+foo
      
    }
  return 0;
}
// return 1+ the index of the first set bit. (msb has priority)
static inline int
find_first_set_and_clear( U32 * arr, const int max )
{
  int i;

  for( i=0; i <= (max/32); i++ )
    {
      U32 x, y;
      
      x = arr[i];
      y = pri( x, ~0 );
      
      if( y > 0 )
	{
	  arr[i] = x & ( ~(1<<(y-1)) );
	  return (i*32) + y ;  // pri returns 1+foo
	}
      
    }
  return 0;
}

/* count 1s ("population") in (binary) w */
static inline U32
pop_count(U32 w)
{
    U32 res = (w & 0x55555555) + ((w >> 1) & 0x55555555);
    res = (res & 0x33333333) + ((res >> 2) & 0x33333333);
    res = (res & 0x0F0F0F0F) + ((res >> 4) & 0x0F0F0F0F);
    res = (res & 0x00FF00FF) + ((res >> 8) & 0x00FF00FF);
    return (res & 0x0000FFFF) + ((res >> 16) & 0x0000FFFF);
}


static inline tgDmaDescr_t * 
get_next_wr_dma_high_descr( tgDmaDescr_t * ddp )
{
  return ((ddp == &tdp->wr_dma_hi_ring[TG_DMA_ASSIST_DESCRS - 1]) ?
	  tdp->wr_dma_hi_ring : (ddp + 1));
}

static inline tgDmaDescr_t * 
get_next_rd_dma_high_descr( tgDmaDescr_t * ddp )
{
  // This should be improved to remove the branch!!!

#if 0
  U32 n = (U32) (ddp + 1);

  n |=  (1<<10);
  n &= ~(1<<11);

  return (tgDmaDescr_t *) n;
#else
  return ((ddp == &tdp->rd_dma_hi_ring[TG_DMA_ASSIST_DESCRS - 1])?
	  tdp->rd_dma_hi_ring:
	  (ddp + 1));
#endif

}

static inline tgDmaDescr_t * 
get_next_rd_dma_low_descr( tgDmaDescr_t * ddp )
{
  // This should be improved to remove the branch!!!

#if 0
  U32 n = (U32) (ddp + 1);

  n |=  (1<<10);
  n &= ~(1<<11);

  return (tgDmaDescr_t *) n;
#else
  return ((ddp == &tdp->rd_dma_lo_ring[TG_DMA_ASSIST_DESCRS - 1])?
	  tdp->rd_dma_lo_ring:
	  (ddp + 1));
#endif

}


static inline void
fill_in_dma_record( tgDmaDescr_t *dd_prod,
		    tg_hostaddr_t host_addr, U32 nic_addr, U32 len, 
		    U16 type, U16 id, U32 index, U32 state) 
{
  dd_prod->host_addr = host_addr; 
  dd_prod->nic_addr  = nic_addr; 
  dd_prod->len       = len; 
  dd_prod->type      = type;
  dd_prod->index     = index;
  dd_prod->usd_id    = id;
  dd_prod->state     = state;
  dd_prod->cksum     = 0; //(U32)dd_cons; /* only to debug dma overrun */
  
/*
  NIC_TRACE_IF(TRACE_TYPE_DMA, "2QrDmIdx", 0x11700, 
	       type, TIGON_TYPE_TX,
	       (dd_prod - tdp->rd_dma_lo_ring),
	       trp->host_dma_assist.read_chan_lo_pri_producer,
	       trp->host_dma_assist.read_chan_lo_pri_consumer,
	       trp->host_dma_assist.read_chan_lo_pri_ref);
*/

  NIC_TRACE((TRACE_TYPE_TX2_TRACE|TRACE_TYPE_RX2_TRACE), "2FillD0", 0x11800,
	       *(U32 *)dd_prod,	/* host addr */
	       *((U32 *)dd_prod + 1),	/* host addr */
	       *((U32 *)dd_prod + 2),	/* nic addr */
	       *((U32 *)dd_prod + 3));	/* reserved & len */
  
  NIC_TRACEV((TRACE_TYPE_TX2_TRACE|TRACE_TYPE_RX2_TRACE), "2FillD1", 0x11900,
	       *((U32 *)dd_prod + 4),	/* state */
	       *((U32 *)dd_prod + 5),	/* reserved & cksum addr */
	       *((U32 *)dd_prod + 6),	/* type */
	       *((U32 *)dd_prod + 7));	/* index */
}

/*
 * The following 4 macros do the right thing even if event values have
 * wrapped, on the ASSUMPTION that the values being compared never
 * differ by 2^(word-size - 1) or more.  NB. "Event_Val"s are incremented
 * as UNsigned quantities and their differences are compared with 0 here as
 * SIGNED quantities.
 */

#define U32S_LT(ev1,ev2)		     (((S32) ((ev1) - (ev2))) < 0)
#define U32S_LE(ev1,ev2)		     (((S32) ((ev1) - (ev2))) <= 0)
#define U32S_GT(ev1,ev2)		     (((S32) ((ev1) - (ev2))) > 0)
#define U32S_GE(ev1,ev2)		     (((S32) ((ev1) - (ev2))) >= 0)

#ifdef TX_SHAPER_SCHED

//int heap_entries;
//U32 heap_keys[USD2_NUM_CHANS+2]; // +1 for stats timer, 1 for sentinel
//U8  heap_data[USD2_NUM_CHANS+2]; // +1 for stats timer, 1 for sentinel

static int spq_insert( U32 v_key, int v_data ); // return 'k'
static int spq_head_data( void );
static int spq_entries( void );
static U32 spq_head_key( void );
static int spq_head_test( U32 nowplus );
static void spq_remove_head( void );

static inline int
spq_insert( U32 v_key, int v_data )
{
  int k = ++nicbfp->heap_entries;
  
  while( (k>1) && U32S_GT(nicbfp->heap_keys[ k/2 ], v_key) )
    {
       nicbfp->heap_keys[ k ] = nicbfp->heap_keys[ k/2 ];
       nicbfp->heap_data[ k ] = nicbfp->heap_data[ k/2 ];

       k = k/2;
    }

  nicbfp->heap_keys[ k ] = v_key;
  nicbfp->heap_data[ k ] = v_data;

  return k;
}

static inline int
spq_head_data() { return nicbfp->heap_data[1]; }

static inline int
spq_entries() { return nicbfp->heap_entries; }

static inline U32
spq_head_key() { return nicbfp->heap_keys[1]; }

static inline int
spq_head_test( U32 nowplus )
{
  return U32S_LT( nicbfp->heap_keys[1], nowplus );
}

static inline void
spq_remove_head()
{
  U32 v_key;
  int v_data;
  int j,k;

  v_key  = nicbfp->heap_keys[ nicbfp->heap_entries ];
  v_data = nicbfp->heap_data[ nicbfp->heap_entries ];

  nicbfp->heap_entries--;

  k = 1;

  while( k <= (nicbfp->heap_entries / 2) )
    {
      j = 2*k;

      if( (j < nicbfp->heap_entries) 
	   && U32S_GT(nicbfp->heap_keys[ j ], nicbfp->heap_keys[ j+1 ]) )
	{
	  j++;
	}
      
      if( U32S_LE( v_key, nicbfp->heap_keys[ j ] ) )
	break;

      nicbfp->heap_keys[ k ] = nicbfp->heap_keys[ j ];
      nicbfp->heap_data[ k ] = nicbfp->heap_data[ j ];

      k = j;
    }

  nicbfp->heap_keys[ k ] = v_key;
  nicbfp->heap_data[ k ] = v_data;
}

#endif


#endif /* _USD2_UTIL_H_ */
