/*
 * COPYRIGHT NOTICE
 * Copyright (c) Alteon Networks, Inc. 1996
 * All rights reserved
 */
/*
 * HISTORY
 * $Log: trace.h,v $
 * Revision 1.8  2000/03/30 15:34:33  kaf24
 * *** empty log message ***
 *
 * Revision 1.7  1999/12/01 10:57:34  iap10
 * *** empty log message ***
 *
 * Revision 1.6  1999/11/08 15:05:07  kaf24
 * *** empty log message ***
 *
 * Revision 1.5  1999/10/25 13:37:40  iap10
 * *** empty log message ***
 *
 * Revision 1.4  1999/06/22 12:43:01  tjd21
 * Before removing extra recv rings
 *
 * Revision 1.1  1999/06/07 10:52:05  tjd21
 * Start of archive
 *
 * Revision 1.1.2.3  1998/12/08  02:36:54  shuang
 * 	Clean up debug tracing. Use sw dma. Fix dma avoidance.
 * 	[1998/12/08  02:28:38  shuang]
 *
 * Revision 1.1.2.2  1998/04/11  05:15:26  shuang
 * 	move fast timer to cpu B, add receive coalesed ticks
 * 	[1998/04/11  04:59:05  shuang]
 * 
 * Revision 1.1.2.1  1998/01/14  23:26:06  ted
 * 	rearrange directories
 * 	[1998/01/14  23:18:04  ted]
 * 
 * Revision 1.1.2.1  1997/11/19  19:23:39  ted
 * 	Support Tigon and Tigon2 in the same driver
 * 	[1997/11/19  19:20:18  ted]
 * 
 * Revision 1.6.9.1  1997/07/25  22:59:19  ted
 * 	Merge fixes from ge_0_22 and add link negotiation support
 * 	[1997/07/25  22:32:32  ted]
 * 
 * Revision 1.6.5.1  1997/07/16  00:20:25  ted
 * 	UTRACE() is now always on.
 * 	[1997/07/15  00:39:59  ted]
 * 
 * Revision 1.6.3.3  1996/11/15  04:24:25  hayes
 * 	convert to new header file structure.
 * 	[1996/11/15  04:12:22  hayes]
 * 
 * Revision 1.6.3.2  1996/11/05  21:54:36  hayes
 * 	Final pre-ODE merge.
 * 	[1996/11/05  21:53:52  hayes]
 * 
 * Revision 1.6.3.1  1996/11/01  18:25:15  ted
 * 	change rr_ to tg_, fix compiler warnings, add copyright notices
 * 	[1996/10/29  22:06:55  ted]
 * 
 * $EndLog$
 */
/*
 * FILE trace.h
 *
 * COPYRIGHT (c) Essential Communication Corp. 1995
 * $Source: /Nfs/stives/grp56/gige/src-current/acenic-fw-12.3.10/nic/fw2/common/RCS/trace.h,v $
 * $Revision: 1.8 $ $Locker: iap10 $
 * $Date: 2000/03/30 15:34:33 $ $Author: kaf24 $ $State: Exp $
 */

#ifndef _TRACE_H_
#define _TRACE_H_

/* various things that may be renamed from system to system */
#define ERROR1
#define ERROR2
#define ERROR3
#define ERROR5

/* ------------------- Tracing --------------------- */
/*
 * Tracing is instrumented at various levels:
 * 	Key events
 * 	Verbose
 * Tracing is compiled into the driver based on these flags
 * 	TRACE_ALL	- verbose
 * 	TRACE	- key events
 * Tracing is run-time controlable (assuming it has been compiled in) 
 * as follows:
 * 	Tracing == 2 - verbose
 * 	Tracing == 1 - key events
 * The variables are set in data.c
 *
 * TRACE, TRACE_ALL, TRACE_ELM_SIZE and TRACE_SIZE are defined in nic.h
 */
#define MAX_STRACE_LINES 4	/* Number of lines in mbuf report */
#define MAX_TRACE_MBUFS  4	/* maximum number of mbufs in traceMC */


#if TRACE && TRACE_ALL

#define NIC_TRACEV(type, a, b, c, d, e, f) { \
    U32 tracing = tsp->gen_com.tuneParms.tracing; \
    if ((tracing & TRACE_LEVEL_2) && (tracing & type)) { \
        trace((U32 *)a, (U32)(b), (U32)(c), (U32)(d), (U32)(e), (U32)(f)); \
    } }

#define NIC_TRACEV_IF(type, a, b, bd_var, bd_type, c, d, e, f) { \
    U32 tracing = tsp->gen_com.tuneParms.tracing; \
    if (((tracing & TRACE_LEVEL_2) && (tracing & type)) || \
	((tracing & (TRACE_TYPE_SEND|TRACE_TYPE_RECV|TRACE_TYPE_RECV_BD)))) { \
        trace((U32 *)a, (U32)(b), (U32)(c), (U32)(d), (U32)(e), (U32)(f)); \
    } }

#else	/* TRACE */

#define NIC_TRACEV(type, a, b, c, d, e, f)
#define NIC_TRACEV_IF(bd_var, bd_type, type, a, b, c, d, e, f)

#endif	/* TRACE && TRACE_ALL */


#if TRACE

#define NIC_TRACE(type, a, b, c, d, e, f) \
    if ((tsp->gen_com.tuneParms.tracing & (type | TRACE_LEVEL_1))) \
        trace((U32 *)a, (U32)(b), (U32)(c), (U32)(d), (U32)(e), (U32)(f)); \

#define NIC_TRACE_IF(type, a, b, bd_var, bd_type, c, d, e, f) { \
    U32 tracing = tsp->gen_com.tuneParms.tracing; \
    if ((tracing & (type | TRACE_LEVEL_1)) || \
        (tracing & (TRACE_TYPE_SEND|TRACE_TYPE_RECV|TRACE_TYPE_RECV_BD))) \
        trace((U32 *)a, (U32)(b), (U32)(c), (U32)(d), (U32)(e), (U32)(f)); \
}

#else	/* TRACE */

#define NIC_TRACE(type, a, b, c, d, e, f)
#define NIC_TRACE_IF(bd_var, bd_type, type, a, b, c, d, e, f)

#endif	/* TRACE */


#if TRACE
/* urgent trace macros - always on for errors */
#define NIC_UTRACE(a, b, c, d, e, f) \
    trace((U32 *)a, (U32)(b), (U32)(c), (U32)(d), (U32)(e), (U32)(f))
#else
#define NIC_UTRACE(a, b, c, d, e, f)
#endif


#define NIC_UUTRACE(a, b, c, d, e, f) \
    trace((U32 *)a, (U32)(b), (U32)(c), (U32)(d), (U32)(e), (U32)(f))

#endif	/* _TRACE_H_ */
