/*
 * COPYRIGHT NOTICE
 * Copyright (c) Alteon Networks, Inc. 1996
 * All rights reserved
 */
/*
 * HISTORY
 * $Log: trace.c,v $
 * Revision 1.6  1999/12/01 10:55:01  iap10
 * *** empty log message ***
 *
 * Revision 1.5  1999/09/24 11:09:33  iap10
 * before new send path
 *
 * Revision 1.4  1999/06/22 12:43:01  tjd21
 * Before removing extra recv rings
 *
 * Revision 1.1  1999/06/07 10:52:05  tjd21
 * Start of archive
 *
 * Revision 1.1.2.5  1998/09/30  18:50:28  shuang
 * 	change for new 12.3 API
 * 	[1998/09/30  18:41:41  shuang]
 *
 * Revision 1.1.2.4  1998/04/24  00:00:45  hayes
 * 	added const to rcsid definitions to eliminate compiler warnings
 * 	[1998/04/23  23:59:03  hayes]
 * 
 * Revision 1.1.2.3  1998/04/11  05:15:25  shuang
 * 	move fast timer to cpu B, add receive coalesed ticks
 * 	[1998/04/11  04:59:02  shuang]
 * 
 * Revision 1.1.2.2  1998/03/26  01:34:35  shuang
 * 	cleanup
 * 	[1998/03/26  01:25:48  shuang]
 * 
 * Revision 1.1.2.1  1998/01/14  23:26:05  ted
 * 	rearrange directories
 * 	[1998/01/14  23:18:01  ted]
 * 
 * Revision 1.1.2.1  1997/11/19  19:23:37  ted
 * 	Support Tigon and Tigon2 in the same driver
 * 	[1997/11/19  19:20:15  ted]
 * 
 * Revision 1.7.6.1  1997/11/14  19:16:50  hayes
 * 	first checkin after mongo merge...
 * 	[1997/11/14  19:11:56  hayes]
 * 
 * Revision 1.7.2.4  1996/11/20  20:04:32  ted
 * 	Redo include file structuring.
 * 	[1996/11/20  19:52:42  ted]
 * 
 * Revision 1.7.2.3  1996/11/15  04:24:24  hayes
 * 	convert to new header file structure.
 * 	[1996/11/15  04:12:10  hayes]
 * 
 * Revision 1.7.2.2  1996/11/05  21:54:36  hayes
 * 	Final pre-ODE merge
 * 	[1996/11/05  21:52:34  hayes]
 * 
 * Revision 1.7.2.1  1996/11/01  18:25:14  ted
 * 	change rr_ to tg_, fix compiler warnings, add copyright notices
 * 	[1996/10/29  22:06:52  ted]
 * 
 * $EndLog$
 */
/*
 * FILE trace.c
 *
 * COPYRIGHT (c) Essential Communication Corp. 1995
 * $Source: /Nfs/stives/grp56/gige/src-current/acenic-fw-12.3.10/nic/fw2/common/RCS/trace.c,v $
 * $Revision: 1.6 $ $Locker:  $
 * $Date: 1999/12/01 10:55:01 $ $Author: iap10 $ $State: Exp $
 */

#ifndef __lint
static const char rcsid[] = "$Header: /Nfs/stives/grp56/gige/src-current/acenic-fw-12.3.10/nic/fw2/common/RCS/trace.c,v 1.6 1999/12/01 10:55:01 iap10 Exp $";
#endif /* __lint */


#include "alt_def.h"
#include "nic_conf.h"
#include "nic_api.h"
#include "tg.h"

#include "nic.h"
#include "trace.h"
#include "proto.h"


/* ------------------------------------------------------------ *
 *
 *			Tracing Functions
 *
 * ------------------------------------------------------------ */

/* NOTES on tracing:
 * A trace entry is 8 longs. 
 * Longs and pointers are 4 bytes on __hpux and __sgi and 8 bytes on __alpha.
 * On both 32 and 64 bit machines the header consists of:
 * literal id (8bytes) - 2 longs
 * id 	   (4bytes) - 1 long
 * tod	   (4bytes) - 1 long
 * This wastes space but keeps tracing easy when viewed from dumps.
 * Following the header are 4 longs of trace data.
 * 
 * build the trace buffer backward so we can read it forwards
 */

static U32 stars = 0x42424242;          /* "****" */
static U32 *curtb;
static U32 *endtb;
static U32 tbuf[ALT_NTRACE_SIZE * ALT_TRACE_ELEM_SIZE];

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
void
init_trace(void)
{
    bzero((U32 *)&tbuf,
          sizeof(U32)*ALT_TRACE_ELEM_SIZE*ALT_NTRACE_SIZE);

    curtb = &tbuf[(ALT_NTRACE_SIZE-1)*ALT_TRACE_ELEM_SIZE];
    endtb = curtb;                  /* save start for wraparound */

    tsp->gen_com.nic_trace_ptr = (U32)curtb;
    tsp->gen_com.nic_trace_start = (U32)&tbuf;
    tsp->gen_com.nic_trace_len =
        ALT_NTRACE_SIZE * ALT_TRACE_ELEM_SIZE * sizeof(U32);
}

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
void
trace(U32 *string, U32 id, U32 a, U32 b, U32 c, U32 d)
{
    register U32 *ntbp, *tbp;

    tbp = curtb;

    ntbp = tbp - ALT_TRACE_ELEM_SIZE;
    if (ntbp < (U32 *)&tbuf)   /* wrap at end */
	ntbp = endtb;
    curtb = ntbp;

    *tbp     = *string;
    *(tbp+1) = *(string+1);
    *(tbp+2) = id | (nicfp->cpu_id<<31);
    *(tbp+3) = trp->gen_control.timer;
    
    *(tbp+4) = a;
    *(tbp+5) = b;
    *(tbp+6) = c;
    *(tbp+7) = d;
    
    tbp = ntbp;

    *tbp = stars;
    *(tbp+1) = stars;

    tsp->gen_com.nic_trace_ptr = (U32)tbp;
    return;
}

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
void
ltrace(U32 *string, U32 id, U32 a, U32 b, U32 c, U32 d, U32 *ptr)
{
    register U32 *tbp = curtb;

    *tbp     = stars;
    *(tbp+1) = stars;
    
    if (ptr)			/* simple check to avoid silly panics */
	bcopy(ptr, tbp+2, 6*sizeof(U32));
    else
	bzero(tbp+2, 6*sizeof(U32));  /* zero it out */
    
    tbp -= ALT_TRACE_ELEM_SIZE;
    if (tbp < (U32 *)&tbuf)	/* wrap at end */
	tbp = endtb;
    
    *tbp     = *string;
    *(tbp+1) = *(string+1);
    *(tbp+2) = id | (nicfp->cpu_id<<31);
    *(tbp+3) = trp->gen_control.timer;
    
    *(tbp+4) = a;
    *(tbp+5) = b;
    *(tbp+6) = c;
    *(tbp+7) = d;
    
    tbp -= ALT_TRACE_ELEM_SIZE;
    if (tbp < (U32 *)&tbuf)	/* wrap at end */
	tbp = endtb;
    
    *tbp = stars;
    *(tbp+1) = stars;
    curtb = tbp;
    tsp->gen_com.nic_trace_ptr = (U32)tbp;
    return;
}

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
