/*
 * COPYRIGHT NOTICE
 * Copyright (c) Alteon Networks, Inc. 1996
 * All rights reserved
 */
/*
 * HISTORY
 * $Log: timer.h,v $
 * Revision 1.4  1999/06/22 12:43:01  tjd21
 * Before removing extra recv rings
 *
 * Revision 1.1  1999/06/07 10:52:05  tjd21
 * Start of archive
 *
 * Revision 1.1.2.5  1998/09/30  18:50:27  shuang
 * 	change for new 12.3 API
 * 	[1998/09/30  18:41:40  shuang]
 *
 * Revision 1.1.2.4  1998/04/11  05:15:24  shuang
 * 	move fast timer to cpu B, add receive coalesed ticks
 * 	[1998/04/11  04:58:58  shuang]
 * 
 * Revision 1.1.2.3  1998/04/01  07:32:37  shuang
 * 	add features: pass (CRC, bad, partial) frame, timer tick to 5us...
 * 	[1998/04/01  07:27:39  shuang]
 * 
 * Revision 1.1.2.2  1998/03/26  01:34:35  shuang
 * 	cleanup
 * 	[1998/03/26  01:25:45  shuang]
 * 
 * Revision 1.1.2.1  1998/01/14  23:26:04  ted
 * 	     rearrange directories
 * 	     [1998/01/14  23:18:00  ted]
 * 
 * Revision 1.1.2.1  1997/11/19  19:23:34  ted
 * 	     Support Tigon and Tigon2 in the same driver
 * 	     [1997/11/19  19:20:12  ted]
 * 
 * Revision 1.6.4.1  1997/10/30  02:21:23  hayes
 * 	     get link negotiation working for Tigon2
 * 	     [1997/10/30  02:18:39  hayes]
 * 
 * Revision 1.6.2.3  1996/11/15  04:24:22  hayes
 * 	     convert to new header file structure.
 * 	     [1996/11/15  04:12:21  hayes]
 * 
 * Revision 1.6.2.2  1996/11/05  21:54:35  hayes
 * 	     Final pre-ODE merge
 * 	     [1996/11/05  21:52:31  hayes]
 * 
 * Revision 1.6.2.1  1996/11/01  18:25:13  ted
 * 	     change rr_ to tg_, fix compiler warnings, add copyright notices
 * 	     [1996/10/29  22:06:49  ted]
 * 
 * $EndLog$
 */
/*
 * FILE timer.h
 *
 * $Source: /Nfs/stives/grp56/gige/src-current/acenic-fw-12.3.10/nic/fw2/common/RCS/timer.h,v $
 * $Revision: 1.4 $ $Locker:  $
 * $Date: 1999/06/22 12:43:01 $ $Author: tjd21 $ $State: Exp $
 */

#ifndef _TIMER_H_
#define _TIMER_H_

/*
 * timer constants and definitions...
 * TG_TICK_TIME defined in rr_host.h
 */
#define	TG_TICK_1US	(1)			/* hw resolution */
#define TG_TICK_FAST    (5 * TG_TICK_1US)       /* per timer event */
#define TG_TICK_SLOW    (1000 * TG_TICK_1US)    /* per timer event */
#define TG_TICK_US(us)  (us * TG_TICK_1US)

/*
 *  Following computation is done the way it is to handle the timer
 *  wrapping around: Simply saying less than __stop_time will NOT work
 *  if the timer is (say) 0xffffffe0 and __stop_time is 0x00000010...
 */
#define WAIT_US(us) { \
	    U32 __stop_time = trp->gen_control.timer + (us); \
	    while(__stop_time - trp->gen_control.timer <= (us)) \
		; \
	}

#endif /* _TIMER_H_ */

