/*
 * COPYRIGHT NOTICE
 * Copyright (c) Alteon Networks, Inc. 1996
 * All rights reserved
 */
/*
 * HISTORY
 * $Log: mem.c,v $
 * Revision 1.4  1999/06/22 12:43:01  tjd21
 * Before removing extra recv rings
 *
 * Revision 1.1  1999/06/07 10:52:05  tjd21
 * Start of archive
 *
 * Revision 1.1.2.5  1998/09/30  18:50:08  shuang
 * 	change for new 12.3 API
 * 	[1998/09/30  18:40:16  shuang]
 *
 * Revision 1.1.2.4  1998/04/24  00:00:40  hayes
 * 	added const to rcsid definitions to eliminate compiler warnings
 * 	[1998/04/23  23:58:54  hayes]
 * 
 * Revision 1.1.2.3  1998/04/11  05:15:12  shuang
 * 	move fast timer to cpu B, add receive coalesed ticks
 * 	[1998/04/11  04:58:26  shuang]
 * 
 * Revision 1.1.2.2  1998/03/26  01:34:28  shuang
 * 	cleanup
 * 	[1998/03/26  01:25:20  shuang]
 * 
 * Revision 1.1.2.1  1998/01/14  23:25:54  ted
 * 	rearrange directories
 * 	[1998/01/14  23:17:50  ted]
 * 
 * Revision 1.1.2.1  1997/11/19  19:23:14  ted
 * 	Support Tigon and Tigon2 in the same driver
 * 	[1997/11/19  19:19:34  ted]
 * 
 * Revision 1.4.2.4  1996/11/20  20:04:23  ted
 * 	Redo include file structuring.
 * 	[1996/11/20  19:51:48  ted]
 * 
 * Revision 1.4.2.3  1996/11/15  04:24:11  hayes
 * 	convert to new header file structure.
 * 	[1996/11/15  04:12:04  hayes]
 * 
 * Revision 1.4.2.2  1996/11/05  21:54:24  hayes
 * 	Final pre-ODE merge
 * 	[1996/11/05  21:51:50  hayes]
 * 
 * Revision 1.4.2.1  1996/11/01  18:25:01  ted
 * 	change rr_ to tg_, fix compiler warnings, add copyright notices
 * 	[1996/10/29  22:06:21  ted]
 * 
 * $EndLog$
 */
/*
 * FILE mem.c
 *
 * COPYRIGHT (c) Essential Communication Corp. 1995
 * $Source: /Nfs/stives/grp56/gige/src-current/acenic-fw-12.3.10/nic/fw2/common/RCS/mem.c,v $
 * $Revision: 1.4 $ $Locker:  $
 * $Date: 1999/06/22 12:43:01 $ $Author: tjd21 $ $State: Exp $
 */

#ifndef __lint
static const char rcsid[] = "$Header: /Nfs/stives/grp56/gige/src-current/acenic-fw-12.3.10/nic/fw2/common/RCS/mem.c,v 1.4 1999/06/22 12:43:01 tjd21 Exp $";
#endif /* __lint */



#include "alt_def.h"
#include "nic_conf.h"
#include "nic_api.h"
#include "tg.h"

#include "nic.h"
#include "trace.h"
#include "proto.h"


/*
 * memory functions - bzero and bcopy
 *
 * These functions do not handle unaligned addresses or odd lengths, because
 * our processor work in word quantities only.  At some point this needs
 * to be made smarter to use doubles where appropriate.
 */

void
bzero(U32 *dst, U32 len)
{
    register U32 *dst_end = (U32 *)((U32)dst + len);

    while (dst < dst_end) {
	*dst++ = 0;
    }
    return;
}

void
bcopy(U32 *src, U32 *dst, U32 len)
{
    register U32 *dst_end = (U32 *)((U32)dst + len);

    while (dst < dst_end) {
	*dst++ = *src++;
    }
    return;
}

/*
 * gcc implicitly calls memcpy() for struct copies...
 */
void
memcpy(U32 *dst, U32 *src, U32 len)
{
    register U32 *dst_end = (U32 *)((U32)dst + len);

    while (dst < dst_end) {
	*dst++ = *src++;
    }
    return;
}

void
memset_w(U32 *dst, U32 value, U32 nwords)
{
    U32 *wend = dst + nwords;

    while (dst < wend)
	*dst++ = value;
    return;
}
