/*
 * COPYRIGHT NOTICE
 * Copyright (c) Alteon Networks, Inc. 1996, 1997 
 * All rights reserved
 * 
 */
/*
 * HISTORY
 * $Log: mcast.h,v $
 * Revision 1.4  1999/06/22 12:43:01  tjd21
 * Before removing extra recv rings
 *
 * Revision 1.1  1999/06/07 10:52:05  tjd21
 * Start of archive
 *
 * Revision 1.1.2.5  1998/09/30  18:50:06  shuang
 * 	change for new 12.3 API
 * 	[1998/09/30  18:40:13  shuang]
 *
 * Revision 1.1.2.4  1998/04/13  18:11:51  shuang
 * 	cleanup TRP, NIC...
 * 	[1998/04/13  17:54:23  shuang]
 * 
 * Revision 1.1.2.3  1998/04/07  00:12:17  shuang
 * 	fix rx multicast packet
 * 	[1998/04/03  23:03:18  shuang]
 * 
 * Revision 1.1.2.2  1998/03/26  01:34:27  shuang
 * 	     cleanup
 * 	     [1998/03/26  01:25:16  shuang]
 * 
 * Revision 1.1.2.1  1998/02/24  23:55:48  shuang
 * 	          Create mcast.h mcast.c for multicast functions
 * 	          [1998/02/24  23:51:33  shuang]
 * 
 * $EndLog$
 */
/*
 * FILE mcast.h
 *
 * $Source: /Nfs/stives/grp56/gige/src-current/acenic-fw-12.3.10/nic/fw2/common/RCS/mcast.h,v $
 * $Revision: 1.4 $ $Locker:  $
 * $Date: 1999/06/22 12:43:01 $ $Author: tjd21 $ $State: Exp $
 */

#ifndef _MCAST_H_
#define _MCAST_H_

#define MAX_MCAST_THRESHOLD     5


/*
 * return TRUE if two given mac addresses match
 */
__inline__ static bool
is_macaddr_match(U8 *a1, U8 *a2)
{
    return ((*(U16 *)a1 == *(U16 *)a2) && 
            (*(U16 *)(a1 + 2) == *(U16 *)(a2 + 2)) &&
            (*(U16 *)(a1 + 4) == *(U16 *)(a2 + 4)));
}

/*
 * copy mac address from src to dst
 */
__inline__ static void
macaddr_copy(U8 *dst, U8 *src)
{
    *(U16 *)dst = *(U16 *)src;
    *(U32 *)(dst + 2) = *(U32 *)(src + 2);
    return;
}

/*
 * return a free hash entry index
 *      or 0 if no more free hash entry
 */
__inline__ static U32
deq_mcast_free_list(void)
{
    U32 index = nicfp->mc_free_list;

    if (index) {
        nicfp->mc_free_list = nicp->mc_bucket[index].reserved;
    }
    return (index);
}

/*
 * enqueue an index entry to the head of free list
 */
__inline__ static void
enq_mcast_free_list(U32 index)
{
    nicp->mc_bucket[index].reserved = (U16)nicfp->mc_free_list;
    nicfp->mc_free_list = index;
    return;
}

/*
 * look up mc_table[] for a mac address
 */
__inline__ static bool
mcast_lookup_linear(U8 *addr)
{
    struct macaddr *mp, *mp_end;

    mp = &nicp->mc_table[0];
    mp_end = &nicp->mc_table[nicfp->mc_table_depth];
    for (; mp < mp_end; mp++) {
        if (is_macaddr_match(&mp->octet[0], addr)) {
            return (TRUE);
        }
    }
    return (FALSE);
}

/*
 * add a mac address into mc_table[]
 */
__inline__ static void
mcast_add_linear(U8 *addr)
{
    if ((nicfp->mc_table_depth + 1) < MAX_MCAST_ENTRIES) {
        macaddr_copy(&nicp->mc_table[nicfp->mc_table_depth].octet[0], addr);
        nicfp->mc_table_depth++;
    }
    return;
}

/*
 * delete an entry in mc_table[] with a mac address
 */
__inline__ static void
mcast_del_linear(U8 *addr)
{
    struct macaddr *mp;
    S32 i;

    mp = &nicp->mc_table[0];
    for (i = 0; i < nicfp->mc_table_depth; i++, mp++) {
        if (!is_macaddr_match(&mp->octet[0], addr)) {
            continue;
        }
        /* move remainding entries */
        while (i < (nicfp->mc_table_depth - 1)) {
            macaddr_copy(&mp->octet[0], &(mp + 1)->octet[0]);
            i++; mp++;
        }
        nicfp->mc_table_depth--;
        break;
    }
    return;
}

/*
 * look up mc_bucket[] for a mac address
 * return index to mc_bucket[] if found or 0
 */
__inline__ static U32
mcast_lookup_hash(U8 *addr, U32 hash)
{
    U32 index;

    index = nicp->mc_table[hash].reserved;
    while (index) {
        if (is_macaddr_match(&nicp->mc_bucket[index].octet[0], addr)) {
            break;
        }
        index = nicp->mc_bucket[index].reserved;
    }
    return (index);
}

/*
 * look up mc_bucket[] for a mac address
 * return index to mc_bucket[] if found or 0
 * the previous index is returned in *prev (may be 0)
 */
__inline__ static U32
mcast_lookup_hash_prev(U8 *addr, U32 hash, U32 *prev /*ret*/)
{
    U32 index, index_prev;

    index_prev = 0;
    index = nicp->mc_table[hash].reserved;
    while (index) {
        if (is_macaddr_match(&nicp->mc_bucket[index].octet[0], addr)) {
            break;
        }
        index_prev = index;
        index = nicp->mc_bucket[index].reserved;
    }
    *prev = index_prev;
    return (index);
}

/*
 * add a mac address entry into mc_bucket[]
 */
__inline__ static void
mcast_add_hash(U8 *addr, U32 hash, U32 index)
{
    macaddr_copy(&nicp->mc_bucket[index].octet[0], addr);

    /* add to hash head */
    nicp->mc_bucket[index].reserved = nicp->mc_table[hash].reserved;
    nicp->mc_table[hash].reserved = (U16)index;
    return;
}

/*
 * delete an index entry in mc_bucket[]
 */
__inline__ static void
mcast_del_hash(U32 hash, U32 index, U32 prev)
{
    if (prev) {
        nicp->mc_bucket[prev].reserved = nicp->mc_bucket[index].reserved;
    } else {
        nicp->mc_table[hash].reserved = nicp->mc_bucket[index].reserved;
    }
    enq_mcast_free_list(index); /* put index back to free list */
    return;
}

/*
 * set corresponding bit in hardware filtering mask registers
 */
__inline__ static void
mcast_set_hw_filter_masks(U32 hash)
{
    U32 index;

    index = (hash & MCAST_HASH_GROUP_MASK) >> MCAST_HASH_GROUP_SHIFT;
    if (is_global_flags(GF_CMD_MCAST_MODE)) {
        nicp->mc_filter_saved[MCAST_MAX_HASH_GROUP - index] |= 
                (1 << (hash & MCAST_HASH_ENTRY_MASK));
    } else {
        trp->mac_control.mac_rx_mcast_filter[MCAST_MAX_HASH_GROUP - index] |= 
                (1 << (hash & MCAST_HASH_ENTRY_MASK));
    }
    return;
}

/*
 * clear corresponding bit in hardware filtering mask registers
 */
__inline__ static void
mcast_clear_hw_filter_masks(U32 hash)
{
    U32 index;

    if (nicp->mc_table[hash].reserved == 0) { /* no entry */
        index = (hash & MCAST_HASH_GROUP_MASK) >> MCAST_HASH_GROUP_SHIFT;
        if (is_global_flags(GF_CMD_MCAST_MODE)) {
            nicp->mc_filter_saved[MCAST_MAX_HASH_GROUP - index]
                 &= ~(1 << (hash & MCAST_HASH_ENTRY_MASK));
        } else {
            trp->mac_control.mac_rx_mcast_filter[MCAST_MAX_HASH_GROUP - index]
                 &= ~(1 << (hash & MCAST_HASH_ENTRY_MASK));
        }
    }
    return;
}

#endif /* _MCAST_H_ */
