/*
 * COPYRIGHT NOTICE
 * Copyright (c) Alteon Networks, Inc. 1996, 1997 
 * All rights reserved
 * 
 */
/*
 * HISTORY
 * $Log: mcast.c,v $
 * Revision 1.5  1999/12/01 10:58:15  iap10
 * *** empty log message ***
 *
 * Revision 1.4  1999/06/22 12:43:01  tjd21
 * Before removing extra recv rings
 *
 * Revision 1.1  1999/06/07 10:52:05  tjd21
 * Start of archive
 *
 * Revision 1.1.2.8  1998/12/08  02:36:36  shuang
 * 	Clean up debug tracing. Use sw dma. Fix dma avoidance.
 * 	[1998/12/08  02:28:07  shuang]
 *
 * Revision 1.1.2.7  1998/09/30  18:50:05  shuang
 * 	change for new 12.3 API
 * 	[1998/09/30  18:40:09  shuang]
 * 
 * Revision 1.1.2.6  1998/08/27  23:22:49  shuang
 * 	add new mcast and mbox cmds, intr masks, obsolete recv ret cons idx
 * 	[1998/08/27  23:20:39  shuang]
 * 
 * Revision 1.1.2.5  1998/04/24  00:00:39  hayes
 * 	added const to rcsid definitions to eliminate compiler warnings
 * 	[1998/04/23  23:58:53  hayes]
 * 
 * Revision 1.1.2.4  1998/04/11  05:15:11  shuang
 * 	move fast timer to cpu B, add receive coalesed ticks
 * 	[1998/04/11  04:58:19  shuang]
 * 
 * Revision 1.1.2.3  1998/04/07  00:12:16  shuang
 * 	test bci
 * 	[1998/04/04  02:23:20  shuang]
 * 
 * 	fix rx multicast packet
 * 	[1998/04/03  23:03:22  shuang]
 * 
 * Revision 1.1.2.2  1998/03/26  01:34:26  shuang
 * 	     cleanup
 * 	     [1998/03/26  01:25:13  shuang]
 * 
 * Revision 1.1.2.1  1998/02/24  23:55:46  shuang
 * 	          Create mcast.h mcast.c for multicast functions
 * 	          [1998/02/24  23:51:27  shuang]
 * 
 * $EndLog$
 */
/*
 * FILE mcast.c
 *
 * $Source: /Nfs/stives/grp56/gige/src-current/acenic-fw-12.3.10/nic/fw2/common/RCS/mcast.c,v $
 * $Revision: 1.5 $ $Locker:  $
 * $Date: 1999/12/01 10:58:15 $ $Author: iap10 $ $State: Exp $
 */

#ifndef __lint
static const char rcsid[] = "$Header: /Nfs/stives/grp56/gige/src-current/acenic-fw-12.3.10/nic/fw2/common/RCS/mcast.c,v 1.5 1999/12/01 10:58:15 iap10 Exp $";
#endif /* __lint */

#include "alt_def.h"
#include "nic_conf.h"
#include "nic_api.h"
#include "tg.h"

#include "nic.h"
#include "proto.h"
#include "trace.h"
#include "dma.h"
#include "ring.h"
#include "assert.h"
#include "mcast.h"

/*
 * Two tables mc_table[] and mc_bucket[] are provided for
 * keeping an multicast address. Table mc_table[] is searched
 * linearly and table mc_bucket[] is searched by a hash function
 * from the CRC value generated by software. It takes some time
 * to generate this CRC value.
 * 
 * Hence, mc_table[] is searched first if contained mac 
 * addresses are less than a threshold (MAX_MCAST_THRESHOLD).
 *
 * To save space, the unused reserved field in an entry of
 * mc_table[] is also used as the link-list head to keep the
 * hashed index into mc_bucket[].
 *
 * Free entries in mc_bucket[] are linked by mc_free_list.
 *
 * A index value of 0 indicates EOL (end of list). So first entry
 * mc_bucket[0] is not used. The way chosen is to simply the 
 * comparison operation (be a single instruction BEQ or BNE).
 *
 * Note: BIG ENDING is assumed for the mac address in memory.
 */

void
mcast_init(void)
{
    U32 i;

    nicfp->mc_table_depth = 0;

    /* build free list
     * first entry mc_bucket[0] won't be used
     * an index value of 0 indicate end of list similar to the NULL pointer
     */
    for (i = 1; i < MAX_MCAST_ENTRIES; i++) {
        nicp->mc_bucket[i].reserved = i + 1;
    }
    nicp->mc_bucket[MAX_MCAST_ENTRIES].reserved = 0; /* end of list */
    nicfp->mc_free_list = 1; /* start at index 1 */

    /* Clear all multicast filtering
     * i.e. do not recieve any multicast traffic
     */
    trp->mac_control.mac_rx_mcast_filt1 = 0; 
    trp->mac_control.mac_rx_mcast_filt2 = 0; 
    trp->mac_control.mac_rx_mcast_filt3 = 0; 
    trp->mac_control.mac_rx_mcast_filt4 = 0; 

    return;
}

/*
 * return TRUE if a given multicast should be accepted
 */
bool
mcast_rx_filter(U8 *addr)
{
    /* look up linear table if contains only a few entries */
    if (nicfp->mc_table_depth < MAX_MCAST_THRESHOLD) {
        if (!mcast_lookup_linear(addr)) {
            NIC_TRACE(TRACE_TYPE_RECV, "rxMcMisL", 0x40100, 
		*(U16 *)(addr),
		(*(U16 *)(addr + 2) << 16) | (*(U16 *)(addr + 4)),
		nicfp->mc_table_depth,
		0);
            return (FALSE);
        }
    } else {
        U32 hash;

        /* Use Hash Table to find the entry */
        hash = gen_crc(addr, 6) & (MAX_MCAST_ENTRIES - 1);
        if ((nicp->mc_table[hash].reserved == 0) ||
            (mcast_lookup_hash(addr, hash) == 0)) {
            NIC_TRACE(TRACE_TYPE_RECV, "rxMcMisH", 0x40200, 
		*(U16 *)(addr),
		(*(U16 *)(addr + 2) << 16) | (*(U16 *)(addr + 4)),
		hash,
		nicp->mc_table[hash].reserved);
            return (FALSE);
        }
    }
    return (TRUE);
}

void mcast_rx_filter_end(void) {}

/*
 * add a multicast entry
 */
void
add_mcast(tg_macaddr_t *macaddr)
{
    struct tg_event ee;
    U8  *cp;
    U32 *wp;
    U32 hash;
    U32 index;

    cp = &macaddr->octet[0]; /* pointer to mac address (6 octets) */
    wp = (U32 *)macaddr;
    hash = gen_crc(cp, 6) & (MAX_MCAST_ENTRIES - 1);

    NIC_TRACE(TRACE_TYPE_COMMAND, "addMc", 0x40300, 
              *wp,
              *(wp + 1), 
              hash,
              nicp->mc_table[hash].reserved);

    index = mcast_lookup_hash(cp, hash);
    if (index) {
        /* oops, we already have this entry */
        NIC_UTRACE("addMcDup", 0x40400, 
		  *wp,
		  *(wp + 1),
                  *(U32 *)&nicp->mc_bucket[index],
                  *(U32 *)&nicp->mc_bucket[index].octet[2]);
    } else {
        index = deq_mcast_free_list();
        if (index == 0) {
            /* no more free entries */
            NIC_UTRACE("addMcFul", 0x40500, 
			*wp,
			*(wp + 1),
                        hash,
                        nicp->mc_table[hash].reserved);
        } else {
            mcast_add_hash(cp, hash, index);
            mcast_add_linear(cp);
            mcast_set_hw_filter_masks(hash);

            NIC_TRACE(TRACE_TYPE_COMMAND, "addMcOk", 0x40600, 
                      *(U32 *)&nicp->mc_bucket[index],
                      *(U32 *)&nicp->mc_bucket[index].octet[2],
                      hash,
                      index);

            NIC_TRACE(TRACE_TYPE_COMMAND, "addMcMsk", 0x40700, 
                      nicp->mc_filter_saved[MCAST_FILTER(hash)],
                      trp->mac_control.mac_rx_mcast_filter[MCAST_FILTER(hash)],
                      hash,
                      MCAST_FILTER(hash));
        }
    }

    /* ack host */
    ee.TG_EVENT_w0 =
	(TG_EVENT_MULTICAST_LIST_UPDATED << TG_EVENT_EVENT_SHIFT) |
	(TG_EVENT_CODE_MCAST_ADDR_ADDED << TG_EVENT_CODE_SHIFT);
    must_enq_event(&ee);

    nicfp->stats.nicCmdsAddMCastAddr++;
    nicfp->stats.nicEventsMCastListUpdated++;

    return;
}

/*
 * delete a multicast entry
 */
void
del_mcast(tg_macaddr_t *macaddr)
{
    struct tg_event ee;
    U8  *cp;
    U32 *wp;
    U32 hash;
    U32 index, prev;

    cp = &macaddr->octet[0]; /* pointer to mac address (6 octets) */
    wp = (U32 *)macaddr;
    hash = gen_crc(cp, 6) & (MAX_MCAST_ENTRIES - 1);

    NIC_TRACE(TRACE_TYPE_COMMAND, "delMc", 0x40800, 
	      *wp,
	      *(wp + 1),
              hash,
              nicp->mc_table[hash].reserved);

    index = mcast_lookup_hash_prev(cp, hash, &prev);
    if (index == 0) {
        /* oops, no such entry */
        NIC_UTRACE("delMcNoE", 0x40900, 
		   *wp,
		   *(wp + 1),
                   hash,
                   nicp->mc_table[hash].reserved);
    } else {
        NIC_TRACE(TRACE_TYPE_COMMAND, "delMcOk", 0x41000, 
                  *(U32 *)&nicp->mc_bucket[index],
                  *(U32 *)&nicp->mc_bucket[index].octet[2],
                  prev,
                  index);

        mcast_del_hash(hash, index, prev);
        mcast_del_linear(cp);
        mcast_clear_hw_filter_masks(hash);

        NIC_TRACE(TRACE_TYPE_COMMAND, "delMcMsk", 0x41100, 
                  nicp->mc_filter_saved[MCAST_FILTER(hash)],
                  trp->mac_control.mac_rx_mcast_filter[MCAST_FILTER(hash)],
                  hash,
                  MCAST_FILTER(hash));
    }

    /* ack host */
    ee.TG_EVENT_w0 =
	(TG_EVENT_MULTICAST_LIST_UPDATED << TG_EVENT_EVENT_SHIFT) |
	(TG_EVENT_CODE_MCAST_ADDR_DELETED << TG_EVENT_CODE_SHIFT);
    must_enq_event(&ee);

    nicfp->stats.nicCmdsDelMCastAddr++;
    nicfp->stats.nicEventsMCastListUpdated++;

    return;
}
