/******************************************************************************
 * event.c
 * 
 * An event mechanism for communication between the two processors.
 * 
 * Copyright (c) 2000, University of Cambridge
 *
 * Please read the FIRMWARE-LICENSE file distributed with this source file
 * for details of the license agreement.
 */

#include "alt_def.h"
#include "nic_conf.h"
#include "nic_api.h"
#include "tg.h"

#include "nic.h"
#include "proto.h"
#include "ring.h"
#include "assert.h"
#include "event.h"


#define get_args(r,p,l)                                                    \
{                                                                          \
    int __i;                                                               \
    for ( __i = 0; __i < (l); __i++ )                                      \
    {                                                                      \
        (p)[__i] = nicp->event_ring_ ## r ## .ring[                        \
            nicp->event_ring_ ## r ## .cons++ & (CPU_EVENT_RING_SIZE-1)];  \
    }                                                                      \
}


/******************************************************************************
 * event_handler_A:
 *   Called as an event handler when there are outstanding events from CPU B.
 */
void event_handler_A(void)
{
    U16 cons, prod;
    clear_event_reg(TG_FW_EVENT_USD_EVENT_A);

    cons = nicp->event_ring_a.cons;
    prod = nicp->event_ring_a.prod;

    //NIC_UTRACE("EventA", 0, cons, prod, 
    //           trp->gen_control.event, TG_FW_EVENT_USD_EVENT_A);

    while ( cons != prod )
    {
        U32 ev   = nicp->event_ring_a.ring[cons++ & (CPU_EVENT_RING_SIZE-1)];
        U32 data = ev & EVENT_DATA_MASK; 
        nicp->event_ring_a.cons++; /* update consumer in a timely manner */

        switch ( ev & EVENT_ID_MASK )
        {
        case EVA_ADD_CONTEXT_FINAL:
        {
            h_usd_add_context_final(data);
        }
        break;

        case EVA_DEL_CONTEXT_FINAL:
        {
            delete_usd_context_final(data);
        }
        break;

        default: PANIC();
        }
        cons = nicp->event_ring_a.cons;
    }
}


/******************************************************************************
 * event_handler_B:
 *   Called as an event handler when there are outstanding events from CPU A.
 */
void event_handler_B(void)
{
    U16 cons, prod;
    clear_event_reg_b(TG_FW_EVENT_USD_EVENT_B);

    cons = nicp->event_ring_b.cons;
    prod = nicp->event_ring_b.prod;

    //NIC_UTRACE("EventB", 0, cons, prod,
    //           trp->gen_control.event_b, TG_FW_EVENT_USD_EVENT_B);

    while ( cons != prod )
    {
        U32 ev   = nicp->event_ring_b.ring[cons++ & (CPU_EVENT_RING_SIZE-1)];
        U32 data = ev & EVENT_DATA_MASK; 
        nicp->event_ring_b.cons++; /* update consumer in a timely manner */

        switch ( ev & EVENT_ID_MASK )
        {
        case EVB_ADD_CONTEXT:
        {
            conn_ctxt_host_part_t hp;
            get_args(b, (U32*)&hp, sizeof(hp)>>2);
            h_usd_add_context_B(data, &hp);
        }
        break;

        case EVB_DEL_CONTEXT:
        {
            h_usd_delete_context_B(data);
        }
        break;

        default: PANIC();
        }
        cons = nicp->event_ring_b.cons;
    }
}


