/*
 * COPYRIGHT NOTICE
 * Copyright (c) Alteon Networks, Inc. 1996
 * All rights reserved
 */
/*
 * HISTORY
 * $Log: dma.h,v $
 * Revision 1.6  1999/12/01 10:58:15  iap10
 * *** empty log message ***
 *
 * Revision 1.5  1999/07/12 13:17:40  tjd21
 * Scheduling in place, ready for multiple USDs
 *
 * Revision 1.4  1999/06/22 12:43:01  tjd21
 * Before removing extra recv rings
 *
 * Revision 1.1  1999/06/07 10:52:05  tjd21
 * Start of archive
 * 
 * $EndLog$
 */
/*
 * FILE dma.h
 *
 * $Source: /Nfs/stives/grp56/gige/src-current/acenic-fw-12.3.10/nic/fw2/common/RCS/dma.h,v $
 * $Revision: 1.6 $ $Locker:  $
 * $Date: 1999/12/01 10:58:15 $ $Author: iap10 $ $State: Exp $
 */

#ifndef _DMA_H_
#define _DMA_H_

#include "trace.h"

/* grouping of dma avoidance */
#define	WR_DMA_GROUP_1	(TIGON_TYPE_RX_PROD | \
			 TIGON_TYPE_TX_CONS | \
			 TIGON_TYPE_EVENT_PROD)

#define	WR_DMA_GROUP_2	((U16)~WR_DMA_GROUP_1)

#define RD_DMA_GROUP_1	(TIGON_TYPE_SEND_DATA | \
			 TIGON_TYPE_SEND_DATA_LAST)

#define	RD_DMA_GROUP_2	((U16)~RD_DMA_GROUP_1)

/* grouping of BD types to control tracing */
#define	TIGON_TYPE_TX	(TIGON_TYPE_SEND_BD | \
			 TIGON_TYPE_SEND_DATA | \
			 TIGON_TYPE_SEND_DATA_LAST | \
			 TIGON_TYPE_SEND_DATA_LAST_VLAN | \
			 TIGON_TYPE_SEND_DATA_COAL | \
			 TIGON_TYPE_SEND_DATA_LAST_COAL | \
			 TIGON_TYPE_SEND_DATA_LAST_VLAN_COAL | \
			 TIGON_TYPE_RECV_BD | \
			 TIGON_TYPE_RECV_JUMBO_BD | \
			 TIGON_TYPE_RECV_MINI_BD | \
			 TIGON_TYPE_RECV_BD_LAST)

#define	TIGON_TYPE_RX	(TIGON_TYPE_RECV_DATA | \
			 TIGON_TYPE_RECV_DATA_LAST | \
			 TIGON_TYPE_RECV_BD | \
			 TIGON_TYPE_RECV_JUMBO_BD | \
			 TIGON_TYPE_RECV_MINI_BD | \
			 TIGON_TYPE_RECV_BD_LAST)


__inline__ static tgDmaDescr_t *
get_next_rd_dma_descr(tgDmaDescr_t *ddp)
{
    return ((ddp == &tdp->rd_dma_ring[TG_DMA_ASSIST_DESCRS - 1])?
	    tdp->rd_dma_ring:
	    (ddp + 1));
}

__inline__ static tgDmaDescr_t *
get_next_wr_dma_descr(tgDmaDescr_t *ddp)
{
    return ((ddp == &tdp->wr_dma_ring[TG_DMA_ASSIST_DESCRS - 1])?
	    tdp->wr_dma_ring:
	    (ddp + 1));
}

__inline__ static U32
get_next_dma_descr_index(U32 index)
{
    return ((index == (TG_DMA_ASSIST_DESCRS - 1))?
	    0:
	    (index + 1));
}


__inline__ static U32
q_dma_to_host_index(tg_hostaddr_t host_addr, U32 len, U16 type, 
                    U16 id, U32 index, U32 state)
{
    return (*nicfp->q_dma_to_host_stub)
		(host_addr,
		(U32)&trp->host_dma_assist.write_chan_producer->index,
		len,
		type,
		id,
		index,
		state);
}

__inline__ static void
dma_to_nic(struct recv_bd *bdp)
{
    NIC_TRACE(TRACE_TYPE_DMA, "QrDmaM", 0x15200,
	 (U32)bdp->BD_host_addr,
	 bdp->BD_nic_addr,
	 bdp->BD_w2,
	 0);

    trp->host_dma.dma_rd_host_addr = bdp->BD_host_addr;
    trp->host_dma.dma_rd_loc_addr  = bdp->BD_nic_addr;
    trp->host_dma.dma_rd_len       = bdp->BD_w2 & BD_LEN_MASK;

    /* start the DMA... */
    trp->host_dma.dma_rd_state    |= nicfp->dma_to_nic_bd_state;

    /* we'll receive an event when DMA completes... */
    return;
}

#endif /* _DMA_H_ */
