/*
 * COPYRIGHT NOTICE
 * Copyright (c) Alteon Networks, Inc. 1996
 * All rights reserved
 */
/*
 * HISTORY
 * $Log: dma.c,v $
 * Revision 1.13  2000/03/31 12:18:50  iap10
 * *** empty log message ***
 *
 * Revision 1.12  2000/03/14 14:57:46  kaf24
 * *** empty log message ***
 *
 * Revision 1.11  2000/03/14 10:19:49  iap10
 * *** empty log message ***
 *
 * Revision 1.10  1999/12/01 10:55:01  iap10
 * *** empty log message ***
 *
 * Revision 1.9  1999/11/01 15:32:44  iap10
 * *** empty log message ***
 *
 * Revision 1.8  1999/10/13 14:30:34  iap10
 * *** empty log message ***
 *
 * Revision 1.7  1999/09/24 11:09:33  iap10
 * before new send path
 *
 * Revision 1.6  1999/08/10 15:05:33  tjd21
 * First version by kaf.
 *
 * Revision 1.5  1999/07/12 13:17:40  tjd21
 * Scheduling in place, ready for multiple USDs
 *
 * Revision 1.4  1999/06/22 12:43:01  tjd21
 * Before removing extra recv rings
 *
 * Revision 1.1  1999/06/07 10:52:05  tjd21
 * Start of archive
 *
 * Revision 1.1  1999/06/07 10:48:14  tjd21
 * Start of archive
 * 
 * $EndLog$
 */
/*
 * FILE dma.c
 *
 * COPYRIGHT (c) Essential Communication Corp. 1995
 * $Source: /Nfs/stives/grp56/gige/src-current/acenic-fw-12.3.10/nic/fw2/common/RCS/dma.c,v $
 * $Revision: 1.13 $ $Locker: iap10 $
 * $Date: 2000/03/31 12:18:50 $ $Author: iap10 $ $State: Exp $
 */

#ifndef __lint
static const char rcsid[] = "$Header: /Nfs/stives/grp56/gige/src-current/acenic-fw-12.3.10/nic/fw2/common/RCS/dma.c,v 1.13 2000/03/31 12:18:50 iap10 Exp iap10 $";

#endif /* __lint */



#include "alt_def.h"
#include "nic_conf.h"
#include "nic_api.h"
#include "tg.h"

#include "nic.h"
#include "trace.h"
#include "proto.h"
#include "assert.h"
#include "ring.h"

#include "usd2_util.h"

/* should be defined in tg.h */
#define TG_DMA_STATE_CROSS_ADDR_ERROR	(0x08000000)

/*
 * Set up the DMA assist rings and enable the DMA assist.  From now on,
 * all DMA must go through the assist logic.  Using the other DMA
 * method will confuse the DMA assist logic.
 */
void
init_dma_assist(void)
{
    /* zero the assist rings */
    bzero((U32 *)tdp->rd_dma_ring,
          sizeof(struct tg_dma_descr) * TG_DMA_ASSIST_DESCRS * 2);

#if (TG_DMA_DESCR_CHAINED)
    /* chaining must be done prior to initializing the assist pointers */
    trp->host_dma_assist.assist_state = TG_DMA_ASSIST_CHAIN_RINGS;
#else
    trp->host_dma_assist.assist_state = 0;
#endif

    trp->host_dma_assist.read_chan_producer = 0;
    trp->host_dma_assist.read_chan_consumer = 0;
    trp->host_dma_assist.read_chan_ref      = 0;

    trp->host_dma_assist.read_chan_lo_pri_producer = 0;
    trp->host_dma_assist.read_chan_lo_pri_consumer = 0;
    trp->host_dma_assist.read_chan_lo_pri_ref      = 0;

    trp->host_dma_assist.write_chan_producer = 0;
    trp->host_dma_assist.write_chan_consumer = 0;
    trp->host_dma_assist.write_chan_ref      = 0;

    trp->host_dma_assist.write_chan_lo_pri_producer = 0;
    trp->host_dma_assist.write_chan_lo_pri_consumer = 0;
    trp->host_dma_assist.write_chan_lo_pri_ref      = 0;

    trp->host_dma_assist.assist_state |= TG_DMA_ASSIST_ENABLE; 

    NIC_UTRACE("swDmaOff", 0x10100,
               trp->host_dma_assist.assist_state,0,0,0);
}

void print_assist_ring(char * name, tgDmaDescr_t *ring, 
		      tgDmaDescr_t *ref,
		      tgDmaDescr_t *prod )
{
    int i;
    tgDmaDescr_t *dd;

    //    NIC_UTRACE("ClrAsst", 0x99294, ring, ref, prod, 0 );

    for ( i = 0, dd = ref; 
          dd != prod; 
          i++, dd = (dd == (ring + TG_DMA_ASSIST_DESCRS - 1)) ? ring : dd+1 )
    {
      NIC_UTRACE( name, i,
		  dd->len, dd->type, dd->usd_id, dd->index );

      if( i > TG_DMA_ASSIST_DESCRS ) PANIC();	
    }
}

#if 1

#define TEST_ITERATIONS 30

void perf_test(tg_hostaddr_t host_buf)
{
  int j;
  //int size[] = {32, 256, 1024, 8192};
  int size[] = {8192};
  
  U32 nic_buf = NIC_RX_BUF; // currently unused area

  for(j=0;j<sizeof(size)/sizeof(int);j++)
    {
      U32 start, stop;
      tgDmaDescr_t *dd_prod, *ndd_prod, *dd_ref, *dd_cons;    
      int queued, done;
      int len;

      len = size[j];
      queued = done = 0;

      dd_prod  = trp->host_dma_assist.write_chan_hi_pri_producer; 
      dd_ref   = trp->host_dma_assist.write_chan_hi_pri_ref;
      ndd_prod = get_next_wr_dma_high_descr( dd_prod );

      start = trp->gen_control.timer;

      while(done<TEST_ITERATIONS)
      {	
          while( queued < TEST_ITERATIONS && ndd_prod != dd_ref )
          {
	      // we have stuff to send and there is space
	      fill_in_dma_record(dd_prod,
				 host_buf,
				 nic_buf,
				 //len,
				 (queued&1)?len:8,
				 TIGON_TYPE_NULL,
				 0x51,          // chan 
				 queued,     // Mac RX Descr
				 RX2_DMA_TO_HOST_FRAG_STATE );
	      
	      trp->host_dma_assist.write_chan_hi_pri_producer = ndd_prod;
	      dd_prod = ndd_prod; // advance our copy
	      ndd_prod = get_next_wr_dma_high_descr( dd_prod );
	      queued++;
          }
          
          // wait for atleast one completion
          while(!(trp->gen_control.event&TG_FW_EVENT_DMA_WR_ASST_HI))
            {       
              int k;
              for(k=0;k<15;k++);
            }

          dd_cons  = trp->host_dma_assist.write_chan_hi_pri_consumer;
          // clear up any that have now completed
          while( dd_ref != dd_cons )
            {
              done++;
              trp->host_dma_assist.write_chan_hi_pri_ref = dd_ref+1;
              dd_ref = trp->host_dma_assist.write_chan_hi_pri_ref;
            }

      }
      stop = trp->gen_control.timer;
      
      NIC_UTRACE("PerfWr2H", 0x97801, len, queued, done, stop-start);

  for(j=0;j<100000;j++)
    {
      dd_cons  = trp->host_dma_assist.write_chan_hi_pri_consumer;
      while( dd_ref != dd_cons )
            {
              done++;
              trp->host_dma_assist.write_chan_hi_pri_ref = dd_ref+1;
              dd_ref = trp->host_dma_assist.write_chan_hi_pri_ref;
            }
    }

      NIC_UTRACE("XXrfWr2H", 0x97801, len, queued, done, stop-start);

    }

  //init_dma_assist();

  for(j=0;j<sizeof(size)/sizeof(int);j++)
    {
      U32 start, stop;
      tgDmaDescr_t *dd_prod, *ndd_prod, *dd_ref, *dd_cons;    
      int queued, done;
      int len;

      len = size[j];
      queued = done = 0;

      dd_prod  = trp->host_dma_assist.read_chan_hi_pri_producer; 
      dd_ref   = trp->host_dma_assist.read_chan_hi_pri_ref;
      ndd_prod = get_next_rd_dma_high_descr( dd_prod );

      start = trp->gen_control.timer;

      while(done<TEST_ITERATIONS)
      {	
          while( queued < TEST_ITERATIONS && ndd_prod != dd_ref )
          {
	      // we have stuff to send and there is space
	      fill_in_dma_record(dd_prod,
				 host_buf,
				 nic_buf,
				 len,
				 TIGON_TYPE_NULL,
				 0x52,          // chan 
				 queued,     // Mac RX Descr
				 TX2_DMA_TO_NIC_FRAG_STATE );
	      
	      trp->host_dma_assist.read_chan_hi_pri_producer = ndd_prod;
	      dd_prod = ndd_prod; // advance our copy
	      ndd_prod = get_next_rd_dma_high_descr( dd_prod );
	      queued++;
          }
     
          // wait for atleast one completion
          while(!(trp->gen_control.event&TG_FW_EVENT_DMA_RD_ASST_HI))
            {       
              int k;
              for(k=0;k<15;k++);
            }

          dd_cons  = trp->host_dma_assist.read_chan_hi_pri_consumer;
          // clear up any that have now completed
          while( dd_ref != dd_cons )
            {
              done++;
              trp->host_dma_assist.read_chan_hi_pri_ref = dd_ref+1;
              dd_ref = trp->host_dma_assist.read_chan_hi_pri_ref;
            }

      }
      stop = trp->gen_control.timer;
      
      NIC_UTRACE("PerfRd2H", 0x97802, len, queued, done, stop-start);
    }

  for(j=0;j<sizeof(size)/sizeof(int);j++)
    {
      U32 start, stop;
      tgDmaDescr_t *Rdd_prod, *Rndd_prod, *Rdd_ref, *Rdd_cons;    
      tgDmaDescr_t *Wdd_prod, *Wndd_prod, *Wdd_ref, *Wdd_cons;    
      int Rqueued, Rdone;
      int Wqueued, Wdone;
      int len;

      len = size[j];
      Rqueued = Rdone = 0;
      Wqueued = Wdone = 0;

      Rdd_prod  = trp->host_dma_assist.read_chan_hi_pri_producer; 
      Rdd_ref   = trp->host_dma_assist.read_chan_hi_pri_ref;
      Rndd_prod = get_next_rd_dma_high_descr( Rdd_prod );

      Wdd_prod  = trp->host_dma_assist.write_chan_hi_pri_producer; 
      Wdd_ref   = trp->host_dma_assist.write_chan_hi_pri_ref;
      Wndd_prod = get_next_wr_dma_high_descr( Wdd_prod );

      start = trp->gen_control.timer;

      while(Rdone<TEST_ITERATIONS || Wdone<TEST_ITERATIONS*2)
      {	
          while( Rqueued < TEST_ITERATIONS && Rndd_prod != Rdd_ref )
          {
	      // we have stuff to send and there is space
	      fill_in_dma_record(Rdd_prod,
				 host_buf,
				 nic_buf,
				 len,
				 TIGON_TYPE_NULL,
				 0x53,          // chan 
				 Rqueued,     // Mac RX Descr
				 TX2_DMA_TO_NIC_FRAG_STATE );
	      
	      trp->host_dma_assist.read_chan_hi_pri_producer = Rndd_prod;
	      Rdd_prod = Rndd_prod; // advance our copy
	      Rndd_prod = get_next_rd_dma_high_descr( Rdd_prod );
	      Rqueued++;
          }

	  while( Wqueued < TEST_ITERATIONS*2 && Wndd_prod != Wdd_ref )
          {
	      // we have stuff to send and there is space
	      fill_in_dma_record(Wdd_prod,
				 host_buf+8192,
				 nic_buf+8192,
				 //len,
				 (Wqueued&1)?len:8,
				 TIGON_TYPE_NULL,
				 0x54,          // chan 
				 Wqueued,     // Mac RX Descr
				 RX2_DMA_TO_HOST_FRAG_STATE );
	      
	      trp->host_dma_assist.write_chan_hi_pri_producer = Wndd_prod;
	      Wdd_prod = Wndd_prod; // advance our copy
	      Wndd_prod = get_next_wr_dma_high_descr( Wdd_prod );
	      Wqueued++;
          }

          
          // wait for atleast one completion
          while(!(trp->gen_control.event&
		  (TG_FW_EVENT_DMA_RD_ASST_HI|TG_FW_EVENT_DMA_WR_ASST_HI)))
            {       
              int k;
              for(k=0;k<15;k++);
            }

          Rdd_cons  = trp->host_dma_assist.read_chan_hi_pri_consumer;
          // clear up any that have now completed
          while( Rdd_ref != Rdd_cons )
            {
              Rdone++;

NIC_UTRACE("Rd..", 0x97803, 
			     Rdd_ref->usd_id, Rdd_ref->index, Rdone, Wdone);


              trp->host_dma_assist.read_chan_hi_pri_ref = Rdd_ref+1;
              Rdd_ref = trp->host_dma_assist.read_chan_hi_pri_ref;



	      if( Rdone == TEST_ITERATIONS )
		  NIC_UTRACE("PerfRd--", 0x97803, 
			     len, Rdone, Wdone, trp->gen_control.timer-start);
            }

          Wdd_cons  = trp->host_dma_assist.write_chan_hi_pri_consumer;
          // clear up any that have now completed
          while( Wdd_ref != Wdd_cons )
            {
              Wdone++;

NIC_UTRACE("Wr..", 0x97803, 
			     Wdd_ref->usd_id, Wdd_ref->index, Rdone, Wdone);

              trp->host_dma_assist.write_chan_hi_pri_ref = Wdd_ref+1;
              Wdd_ref = trp->host_dma_assist.write_chan_hi_pri_ref;

	      if( Wdone == TEST_ITERATIONS*2 )
		  NIC_UTRACE("Perf--Wr", 0x97803, 
			     len, Rdone, Wdone, trp->gen_control.timer-start);
            }

      }
      stop = trp->gen_control.timer;
      
      NIC_UTRACE("PerfRdWr", 0x97804, len, Rdone, Wdone, stop-start);
    }


  // everything should have stopped by the time we get here....
  init_dma_assist();
}
void perf_test_end(void) {}

#endif

U32
q_dma_to_host(tg_hostaddr_t host_addr, U32 nic_addr, U32 len, 
              U16 type, U16 id, U32 index, U32 state) 
{
    struct tg_dma_descr *dd_prod, *ndd_prod, *dd_cons;

    dd_prod = trp->host_dma_assist.write_chan_next;
    if (!dd_prod ||
	((ndd_prod = get_next_wr_dma_descr(dd_prod)) ==
	     trp->host_dma_assist.write_chan_ref) ||
 	(ndd_prod == (dd_cons = trp->host_dma_assist.write_chan_consumer))) {

        nicfp->stats.nicDmaWriteRingFull++; 

	NIC_TRACE(TRACE_TYPE_DMA, "QwDmaF", 0x10400,
	    trp->host_dma_assist.write_chan_producer,
	    trp->host_dma_assist.write_chan_consumer,
	    trp->host_dma_assist.write_chan_ref,
	    nicfp->stats.nicDmaWriteRingFull);
        return (ERROR);
    }

    dd_prod->host_addr = host_addr; 
    dd_prod->nic_addr  = nic_addr; 
    dd_prod->len       = len; 
    dd_prod->type      = type; 
    dd_prod->usd_id    = id;
    dd_prod->index     = index; 
    dd_prod->state     = state; 
    dd_prod->cksum     = (U32)dd_cons; /* only to debug dma overrun */

    trp->host_dma_assist.write_chan_producer = ndd_prod;

    NIC_TRACE_IF(TRACE_TYPE_DMA, "QwDmaIdx", 0x10600,
		 type, TIGON_TYPE_RX,
	(dd_prod - tdp->wr_dma_ring),
        trp->host_dma_assist.write_chan_producer,
        trp->host_dma_assist.write_chan_consumer,
        trp->host_dma_assist.write_chan_ref);

    NIC_TRACE_IF(TRACE_TYPE_DMA, "QwDmaD0", 0x10700,
		 type, TIGON_TYPE_RX,
	*(U32 *)dd_prod,	/* host addr */
	*((U32 *)dd_prod + 1),	/* host addr */
	*((U32 *)dd_prod + 2),	/* nic addr */
	*((U32 *)dd_prod + 3));	/* reserved & len */

    NIC_TRACE_IF(TRACE_TYPE_DMA, "QwDmaD1", 0x10800,
		 type, TIGON_TYPE_RX,
	*((U32 *)dd_prod + 4),	/* state */
	*((U32 *)dd_prod + 5),	/* reserved & cksum addr */
	*((U32 *)dd_prod + 6),	/* type */
	*((U32 *)dd_prod + 7));	/* index */

    return (OK);
}

/* null routine to assist with scratchpad setup */
void q_dma_to_host_end(void) {}


U32 q_dma_to_nic(tg_hostaddr_t host_addr, U32 nic_addr, U32 len, 
                 U16 type, U16 id, U32 index, U32 state) 
{
    struct tg_dma_descr *dd_prod, *ndd_prod, *dd_cons;

    dd_prod = trp->host_dma_assist.read_chan_next; 
    if (!dd_prod ||
	((ndd_prod = get_next_rd_dma_descr(dd_prod)) ==
	     trp->host_dma_assist.read_chan_ref) ||
 	(ndd_prod == (dd_cons = trp->host_dma_assist.read_chan_consumer))) {

        nicfp->stats.nicDmaReadRingFull++; 

	NIC_TRACE(TRACE_TYPE_DMA, "QrDmaF", 0x11500, 
	    trp->host_dma_assist.read_chan_producer,
	    trp->host_dma_assist.read_chan_consumer,
	    trp->host_dma_assist.read_chan_ref,
	    nicfp->stats.nicDmaReadRingFull);

	PANIC(); // debug IAP
        return (ERROR);
    }

    dd_prod->host_addr = host_addr; 
    dd_prod->nic_addr  = nic_addr; 
    dd_prod->len       = len;
    dd_prod->type      = type;
    dd_prod->index     = index;
    dd_prod->usd_id    = id;
    dd_prod->state     = state;
    dd_prod->cksum     = (U32)dd_cons; /* only to debug dma overrun */

    trp->host_dma_assist.read_chan_producer = ndd_prod; 


    NIC_TRACE_IF(TRACE_TYPE_DMA, "QrDmaIdx", 0x11700, 
		 type, TIGON_TYPE_TX,
	(dd_prod - tdp->rd_dma_ring),
        trp->host_dma_assist.read_chan_producer,
        trp->host_dma_assist.read_chan_consumer,
        trp->host_dma_assist.read_chan_ref);

    NIC_TRACE_IF(TRACE_TYPE_DMA, "QrDmaD0", 0x11800,
		 type, TIGON_TYPE_TX,
	*(U32 *)dd_prod,	/* host addr */
	*((U32 *)dd_prod + 1),	/* host addr */
	*((U32 *)dd_prod + 2),	/* nic addr */
	*((U32 *)dd_prod + 3));	/* reserved & len */

    NIC_TRACE_IF(TRACE_TYPE_DMA, "QrDmaD1", 0x11900,
		 type, TIGON_TYPE_TX,
	*((U32 *)dd_prod + 4),	/* state */
	*((U32 *)dd_prod + 5),	/* reserved & cksum addr */
	*((U32 *)dd_prod + 6),	/* type */
	*((U32 *)dd_prod + 7));	/* index */

    return (OK);
}

/* null routine to assist with scratchpad setup */
void q_dma_to_nic_end(void) {}


void h_dma_rd_attn(void)
{
    struct tg_dma_descr *dd_cons;
    U32 dma_rd_state;
    U32 assist_state;

    dd_cons = trp->host_dma_assist.read_chan_consumer;
    dma_rd_state = trp->host_dma.dma_rd_state;
    assist_state = trp->host_dma_assist.assist_state;

    NIC_UTRACE("#rDmaATN", 0x12500,
	assist_state,
	dma_rd_state,
	trp->host_dma_assist.read_chan_producer,
	dd_cons);

    NIC_UTRACE("rDmaATN0", 0x12510,
	*(U32 *)dd_cons,	/* host addr */
	*((U32 *)dd_cons + 1),	/* host addr */
	*((U32 *)dd_cons + 2),	/* nic addr */
	*((U32 *)dd_cons + 3));	/* reserved & len */

    NIC_UTRACE("rDmaATN1", 0x12520,
	*((U32 *)dd_cons + 4),	/* state */
	*((U32 *)dd_cons + 5),	/* reserved & cksum addr */
	*((U32 *)dd_cons + 6),	/* type */
	*((U32 *)dd_cons + 7));	/* index */

    PANIC(); // IAP debug!
}

void h_dma_wr_attn(void)
{
    struct tg_dma_descr *dd_cons;
    U32 dma_wr_state;
    U32 assist_state;

    dd_cons = trp->host_dma_assist.write_chan_consumer;
    dma_wr_state = trp->host_dma.dma_wr_state;
    assist_state = trp->host_dma_assist.assist_state;

    NIC_UTRACE("#wDmaATN", 0x12600,
	assist_state,
	dma_wr_state,
	trp->host_dma_assist.write_chan_producer,
	dd_cons);

    NIC_UTRACE("wDmaATN0", 0x12610,
	*(U32 *)dd_cons,	/* host addr */
	*((U32 *)dd_cons + 1),	/* host addr */
	*((U32 *)dd_cons + 2),	/* nic addr */
	*((U32 *)dd_cons + 3));	/* reserved & len */

    NIC_UTRACE("wDmaATN1", 0x12620,
	*((U32 *)dd_cons + 4),	/* state */
	*((U32 *)dd_cons + 5),	/* reserved & cksum addr */
	*((U32 *)dd_cons + 6),	/* type */
	*((U32 *)dd_cons + 7));	/* index */

    PANIC(); // IAP debug!
}


