ANSI_CC=	${TOOLS_BASE}/bin/mips-any-elf-gcc
AS=		${TOOLS_BASE}/bin/mips-any-elf-as
ANSI_LD=	${TOOLS_BASE}/bin/mips-any-elf-ld
NM=		${TOOLS_BASE}/bin/mips-any-elf-nm
ANSI_RANLIB=	${TOOLS_BASE}/bin/mips-any-elf-ranlib
ANSI_AR=	${TOOLS_BASE}/bin/mips-any-elf-ar
SIZE=		${TOOLS_BASE}/bin/mips-any-elf-size

CNTXT_CFLAGS=	-mcpu=r4000 -mips2 -mno-abicalls -fverbose-asm -G 0 -fno-pic
CNTXT_AFLAGS=	-mips2 -G 0

STD_CFLAGS=	-Wall -Wshadow -Winline -S -mgas 
PROTO_CFLAGS=	-Wstrict-prototypes -Wmissing-prototypes \
                -Wmissing-declarations -Wredundant-decls
STD_AFLAGS=	

INCLUDES	= alt_fw2.h

GENFW       = ${SOURCEBASE}/utils/genfw.pl
GENFWFLAGS  = -ptigon2 
#-h ${SOURCEBASE}/nic/host/common/altreg.h 
#GENFWFLAGS += -r ${SOURCEBASE}/common/release.h

PROGRAMS	= alt_fw2

# IAP: changed this to O2 to avoid reordering scratchpad _end markers
OPT_LEVEL     = -O2
CDEFS		= -DSBUS=0 -DTRACE=0 -DTRACE_ALL=0 \
		-DFW_PROFILE=0 -DSCRATCH_PAD_STACK_ADJUST=1 \
                -DUSD -DSCRATCH_PAD -DRX_INT_HOLDOFF -DTX_SHAPER_SCHED

CFLAGS        := ${CDEFS} ${STD_CFLAGS} ${PROTO_CFLAGS} ${CNTXT_CFLAGS}
CFLAGS        += -DTIGON_REV=2 -fno-builtin
AFLAGS        := ${STD_AFLAGS} ${CNTXT_AFLAGS}

INCFLAGS	= -I../../../common -I../../common -I../common

GENNED_HDRS	= compile.h

_OFILES_ 	= ${OFILES}
_CC_		= ${ANSI_CC}
_CCFLAGS_	= ${OPT_LEVEL} ${CFLAGS} -DOEM_ALTEON ${INCFLAGS}
_LDFLAGS_	= ${LDFLAGS} 
_LD_		= ${ANSI_LD}
MV=mv

build_all: all

_OBJDIR_=./
compile.h:
	@echo \#define FW_VERSION \"FW_VERSION: XXX\" >> ${_OBJDIR_}.ver
	@echo \#define FW_COMPILE_TIME \"FW_COMPILE_TIME: XXX\" >> ${_OBJDIR_}.ver
	@echo \#define FW_COMPILE_BY \"FW_COMPILE_BY: XXX\" >> ${_OBJDIR_}.ver
	@echo \#define FW_COMPILE_HOST \"FW_COMPILE_HOST: XXX\" >> ${_OBJDIR_}.ver
	@echo \#define FW_COMPILE_DOMAIN \"FW_COMPILE_DOMAIN: XXX\" >> ${_OBJDIR_}.ver
	@echo \#define FW_COMPILER \"FW_COMPILER: XXX\" >> ${_OBJDIR_}.ver
	@echo \#define FW_SANDBOX \"FW_SANDBOX: XXX\" >> ${_OBJDIR_}.ver
	@mv -f ${_OBJDIR_}.ver ${_OBJDIR_}$@

