/*
 * COPYRIGHT NOTICE
 * Copyright (c) Alteon Networks, Inc. 1996, 1997 
 * All rights reserved
 * 
 */
/*
 * HISTORY
 * $Log: zconf.h,v $
 * Revision 1.4  1999/06/22 12:43:01  tjd21
 * Before removing extra recv rings
 *
 * Revision 1.1  1999/06/07 10:53:09  tjd21
 * Start of archive
 *
 * Revision 1.1.2.22  1999/01/27  19:09:48  hayes
 * 	incorporate autosense code
 * 	[1999/01/27  19:08:00  hayes]
 *
 * Revision 1.1.30.4  1999/01/06  02:07:58  hayes
 * 	checkin for merge
 * 	[1999/01/06  02:07:17  hayes]
 * 
 * 	link autosense mode now works
 * 	[1998/11/07  21:00:00  hayes]
 * 
 * Revision 1.1.2.21  1998/12/03  22:35:25  hayes
 * 	protect REMOTE_ASSERT from being defined trwice.
 * 	[1998/12/03  22:35:15  hayes]
 * 
 * Revision 1.1.2.20  1998/06/17  03:50:07  fhwang
 * 	Added saved_rx_config field to save the config data.
 * 	[1998/06/17  03:49:25  fhwang]
 * 
 * Revision 1.1.2.19  1998/01/04  23:48:12  hayes
 * 	lower restart threshhold
 * 	[1998/01/04  23:32:55  hayes]
 * 
 * 	remove idle_match_count; obsolete
 * 	[1998/01/04  02:28:31  hayes]
 * 
 * Revision 1.1.2.18  1997/10/30  02:21:17  hayes
 * 	get link negotiation working for Tigon2
 * 	[1997/10/30  02:18:16  hayes]
 * 
 * Revision 1.1.17.2  1997/10/19  19:55:47  hayes
 * 	fix NP_DATA() macro
 * 	[1997/10/19  19:53:52  hayes]
 * 
 * 	intermediate checkin
 * 	[1997/10/18  22:29:27  hayes]
 * 
 * Revision 1.1.2.17  1997/10/11  19:02:53  hayes
 * 	updated rerorting of ALTEON, NIC and JUMBO LNK_XXX bits
 * 	[1997/10/11  19:02:32  hayes]
 * 
 * Revision 1.1.2.16  1997/10/10  20:38:30  hayes
 * 	new next page code
 * 	[1997/10/10  20:36:02  hayes]
 * 
 * 	added link_conf_state_last
 * 	[1997/10/09  21:59:59  hayes]
 * 
 * Revision 1.1.2.15  1997/08/26  21:09:06  hayes
 * 	split up link files in preparation for SC changes
 * 	[1997/08/26  21:02:16  hayes]
 * 
 * Revision 1.1.2.14  1997/08/12  03:31:28  hayes
 * 	added define for NP_INFO_GOT_ACK2
 * 	[1997/08/12  03:31:01  hayes]
 * 
 * Revision 1.1.2.13  1997/08/12  02:54:01  hayes
 * 	add definitions for FRAME_SIZE_NP, add NP_INFO_TX and NP_INFO_GOT_RX
 * 	[1997/08/12  02:53:19  hayes]
 * 
 * Revision 1.1.2.12  1997/08/01  17:00:37  hayes
 * 	add extern for additional_rx_bits_wanted
 * 	[1997/08/01  17:00:26  hayes]
 * 
 * Revision 1.1.2.11  1997/07/22  23:35:59  hayes
 * 	bring ge_latest up to same revision level as r1 branch
 * 	[1997/07/22  23:28:15  hayes]
 * 
 * 	update ge_latest to r1 levels...
 * 	[1997/07/16  22:33:39  hayes]
 * 
 * Revision 1.1.5.4  1997/07/22  22:41:01  hayes
 * 	Set correct bit ordering again for config registers, the Netcom box
 * 	got it byteswapped. :-(
 * 	Added NORMAL_DATA define to convert received unformatted data back to
 * 	usable information.
 * 	[1997/07/22  22:36:45  hayes]
 * 
 * 	added define for CONFIG_BASE_REM_FAULT_NO_FAULT
 * 	[1997/07/21  02:09:44  hayes]
 * 
 * 	intermediate checkin
 * 	[1997/07/19  19:52:08  hayes]
 * 
 * Revision 1.1.5.2  1997/07/16  19:33:49  hayes
 * 	fix config bit positions
 * 	[1997/07/16  19:33:28  hayes]
 * 
 * Revision 1.1.5.1  1997/07/11  00:43:34  hayes
 * 	added up_ack2 field
 * 	[1997/07/11  00:41:55  hayes]
 * 
 * Revision 1.1.2.10  1997/07/05  00:12:34  hayes
 * 	next page functionality works
 * 	[1997/07/05  00:03:41  hayes]
 * 
 * Revision 1.1.2.9  1997/06/30  00:34:55  hayes
 * 	added defines for CONFIG_BASE_PAUSE_NONE and CONFIG_BASE_DUPLEX_MASK
 * 	[1997/06/30  00:34:41  hayes]
 * 
 * Revision 1.1.2.8  1997/06/29  21:11:20  hayes
 * 	Add bringup link defines from mac.h
 * 	[1997/06/29  21:09:58  hayes]
 * 
 * 	move LC from mac.c to link.c
 * 	[1997/06/26  21:49:32  hayes]
 * 
 * Revision 1.1.2.7  1997/06/09  17:30:14  hayes
 * 	updated link autoconfig states
 * 	[1997/06/09  17:30:04  hayes]
 * 
 * Revision 1.1.2.6  1997/05/21  03:35:34  ted
 * 	Remote assert support (for NIC)
 * 	[1997/05/21  03:00:34  ted]
 * 
 * Revision 1.1.2.5  1997/05/17  18:05:43  hayes
 * 	fix LC states again, NIC code ok
 * 	[1997/05/17  18:05:35  hayes]
 * 
 * Revision 1.1.2.4  1997/04/30  23:09:49  skapur
 * 	Added back two literals earlier removed by John to fix the
 * 	     compilation problem in mac.c STATE_LINK_CONF_TX_DISABLE &
 * 	     TX_DISABLE_THRESHOLD
 * 	[1997/04/30  23:09:22  skapur]
 * 
 * Revision 1.1.2.3  1997/04/30  20:05:47  hayes
 * 	change bit orderings for config characters
 * 	[1997/04/30  20:03:20  hayes]
 * 
 * Revision 1.1.2.2  1997/04/15  21:00:58  hayes
 * 	added LINK_FLAP_THRESHHOLD
 * 	[1997/04/15  21:00:35  hayes]
 * 
 * Revision 1.1.2.1  1997/04/15  05:47:00  hayes
 * 	Initial checkin of defines for the gigabit autonegotiation stae
 * 	machine and config registers.
 * 	[1997/04/15  05:46:09  hayes]
 * 
 * $EndLog$
 */

#ifndef _ZCONF_H_
#define _ZCONF_H_

/*
 * data structure for our autonegotiation state machine
 */

typedef struct zconf_state {
    U32 link_conf_state;
    U32 link_conf_last_state;
    U32 link_cfg_count;
    U32 rx_config_last;
    U32 rx_match_ability_count;
    U32 rx_match_acknowledge_count;
    U32 rx_config_count;
    U32 rx_toggle;
    U32 tx_toggle;
    U32 link_conf_timer;
    U32 restart_count;
    U32 ack_detect_count;
    U32 ability_match;
    U32 acknowledge_match;
    U32 consistency_match_value;
    U32 mr_base_page;
    U32 idle_match;

    U32 alt_np_state;
    U32 alt_next_page;
    U32 alt_base_page;
    U32 last_tx_config;
    U32 rx_rem_error;
    U32 tx_rem_error;
    U32 saved_rx_config;/* workaround bug in T2/R6/INT SERDES */
} zconf_state_t;

extern zconf_state_t zs;

/*
 * Config register base page values from 802.3z 
 * section 37.2.1.2
 *
 * Tigon config register bits are numbered as follows:
 *
 *   +--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
 *   | 7| 6| 5| 4| 3| 2| 1| 0|15|14|13|12|11|10| 9| 8|
 *   +--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
 *
 */

#define CONFIG_BASE_FD		0x2000	/* D5 */
#define CONFIG_BASE_HD		0x4000	/* D6 */
#define CONFIG_BASE_PS1		0x8000	/* D7 */
#define CONFIG_BASE_PS2		0x0001	/* D8 */
#define CONFIG_BASE_RF1		0x0010	/* D12 */
#define CONFIG_BASE_RF2		0x0020	/* D13 */
#define CONFIG_BASE_ACK		0x0040	/* D14 */
#define CONFIG_BASE_NP		0x0080	/* D15 */


/*
 * aggregate encodings...
 */
#define CONFIG_BASE_REM_FAULT_NO_FAULT	0
#define CONFIG_BASE_REM_FAULT_OFFLINE	CONFIG_BASE_RF2
#define CONFIG_BASE_REM_FAULT_LINK_FAIL	CONFIG_BASE_RF1
#define CONFIG_BASE_REM_FAULT_CONFIG_ERR \
	(CONFIG_BASE_RF1 | CONFIG_BASE_RF2)
#define CONFIG_BASE_REM_FAULT_MASK      (CONFIG_BASE_RF1 | CONFIG_BASE_RF2)

#define CONFIG_BASE_PAUSE_MASK		(CONFIG_BASE_PS1 | CONFIG_BASE_PS2)
#define CONFIG_BASE_PAUSE_NONE		0
#define CONFIG_BASE_PAUSE_SYM		CONFIG_BASE_PS1
#define CONFIG_BASE_PAUSE_ASYM_REMOTE	CONFIG_BASE_PS2
#define CONFIG_BASE_PAUSE_ASYM_LOCAL	(CONFIG_BASE_PS1 | CONFIG_BASE_PS2)

#define CONFIG_BASE_DUPLEX_MASK		(CONFIG_BASE_FD | CONFIG_BASE_HD)

#if !defined(CONFIG_BASE_REMOTE_ASSERT)
/*
 * special code for Alteon remote assert processing
 */
#define CONFIG_BASE_REMOTE_ASSERT	0x1402
#endif /* !defined(CONFIG_BASE_REMOTE_ASSERT) */

/*
 * Config register next page values from 802.3z
 * section 37.2.3.3.1
 *
 * Tigon config register bits are numbered as follows:
 *
 *   +--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
 *   | 7| 6| 5| 4| 3| 2| 1| 0|15|14|13|12|11|10| 9| 8|
 *   +--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
 *
 */

#define CONFIG_NP_T		0x0008	/* D11 */
#define CONFIG_NP_ACK2	    	0x0010	/* D12 */
#define CONFIG_NP_MP		0x0020	/* D13 */
#define CONFIG_NP_ACK		0x0040	/* D14 */
#define CONFIG_NP_NP		0x0080	/* D15 */

#define CONFIG_NP_MASK ~(CONFIG_NP_ACK2 | \
    CONFIG_NP_MP | CONFIG_NP_ACK | CONFIG_NP_NP)

#define CONFIG_NP_DATA_MASK ~(CONFIG_NP_T | CONFIG_NP_ACK2 | \
    CONFIG_NP_MP | CONFIG_NP_ACK | CONFIG_NP_NP)

/*
 * take low order 11 bits and place in proper position in
 * unformatted message, Note bit locations above...
 */
#define NP_DATA(x) (((x & 0x00ff) << 8) | ((x & 0x0700) >> 8))
#define NORMAL_DATA(x) (((x & 0xff00) >> 8) | ((x & 0x0007) << 8))

/* 
 * definitions for formatted next page messages
 * See 802.3u Annex 28c for more details.
 */
#define CONFIG_NP_NULL			NP_DATA(1)
#define CONFIG_NP_UP1			NP_DATA(2)
#define CONFIG_NP_UP2			NP_DATA(3)
#define CONFIG_NP_REM_FAULT_UP1		NP_DATA(4)
#define CONFIG_NP_OUI_UP4		NP_DATA(5)
#define CONFIG_NP_PHY_TAG_UP4		NP_DATA(6)

typedef struct np_oui_info {
    U32 type;		/* type so I don't have to interpret the UPs */
    U32 tx_index;	/* tx index into the data array */
    U32 rx_index;	/* rx index into the data array */
    U32 data[4];	/* the OUI data */
    U32 flags;		
#define NP_INFO_TX		0x0001	/* send this next page */
#define NP_INFO_ACK2		0x0002	/* acknowledge this next page */
#define NP_INFO_DONE		0x0004	/* we're done */
#define NP_INFO_GOT_RX		0x0008	/* we received this page */
#define NP_INFO_GOT_ACK2	0x0010	/* we received an ACK2 for this */
#define NP_INFO_GOT_EARLY_ACK2	0x0020	/* we received an early ACK2 for this */
} np_oui_info_t;

/*
 * states in the autonegotiation state machine from 802.3z
 * section 37.3.3
 */

#define STATE_LINK_CONF_AUTONEG_ENABLE		1
#define STATE_LINK_CONF_RESTART_INIT 		2
#define STATE_LINK_CONF_RESTART			3
#define STATE_LINK_CONF_ABILITY_DETECT_INIT	4
#define STATE_LINK_CONF_ABILITY_DETECT		5
#define STATE_LINK_CONF_ACK_DETECT_INIT		6
#define STATE_LINK_CONF_ACK_DETECT		7
#define STATE_LINK_CONF_COMPLETE_ACK_INIT	8
#define STATE_LINK_CONF_COMPLETE_ACK		9
#define STATE_LINK_CONF_NEXT_PAGE_WAIT_INIT	10
#define STATE_LINK_CONF_NEXT_PAGE_WAIT		11
#define STATE_LINK_CONF_IDLE_DETECT_INIT	12
#define STATE_LINK_CONF_IDLE_DETECT		13
#define STATE_LINK_CONF_LINK_OK			14

/*
 * parameters for the state machine
 */
#define LINK_CONF_EXPIRE		3	
#define LINK_CODE_MATCH_COUNT		3
#define LINK_CODE_NO_MATCH_THRESHHOLD	20
#define RESTART_THRESHHOLD		3
#define ACK_DETECT_THRESHHOLD		20
#define LINK_FLAP_THRESHHOLD		10000

/* LC related externs */

extern U32 gig_negotiate;
extern U32 gig_negotiate_options;
extern U32 gig_negotiate_fctl;

extern U32 link_partner_alteon;
extern U32 link_partner_jumbo;
extern U32 link_partner_nic;
extern U32 link_sense_mode;
extern U32 link_sense_count;
extern U32 link_sense_countdown;

/* forward declarations */
void autoneg_8023z(U32 rx_state);
 
/* link related externs */

#endif /* _ZCONF_H_ */
