/*
 * COPYRIGHT NOTICE
 * Copyright (c) Alteon Networks, Inc. 1996
 * All rights reserved
 */
/*
 * HISTORY
 * $Log: tg.h,v $
 * Revision 1.5  1999/09/24 11:16:36  iap10
 * *** empty log message ***
 *
 * Revision 1.4  1999/06/22 12:43:01  tjd21
 * Before removing extra recv rings
 *
 * Revision 1.1  1999/06/07 10:53:09  tjd21
 * Start of archive
 *
 * Revision 1.1.6.70  1998/10/13  03:33:16  ted
 * 	Support Mini ring, compiles on Solaris
 * 	[1998/10/13  03:30:50  ted]
 *
 * Revision 1.1.6.69  1998/09/28  18:33:43  hayes
 * 	fix pciClass for little endian machines too...
 * 	[1998/09/28  18:33:33  hayes]
 * 
 * Revision 1.1.6.68  1998/09/12  19:48:25  wayne
 * 	Add comments that EVENT_SW0 cannot change; see libhw_api.h
 * 	[1998/09/12  19:46:08  wayne]
 * 
 * Revision 1.1.6.67  1998/09/02  21:00:28  ted
 * 	Add other mailboxes into publicly available section
 * 	[1998/09/02  20:51:15  ted]
 * 
 * Revision 1.1.6.66  1998/06/23  00:29:38  shuang
 * 	moved tigon revision definitions to tg_rev.h
 * 	[1998/06/23  00:25:01  shuang]
 * 
 * Revision 1.1.6.65  1998/06/16  16:45:22  ted
 * 	NT initialization cleanup/rewrite
 * 	[1998/06/16  16:42:44  ted]
 * 
 * Revision 1.1.6.64  1998/05/18  20:09:17  ted
 * 	Make TG_PCI_STATE_DMA_WR_ALL_ALIGN bit public
 * 	[1998/05/18  19:59:47  ted]
 * 
 * Revision 1.1.6.63  1998/04/11  20:04:05  wayne
 * 	Teach SUN_MP about TG_STACK_START_B for REV5
 * 	[1998/04/11  19:55:18  wayne]
 * 
 * Revision 1.1.6.62  1998/04/11  05:14:56  shuang
 * 	swap TG_FW_EVENT_NUM_XXX between TIGON_REV5 and !TIGON_REV5
 * 	[1998/04/11  04:54:20  shuang]
 * 
 * Revision 1.1.6.61  1998/03/28  00:53:13  shuang
 * 	Replace hard coded size of stack_page_align_padding[]
 * 	[1998/03/28  00:43:37  shuang]
 * 
 * Revision 1.1.6.60  1998/03/26  01:34:14  shuang
 * 	Added optional stack_page_align_padding[] in tg_data structure
 * 	[1998/03/26  01:06:56  shuang]
 * 
 * Revision 1.1.6.59  1998/03/09  18:47:31  hayes
 * 	remove pre-rev4 defines, make TAG_MASK visible
 * 	[1998/03/09  18:47:22  hayes]
 * 
 * Revision 1.1.6.58  1998/02/24  17:41:43  shuang
 * 	Modified mac_rx_mcast_filt[1234] fields with alias
 * 	[1998/02/24  17:30:43  shuang]
 * 
 * Revision 1.1.6.57  1998/01/28  21:27:51  hayes
 * 	add stack redzone area
 * 	[1998/01/28  21:24:34  hayes]
 * 
 * Revision 1.1.6.56  1998/01/24  04:06:39  venkat
 * 	added a shifting constant used in window manipulation
 * 	[1998/01/24  04:06:08  venkat]
 * 
 * Revision 1.1.6.55  1998/01/20  04:39:18  hayes
 * 	add tigon Rev6 support
 * 	[1998/01/20  04:37:10  hayes]
 * 
 * Revision 1.1.6.54  1998/01/07  18:49:05  ted
 * 	change class in tg_pci_conf to pciClass to avoid C++ reserved word
 * 	[1998/01/07  18:48:55  ted]
 * 
 * Revision 1.1.6.53  1998/01/06  20:03:51  ted
 * 	Fix public-only version of tg_mac_control
 * 	[1998/01/06  20:03:36  ted]
 * 
 * Revision 1.1.6.52  1997/12/19  07:21:48  hayes
 * 	add pci subsystem id and subsystem vendor id
 * 	[1997/12/19  07:21:32  hayes]
 * 
 * Revision 1.1.6.51  1997/11/25  23:59:18  ted
 * 	Fix overzealous public_only problem
 * 	[1997/11/25  23:59:09  ted]
 * 
 * Revision 1.1.6.50  1997/11/25  22:06:53  ted
 * 	Merged with changes from 1.1.6.49
 * 	[1997/11/25  22:06:37  ted]
 * 
 * 	Rearrange public only areas
 * 	[1997/11/25  21:57:21  ted]
 * 
 * Revision 1.1.6.49  1997/11/24  19:23:33  taylor
 * 	Rev6: disabled rev5 workarounds for rev6
 * 	[1997/11/24  19:22:52  taylor]
 * 
 * Revision 1.1.6.48  1997/11/19  19:22:08  ted
 * 	Support Tigon and Tigon2 in the same driver
 * 	[1997/11/19  19:15:08  ted]
 * 
 * Revision 1.1.6.47  1997/11/18  19:18:44  hayes
 * 	fix MISC bit change
 * 	[1997/11/18  19:18:32  hayes]
 * 
 * Revision 1.1.6.46  1997/11/18  01:33:48  hayes
 * 	swap definitions of MISC_0 and MISC_1 bits in Misc Local Control
 * 	register.
 * 	[1997/11/18  01:29:26  hayes]
 * 
 * Revision 1.1.6.45  1997/11/14  17:58:25  kyung
 * 	Rev5: fixed macstats layout
 * 	[1997/11/14  17:57:17  kyung]
 * 
 * Revision 1.1.6.44  1997/11/09  23:27:23  hayes
 * 	change name of LINK_READY bit to LINK_POLARITY
 * 	[1997/11/09  23:25:16  hayes]
 * 
 * Revision 1.1.6.43  1997/10/28  18:35:48  hayes
 * 	Remove bogus #defines...
 * 	[1997/10/28  18:35:16  hayes]
 * 
 * Revision 1.1.6.42  1997/10/27  23:13:17  taylor
 * 	Merged with changes from 1.1.6.41
 * 	[1997/10/27  23:12:59  taylor]
 * 
 * 	SLB: implemented web request redirection
 * 	[1997/10/27  23:09:12  taylor]
 * 
 * Revision 1.1.6.41  1997/10/27  22:59:53  hayes
 * 	Merged with changes from 1.1.6.40
 * 	[1997/10/27  22:59:40  hayes]
 * 
 * 	change TG_DATA_END for Tigon 2
 * 	[1997/10/27  22:58:31  hayes]
 * 
 * Revision 1.1.6.40  1997/10/24  02:22:28  taylor
 * 	SLB: additional hot-standby (failover) work
 * 	[1997/10/24  02:17:26  taylor]
 * 
 * Revision 1.1.6.39  1997/10/22  21:13:30  hayes
 * 	Fix up REV5 defines to work when both REV4 and REV5 are defined.
 * 	Add hack to support scratch pad access on second CPU via gdb.
 * 	[1997/10/22  21:13:15  hayes]
 * 
 * Revision 1.1.6.38  1997/10/21  00:56:13  ted
 * 	Add instruction cache flush bit to CPU_STATE bit definitions
 * 	[1997/10/21  00:56:02  ted]
 * 
 * Revision 1.1.6.37  1997/10/16  23:42:04  hayes
 * 	cleanup REV4 Tigon defines
 * 	[1997/10/16  23:40:14  hayes]
 * 
 * Revision 1.1.6.36  1997/10/11  16:57:03  hayes
 * 	fixed up public definitions so that pub_tg.h works for HOST code
 * 	[1997/10/11  16:56:10  hayes]
 * 
 * Revision 1.1.6.35  1997/10/10  20:33:17  hayes
 * 	fix compiler warnings, cleanup board dependant defines
 * 	[1997/10/10  20:32:25  hayes]
 * 
 * Revision 1.1.6.34  1997/10/10  08:43:40  tibor
 * 	need to keep LADDR def
 * 	[1997/10/10  08:43:22  tibor]
 * 
 * Revision 1.1.6.33  1997/10/10  06:37:51  tibor
 * 	changed misc-bits define names for rev5
 * 	[1997/10/10  06:24:00  tibor]
 * 
 * Revision 1.1.6.32  1997/09/12  01:46:30  taylor
 * 	For Rev5: TG_END_SRAM and TG_DATA_END now 0x800000
 * 	[1997/09/12  01:33:53  taylor]
 * 
 * Revision 1.1.6.31  1997/09/08  21:39:09  hayes
 * 	add definitions for mac_serdes_config regisater
 * 	[1997/09/08  21:38:55  hayes]
 * 
 * 	Added defines for rev5 tx mac descrs
 * 	[1997/09/05  01:15:46  taylor]
 * 
 * Revision 1.1.6.30  1997/09/05  01:17:14  taylor
 * 	Added defines for rev5 tx mac descrs
 * 
 * Revision 1.1.6.29  1997/08/15  23:51:51  taylor
 * 	Changed TG_MAC_TX_STATE_ENA_BUF_CMP to TG_MAC_TX_STATE_DIS_BUF_CMP
 * 	[1997/08/15  18:40:49  taylor]
 * 
 * Revision 1.1.6.28  1997/07/25  19:08:29  taylor
 * 	Tigon rev5 support
 * 	[1997/07/25  18:49:01  taylor]
 * 
 * Revision 1.1.6.27  1997/07/19  20:39:22  ted
 * 	Remove #error pragma because cppp doesn't understand it.
 * 	[1997/07/19  20:39:10  ted]
 * 
 * Revision 1.1.6.26  1997/07/18  17:14:25  tibor
 * 	Another off by 12 byte problem
 * 	[1997/07/18  17:14:02  tibor]
 * 
 * Revision 1.1.6.25  1997/07/18  02:38:28  tibor
 * 	Removed extra ifdef
 * 	[1997/07/18  02:38:02  tibor]
 * 
 * Revision 1.1.6.24  1997/07/18  00:08:17  tibor
 * 	Merged with changes from 1.1.6.23
 * 	[1997/07/18  00:08:05  tibor]
 * 
 * 	TIGON_REV4/5 mods by skapur
 * 	[1997/07/18  00:00:26  tibor]
 * 
 * Revision 1.1.6.23  1997/07/09  19:32:31  skapur
 * 	Changed the mac_control structure; the element mac_mcast_addr is
 * 	     changed to mac_mcast_filter; In addition to changing the name, its
 * 	     type is changed from tg_macaddr_t to U32. The reserved_1 filed is
 * 	     appropriatly adjusted.
 * 	[1997/07/09  19:30:39  skapur]
 * 
 * Revision 1.1.6.22  1997/06/03  01:35:04  davis
 * 	Added cpu_priority defines.
 * 	[1997/06/03  01:34:02  davis]
 * 
 * Revision 1.1.6.21  1997/05/21  16:37:23  ted
 * 	Got carried away with #ifdefing.  Sorry switch guys.
 * 	[1997/05/21  16:37:11  ted]
 * 
 * Revision 1.1.6.20  1997/05/21  03:35:32  ted
 * 	Publification of tg.h
 * 	[1997/05/21  02:59:50  ted]
 * 
 * Revision 1.1.6.19  1997/04/25  23:59:15  hayes
 * 	fix VOLATILE definitions properly this time...
 * 	[1997/04/25  23:58:19  hayes]
 * 
 * Revision 1.1.6.18  1997/04/25  22:19:24  hayes
 * 	Changed any registers that have a hardware wrap to VOLATILE since a hardware
 * 	wrap is a change to the value without the compiler knowing about it.
 * 	[1997/04/25  22:19:15  hayes]
 * 
 * Revision 1.1.6.17  1997/04/19  23:25:26  wayne
 * 	Add #defines for CPU_WATCHDOG_ENA bit and watchdog_clear register
 * 	[1997/04/19  23:25:20  wayne]
 * 
 * Revision 1.1.6.16  1997/04/15  05:46:54  hayes
 * 	Removed old link negotiation defines, they are now in the new file
 * 	zconf.h along with the other defines for running the gigabit
 * 	autoconfiguration state machine.
 * 	[1997/04/15  05:45:31  hayes]
 * 
 * Revision 1.1.6.15  1997/04/09  22:54:54  davis
 * 	Added threshold defines and mac_threshold register to mac_control.
 * 	[1997/04/09  22:39:46  davis]
 * 
 * Revision 1.1.6.14  1997/04/03  23:24:14  hayes
 * 	replace the status/command union...
 * 	[1997/04/03  23:24:02  hayes]
 * 
 * Revision 1.1.6.13  1997/04/03  22:33:15  ted
 * 	Under duress, I have built the pci_config to be different depending on
 * 	the way the ALT_BIG_ENDIAN define is set.  Sigh.
 * 	[1997/04/03  22:32:59  ted]
 * 
 * Revision 1.1.6.12  1997/04/03  22:05:25  ted
 * 	Really fix pci_config structure (still need to update the equivalent
 * 	#defines, but this requires coordination with the software).
 * 	[1997/04/03  22:05:05  ted]
 * 
 * Revision 1.1.6.11  1997/03/28  02:46:48  skapur
 * 	Added TG_DMA_STATE_UPDATE_TX_BUF_PROD bit definition and corrected the address for DMA ASSIST READ/WRITE HI/LO Addresses at the bottom of the file
 * 	[1997/03/28  02:35:36  skapur]
 * 
 * Revision 1.1.6.10  1997/03/27  22:18:28  hayes
 * 	fixed pci_conf region, added rom_base
 * 	[1997/03/27  22:07:41  hayes]
 * 
 * Revision 1.1.6.9  1997/03/25  23:51:33  ted
 * 	New defines for scratch pad area.
 * 	[1997/03/25  23:21:31  ted]
 * 
 * Revision 1.1.6.8  1997/03/19  16:44:28  wayne
 * 	Changed some TG_DMA_STATE defines for tigon rev.
 * 	[1997/03/19  16:05:15  wayne]
 * 
 * Revision 1.1.6.7  1997/03/16  20:28:30  hayes
 * 	added mac_stats
 * 	[1997/03/16  20:28:19  hayes]
 * 
 * Revision 1.1.6.6  1997/03/12  18:03:06  hayes
 * 	Added TG_MLC_UART_MASK
 * 	[1997/03/12  18:02:50  hayes]
 * 
 * Revision 1.1.6.5  1997/03/08  21:00:43  wayne
 * 	Merged with changes from 1.1.6.4
 * 	[1997/03/08  21:00:34  wayne]
 * 
 * 	Updated several DMA_STATE bits and MAC_RX bits.
 * 	[1997/03/08  20:09:22  wayne]
 * 
 * 	Added MAC_RX_STATE bits (0x00600000).
 * 	[1997/03/06  22:59:03  wayne]
 * 
 * Revision 1.1.6.4  1997/03/07  23:48:41  hayes
 * 	Added define for TG_MLC_SER_EEPROM_MASK
 * 	[1997/03/07  23:48:30  hayes]
 * 
 * Revision 1.1.6.3  1997/03/02  18:36:41  ted
 * 	redundancy support and a few bug fixes
 * 	[1997/03/02  18:25:26  ted]
 * 
 * Revision 1.1.6.2  1997/02/28  22:59:04  ted
 * 	Change parallel EEPROM accesses to flash accesses
 * 	[1997/02/28  22:58:53  ted]
 * 
 * Revision 1.1.6.1  1997/02/11  04:08:02  ted
 * 	Add missing define
 * 	[1997/02/11  03:58:29  ted]
 * 
 * 	Change some addresses for internal hardware locations used by gdb support
 * 	code.
 * 	[1997/02/08  22:23:55  ted]
 * 
 * 	Play with starting addresses of various hardware components (mostly for
 * 	gdb support).
 * 	[1997/02/08  22:21:19  ted]
 * 
 * Revision 1.1.2.17  1997/02/01  17:04:31  wayne
 * 	SUN_MP debug: Define non-hardware-oriented TRP, TSP, and TDP
 * 	[1997/02/01  16:52:30  wayne]
 * 
 * Revision 1.1.2.16  1997/01/11  22:52:22  ted
 * 	Change order of byte stuff in pci_config area to be correct.
 * 	[1997/01/11  22:51:58  ted]
 * 
 * Revision 1.1.2.15  1996/12/22  01:54:32  hayes
 * 	Change the TG_DMA_STATE_OVRIDE_BYTE_ALIGN bit definition
 * 	to TG_DMA_STATE_FORCE_32_BIT.  The reflects the current state of the
 * 	tigon.  ASYNC has been gone since RR days...
 * 	Add define for TG_PCI_STATE_USE_32_BITS_ONLY to allow override of
 * 	64 bit wide systems.
 * 	[1996/12/22  01:54:21  hayes]
 * 
 * Revision 1.1.2.14  1996/12/20  03:07:08  hayes
 * 	Added reserved area to tg_regs region.  It is now an accurate
 * 	reflection of the Tigon ASIC.
 * 	Added more meaningful defined for DMA_STATE_THRESH_XXX for
 * 	what he threshholds actually are.
 * 	[1996/12/20  03:06:58  hayes]
 * 
 * Revision 1.1.2.13  1996/12/17  00:01:31  hayes
 * 	Added DMA_ASSIST defines for SHORT and MINI descriptors and also for
 * 	CHAINED assist rings.
 * 	[1996/12/16  23:57:19  hayes]
 * 
 * Revision 1.1.2.12  1996/12/16  18:51:21  hayes
 * 	Move write_chan_xxx to proper place for CHAINED descriptors, add
 * 	prod, cons and ref pointers for unused DMA rings, so they can be
 * 	initialized properly even though they are unused in the CHAINED
 * 	case.
 * 	[1996/12/16  18:50:20  hayes]
 * 
 * Revision 1.1.2.11  1996/11/29  22:31:37  hayes
 * 	Merged with changes from 1.1.2.10
 * 	[1996/11/29  22:31:30  hayes]
 * 
 * 	Merge back into tg.h.
 * 	[1996/11/29  22:29:41  hayes]
 * 
 * Revision 1.1.2.10  1996/11/29  20:03:39  skapur
 * 	Merged with changes from 1.1.2.9
 * 	[1996/11/29  20:03:33  skapur]
 * 
 * 	updated the dma descriptor structure to match with Tigon HW
 * 	[1996/11/29  20:01:04  skapur]
 * 
 * 	Fixed len and cksum fields in the tgDmaDescr_t structure.
 * 	[1996/11/26  21:51:59  skapur]
 * 
 * Revision 1.1.2.9  1996/11/29  17:43:14  hayes
 * 	Reordered hardware specific structures in TDP.  Removed uar TX and RX
 * 	buffers, there are no longer gaps in high memory, so we don't have to
 * 	fill them.  Uart TX and RX buffers can be places elsewhere.
 * 	[1996/11/29  17:33:22  hayes]
 * 
 * Revision 1.1.2.9  1996/11/29  17:43:14  hayes
 * 	Reordered hardware specific structures in TDP.  Removed uar TX and RX
 * 	buffers, there are no longer gaps in high memory, so we don't have to
 * 	fill them.  Uart TX and RX buffers can be places elsewhere.
 * 	[1996/11/29  17:33:22  hayes]
 * 
 * Revision 1.1.2.8  1996/11/25  22:50:05  davis
 * 	Modified TG_DMA_ASSIST_DESCRS calculation to use TG_DMA_DESCR_CHAINED.
 * 	[1996/11/25  22:41:52  davis]
 * 
 * Revision 1.1.2.7  1996/11/20  20:04:03  ted
 * 	Merged with changes from 1.1.2.6
 * 	[1996/11/20  20:03:48  ted]
 * 
 * 	Minor prettification.
 * 	Change a few EEPROM related flag defines to match tg.h changes I'd made
 * 	when tg.h lived in nic/common.
 * 	[1996/11/20  19:44:36  ted]
 * 
 * Revision 1.1.2.6  1996/11/20  19:40:22  wayne
 * 	Redefine word 3 of mini-format DMA descriptor as union
 * 	[1996/11/20  19:40:08  wayne]
 * 
 * Revision 1.1.2.10  1996/11/29  20:03:39  skapur
 * 	Merged with changes from 1.1.2.9
 * 	[1996/11/29  20:03:33  skapur]
 * 
 * 	updated the dma descriptor structure to match with Tigon HW
 * 	[1996/11/29  20:01:04  skapur]
 * 
 * 	Fixed len and cksum fields in the tgDmaDescr_t structure.
 * 	[1996/11/26  21:51:59  skapur]
 * 
 * Revision 1.1.2.9  1996/11/29  17:43:14  hayes
 * 	Reordered hardware specific structures in TDP.  Removed uar TX and RX
 * 	buffers, there are no longer gaps in high memory, so we don't have to
 * 	fill them.  Uart TX and RX buffers can be places elsewhere.
 * 	[1996/11/29  17:33:22  hayes]
 * 
 * Revision 1.1.2.9  1996/11/29  17:43:14  hayes
 * 	Reordered hardware specific structures in TDP.  Removed uar TX and RX
 * 	buffers, there are no longer gaps in high memory, so we don't have to
 * 	fill them.  Uart TX and RX buffers can be places elsewhere.
 * 	[1996/11/29  17:33:22  hayes]
 * 
 * Revision 1.1.2.8  1996/11/25  22:50:05  davis
 * 	Modified TG_DMA_ASSIST_DESCRS calculation to use TG_DMA_DESCR_CHAINED.
 * 	[1996/11/25  22:41:52  davis]
 * 
 * Revision 1.1.2.7  1996/11/20  20:04:03  ted
 * 	Merged with changes from 1.1.2.6
 * 	[1996/11/20  20:03:48  ted]
 * 
 * 	Minor prettification.
 * 	Change a few EEPROM related flag defines to match tg.h changes I'd made
 * 	when tg.h lived in nic/common.
 * 	[1996/11/20  19:44:36  ted]
 * 
 * Revision 1.1.2.6  1996/11/20  19:40:22  wayne
 * 	Redefine word 3 of mini-format DMA descriptor as union
 * 	[1996/11/20  19:40:08  wayne]
 * 
 * Revision 1.1.2.5  1996/11/15  04:23:54  hayes
 * 	Fix TG_CHAINED_DESCRS area; rings still swapped.
 * 	[1996/11/15  04:09:12  hayes]
 * 
 * Revision 1.1.2.4  1996/11/13  01:07:10  hayes
 * 	More changes to make things work... :-)
 * 	[1996/11/13  01:07:00  hayes]
 * 
 * Revision 1.1.2.3  1996/11/13  00:36:18  wayne
 * 	Finally got one that builds...
 * 	[1996/11/13  00:11:14  wayne]
 * 
 * Revision 1.1.2.2  1996/11/12  21:44:42  wayne
 * 	Updated with new structure etc etc etc
 * 	[1996/11/12  21:44:31  wayne]
 * 
 * Revision 1.1.2.1  1996/11/11  23:43:39  skapur
 * 	Moving tg.h from src/nic/common to /src/common
 * 	[1996/11/11  23:42:27  skapur]
 * 
 * Revision 1.7.2.2  1996/11/05  00:04:19  ted
 * 	Correct spello for TG_CPU_BAD_MEM_ALIGN
 * 	Delete unused TG_ASSIST_BASE
 * 	Add a second MCAST address to mac area
 * 	Redo mailbox region (for 8 byte mailboxes and new addressing)
 * 	Add memory window size #define
 * 	[1996/11/05  00:03:25  ted]
 * 
 * Revision 1.7.2.1  1996/10/31  22:04:05  ted
 * 	Add PCI_STATE masks and shift values
 * 	[1996/10/30  19:05:24  ted]
 * 
 * 	Add copyright notice and history
 * 	Add and correct Tigon hardware info
 * 	[1996/10/30  00:49:20  ted]
 * 
 * $EndLog$
 */

/*
 * FILE tg.h
 *
 * COPYRIGHT (c) Essential Communication Corp. 1995
 * $Source: /Nfs/bescot/usr29/kaf24/development/usd/alteon_changes_12.3.10/src/common/RCS/tg.h,v $
 */

#ifndef _TG_H_
#define _TG_H_

#include "tg_rev.h"	/* tigon revisions */

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/*
 *  This file defines the Tigon hardware -- basically a #includable manual.
 *
 *  It requires previous inclusion of alt_def.h as well as the following
 *  defines and #typedefs, which are typically defined in xx_conf.h files:
 */

#if !defined(PUBLIC_ONLY)
/*  #defines:
 *
 * PLEASE NOTE:
 *       The literal TIGON_REV represents the tigon versions for which the code
 * 	 is being compiled. This is a bit mask, where by one bit representing
 *       a rev. For instance bit 0 represents rev4, bit 1 represents rev5 and 
 *       so on. Therefore, multiple bits may be set in order to deal with 
 *       multiple revs. This is necessary for NIC Drivers. Therefore, 
 *       the need to have a bit representing each rev.
 *
 *    TIGON_REV	    	    1 if the code is expected to run on Tigon Rev4 
 *    			    2 if the code is expected to run on Tigon Rev5 
 *			    3 if the code is expected to run on both rev4 & rev5
 *
 *    TG_DMA_DESCR_CHAINED  1 if single chained DMA descriptor ring,
 *                          0 if separate HI/LOW rings
 *
 *    TG_DMA_DESCR_FMT      1 to use the LONG DMA descriptor format,
 *                          2 to use the SHORT DMA descriptor format,
 *                          3 to use the MINI DMA descriptor format
 *
 *    TG_RX_BUF_SIZE        size of MAC receive buffer in bytes
 *                          must be a multiple of 4K.
 *
 *    TG_TX_BUF_SIZE        size of MAC transmit buffer in bytes
 *                          must be a multiple of 4K.
 */
#endif /* !defined(PUBLIC_ONLY) */

/*  typedefs:
 *
 *    tg_gencom_t      512-byte general communications area
 *
 *    tg_hostaddr_t    64-bit host address for long-form DMA descriptors
 *                     [only referenced if TG_DMA_DESCR_FMT is LONG]
 *
 *    tg_macaddr_t     MAC address (how 48 bits appear in 64-bit field)
 *
 *    tg_mbox_t        mailbox format, probably U32[2] or U64
 */
#if !defined(PUBLIC_ONLY)
/*
 * The memory map on a Tigon looks like the following, assuming a
 * logical address space of 2MBytes (21 address lines):
 *
 *   +-----------------+  0x00000000
 *   |  shared memory  |               defined below as tg_shmem_t
 *   +-----------------+  0x00000400   pointed to by TSP
 *   |      text       |
 *   +-----------------+
 *   |       bss       |
 *   +-----------------+ 
 *   ~                 ~
 *   +-----------------+\  TG_DATA_START
 *   |      stack      | \
 *   +-----------------+  \TG_STACK_START (satck grows down)
 *   |  MAX TX descrs  |   \
 *   +-----------------+    \
 *   |  MAC RX descrs  |     \         defined below as tg_data_t,
 *   +-----------------+     /         pointed to by TDP 
 *   |DMA assist rings |    /
 *   +-----------------+   /
 *   |  MAC TX buffer  |  /
 *   +-----------------+ /
 *   |  MAC RX buffer  |/
 *   +-----------------+  0x00200000 (end of 2M memory)
 *   ~                 ~
 *   +-----------------+  0xc0000000
 *   |    registers    |               defined below as tg_regs_t,
 *   +-----------------+               pointed to by TRP
 */
#endif /* !defined(PUBLIC_ONLY) */


/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/*
 *                               REGISTERS
 */
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/*
 *                       PCI CONFIGURATION REGISTERS
 */
typedef struct tg_pci_conf {
#if ALT_BIG_ENDIAN
    U16 device_id;
    U16 vendor_id;
    union {
        struct {
            U16 status;
            U16 command;
        } st_cmd;
        U32 status_command;             /* see PCI_CONF_CMD_XXXX below */
    } un;
    U8  pciClass[3];		/* class is a C++ reserved word */
    U8  revision;
    U8  bist;                           /* see BIST_XXXX below */
    U8  header_type;
    U8  latency_timer;
    U8  cache_line_size;
    U32 shared_mem_base;
    U32 reserved_0[6];
    U16 subsystem_id;
    U16 subsystem_vendor_id;
    U32 rom_base;
    U32 reserved_1[2];
    U8  max_latency;
    U8  min_grant;
    U8  interrupt_pin;
    U8  interrupt_line;
#else /* ALT_BIG_ENDIAN */
    U16 vendor_id;
    U16 device_id;
    union {
        struct {
            U16 command;
            U16 status;
        } st_cmd;
        U32 status_command;             /* see PCI_CONF_CMD_XXXX below */
    } un;
    U8  revision;
    U8  pciClass[3];		/* class is a C++ reserved word */
    U8  cache_line_size;
    U8  latency_timer;
    U8  header_type;
    U8  bist;                           /* see BIST_XXXX below */
    U32 shared_mem_base;
    U32 reserved_0[6];
    U16 subsystem_vendor_id;
    U16 subsystem_id;
    U32 rom_base;
    U32 reserved_1[2];
    U8  interrupt_line;
    U8  interrupt_pin;
    U8  min_grant;
    U8  max_latency;
#endif /* ALT_BIG_ENDIAN */
} tgPciConf_t;

#define PCI_CONF_CMD_BUS_MASTER  0x0004      /* Enable bus master capability */
#define PCI_CONF_CMD_MEMORY      0x0002      /* Window is in memory space */
#if (TIGON_REV & TIGON_REV5)
#define PCI_CONF_CMD_MEM_WRITE_INVALIDATE 0x0010 /* Enable Mem Write Invalidate*/
#endif /* (TIGON_REV & TIGON_REV5) */

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/*
 *                       GENERAL CONTROL REGISTERS
 */
#if !defined(PUBLIC_ONLY)
typedef struct tg_gen_control {
    VOLATILE U32 misc_host_control;     /* see TG_MHC_XXXX below */
    VOLATILE U32 misc_local_control;    /* see TG_MLC_XXXX below */
#if (TIGON_REV & TIGON_REV5)
    VOLATILE U32 semaphore_a;    		/* Processor A */
    VOLATILE U32 semaphore_b;    		/* Processor B */
#else /* (TIGON_REV & TIGON_REV5) */
    U32          reserved_0[2];
#endif /* (TIGON_REV & TIGON_REV5) */
    VOLATILE U32 misc_config;   /* Was timer_state in rev4; changed in rev5 */
    				/* see TG_MSC_XXXX below for bit definitione */
#define timer_state misc_config     /* for backword compatibility */
    VOLATILE U32 timer;
    U32          timer_ref;
    VOLATILE U32 pci_state;             /* see TG_PCI_STATE_XXXX below */
    VOLATILE U32 event;                 /* see TG_FW_EVENT_XXXX below */
    VOLATILE U32 mailbox_event;
    U32          window_base;
    VOLATILE U32 window_data;
#if (TIGON_REV & TIGON_REV5)
    VOLATILE U32 event_b;                 /* see TG_FW_EVENT_XXXX below */
    VOLATILE U32 mailbox_event_b;
    U32          timer_ref_b;		/* Processor b timer ref */
#else /* (TIGON_REV & TIGON_REV5) */
    U32          reserved_1[3];
#endif /* (TIGON_REV & TIGON_REV5) */
    VOLATILE U32 ext_ser_data;
} tgGenControl_t;

#else /* !defined(PUBLIC_ONLY) */

typedef struct tg_gen_control {
    VOLATILE U32 misc_host_control;     /* see TG_MHC_XXXX below */
    VOLATILE U32 misc_local_control;    /* see TG_MLC_XXXX below */
    U32          reserved_0[2];
    VOLATILE U32 misc_config;   /* Was timer_state in rev4; changed in rev5 */
    				/* see TG_MSC_XXXX below for bit definitione */
    U32          reserved_1[2];
    VOLATILE U32 pci_state;             /* see TG_PCI_STATE_XXXX below */
    U32          reserved_2[2];
    U32          window_base;
    VOLATILE U32 window_data;
    U32          reserved_3[4];
} tgGenControl_t;
#endif /* !defined(PUBLIC_ONLY) */

#if !defined(PUBLIC_ONLY)
#define EXT_SER_DATA_BYTE               0x000000ff
#endif /* !defined(PUBLIC_ONLY) */

/* Misc. Host Control Bit definitions */
#define TG_MHC_TIGON_VERSION_MASK       0xf0000000
#define TG_MHC_CHIP_EXPRESS_VERS        0x30000000
#define TG_MHC_LSI_GATE_VERS            0x40000000
#define TG_MHC_LSI_STANDARD_CELL_VERS   0x50000000
#define TG_MHC_LSI_STANDARD_CELL_VERS_B 0x60000000
#if (TIGON_REV & TIGON_REV5)
#define TG_MHC_MASK_OFF_RUPT            0x00000040
#endif /* (TIGON_REV & TIGON_REV5) */
#define TG_MHC_WORD_SWAP                0x00000020
#define TG_MHC_BYTE_SWAP                0x00000010
#define TG_MHC_RESET                    0x00000008
#define TG_MHC_CLEAR_RUPT               0x00000002
#define TG_MHC_RUPT_STATE               0x00000001

/* Misc. Local Control Bit definitions */
#if !defined(PUBLIC_ONLY)
#if (TIGON_REV & TIGON_REV5)
#define TG_MLC_INPUT_INTERRUPT   	0x08000000
#endif /* (TIGON_REV & TIGON_REV5) */

#define TG_MLC_UART_RX_OVERRUN          0x04000000
#define TG_MLC_UART_RX_READY            0x02000000
#define TG_MLC_UART_TX_DONE             0x01000000
#define TG_MLC_UART_MASK                0x07000000 

#define TG_MLC_MII_DATA_IN       	0x00080000
#define TG_MLC_MII_DATA_OUT       	0x00040000
#define TG_MLC_MII_DATA_OUT_ENA       	0x00020000
#define TG_MLC_MII_CLK_OUT       	0x00010000
#define TG_MLC_MII_MASK			0x000f0000

#if (TIGON_REV & TIGON_REV5)
#define TG_MLC_MISC_OUT_1	     	0x00008000
#define TG_MLC_MISC_OUT_0	     	0x00004000
#define TG_MLC_MISC_OUT_1_ENA     	0x00002000
#define TG_MLC_MISC_OUT_0_ENA     	0x00001000
#define TG_MLC_MISC_IN_1     		0x00000800
#define TG_MLC_MISC_IN_0     		0x00000400

/*
 * XXX Note to people needing board specific definitions for
 * the MISC_IN/OUT- please define all board specific defines
 * in a project related header file.  This is for Tigon 
 * defines.  
 */
#endif /* (TIGON_REV & TIGON_REV5) */

/* can be used on either board type, the bit locations are the same */
#endif /* !defined(PUBLIC_ONLY) */
#define TG_MLC_SRAM_LADDR_22            0x00008000
#define TG_MLC_SRAM_LADDR_21            0x00004000

#if (TIGON_REV & TIGON_REV4)
#define TG_MLC_MORE_SRAM_BANK_ENA       0x00000100
#endif /* (TIGON_REV & TIGON_REV4) */

#if (TIGON_REV & TIGON_REV5)
#define TG_MLC_SRAM_BANK_DISA		0x00000000
#define TG_MLC_SRAM_BANK_1024K		0x00000100
#define TG_MLC_SRAM_BANK_512K		0x00000200
#define TG_MLC_SRAM_BANK_256K		0x00000300
#if !defined(PUBLIC_ONLY)
#define TG_MLC_MISC_OUT_2		0x00000080
#endif /* !defined(PUBLIC_ONLY) */
#endif /* (TIGON_REV & TIGON_REV5) */

#if !defined(PUBLIC_ONLY)
#define TG_MLC_LOOPBACK			0x00000080
#define TG_MLC_LED_DATA			0x00000040
#define TG_MLC_LED_LINK			0x00000020

#define TG_MLC_FAST_EEPROM              0x00000008
#define TG_MLC_SET_INTERRUPT            0x00000004
#define TG_MLC_CLEAR_INTERRUPT          0x00000002
#define TG_MLC_INTERRUPT_STATE          0x00000001
#endif /* !defined(PUBLIC_ONLY) */

#define TG_MLC_SER_EEPROM_DATA_IN      	0x00800000
#define TG_MLC_SER_EEPROM_DATA_OUT     	0x00400000
#define TG_MLC_SER_EEPROM_WRITE_ENA 	0x00200000
#define TG_MLC_SER_EEPROM_CLK_OUT      	0x00100000
#define TG_MLC_SER_EEPROM_MASK      	0x00f00000

#define TG_MLC_MORE_SRAM_256K           0x00000200

#define TG_MLC_EEPROM_WRITE_ENA	        0x00000010

/* Misc config bits definition. This is new for Rev5 */
#if (TIGON_REV & TIGON_REV5)
#if !defined(PUBLIC_ONLY)
#define TG_MSC_TX_CLK_ENA     		0x10000000
#define TG_MSC_TX_CLK_SEL_MASK   	0x0C000000
#define TG_MSC_TX_CLK_SEL_INT_SERDES   	0x00000000
#define TG_MSC_TX_CLK_SEL_MII   	0x04000000
#define TG_MSC_TX_CLK_SEL_EXT_SERDES   	0x08000000
#define TG_MSC_TX_CLK_SEL_GMII   	0x0C000000
#define TG_MSC_RX_CLK_SEL_MASK   	0x03000000
#define TG_MSC_RX_CLK_SEL_INT_SERDES   	0x00000000
#define TG_MSC_RX_CLK_SEL_GMII   	0x01000000
#define TG_MSC_RX_CLK_SEL_EXT_SERDES   	0x02000000
#define TG_MSC_RX_CLK_SEL_MII   	0x03000000
#define TG_MSC_RES3     		0x00800000
#define TG_MSC_RES2     		0x00400000
#define TG_MSC_RES1     		0x00200000
#endif /* !defined(PUBLIC_ONLY) */
#define TG_MSC_ENA_SYNC_SRAM_TIMING     0x00100000
#if !defined(PUBLIC_ONLY)
#define TG_MSC_SPLIT_MAILBOX_EVENTS     0x00080000
#define TG_MSC_INPUT_INTERRUPT_ENABLE   0x00040000
#define TG_MSC_UART_SERIAL_INPUT   	0x00020000
#define TG_MSC_UART_LOCAL_SPD   	0x00010000
#define TG_MSC_UART_HALF_BIT_TIMER_MASK	0x0000FF00
#define TG_MSC_RES0			0x00000080
#define TG_MSC_TIMER_PRESCALER_MASK	0x0000007F
#endif /* !defined(PUBLIC_ONLY) */
#endif /* (TIGON_REV & TIGON_REV5) */


/* PCI state Bit definitions */
#if !defined(PUBLIC_ONLY)
#define TG_PCI_STATE_FIFO_RETRY_ENAB    0x00010000
#endif /* !defined(PUBLIC_ONLY) */

#define TG_PCI_STATE_FORCE_RESET        0x00000001
#define TG_PCI_STATE_PROVIDE_LEN        0x00000002

#define TG_PCI_STATE_DMA_READ_MAX_DISA  0x00000000
#define TG_PCI_STATE_DMA_READ_MAX_4     0x00000004
#define TG_PCI_STATE_DMA_READ_MAX_16    0x00000008
#define TG_PCI_STATE_DMA_READ_MAX_32    0x0000000c
#define TG_PCI_STATE_DMA_READ_MAX_64    0x00000010
#define TG_PCI_STATE_DMA_READ_MAX_128   0x00000014
#define TG_PCI_STATE_DMA_READ_MAX_256   0x00000018
#define TG_PCI_STATE_DMA_READ_MAX_1K    0x0000001c
#define TG_PCI_STATE_DMA_READ_MASK      0x0000001c
#define TG_PCI_STATE_DMA_READ_SHIFT     2

#define TG_PCI_STATE_DMA_WRITE_MAX_DISA 0x00000000
#define TG_PCI_STATE_DMA_WRITE_MAX_4    0x00000020
#define TG_PCI_STATE_DMA_WRITE_MAX_16   0x00000040
#define TG_PCI_STATE_DMA_WRITE_MAX_32   0x00000060
#define TG_PCI_STATE_DMA_WRITE_MAX_64   0x00000080
#define TG_PCI_STATE_DMA_WRITE_MAX_128  0x000000a0
#define TG_PCI_STATE_DMA_WRITE_MAX_256  0x000000c0
#define TG_PCI_STATE_DMA_WRITE_MAX_1K   0x000000e0
#define TG_PCI_STATE_DMA_WRITE_MASK     0x000000e0
#define TG_PCI_STATE_DMA_WRITE_SHIFT    5

#define TG_PCI_STATE_MIN_DMA            0x0000ff00

#define TG_PCI_STATE_USE_MEM_RD_MULT	0x00020000
#if (TIGON_REV & TIGON_REV5)
#define TG_PCI_STATE_NO_WORD_SWAP	0x00040000 /*one bit for rd and write*/
#define TG_PCI_STATE_66_MH_BUS		0x00080000 /* READ ONLY */
#endif /* (TIGON_REV & TIGON_REV5) */
#if (TIGON_REV & TIGON_REV4)
#define TG_PCI_STATE_NO_READ_WORD_SWAP	0x00040000
#define TG_PCI_STATE_NO_WRITE_WORD_SWAP	0x00080000
#endif /* (TIGON_REV & TIGON_REV4) */

#define TG_PCI_STATE_USE_32_BITS_ONLY	0x00100000
#if !defined(PUBLIC_ONLY)
#if (TIGON_REV & TIGON_REV5)
#define TG_PCI_STATE_ENA_ROM_BASE_ADDR  0x00200000
#define TG_PCI_STATE_FORCE_ROM_RETRY    0x00400000
#endif /* (TIGON_REV & TIGON_REV5) */
#endif /* !defined(PUBLIC_ONLY) */

#if (TIGON_REV & TIGON_REV5)
#define TG_PCI_STATE_DMA_WR_ALL_ALIGN   0x00800000
#endif /* (TIGON_REV & TIGON_REV5) */

#define TG_PCI_STATE_READ_CMD_MASK	0x0f000000
#define TG_PCI_STATE_WRITE_CMD_MASK	0xf0000000

#define TG_PCI_STATE_READ_CMD_MEM_READ	0x06000000
#define TG_PCI_STATE_READ_CMD_CONF_READ	0x0a000000

#define TG_PCI_STATE_WRITE_CMD_MEM_WRITE	0x70000000
#define TG_PCI_STATE_WRITE_CMD_CONF_WRITE	0xb0000000

#if !defined(PUBLIC_ONLY)
/*
 * firmware events
 */
#if (TIGON_REV & TIGON_REV5)
#define TG_FW_EVENT_SW13                0x80000000
#define TG_FW_EVENT_SERIAL              0x40000000
#define TG_FW_EVENT_SW12                0x20000000
#define TG_FW_EVENT_TIMER               0x10000000
#define TG_FW_EVENT_REMOTE_CPU_ATTN     0x08000000
#define TG_FW_EVENT_MAC_TX_ATTN         0x04000000
#define TG_FW_EVENT_MAC_RX_ATTN         0x02000000
#define TG_FW_EVENT_SW11                0x01000000
#define TG_FW_EVENT_SW10                0x00800000
#define TG_FW_EVENT_MAILBOX             0x00400000
#define TG_FW_EVENT_SW9                 0x00200000
#define TG_FW_EVENT_DMA_RD_ATTN         0x00100000
#define TG_FW_EVENT_DMA_WR_ATTN         0x00080000
#define TG_FW_EVENT_DMA_RD_COMP         0x00040000
#define TG_FW_EVENT_DMA_WR_COMP         0x00020000
#define TG_FW_EVENT_SW8                 0x00010000
#define TG_FW_EVENT_DMA_RD_ASST_HI      0x00008000
#define TG_FW_EVENT_DMA_WR_ASST_HI      0x00004000
#define TG_FW_EVENT_DMA_RD_ASST_LO      0x00002000
#define TG_FW_EVENT_DMA_WR_ASST_LO      0x00001000
#define TG_FW_EVENT_SW7                 0x00000800
#define TG_FW_EVENT_SET_REMOTE_CPU_ATTN 0x00000400  /* Write only */
#define TG_FW_EVENT_SW6                 0x00000200
#define TG_FW_EVENT_SW5                 0x00000100
#define TG_FW_EVENT_SW4                 0x00000080
#define TG_FW_EVENT_MAC_RX_COMP         0x00000040
#define TG_FW_EVENT_MAC_RX_START        0x00000020
#define TG_FW_EVENT_SW3                 0x00000010
#define TG_FW_EVENT_SW2                 0x00000008
#define TG_FW_EVENT_MAC_TX_COMP         0x00000004
#define TG_FW_EVENT_SW1                 0x00000002
/* NOTE: libhw_api.h assumes the following assignment; do not change!!! */
#define TG_FW_EVENT_SW0                 0x00000001

#else /* (TIGON_REV & TIGON_REV5) */
XXX
#define TG_FW_EVENT_SW15                0x80000000
#define TG_FW_EVENT_SERIAL              0x40000000
#define TG_FW_EVENT_SW14                0x20000000
#define TG_FW_EVENT_TIMER               0x10000000
#define TG_FW_EVENT_SW13                0x08000000
#define TG_FW_EVENT_MAC_TX_ATTN         0x04000000
#define TG_FW_EVENT_MAC_RX_ATTN         0x02000000
#define TG_FW_EVENT_SW12                0x01000000
#define TG_FW_EVENT_SW11                0x00800000
#define TG_FW_EVENT_MAILBOX             0x00400000
#define TG_FW_EVENT_SW10                0x00200000
#define TG_FW_EVENT_DMA_RD_ATTN         0x00100000
#define TG_FW_EVENT_DMA_WR_ATTN         0x00080000
#define TG_FW_EVENT_DMA_RD_COMP         0x00040000
#define TG_FW_EVENT_DMA_WR_COMP         0x00020000
#define TG_FW_EVENT_SW9                 0x00010000
#define TG_FW_EVENT_DMA_RD_ASST_HI      0x00008000
#define TG_FW_EVENT_DMA_WR_ASST_HI      0x00004000
#define TG_FW_EVENT_DMA_RD_ASST_LO      0x00002000
#define TG_FW_EVENT_DMA_WR_ASST_LO      0x00001000
#define TG_FW_EVENT_SW8                 0x00000800
#define TG_FW_EVENT_SW7                 0x00000400
#define TG_FW_EVENT_SW6                 0x00000200
#define TG_FW_EVENT_SW5                 0x00000100
#define TG_FW_EVENT_SW4                 0x00000080
#define TG_FW_EVENT_MAC_RX_COMP         0x00000040
#define TG_FW_EVENT_MAC_RX_START        0x00000020
#define TG_FW_EVENT_SW3                 0x00000010
#define TG_FW_EVENT_SW2                 0x00000008
#define TG_FW_EVENT_MAC_TX_COMP         0x00000004
#define TG_FW_EVENT_SW1                 0x00000002
/* NOTE: libhw_api.h assumes the following assignment; do not change!!! */
#define TG_FW_EVENT_SW0                 0x00000001

#endif /* (TIGON_REV & TIGON_REV5) */

#if (TIGON_REV & TIGON_REV5)

#define TG_FW_EVENT_NUM_SW13                31
#define TG_FW_EVENT_NUM_SERIAL              30
#define TG_FW_EVENT_NUM_SW12                29
#define TG_FW_EVENT_NUM_TIMER               28
#define TG_FW_EVENT_NUM_REMOTE_CPU_ATTN     27
#define TG_FW_EVENT_NUM_MAC_TX_ATTN         26
#define TG_FW_EVENT_NUM_MAC_RX_ATTN         25
#define TG_FW_EVENT_NUM_SW11                24
#define TG_FW_EVENT_NUM_SW10                23
#define TG_FW_EVENT_NUM_MAILBOX             22
#define TG_FW_EVENT_NUM_SW9                 21
#define TG_FW_EVENT_NUM_DMA_RD_ATTN         20
#define TG_FW_EVENT_NUM_DMA_WR_ATTN         19
#define TG_FW_EVENT_NUM_DMA_RD_COMP         18
#define TG_FW_EVENT_NUM_DMA_WR_COMP         17
#define TG_FW_EVENT_NUM_SW8                 16
#define TG_FW_EVENT_NUM_DMA_RD_ASST_HI      15
#define TG_FW_EVENT_NUM_DMA_WR_ASST_HI      14
#define TG_FW_EVENT_NUM_DMA_RD_ASST_LO      13
#define TG_FW_EVENT_NUM_DMA_WR_ASST_LO      12
#define TG_FW_EVENT_NUM_SW7                 11
#define TG_FW_EVENT_NUM_SET_REMOTE_CPU_ATTN 10
#define TG_FW_EVENT_NUM_SW6                 9
#define TG_FW_EVENT_NUM_SW5                 8
#define TG_FW_EVENT_NUM_SW4                 7
#define TG_FW_EVENT_NUM_MAC_RX_COMP         6
#define TG_FW_EVENT_NUM_MAC_RX_START        5
#define TG_FW_EVENT_NUM_SW3                 4
#define TG_FW_EVENT_NUM_SW2                 3
#define TG_FW_EVENT_NUM_MAC_TX_COMP         2
#define TG_FW_EVENT_NUM_SW1                 1
/* NOTE: libhw_api.h assumes the following assignment; do not change!!! */
#define TG_FW_EVENT_NUM_SW0                 0

#else /* (TIGON_REV & TIGON_REV5) */

#define TG_FW_EVENT_NUM_SW15                31
#define TG_FW_EVENT_NUM_SERIAL              30
#define TG_FW_EVENT_NUM_SW14                29
#define TG_FW_EVENT_NUM_TIMER               28
#define TG_FW_EVENT_NUM_SW13                27
#define TG_FW_EVENT_NUM_MAC_TX_ATTN         26
#define TG_FW_EVENT_NUM_MAC_RX_ATTN         25
#define TG_FW_EVENT_NUM_SW12                24
#define TG_FW_EVENT_NUM_SW11                23
#define TG_FW_EVENT_NUM_MAILBOX             22
#define TG_FW_EVENT_NUM_SW10                21
#define TG_FW_EVENT_NUM_DMA_RD_ATTN         20
#define TG_FW_EVENT_NUM_DMA_WR_ATTN         19
#define TG_FW_EVENT_NUM_DMA_RD_COMP         18
#define TG_FW_EVENT_NUM_DMA_WR_COMP         17
#define TG_FW_EVENT_NUM_SW9                 16
#define TG_FW_EVENT_NUM_DMA_RD_ASST_HI      15
#define TG_FW_EVENT_NUM_DMA_WR_ASST_HI      14
#define TG_FW_EVENT_NUM_DMA_RD_ASST_LO      13
#define TG_FW_EVENT_NUM_DMA_WR_ASST_LO      12
#define TG_FW_EVENT_NUM_SW8                 11
#define TG_FW_EVENT_NUM_SW7                 10
#define TG_FW_EVENT_NUM_SW6                 9
#define TG_FW_EVENT_NUM_SW5                 8
#define TG_FW_EVENT_NUM_SW4                 7
#define TG_FW_EVENT_NUM_MAC_RX_COMP         6
#define TG_FW_EVENT_NUM_MAC_RX_START        5
#define TG_FW_EVENT_NUM_SW3                 4
#define TG_FW_EVENT_NUM_SW2                 3
#define TG_FW_EVENT_NUM_MAC_TX_COMP         2
#define TG_FW_EVENT_NUM_SW1                 1
/* NOTE: libhw_api.h assumes the following assignment; do not change!!! */
#define TG_FW_EVENT_NUM_SW0                 0

#endif /* (TIGON_REV & TIGON_REV5) */
#endif /* !defined(PUBLIC_ONLY) */

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/*
 *                      HOST DMA CONTROL REGISTERS
 */
#if !defined(PUBLIC_ONLY)
typedef struct tg_host_dma {
#if (TG_DMA_DESCR_FMT == 1)
    VOLATILE tg_hostaddr_t dma_wr_host_addr;             /* only used in NIC */
    U32               reserved_0[2];
    VOLATILE tg_hostaddr_t dma_rd_host_addr;
#else  /* (TG_DMA_DESCR_FMT == 1) */
    VOLATILE U64      dma_wr_rem_addr;                   /* only used in TS */
    U32               reserved_0[2];
    VOLATILE U64      dma_rd_rem_addr;
#endif /* (TG_DMA_DESCR_FMT == 1) */
    U32               reserved_1[1];
    VOLATILE U32      dma_rd_len;
    VOLATILE U32      dma_wr_state;     /* see TG_DMA_STATE_XXXX below */
    VOLATILE U32      dma_wr_loc_addr;
    VOLATILE U32      dma_wr_tcpip_cksum;
    VOLATILE U32      dma_wr_len;
    VOLATILE U32      dma_rd_state;     /* see TG_DMA_STATE_XXXX below */
    VOLATILE U32      dma_rd_loc_addr;
    VOLATILE U32      dma_rd_tcpip_cksum;
    U32               reserved_2[1];
} tgHostDma_t;
#else /* !defined(PUBLIC_ONLY) */
typedef struct tg_host_dma {
    U32               reserved_0[8];
    VOLATILE U32      dma_wr_state;     /* see TG_DMA_STATE_XXXX below */
    U32               reserved_1[3];
    VOLATILE U32      dma_rd_state;     /* see TG_DMA_STATE_XXXX below */
    U32               reserved_2[3];
} tgHostDma_t;
#endif /* !defined(PUBLIC_ONLY) */

/* 
 * DMA State bits 
 */
#if !defined(PUBLIC_ONLY)
#define TG_DMA_STATE_FIFO_LOCAL_ERROR   0x80000000
#define TG_DMA_STATE_FIFO_UNDERRUN      0x40000000
#define TG_DMA_STATE_FIFO_OVERRUN       0x20000000
#define TG_DMA_STATE_DESCR_PARITY_ERR   0x10000000
/* #define TG_DMA_STATE_RESERVED_0      0x08000000 */
#define TG_DMA_STATE_PCI_PARITY_ERR     0x04000000
#define TG_DMA_STATE_PCI_MASTER_ABORT   0x02000000
#define TG_DMA_STATE_PCI_TARGET_ABORT   0x01000000
#define TG_DMA_STATE_PROGRESS_MADE      0x00800000
#if (TIGON_REV & TIGON_REV5)
#define TG_DMA_STATE_SET_INTERRUPT    	0x00200000       /* Write Only */
#endif /* (TIGON_REV & TIGON_REV5) */
#if (TIGON_REV & TIGON_REV4)
#define TG_DMA_STATE_BLOCK_1ST_WRITE    0x00200000
#endif /* (TIGON_REV & TIGON_REV4) */
#define TG_DMA_STATE_FIFO_WRITE         0x00100000
#if (TIGON_REV & TIGON_REV5)
#define TG_DMA_STATE_INVERT_CHECKSUM 	0x00080000      /* Read only */
#endif /* (TIGON_REV & TIGON_REV5) */
#define TG_DMA_STATE_UPDATE_RX_BUF_CONS 0x00080000      /* write only */
#define TG_DMA_STATE_BYTE_BUCKET        0x00040000      /* write only */
#define TG_DMA_STATE_DISABLE_PROD_COMP  0x00020000      /* write only */
#define TG_DMA_STATE_UPDATE_TX_BUF_PROD 0x00020000      /* Read only */
#define TG_DMA_STATE_WORDS_0            0x00010000
#define TG_DMA_STATE_WORDS_1            0x00008000
#define TG_DMA_STATE_WORDS_2            0x00004000
#define TG_DMA_STATE_WORDS_3            0x00002000
#define TG_DMA_STATE_WORDS_4            0x00001000
#define TG_DMA_STATE_SAVE_CKSUM         0x00000800
#define TG_DMA_STATE_CLEAR_CKSUM        0x00000400
#define TG_DMA_STATE_ENABLE_CKSUM       0x00000200
#endif /* !defined(PUBLIC_ONLY) */

#define TG_DMA_STATE_ERROR_MASK         0x7f000000
#if (TIGON_REV & TIGON_REV5)
#define TG_DMA_STATE_THRESH_32W         0x00000000 /* 0 in REV5 = 32 words */
#endif /* (TIGON_REV & TIGON_REV5) */
#define TG_DMA_STATE_THRESH_16W         0x00000100
#define TG_DMA_STATE_THRESH_8W          0x00000080
#define TG_DMA_STATE_THRESH_4W          0x00000040
#define TG_DMA_STATE_THRESH_2W          0x00000020
#define TG_DMA_STATE_THRESH_1W          0x00000010

#define TG_DMA_STATE_FORCE_32_BIT  	0x00000008
#define TG_DMA_STATE_ACTIVE             0x00000004
#define TG_DMA_STATE_NO_SWAP            0x00000002
#define TG_DMA_STATE_RESET              0x00000001

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/*
 *                   LOCAL MEMORY CONFIGURATION REGISTERS
 */
#if !defined(PUBLIC_ONLY)
/*
 *  First need to define the MAC descriptor, since have pointers here...
 */
typedef struct tg_mac_descr {
    U32 w0;                             /* see TG_MAC_?X_W0_XXXX below */
    U32 w1;                             /* see TG_MAC_?X_W1_XXXX below */
} tgMacDescr_t;
#endif /* !defined(PUBLIC_ONLY) */

#if !defined(PUBLIC_ONLY)
/*
 * Defines for the MAC TX descriptor 
 */
#if (TIGON_REV & TIGON_REV4)
#define TG_MAC_TX_W0_ADDR_MASK			0xffffffff
#define TG_MAC_TX_W1_LEN_MASK			0x00007fff
#define TG_MAC_TX_W1_NO_CRC			0x80000000
#else /* (TIGON_REV & TIGON_REV4) */
#define TG_MAC_TX_W0_ADDR_MASK			0x001fffff
#define TG_MAC_TX_W0_NO_CRC			0x80000000
#define TG_MAC_TX_W0_NO_TAG			0x00000000
#define TG_MAC_TX_W0_REM_TAG			0x20000000
#define TG_MAC_TX_W0_ADD_TAG			0x40000000
#define TG_MAC_TX_W0_MAP_TAG			0x60000000
#define TG_MAC_TX_W1_LEN_MASK			0x0000ffff
#define TG_MAC_TX_W1_TAG_SHIFT			16
#endif /* (TIGON_REV & TIGON_REV4) */

/*
 * Defines for the MAC RX descriptor 
 */
#define TG_MAC_RX_W0_ADDR_MASK			0xffffffff
#define TG_MAC_RX_W1_LEN_MASK			0x0000ffff
#define TG_MAC_RX_W1_BAD_CRC			0x00010000
#define TG_MAC_RX_W1_COLL_DETECT		0x00020000
#define TG_MAC_RX_W1_LINK_LOST_DURING_PKT	0x00040000
#define TG_MAC_RX_W1_PHY_DECODE_ERR		0x00080000
#define TG_MAC_RX_W1_ODD_NIBBLES_RCVD_MII	0x00100000
#define TG_MAC_RX_W1_MAC_ABORT			0x00200000
#define TG_MAC_RX_W1_LEN_LT_64			0x00400000
#define TG_MAC_RX_W1_TRUNC_NO_RESOURCES		0x00800000
#define TG_MAC_RX_W1_STATUS_MASK		0xffff0000
#endif /* !defined(PUBLIC_ONLY) */

#if !defined(PUBLIC_ONLY)
/*
 *  Now define the local memory configuration control registers...
 */
typedef struct tg_local_mem_conf {
    U32                    rx_buf_base;
    VOLATILE U32           rx_buf_producer;
    VOLATILE U32           rx_buf_consumer;
    VOLATILE U32           rx_buf_start;
    U32                    tx_buf_base;
    VOLATILE U32           tx_buf_producer;
    VOLATILE U32           tx_buf_consumer;
#if (TIGON_REV & TIGON_REV5)
    VOLATILE U32           tx_buf_next;
#else /* (TIGON_REV & TIGON_REV5) */
    U32                    delay_line_state;
#endif /* (TIGON_REV & TIGON_REV5) */
    tgMacDescr_t * VOLATILE mac_rx_descr_producer;
    tgMacDescr_t * VOLATILE mac_rx_descr_consumer;
    tgMacDescr_t * VOLATILE mac_rx_descr_ref;
    U32                    cpu_priority;       /* see TG_CPU_PRI_XXXX below */
    tgMacDescr_t * VOLATILE mac_tx_descr_producer;
    tgMacDescr_t * VOLATILE mac_tx_descr_consumer;
    tgMacDescr_t * VOLATILE mac_tx_descr_ref;
#if (TIGON_REV & TIGON_REV5)
    tgMacDescr_t * VOLATILE mac_tx_descr_next;
#else /* (TIGON_REV & TIGON_REV5) */
    U32                    reserved_1;
#endif /* (TIGON_REV & TIGON_REV5) */
} tgLocalMemConf_t;
#else /* !defined(PUBLIC_ONLY) */
typedef struct tg_local_mem_conf {
    U32                    reserved[16];
} tgLocalMemConf_t;
#endif /* !defined(PUBLIC_ONLY) */

#if !defined(PUBLIC_ONLY)
#if (TIGON_REV & TIGON_REV5)
#define TG_CPU_A_PRI_MASK                      0x0000000f
#define TG_CPU_A_PRI_SHIFT                              0
#define TG_CPU_B_PRI_MASK                      0x000000f0
#define TG_CPU_B_PRI_SHIFT                     		4
#define TG_CPU_FLASH_ADDR_HOLD_MASK            0x00000300
#define TG_CPU_FLASH_ADDR_HOLD_SHIFT           		8
#define TG_CPU_FLASH_OPERATION_MASK            0x00003C00
#define TG_CPU_FLASH_OPERATION_SHIFT           	       10
#define TG_CPU_FLASH_ADDR_SETUP_MASK           0x0000C000
#define TG_CPU_FLASH_ADDR_SETUP_SHIFT         	       14
#endif /* (TIGON_REV & TIGON_REV5) */
#if (TIGON_REV & TIGON_REV4)
#define TG_CPU_PRI_MASK                         0x0000000f
#define TG_CPU_PRI_SHIFT                                 0
#endif /* (TIGON_REV & TIGON_REV4) */
#define TG_CPU_PRI_RX_DESCR_AVAIL_MASK         0x00ff0000
#define TG_CPU_PRI_RX_DESCR_AVAIL_SHIFT                16
#define TG_CPU_PRI_RX_BUF_AVAIL_MASK           0xff000000
#define TG_CPU_PRI_RX_BUF_AVAIL_SHIFT                  24
#endif /* !defined(PUBLIC_ONLY) */

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/*
 *                        HOST DMA ASSIST CONTROL
 */

#if !defined(PUBLIC_ONLY)
/*
 *  First to define the DMA descriptor, in one of three possible formats...
 */
#if (TG_DMA_DESCR_FMT == 1)             /* LONG format */
typedef struct tg_dma_descr {
    tg_hostaddr_t host_addr;            /* host address (across PCI bus) */
    U32      nic_addr;                  /* NIC address (SRAM) */
    U16      reserved1;                 /* should be 0 always, per hw spec  */
    U16      len;                       /* length */
    U32      state;                     /* read or write state bits */
#if (TIGON_REV & TIGON_REV5)
    U32      cksum;                     /* TCP/IP checksum */
#else /* (TIGON_REV & TIGON_REV5) */
    U16      reserved2;                 /* should be 0 always, per hw spec  */
    U16      cksum;                     /* TCP/IP checksum */
#endif /* (TIGON_REV & TIGON_REV5) */
#if 0
    U32      type;                      /* transfer type */
#else /* USD firmware labels each DMA with its originator's ID */
    U16      usd_id;                    /* Who asked for this? */
    U16      type;                      /* transfer type */
#endif
    U32      index;                     /* ring index */
} tgDmaDescr_t;
#if (TG_DMA_DESCR_CHAINED)
#define TG_DMA_ASSIST_DESCRS    64  XXX
#else  /* (TG_DMA_DESCR_CHAINED) */
#define TG_DMA_ASSIST_DESCRS    32
#endif /* (TG_DMA_DESCR_CHAINED) */

#endif /* (TG_DMA_DESCR_FMT == 1) */

#if (TG_DMA_DESCR_FMT == 2)             /* SHORT format */
#if (TIGON_REV & TIGON_REV4)
typedef struct tg_dma_descr { XXX
    U32      rem_addr;                  /* remote address (across PCI bus) */
    U32      loc_addr;                  /* local address (SRAM) */
    U16      reserved1;                 /* should be 0 always, per hw spec  */
    U16      len;                       /* length */
    U32      state;                     /* read or write state bits */
    U32      reserved;
    U16      reserved2;                 /* should be 0 always, per hw spec  */
    U16      cksum;                     /* TCP/IP checksum */
    U32      type;                      /* transfer type */
    U32      data;                      /* firmware-specific data (eg, ptr) */
} tgDmaDescr_t;
#if (TG_DMA_DESCR_CHAINED)
#define TG_DMA_ASSIST_DESCRS    64 XXX
#else  /* (TG_DMA_DESCR_CHAINED) */
#define TG_DMA_ASSIST_DESCRS    32
#endif /* (TG_DMA_DESCR_CHAINED) */

#else /* (TIGON_REV & TIGON_REV4) */
THIS IS BROKEN, THERE IS NO TYPE 2 FORMAT ON ANY REV OTHER THAN REV4
#endif /* (TIGON_REV & TIGON_REV4) */
#endif /* (TG_DMA_DESCR_FMT == 2) */

#if (TG_DMA_DESCR_FMT == 3)             /* MINI format */
typedef struct tg_dma_descr { XXXX
    U32      rem_addr;                  /* remote address (across PCI bus) */
    U32      loc_addr;                  /* local address (SRAM) */
    union {
        struct {
            U8  type;                   /* type */
            U8  mod;                    /* modifier to remember other info */
            U16 len;                    /* length */
        } w;
        U32 type_mod_len;               /* combined type/mod/len for speed */
    } un;
    U32      state;                     /* read or write state bits */
} tgDmaDescr_t;

#define DD_type          un.w.type
#define DD_mod           un.w.mod
#define DD_len           un.w.len
#define DD_type_mod_len  un.type_mod_len

#if (TG_DMA_DESCR_CHAINED)
#define TG_DMA_ASSIST_DESCRS    128
#else  /* (TG_DMA_DESCR_CHAINED) */
#define TG_DMA_ASSIST_DESCRS    64
#endif /* (TG_DMA_DESCR_CHAINED) */

#endif /* (TG_DMA_DESCR_FMT == 3) */

/*
 *  Then define the DMA assist control pointers, in two possible formats...
 */

#define wr_dma_hi_ring             wr_dma_ring
#define rd_dma_hi_ring             rd_dma_ring

#define read_chan_hi_pri_producer  read_chan_producer 
#define read_chan_hi_pri_consumer  read_chan_consumer
#define read_chan_hi_pri_ref       read_chan_ref

#define write_chan_hi_pri_producer write_chan_producer 
#define write_chan_hi_pri_consumer write_chan_consumer
#define write_chan_hi_pri_ref      write_chan_ref

#if (TG_DMA_DESCR_CHAINED)
typedef struct tg_host_dma_assist {
    tgDmaDescr_t * VOLATILE read_chan_producer;
    tgDmaDescr_t * VOLATILE read_chan_consumer;
    tgDmaDescr_t * VOLATILE read_chan_ref;
#if (TIGON_REV & TIGON_REV5)
    tgDmaDescr_t * VOLATILE read_chan_next;
#else /* (TIGON_REV & TIGON_REV5) */
    U32                    reserved_0;
#endif /* (TIGON_REV & TIGON_REV5) */
    tgDmaDescr_t * VOLATILE read_chan_lo_pri_producer;	/* initialize only */
    tgDmaDescr_t * VOLATILE read_chan_lo_pri_consumer;	/* initialize only */
    tgDmaDescr_t * VOLATILE read_chan_lo_pri_ref;	/* initialize only */
    VOLATILE U32           assist_state;     /* see TG_DMA_ASSIST_XXXX below */
    tgDmaDescr_t * VOLATILE write_chan_producer;
    tgDmaDescr_t * VOLATILE write_chan_consumer;
    tgDmaDescr_t * VOLATILE write_chan_ref;
#if (TIGON_REV & TIGON_REV5)
    tgDmaDescr_t * VOLATILE write_chan_next;
#else /* (TIGON_REV & TIGON_REV5) */
    U32                    reserved_1;
#endif /* (TIGON_REV & TIGON_REV5) */
    tgDmaDescr_t * VOLATILE write_chan_lo_pri_producer;	/* initialize only */
    tgDmaDescr_t * VOLATILE write_chan_lo_pri_consumer;	/* initialize only */
    tgDmaDescr_t * VOLATILE write_chan_lo_pri_ref;	/* initialize only */
    U32                    reserved_2;
} tgHostDmaAssist_t;
#else  /* (TG_DMA_DESCR_CHAINED) */
typedef struct tg_host_dma_assist {
    tgDmaDescr_t * VOLATILE read_chan_producer; /* XXX IAP _hi */
    tgDmaDescr_t * VOLATILE read_chan_consumer;
    tgDmaDescr_t * VOLATILE read_chan_ref;
#if (TIGON_REV & TIGON_REV5)
    tgDmaDescr_t * VOLATILE read_chan_next;
#else /* (TIGON_REV & TIGON_REV5) */
    U32                    reserved_0;
#endif /* (TIGON_REV & TIGON_REV5) */
    tgDmaDescr_t * VOLATILE read_chan_lo_pri_producer;
    tgDmaDescr_t * VOLATILE read_chan_lo_pri_consumer;
    tgDmaDescr_t * VOLATILE read_chan_lo_pri_ref;
    VOLATILE U32           assist_state;     /* see TG_DMA_ASSIST_XXXX below */
    tgDmaDescr_t * VOLATILE write_chan_producer; /* XXX IAP _hi_pr */
    tgDmaDescr_t * VOLATILE write_chan_consumer;
    tgDmaDescr_t * VOLATILE write_chan_ref;
#if (TIGON_REV & TIGON_REV5)
    tgDmaDescr_t * VOLATILE write_chan_next;
#else /* (TIGON_REV & TIGON_REV5) */
    U32                    reserved_1;
#endif /* (TIGON_REV & TIGON_REV5) */
    tgDmaDescr_t * VOLATILE write_chan_lo_pri_producer;
    tgDmaDescr_t * VOLATILE write_chan_lo_pri_consumer;
    tgDmaDescr_t * VOLATILE write_chan_lo_pri_ref;
    U32                    reserved_2;
} tgHostDmaAssist_t;
#endif /* (TG_DMA_DESCR_CHAINED) */
#else /* !defined(PUBLIC_ONLY) */
typedef struct tg_host_dma_assist {
    U32                    reserved_0[7];
    VOLATILE U32           assist_state;     /* see TG_DMA_ASSIST_XXXX below */
    U32                    reserved_1[8];
} tgHostDmaAssist_t;
#endif /* !defined(PUBLIC_ONLY) */

#if !defined(PUBLIC_ONLY)
/* DMA assist Bit definitions */
#if (TG_DMA_DESCR_CHAINED)
#define TG_DMA_ASSIST_RD_NOT_EMPTY      0x00008000
#define TG_DMA_ASSIST_RD_SELECTED       0x00002000
#define TG_DMA_ASSIST_WR_NOT_EMPTY      0x00000800
#define TG_DMA_ASSIST_WR_SELECTED       0x00000200
#else  /* (TG_DMA_DESCR_CHAINED) */
#define TG_DMA_ASSIST_RD_HI_NOT_EMPTY   0x00008000
#define TG_DMA_ASSIST_RD_LO_NOT_EMPTY   0x00004000
#define TG_DMA_ASSIST_RD_HI_SELECTED    0x00002000
#define TG_DMA_ASSIST_WR_HI_NOT_EMPTY   0x00000800
#define TG_DMA_ASSIST_WR_LO_NOT_EMPTY   0x00000400
#define TG_DMA_ASSIST_WR_HI_SELECTED    0x00000200
#endif /* (TG_DMA_DESCR_CHAINED) */

#define TG_DMA_ASSIST_RD_BUSY           0x00001000
#define TG_DMA_ASSIST_WR_BUSY           0x00000100

#define TG_DMA_ASSIST_CHAIN_RINGS       0x00000020
#if (TIGON_REV & TIGON_REV5)
#define TG_DMA_ASSIST_RD_MINI_DESCR	0x00000010 
#define TG_DMA_ASSIST_WR_MINI_DESCR	0x00000008 
#endif /* (TIGON_REV & TIGON_REV5) */
#if (TIGON_REV & TIGON_REV4)
#define TG_DMA_ASSIST_MINI_DESCR	0x00000010  /* requires SHORT_DESCR */
#define TG_DMA_ASSIST_32BIT_HOST        0x00000008
#define TG_DMA_ASSIST_SHORT_DESCR       TG_DMA_ASSIST_32BIT_HOST
#endif /* (TIGON_REV & TIGON_REV4) */
#define TG_DMA_ASSIST_1_DMA_ACTIVE      0x00000004
#endif /* !defined(PUBLIC_ONLY) */

#define TG_DMA_ASSIST_PAUSE             0x00000002
#define TG_DMA_ASSIST_ENABLE            0x00000001


/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/*
 *                        CPU CONTROL REGISTERS
 */
#if !defined(PUBLIC_ONLY)
typedef struct tg_cpu_control {
    VOLATILE U32 cpu_state;             /* see TG_CPU_XXXX below */
    VOLATILE U32 pc;
    VOLATILE U32 breakpoint;
#if (TIGON_REV & TIGON_REV5)
    VOLATILE U32 instruction;         /* CPU Instruction to be written */
#else /* (TIGON_REV & TIGON_REV5) */
    U32          reserved_0;
#endif /* (TIGON_REV & TIGON_REV5) */
#if (TIGON_REV & TIGON_REV5)
    VOLATILE U32 adjust_stack;	      /* used when stack grows > scratch pad */
#else /* (TIGON_REV & TIGON_REV5) */
    U32          sram_base;
#endif /* (TIGON_REV & TIGON_REV5) */
    U32          sram_addr;
    VOLATILE U32 sram_data;
    VOLATILE U32 watchdog_clear;
    U32          reserved_1[8];
} tgCpuControl_t;
#else /* !defined(PUBLIC_ONLY) */
typedef struct tg_cpu_control {
    VOLATILE U32 cpu_state;             /* see TG_CPU_XXXX below */
    VOLATILE U32 pc;
    U32          reserved_0[3];
    U32          sram_addr;
    VOLATILE U32 sram_data;
    U32          reserved_1[9];
} tgCpuControl_t;
#endif /* !defined(PUBLIC_ONLY) */

/* 
 * CPU state Bit Definitions 
 */
#if !defined(PUBLIC_ONLY)
#define TG_CPU_PAGE_0_HALT_ENA	0x00000004
#define TG_CPU_DATA_CACHE_ENA	0x00000008
#define TG_CPU_WATCHDOG_ENA	0x00000020
#if (TIGON_REV & TIGON_REV5)
#define TG_CPU_FLUSH_ICACHE     0x00008000 /* write only */
#endif /* (TIGON_REV & TIGON_REV5) */
#define TG_CPU_BREAK		0x00020000
#define TG_CPU_HALT_OP		0x00040000
#define TG_CPU_INVALID_OP	0x00080000
#define TG_CPU_PAGE_0_DATA_HALT	0x00100000
#define TG_CPU_PAGE_0_INS_HALT	0x00200000
#define TG_CPU_INVAL_DATA_FETCH	0x00400000
#define TG_CPU_INVAL_INS_FETCH	0x00800000
#define TG_CPU_BAD_MEM_ALIGN	0x01000000
#endif /* !defined(PUBLIC_ONLY) */

#define TG_CPU_RESET		0x00000001
#define TG_CPU_SINGLE		0x00000002
#define TG_CPU_PROM_FAILED	0x00000010
#define TG_CPU_HALT		0x00010000
#define TG_CPU_HALTED           0xffff0000 /* processor halted mask */

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/*
 *                        CPU'S INTERNAL REGISTERS
 */
typedef struct tg_cpu_reg {
    VOLATILE U32 cpu_reg[32];
} tgCpuReg_t;

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/*
 *                          MAC CONTROL REGISTERS
 *
 *  Then the MAC control ring pointers, again in only one format...
 */
#if !defined(PUBLIC_ONLY)
typedef struct tg_mac_control {
    VOLATILE U32 mac_tx_state;          /* see TG_MAC_TX_STATE_XXXX below */
    VOLATILE U32 mac_tx_config;         /* see TG_MAC_TX_CONF_XXXX below */ 
    VOLATILE tg_macaddr_t mac_src_addr;
    VOLATILE U32 mac_random;            /* see TG_MAC_TX_RANDOM_XXXX below */
    VOLATILE U32 mac_len;               /* see TG_MAC_TX_LEN_XXXX below */
    VOLATILE U32 mac_reserved;          
    VOLATILE U32 mac_thresholds;        /* see TG_MAC_RX_THRESH_XXXX below */
    VOLATILE U32 mac_rx_state;          /* see TG_MAC_RX_STATE_XXXX below */
    VOLATILE U32 mac_rx_config;         /* see TG_MAC_RX_CONF_XXXX below */
#if (TIGON_REV & TIGON_REV5)
#define mac_rx_mcast_filt1	mac_rx_mcast_filter[0]
#define mac_rx_mcast_filt2	mac_rx_mcast_filter[1]
#define mac_rx_mcast_filt3	mac_rx_mcast_filter[2]
#define mac_rx_mcast_filt4	mac_rx_mcast_filter[3]
    VOLATILE U32 mac_rx_mcast_filter[4];      
    VOLATILE U32 mac_serdes_config;      
    VOLATILE U32 mac_phy_config;      
#else /* (TIGON_REV & TIGON_REV5) */
    VOLATILE U32 mac_mcast_filter;
    U32      reserved_1[5];
#endif /* (TIGON_REV & TIGON_REV5) */
} tgMacControl_t;
#else /* !defined(PUBLIC_ONLY) */
typedef struct tg_mac_control {
    U32      reserved_0[8];
    VOLATILE U32 mac_rx_state;          /* see TG_MAC_RX_STATE_XXXX below */
    U32      reserved_1[7];
} tgMacControl_t;
#endif /* !defined(PUBLIC_ONLY) */

#if !defined(PUBLIC_ONLY)
/*
 * MAC Random Bit definitions
 */
#define TG_MAC_TX_RANDOM_MASK	        0x000003ff

/*
 * MAC TX State Bit definitions
 */
#define TG_MAC_TX_STATE_RESET		0x00000001
#define TG_MAC_TX_STATE_ENABLE		0x00000002
#define TG_MAC_TX_STATE_STOP_NEXT	0x00000004
#define TG_MAC_TX_STATE_ENA_CHECK_CRS	0x00000008
#define TG_MAC_TX_STATE_ENA_GMII	0x00000010
#define TG_MAC_TX_STATE_ENA_FULL_DUPLEX 0x00000020
#define TG_MAC_TX_STATE_ENA_1000BASE_F	0x00000040
#define TG_MAC_TX_STATE_ENA_ENCODING	0x00000080
//XXX IAP XXX#define TG_MAC_TX_STATE_ENA_FC		0x00000100
#define TG_MAC_TX_STATE_ENA_FC		0x00000000
#define TG_MAC_TX_STATE_ENA_XOFF_ATTN	0x00000200
#define TG_MAC_TX_STATE_ENA_BIG_BACKOFF	0x00000400
#define TG_MAC_TX_STATE_DIS_BUF_CMP	0x00000800
#define TG_MAC_TX_STATE_CARR_SYNC	0x00001000 /* R/O */
#define TG_MAC_TX_STATE_TX_XOFF		0x00100000
#define TG_MAC_TX_STATE_WORD_URUN_ERR	0x01000000
#define TG_MAC_TX_STATE_WORD_ORUN_ERR	0x02000000
#define TG_MAC_TX_STATE_AVAIL_URUN_ERR	0x04000000
#define TG_MAC_TX_STATE_AVAIL_ORUN_ERR	0x08000000
#define TG_MAC_TX_STATE_XOFF_ATTN	0x10000000
#define TG_MAC_TX_STATE_XON_ATTN	0x20000000
#define TG_MAC_TX_ATTN_MASK		0x3f000000

/*
 * MAC TX Config Bit definitions - have been moved to zconf.h
 */

/*
 * MAC TX Length Bit definitions
 */
#define TG_MAC_TX_LEN_SLOT_TIME_MASK	0x000000ff
#define TG_MAC_TX_LEN_IPG_LEN_MASK	0x00001f00
#define TG_MAC_TX_LEN_IPG_CARR_MASK	0x00006000

#define TG_MAC_TX_LEN_TAG_TYPE_MASK     0xffff0000	/* REV5/6 only */

/*
 * MAC RX Threshold Bit definitions
 */
#define TG_MAC_RX_THRESH_BUF_MASK	0x3e000000
#define TG_MAC_RX_THRESH_BUF_SHIFT	        25
#define TG_MAC_RX_THRESH_DESC_MASK	0x01f00000
#define TG_MAC_RX_THRESH_DESC_SHIFT	        20
#define TG_MAC_RX_THRESH_BUFF_XOFF_MASK	0x000f8000
#define TG_MAC_RX_THRESH_BUFF_XOFF_SHIFT        15
#define TG_MAC_RX_THRESH_DESC_XOFF_MASK	0x00007c00
#define TG_MAC_RX_THRESH_DESC_XOFF_SHIFT        10
#define TG_MAC_RX_THRESH_BUFF_XON_MASK	0x000003e0
#define TG_MAC_RX_THRESH_BUFF_XON_SHIFT	         5
#define TG_MAC_RX_THRESH_DESC_XON_MASK	0x0000001f
#define TG_MAC_RX_THRESH_DESC_XON_SHIFT	         0

/*
 * MAC RX State Bit definitions
 */
#define TG_MAC_RX_STATE_RESET		0x00000001
#define TG_MAC_RX_STATE_ENABLE		0x00000002
#endif /* !defined(PUBLIC_ONLY) */

#define TG_MAC_RX_STATE_STOP_NEXT	0x00000004

#if !defined(PUBLIC_ONLY)
#define TG_MAC_RX_STATE_ENA_PROMISC	0x00000008
#define TG_MAC_RX_STATE_MAX_JAMS_MASK	0x000000f0
#define TG_MAC_RX_STATE_NOTIFY_LEN_MASK	0x00007f00

#if (TIGON_REV & TIGON_REV5)
#define TG_MAC_RX_STATE_LINK_POL_HIGH	0x00008000
#endif /* (TIGON_REV & TIGON_REV5) */

#if (TIGON_REV & TIGON_REV4)
#define TG_MAC_RX_STATE_TX_FC_LEN	0x00008000
#endif /* (TIGON_REV & TIGON_REV4) */

/*#define TG_MAC_RX_STATE_ENA_FC		0x00010000
********XXXXXXXXXXXXXXXXXXXXXXXXX ARRGGGHHH!!!!!
Horrid hack to prevent TX being XOff'd. */

#define TG_MAC_RX_STATE_ENA_FC		0x00000000

#if (TIGON_REV & TIGON_REV4)
#define TG_MAC_RX_STATE_BLOCK_SYNC	0x00020000
#endif /* (TIGON_REV & TIGON_REV4) */

#if (TIGON_REV & TIGON_REV5)
#define TG_MAC_RX_STATE_BLOCKING	0x00020000
#endif /* (TIGON_REV & TIGON_REV5) */

#define TG_MAC_RX_STATE_LINK_SYNC	0x00040000
#define TG_MAC_RX_STATE_CONFIG_SYNC	0x00080000
#define TG_MAC_RX_STATE_XOFF_TC		0x00100000
#define TG_MAC_RX_STATE_ENA_FC_ATTN	0x00200000

#if (TIGON_REV & TIGON_REV4)
#define TG_MAC_RX_STATE_ENA_BUFIND_ATTN	0x00400000 /* This is out in rev5 */
#endif /* (TIGON_REV & TIGON_REV4) */

#define TG_MAC_RX_STATE_LINK_STATE_ATTN	0x01000000
#define TG_MAC_RX_STATE_NOT_SYNCED_ATTN	0x02000000

#if (TIGON_REV & TIGON_REV5)
#define TG_MAC_RX_STATE_AUTO_NEG_CHNGD	0x04000000
#define TG_MAC_RX_STATE_FIFO_OVERRUN	0x08000000
#endif /* (TIGON_REV & TIGON_REV5) */

#if (TIGON_REV & TIGON_REV4)
#define TG_MAC_RX_STATE_NOT_AVAIL_ERR	0x04000000
#endif /* (TIGON_REV & TIGON_REV4) */

#define TG_MAC_RX_STATE_XOFF_ATTN	0x10000000
#define TG_MAC_RX_STATE_XON_ATTN	0x20000000
#define TG_MAC_RX_STATE_BUF_ATTN	0x40000000
#define TG_MAC_RX_STATE_IND_ATTN	0x80000000
#define TG_MAC_RX_ATTN_MASK		0xf7000000

/*
 * MAC RX Config Bit definitions
 */
#define TG_MAC_RX_CONF_FULL_DUPLEX	TG_MAC_TX_CONF_FULL_DUPLEX
#define TG_MAC_RX_CONF_HALF_DUPLEX	TG_MAC_TX_CONF_HALF_DUPLEX
#define TG_MAC_RX_CONF_REMOTE_FAULT	TG_MAC_TX_CONF_REMOTE_FAULT
#define TG_MAC_RX_CONF_ACK		TG_MAC_TX_CONF_ACK
#define TG_MAC_RX_CONF_NEXT_PAGE	TG_MAC_TX_CONF_NEXT_PAGE

#if (TIGON_REV & TIGON_REV5)
/*
 * MAC Serial De-Serializer Bit definitions
 */
#define TG_MAC_SERDES_RXLOCK			0x80000000
#define TG_MAC_SERDES_TXLOCK			0x40000000
#define TG_MAC_SERDES_PASSN			0x20000000
#define TG_MAC_SERDES_RES2			0x10000000
#define TG_MAC_SERDES_RES1			0x08000000
#define TG_MAC_SERDES_RES0			0x04000000
#define TG_MAC_SERDES_TP_MASK			0x03000000
#define TG_MAC_SERDES_TZ_MASK			0x00c00000
#define TG_MAC_SERDES_RP_MASK			0x00300000
#define TG_MAC_SERDES_RZ_MASK			0x000c0000
#define TG_MAC_SERDES_EMPH_MASK			0x00030000
#define TG_MAC_SERDES_SELFTEST_MASK		0x0000e000
#define TG_MAC_SERDES_SCANTEST			0x00001000
#define TG_MAC_SERDES_PDOWNT			0x00000800
#define TG_MAC_SERDES_PDOWNR			0x00000400
#define TG_MAC_SERDES_PDOWNB			0x00000200
#define TG_MAC_SERDES_RDWS			0x00000100
#define TG_MAC_SERDES_TDWS			0x00000080
#define TG_MAC_SERDES_ENSYNCDET			0x00000040
#define TG_MAC_SERDES_SYNCPOL			0x00000020
#define TG_MAC_SERDES_WRAPBACK			0x00000010
#define TG_MAC_SERDES_LOOPBACK			0x00000008
#define TG_MAC_SERDES_LOCKREF			0x00000004
#define TG_MAC_SERDES_ENABLE			0x00000002
#define TG_MAC_SERDES_RESET			0x00000001

/*
 * MAC PCS Bit definitions
 */
#define TG_MAC_PCS_TEST_DATA_PAT_MASK		0x000FFFFF
#define TG_MAC_PCS_ENA_TEST_MODE		0x00100000
#endif /* (TIGON_REV & TIGON_REV5) */

#endif /* !defined(PUBLIC_ONLY) */

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/*
 *                     TOTAL LAYOUT OF REGISTER AREA
 */

typedef struct tg_regs {
    tgPciConf_t       pci_conf;
    tgGenControl_t    gen_control;
    tgHostDma_t       host_dma;
    tgLocalMemConf_t  local_mem_conf;
    tgHostDmaAssist_t host_dma_assist;
    tgCpuControl_t    cpu_control;
    tgCpuReg_t        cpu_reg;
    tgMacControl_t    mac_control;
#if (TIGON_REV & TIGON_REV5)
    tgCpuControl_t    cpu_control_b;
    tgCpuReg_t        cpu_reg_b;
    U32		      reserved[64];
#else /* (TIGON_REV & TIGON_REV5) */
    U32		      reserved[112];
#endif /* (TIGON_REV & TIGON_REV5) */
} tg_regs_t;

#if !defined(PUBLIC_ONLY)
#if defined(SUN_MP)
extern tg_regs_t *TRP;
#else  /* defined(SUN_MP) */
#define TRP ((tg_regs_t *)(TG_BEG_REGS))
#endif /* defined(SUN_MP) */
#endif /* !defined(PUBLIC_ONLY) */

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/*
 *                         SHARED MEMORY REGION
 */

typedef struct mac_stats {
    U32 excess_colls;
    U32 coll_1;
    U32 coll_2;
    U32 coll_3;
    U32 coll_4;
    U32 coll_5;
    U32 coll_6;
    U32 coll_7;
    U32 coll_8;
    U32 coll_9;
    U32 coll_10;
    U32 coll_11;
    U32 coll_12;
    U32 coll_13;
    U32 coll_14;
    U32 coll_15;
    U32 late_coll;
    U32 defers;
    U32 crc_err;
    U32 underrun;
    U32 crs_err;
    U32 res[3];
    U32 drop_ula;
    U32 drop_mc;
    U32 drop_fc;
    U32 drop_space;
    U32 coll;
#if (TIGON_REV & TIGON_REV5)
    U32 kept_bc;
    U32 kept_mc;
    U32 kept_uc;
#else /* (TIGON_REV & TIGON_REV5) */
    U32 res2[3];
#endif /* (TIGON_REV & TIGON_REV5) */
} mac_stats_t;


typedef struct tg_shmem {
    U32 keep_out[32];                   /* bottom 128 bytes inaccessible */
    mac_stats_t macstats;               /* MAC stats */
    tg_mbox_t mailbox[32];              /* mailboxes -- typedef elsewhere */
    tg_gencom_t gen_com;                /* gen comm area -- typedef elsewhere*/
                                        /*  must be exactly 512 bytes */
    /* NOTE: Following is *NOT* visible in local memory, only over PCI bus! */
    U32 loc_mem_window[512];            /* 2K local memory window */
    U32 host_dma_fifo[3072];            /* 12K host DMA FIFO access */
} tg_shmem_t;

#if !defined(PUBLIC_ONLY)
#if defined(SUN_MP)
extern tg_shmem_t *TSP;
#else  /* defined(SUN_MP) */
#define TSP ((tg_shmem_t *)(0))
#endif /* defined(SUN_MP) */
#endif /* !defined(PUBLIC_ONLY) */

#if !defined(PUBLIC_ONLY)
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/*
 *                    HARDWARE-ORIENTED DATA REGION
 */
/*
 * The following structure is the last addressable space in memory.
 * Any additions must be made to the front of this structure and must
 * insure the proper alignment of things like the MAC TX and RX buffers.
 *
 */

typedef struct tg_data {
    /*
     * our stack
     *
     * We are fixing the size of the stack initially to 4K.  This allows
     * us to place aligned data after the stack, and forces us to know
     * how much stack space we occupy, instead of "knowing that we have
     * enough"...
     */
#ifdef STACK_REDZONE
    U32 redzone[STACK_REDZONE_SIZE];
#endif /* STACK_REDZONE */
/*
 * TG_STACK_WORDS should be moved into the appropriate
 * xxx_conf.h files for each tigon based build...
 */
#define TG_STACK_WORDS	((4*1024)/sizeof(U32))
    U32 stack[TG_STACK_WORDS];
#if (TIGON_REV & TIGON_REV5)
    U32 stack_b[TG_STACK_WORDS];
#endif /* (TIGON_REV & TIGON_REV5) */
#if (SCRATCH_PAD_STACK_ADJUST)
    /*
     * This is only for ulitizing Tigon's CPU Adjust Stack feature.
     * The following stack page alignment padding is necessary
     * to have our stack[] and stack_b[] begin at 4k-byte boundary
     * as required by the Tigon chip to handle stack adjustment
     * to external stack.
     */
    U32 stack_page_align_padding[TG_STACK_PAGE_ALIGN_WORDS];
#endif /* (SCRATCH_PAD_STACK_ADJUST) */
    /*
     * This tx_mac_ring starts is fixed at 2k bytes long.
     */
#define TG_NUM_MAC_TX_DESCRS	256
    struct tg_mac_descr tx_mac_ring[TG_NUM_MAC_TX_DESCRS];
    /*
     * This rx_mac_ring starts is fixed at 4K bytes long.
     */
#define TG_NUM_MAC_RX_DESCRS	512
    struct tg_mac_descr rx_mac_ring[TG_NUM_MAC_RX_DESCRS];
    /*
     * the following must be in order, see Tigon document on
     * DMA assist for details...
     */
#if (TG_DMA_DESCR_CHAINED)
    struct tg_dma_descr rd_dma_ring[TG_DMA_ASSIST_DESCRS];
    struct tg_dma_descr wr_dma_ring[TG_DMA_ASSIST_DESCRS];
#else  /* (TG_DMA_DESCR_CHAINED) */
    struct tg_dma_descr rd_dma_ring[TG_DMA_ASSIST_DESCRS];  /* IAP _hi */
    struct tg_dma_descr rd_dma_lo_ring[TG_DMA_ASSIST_DESCRS];
    struct tg_dma_descr wr_dma_ring[TG_DMA_ASSIST_DESCRS];  /* IAP _hi */
    struct tg_dma_descr wr_dma_lo_ring[TG_DMA_ASSIST_DESCRS];
#endif /* (TG_DMA_DESCR_CHAINED) */
    /*
     * The TX data buffer is TG_TX_BUF_SIZE bytes long
     */
    U32 tx_buf[TG_TX_BUF_SIZE/sizeof(U32)];
    /*
     * The RX data buffer is TG_RX_BUF_SIZE bytes long
     */
    U32 rx_buf[TG_RX_BUF_SIZE/sizeof(U32)];

} tg_data_t;

#if (TIGON_REV & TIGON_REV4)
#define TG_DATA_END	0x200000	/* logical end of memory */
#else /* (TIGON_REV & TIGON_REV4) */
/*
 * XXX Need to add a new define for end of memory.  TG_DATA_END is end
 * of memory addressable by the MAC interface.
 */
#define TG_DATA_END	0x200000	/* logical end of memory */
#endif /* (TIGON_REV & TIGON_REV4) */
#define TG_DATA_START	(TG_DATA_END - sizeof(tg_data_t))

#if defined(SUN_MP)
extern tg_data_t *TDP;
#define TG_STACK_START 0
#if (TIGON_REV & TIGON_REV5)
#define TG_STACK_START_B 0
#endif /* (TIGON_REV & TIGON_REV5) */
#else  /* defined(SUN_MP) */
#define TDP ((tg_data_t *)(TG_DATA_START))
/*
 * Start.s loads in the value of stack_start from data.c to determine
 * where the stack goes.  Stack grows downward.
 */
#define TG_STACK_START	(&TDP->stack[TG_STACK_WORDS - 1])
#if (TIGON_REV & TIGON_REV5)
#define TG_STACK_START_B (&TDP->stack_b[TG_STACK_WORDS - 1])
#endif /* (TIGON_REV & TIGON_REV5) */
#endif /* defined(SUN_MP) */
#endif /* !defined(PUBLIC_ONLY) */

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

/*
 * NOTE: Following used only by HOST drivers.
 */
/* internal processor memory mapping, used by ALT_READ_TG_MEM and
 * ALT_WRITE_TG_MEM to figure out how to map this into the host.  The
 * calls to the ioctl() always work with the Tigon processor 
 * outlook, not the host outlook 
 */
#define TG_BEG_SRAM     0x0             /* host thinks it's here */
#define TG_BEG_SCRATCH  0xc00000        /* beg of scratch pad area */
#if (TIGON_REV & TIGON_REV5)
#define TG_END_SRAM     0x800000        /* end of SRAM, for 2 MB stuffed */
#define TG_END_SCRATCH  0xc04000        /* end of scratch pad CPU A (16KB) */
#define TG_END_SCRATCH_B 0xc02000       /* end of scratch pad CPU B (8KB) */
#define TG_BEG_SCRATCH_B_DEBUG 0xd00000 /* beg of scratch pad for ioctl */
#define TG_END_SCRATCH_B_DEBUG 0xd02000 /* end of scratch pad for ioctl */
#define TG_SCRATCH_DEBUG_OFF 0x100000	/* offset for ioctl usage */
#else /* (TIGON_REV & TIGON_REV5) */
#define TG_END_SRAM     0x200000        /* end of SRAM, for 2 MB stuffed */
#define TG_END_SCRATCH  0xc00800        /* end of scratch pad area (2KB) */
#endif /* (TIGON_REV & TIGON_REV5) */
#define TG_BEG_PROM   	0x40000000      /* beg of PROM, special access */
#define TG_BEG_FLASH    0x80000000      /* beg of EEPROM, special access */
#define TG_END_FLASH    0x80100000      /* end of EEPROM for 1 MB stuff */
#define TG_BEG_SER_EEPROM 0xa0000000    /* beg of Serial EEPROM (fake out) */
#define TG_END_SER_EEPROM 0xa0002000    /* end of Serial EEPROM (fake out) */
#define TG_BEG_REGS     0xc0000000      /* beg of register area */
#define TG_END_REGS     0xc0000400      /* end of register area */
#define TG_END_WRITE_REGS 0xc0000180    /* can't write GPRs currently */
#define TG_BEG_REGS2    0xc0000200      /* beg of second writeable reg area */
/* the EEPROM is byte addressable in a pretty odd way */
#define EEPROM_BYTE_LOC 0xff000000

/* board addresses (mapped starting at 0x0) */
#define TG_DEV_ID      0
#define TG_VENDOR_ID   2
#define TG_STATUS      4
#define TG_COMMAND     6
#define TG_CLASS       8
#define TG_BIST        0xc
#define TG_LAT_TIMER   0xd
#define TG_SHARED_BASE 0x10
#define TG_SUBSYS_ID	0x2c
#define TG_SUBSYS_VENDOR_ID	0x2e
#define TG_MAX_LAT     0x3c

#define TG_MISC_HOST_CONTROL  0x40
#define TG_MISC_LOCAL_CONTROL 0x44

#if !defined(PUBLIC_ONLY)
#if (TIGON_REV & TIGON_REV5)
#define TG_SEMAPHORE_A  	0x48
#define TG_SEMAPHORE_B 		0x4C
#endif /* (TIGON_REV & TIGON_REV5) */
#endif /* !defined(PUBLIC_ONLY) */

#if (TIGON_REV & TIGON_REV5)
#define TG_MISC_CONFIG        0x50
#endif /* (TIGON_REV & TIGON_REV5) */
#if !defined(PUBLIC_ONLY)
#if (TIGON_REV & TIGON_REV4)
#define TG_TIMER_STATE        0x50
#endif /* (TIGON_REV & TIGON_REV4) */
#endif /* !defined(PUBLIC_ONLY) */

#if !defined(PUBLIC_ONLY)
#define TG_TIMER              0x54
#define TG_TIMER_REF          0x58
#endif /* !defined(PUBLIC_ONLY) */

#define TG_PCI_STATE          0x5c

#if !defined(PUBLIC_ONLY)
#define TG_EVENT              0x60
#define TG_MBOX_EVENT         0x64
#if (TIGON_REV & TIGON_REV5)
#define TG_EVENT_B            0x70
#define TG_MBOX_EVENT_B       0x74
#define TG_TIMER_REF_B        0x78
#endif /* (TIGON_REV & TIGON_REV5) */
#endif /* !defined(PUBLIC_ONLY) */

#define TG_WINDOW_BASE        0x68
#define TG_WINDOW_DATA        0x6c

#if !defined(PUBLIC_ONLY)
#define TG_EXT_SERIAL         0x7c

#define TG_DMA_WRITE_HOST_HI  0x80
#define TG_DMA_WRITE_HOST_LO  0x84
#define TG_DMA_READ_HOST_HI   0x90
#define TG_DMA_READ_HOST_LO   0x94
#define TG_DMA_READ_LEN       0x9c
#endif /* !defined(PUBLIC_ONLY) */

#define TG_DMA_WRITE_STATE    0xa0

#if !defined(PUBLIC_ONLY)
#define TG_DMA_WRITE_ADDR     0xa4
#define TG_DMA_WRITE_CKSM     0xa8
#define TG_DMA_WRITE_LEN      0xac
#endif /* !defined(PUBLIC_ONLY) */

#define TG_DMA_READ_STATE     0xb0

#if !defined(PUBLIC_ONLY)
#define TG_DMA_READ_ADDR      0xb4
#define TG_DMA_READ_CKSM      0xb8 

#define TG_RECV_BUF_BASE      0xc0
#define TG_RECV_BUF_PROD      0xc4
#define TG_RECV_BUF_CONSUME   0xc8
#define TG_RECV_BUF_START     0xcc
#define TG_SEND_BUF_BASE      0xd0
#define TG_SEND_BUF_PROD      0xd4
#define TG_SEND_BUF_CONSUME   0xd8
#define TG_DELAY_LINE_STATE   0xdc
#define TG_MAC_RECV_PROD      0xe0
#define TG_MAC_RECV_CONS      0xe4
#define TG_MAC_RECV_REF       0xe8
#define TG_CPU_PRIOR          0xec
#define TG_MAC_SEND_PROD      0xf0
#define TG_MAC_SEND_CONS      0xf4
#define TG_MAC_SEND_REF       0xf8

#define TG_READ_HI_PROD       0x100
#define TG_READ_HI_CONS       0x104
#define TG_READ_HI_REF        0x108
#define TG_READ_LO_PROD       0x110
#define TG_READ_LO_CONS       0x114
#define TG_READ_LO_REF        0x118
#endif /* !defined(PUBLIC_ONLY) */

#define TG_ASSIST_STATE       0x11c

#if !defined(PUBLIC_ONLY)
#define TG_WRITE_HI_PROD      0x120
#define TG_WRITE_HI_CONS      0x124
#define TG_WRITE_HI_REF       0x128
#define TG_WRITE_LO_PROD      0x130
#define TG_WRITE_LO_CONS      0x134
#define TG_WRITE_LO_REF       0x138
#endif /* !defined(PUBLIC_ONLY) */

#define TG_CPU_CONTROL        0x140
#define TG_PROG_CTR           0x144

#if !defined(PUBLIC_ONLY)
#define TG_BREAKPOINT         0x148
#if (TIGON_REV & TIGON_REV5)
#define TG_CPU_INSTRUCTION    0x14C
#endif /* (TIGON_REV & TIGON_REV5) */

#if (TIGON_REV & TIGON_REV5)
#define TG_ADJUST_STACK       0x150
#endif /* (TIGON_REV & TIGON_REV5) */
#if (TIGON_REV & TIGON_REV4)
#define TG_SRAM_BASE          0x150
#endif /* (TIGON_REV & TIGON_REV4) */
#endif /* !defined(PUBLIC_ONLY) */

#define TG_SRAM_ADDR          0x154
#define TG_SRAM_DATA          0x158

#if !defined(PUBLIC_ONLY)
#define TG_WATCHDOG_CLEAR     0x15c
#endif /* !defined(PUBLIC_ONLY) */

#define TG_GPR0               0x180
#define TG_CPU_REGS           TG_GPR0
#define TG_GPR1               0x184
#define TG_GPR2               0x188
#define TG_GPR3               0x18c
#define TG_GPR4               0x190
#define TG_GPR5               0x194
#define TG_GPR6               0x198
#define TG_GPR7               0x19c
#define TG_GPR8               0x1a0
#define TG_GPR9               0x1a4
#define TG_GPR10              0x1a8
#define TG_GPR11              0x1ac
#define TG_GPR12              0x1b0
#define TG_GPR13              0x1b4
#define TG_GPR14              0x1b8
#define TG_GPR15              0x1bc
#define TG_GPR16              0x1c0
#define TG_GPR17              0x1c4
#define TG_GPR18              0x1c8
#define TG_GPR19              0x1cc
#define TG_GPR20              0x1d0
#define TG_GPR21              0x1d4
#define TG_GPR22              0x1d8
#define TG_GPR23              0x1dc
#define TG_GPR24              0x1e0
#define TG_GPR25              0x1e4
#define TG_GPR26              0x1e8
#define TG_GPR27              0x1ec
#define TG_GPR28              0x1f0
#define TG_GPR29              0x1f4
#define TG_GPR30              0x1f8
#define TG_FRAME_PTR          TG_GPR30
#define TG_GPR31              0x1fc

#if (TIGON_REV & TIGON_REV5)
#define TG_PROCESSOR_A		0
#define TG_PROCESSOR_B		1
#define TG_CPU_A		TG_PROCESSOR_A
#define TG_CPU_B		TG_PROCESSOR_B
/*
 * Following macro can be used to access to any of the CPU registers
 * It will adjust the address appropriately.
 * Parameters:
 * 	reg - The register to access, e.g TG_CPU_CONTROL
 *      cpu - cpu, i.e PROCESSOR_A or PROCESSOR_B (or TG_CPU_A or TG_CPU_B)
 */
#define CPU_REG(reg, cpu) ((reg) + (cpu) * 0x100)
#endif /* (TIGON_REV & TIGON_REV5) */

#if !defined(PUBLIC_ONLY)
#define TG_MAC_TX_STATE       0x200
#define TG_MAC_TX_CONFIG      0x204
#define TG_MAC_ADDR           0x208
#define TG_MAC_RANDOM         0x210
#define TG_MAC_LEN            0x214
#define TG_MAC_IDLE           0x218
#endif /* !defined(PUBLIC_ONLY) */

#define TG_MAC_RX_STATE       0x220

#if !defined(PUBLIC_ONLY)
#define TG_MAC_RX_CONFIG      0x224
#define TG_MAC_MCAST1_ADDR    0x228
#define TG_MAC_MCAST2_ADDR    0x22c
#if (TIGON_REV & TIGON_REV5)
#define TG_MAC_MCAST3_ADDR    0x230
#define TG_MAC_MCAST4_ADDR    0x234
#define TG_MAC_SER_DES_CONFIG 0x238
#define TG_MAC_PHY_PCS_CONFIG 0x23C
#endif /* (TIGON_REV & TIGON_REV5) */
#endif /* !defined(PUBLIC_ONLY) */

#define TG_MAX_REG            0x3ff      /* max addr accessable via reg */ 

#define TG_SHMEM_START        0x400      /* start of shmem_t structure */
				         /* from host perspective */
#define TG_SW_REG_AREA        0x500
#define TG_MBOX0_HIGH         0x500
#define TG_MBOX0_LOW          0x504
#define TG_MBOX1_HIGH         0x508
#define TG_MBOX1_LOW          0x50c
#define TG_MBOX2_HIGH         0x510
#define TG_MBOX2_LOW          0x514
#define TG_MBOX3_HIGH         0x518
#define TG_MBOX3_LOW          0x51c
#define TG_MBOX4_HIGH         0x520
#define TG_MBOX4_LOW          0x524
#define TG_MBOX5_HIGH         0x528
#define TG_MBOX5_LOW          0x52c

#if !defined(PUBLIC_ONLY)
#define TG_MBOX6_HIGH         0x530
#define TG_MBOX6_LOW          0x534
#define TG_MBOX7_HIGH         0x538
#define TG_MBOX7_LOW          0x53c
#define TG_MBOX8_HIGH         0x540
#define TG_MBOX8_LOW          0x544
#define TG_MBOX9_HIGH         0x548
#define TG_MBOX9_LOW          0x54c
#define TG_MBOX10_HIGH        0x550
#define TG_MBOX10_LOW         0x554
#define TG_MBOX11_HIGH        0x558
#define TG_MBOX11_LOW         0x55c
#define TG_MBOX12_HIGH        0x560
#define TG_MBOX12_LOW         0x564
#define TG_MBOX13_HIGH        0x568
#define TG_MBOX13_LOW         0x56c
#define TG_MBOX14_HIGH        0x570
#define TG_MBOX14_LOW         0x574
#define TG_MBOX15_HIGH        0x578
#define TG_MBOX15_LOW         0x57c
#define TG_MBOX16_HIGH        0x580
#define TG_MBOX16_LOW         0x584
#define TG_MBOX17_HIGH        0x588
#define TG_MBOX17_LOW         0x58c
#define TG_MBOX18_HIGH        0x590
#define TG_MBOX18_LOW         0x594
#define TG_MBOX19_HIGH        0x598
#define TG_MBOX19_LOW         0x59c
#define TG_MBOX20_HIGH        0x5a0
#define TG_MBOX20_LOW         0x5a4
#define TG_MBOX21_HIGH        0x5a8
#define TG_MBOX21_LOW         0x5ac
#define TG_MBOX22_HIGH        0x5b0
#define TG_MBOX22_LOW         0x5b4
#define TG_MBOX23_HIGH        0x5b8
#define TG_MBOX23_LOW         0x5bc
#define TG_MBOX24_HIGH        0x5c0
#define TG_MBOX24_LOW         0x5c4
#define TG_MBOX25_HIGH        0x5c8
#define TG_MBOX25_LOW         0x5cc
#define TG_MBOX26_HIGH        0x5d0
#define TG_MBOX26_LOW         0x5d4
#define TG_MBOX27_HIGH        0x5d8
#define TG_MBOX27_LOW         0x5dc
#define TG_MBOX28_HIGH        0x5e0
#define TG_MBOX28_LOW         0x5e4
#define TG_MBOX29_HIGH        0x5e8
#define TG_MBOX29_LOW         0x5ec
#define TG_MBOX30_HIGH        0x5f0
#define TG_MBOX30_LOW         0x5f4
#define TG_MBOX31_HIGH        0x5f8
#define TG_MBOX31_LOW         0x5fc
#endif /* !defined(PUBLIC_ONLY) */

#define TG_MEM_WINDOW         0x800
#define TG_MEM_WINDOW_SIZE    0x800
#define TG_MEM_WINDOW_SHIFT   7

#if !defined(PUBLIC_ONLY)
#define TG_DMA_FIFO_ACC       0x1000
#endif /* !defined(PUBLIC_ONLY) */


#if !defined(PUBLIC_ONLY)
/* macros for working with the memory window */
#define TG_MEM_WINDOW_ALIGNED(addr) (((int)(addr) & (TG_MEM_WINDOW_SIZE-1)) == 0)
#define TG_MEM_WINDOW_RESID(addr) (TG_MEM_WINDOW_SIZE - ((int)(addr) & (TG_MEM_WINDOW_SIZE-1)))
#define TG_MEM_WINDOW_OFFSET(addr) ((int)(addr) & (TG_MEM_WINDOW_SIZE-1))
#define TG_MEM_WINDOW_PAGE(addr) ((int)(addr) & ~(TG_MEM_WINDOW_SIZE-1))
#endif /* !defined(PUBLIC_ONLY) */

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

#endif /* _TG_H_ */


