/*
 * COPYRIGHT NOTICE
 * Copyright (c) Alteon Networks, Inc. 1996 
 * All rights reserved
 */
/*
 * HISTORY
 * $Log: np.c,v $
 * Revision 1.4  1999/06/22 12:43:01  tjd21
 * Before removing extra recv rings
 *
 * Revision 1.1  1999/06/07 10:53:09  tjd21
 * Start of archive
 *
 * Revision 1.1.2.9  1998/01/29  19:37:08  ted
 * 	Fix broken syntax
 * 	[1998/01/29  19:22:19  ted]
 *
 * Revision 1.1.2.8  1998/01/21  23:11:36  hayes
 * 	#ifdeff out unused next page code and data structures
 * 	[1998/01/21  23:09:48  hayes]
 * 
 * Revision 1.1.2.7  1998/01/04  23:48:10  hayes
 * 	seperate Alteon device detection from other capability detection
 * 	[1998/01/04  02:27:56  hayes]
 * 
 * Revision 1.1.2.6  1997/10/30  02:21:15  hayes
 * 	get link negotiation working for Tigon2
 * 	[1997/10/30  02:18:10  hayes]
 * 
 * Revision 1.1.4.2  1997/10/19  19:55:41  hayes
 * 	fix next page negotiation and recognition
 * 	[1997/10/19  19:54:40  hayes]
 * 
 * Revision 1.1.4.1  1997/10/17  21:48:45  hayes
 * 	update for D3.2 compliant link state machine
 * 	[1997/10/17  21:42:19  hayes]
 * 
 * Revision 1.1.2.5  1997/10/13  16:46:56  hayes
 * 	remove extrameous entries...
 * 	[1997/10/13  16:46:35  hayes]
 * 
 * Revision 1.1.2.4  1997/10/10  20:38:09  hayes
 * 	new next page code
 * 	[1997/10/10  20:35:50  hayes]
 * 
 * 	completed link code restructuring
 * 	[1997/08/29  22:11:04  hayes]
 * 
 * Revision 1.1.2.3  1997/08/29  22:11:58  hayes
 * 	completed link code restructuring
 * 
 * Revision 1.1.2.2  1997/08/12  03:31:26  hayes
 * 	added dummy NULL page at front of array for new array mechanism
 * 	[1997/08/12  03:30:35  hayes]
 * 
 * Revision 1.1.2.1  1997/08/12  02:53:57  hayes
 * 	initial checkin
 * 	[1997/08/12  02:50:03  hayes]
 * 
 * $EndLog$
 */

#include "link.h"
#include "zconf.h"
#include "np.h"

#ifdef DO_NEXT_PAGE

/*
 * the following pointers are save across invocations of 
 * do_next_page()
 */
np_oui_info_t *rx_npp;	/* pointer for receiving pages */
np_oui_info_t *tx_npp;	/* pointer for sending pages */

U32 rx_unformatted_remaining = 0;
U32 tx_unformatted_remaining = 0;
U32 receiving_oui = 0;
U32 transmitting_oui = 0;
U32 oui_sequence[4];

/*
 * these are the OUI messages that we understand
 */
np_oui_info_t oui_msgs[] = {
    /* NULL stanza must be first */
    {  OUI_LINK_FEATURE_NULL,		/* type */
       0,				/* tx index */
       0,				/* rx index */
       { 0, 0, 0, 0 },			/* data */
       0                                /* flags */
    },
    {  OUI_LINK_FEATURE_ALTEON,		/* type */
       0,				/* tx index */
       0,				/* rx index */
       { OUI_UP1(OUI_LINK, OUI_LINK_PARTNER, OUI_LINK_FEATURE_ALTEON),
         OUI_UP2(OUI_LINK, OUI_LINK_PARTNER, OUI_LINK_FEATURE_ALTEON),
         OUI_UP3(OUI_LINK, OUI_LINK_PARTNER, OUI_LINK_FEATURE_ALTEON),
         OUI_UP4(OUI_LINK, OUI_LINK_PARTNER, OUI_LINK_FEATURE_ALTEON) },
       NP_INFO_TX | NP_INFO_ACK2        /* flags */
    },
    {  OUI_LINK_FEATURE_NIC,		/* type */
       0,				/* tx index */
       0,				/* rx index */
       { OUI_UP1(OUI_LINK, OUI_LINK_PARTNER, OUI_LINK_FEATURE_NIC),
         OUI_UP2(OUI_LINK, OUI_LINK_PARTNER, OUI_LINK_FEATURE_NIC),
         OUI_UP3(OUI_LINK, OUI_LINK_PARTNER, OUI_LINK_FEATURE_NIC),
         OUI_UP4(OUI_LINK, OUI_LINK_PARTNER, OUI_LINK_FEATURE_NIC) },
#if defined(NIC)
       /*
	* only ACK2 this one if we are really a NIC
	*/
       NP_INFO_TX | NP_INFO_ACK2        /* flags */
#else /* defined(NIC) */
       NP_INFO_TX                       /* flags */
#endif /* defined(NIC) */
    },
    {  OUI_LINK_FEATURE_JUMBO,		/* type */
       0,				/* tx index */
       0,				/* rx index */
       { OUI_UP1(OUI_LINK, OUI_LINK_PARTNER, OUI_LINK_FEATURE_JUMBO),
         OUI_UP2(OUI_LINK, OUI_LINK_PARTNER, OUI_LINK_FEATURE_JUMBO),
         OUI_UP3(OUI_LINK, OUI_LINK_PARTNER, OUI_LINK_FEATURE_JUMBO),
         OUI_UP4(OUI_LINK, OUI_LINK_PARTNER, OUI_LINK_FEATURE_JUMBO) },
       NP_INFO_TX | NP_INFO_ACK2        /* flags */
    },
    /* NULL stanzas must be last */
    {  OUI_LINK_FEATURE_NULL,		/* type */
       0,				/* tx index */
       0,				/* rx index */
       { 0, 0, 0, 0 },			/* data */
       NP_INFO_TX                       /* flags */
    },
    {  OUI_LINK_FEATURE_NULL,		/* type */
       0,				/* tx index */
       0,				/* rx index */
       { 0, 0, 0, 0 },			/* data */
       NP_INFO_DONE                     /* flags */
    }
};

#endif /* DO_NEXT_PAGE */


