/*
 * COPYRIGHT NOTICE
 * Copyright (c) Alteon Networks, Inc. 1996, 1997 
 * All rights reserved
 * 
 */
/*
 * HISTORY
 * $Log: link_op.h,v $
 * Revision 1.4  1999/06/22 12:43:01  tjd21
 * Before removing extra recv rings
 *
 * Revision 1.1  1999/06/07 10:53:09  tjd21
 * Start of archive
 *
 * Revision 1.1.2.31  1998/10/31  00:41:06  tibor
 * 	off by 1 index
 * 	[1998/10/31  00:09:41  tibor]
 *
 * Revision 1.1.2.30  1998/09/22  23:42:31  taylor
 * 	Finalize software keys
 * 	[1998/09/22  22:54:58  taylor]
 * 
 * Revision 1.1.2.29  1998/09/16  23:21:49  hayes
 * 	new gig reset state machine works
 * 	[1998/09/14  20:56:33  hayes]
 * 
 * 	intermedioate checkin
 * 	[1998/09/14  17:08:58  hayes]
 * 
 * Revision 1.1.2.28  1998/03/18  03:44:00  hayes
 * 	restructure mac mgt interface
 * 	[1998/03/18  03:38:00  hayes]
 * 
 * Revision 1.1.2.27  1998/02/06  22:19:44  hayes
 * 	improve 10/100 link bringup times
 * 	[1998/02/06  22:18:28  hayes]
 * 
 * Revision 1.1.2.26  1998/01/26  10:29:11  hayes
 * 	remove bogus LINK_TIMER fix
 * 	[1998/01/26  10:28:58  hayes]
 * 
 * Revision 1.1.2.25  1998/01/26  06:24:34  hayes
 * 	fix link timer, change FIX_DISPARITY() macro
 * 	[1998/01/26  06:23:48  hayes]
 * 
 * Revision 1.1.2.24  1998/01/22  22:51:14  hayes
 * 	fix different phy fctl bug
 * 	[1998/01/22  22:47:21  hayes]
 * 
 * Revision 1.1.2.23  1998/01/20  04:39:17  hayes
 * 	add tigon Rev6 support
 * 	[1998/01/20  04:37:07  hayes]
 * 
 * Revision 1.1.2.22  1998/01/14  23:58:55  hayes
 * 	improve low level link robustness
 * 	[1998/01/14  23:58:40  hayes]
 * 
 * Revision 1.1.2.21  1998/01/08  22:32:51  tibor
 * 	converted DISABLE_MAC_RX to function
 * 	[1998/01/08  22:21:41  tibor]
 * 
 * Revision 1.1.2.20  1997/12/28  01:09:13  hayes
 * 	improve gig link bringup speed
 * 	[1997/12/28  01:08:56  hayes]
 * 
 * Revision 1.1.2.19  1997/12/09  23:56:42  hayes
 * 	cleanup link negotiation
 * 	[1997/12/09  23:55:42  hayes]
 * 
 * Revision 1.1.2.18  1997/12/09  02:38:04  hayes
 * 	fix timer incompatibility between nic and switch
 * 	[1997/12/09  02:37:46  hayes]
 * 
 * Revision 1.1.2.17  1997/11/29  22:09:27  hayes
 * 	internal SERDES link code now works for everything
 * 	[1997/11/29  22:09:13  hayes]
 * 
 * Revision 1.1.2.16  1997/11/26  01:08:47  hayes
 * 	improve external serdes bringup
 * 	[1997/11/26  01:07:24  hayes]
 * 
 * Revision 1.1.2.15  1997/11/24  01:00:21  taylor
 * 	Rev5: move data structures into scratchpad
 * 	[1997/11/23  21:42:55  taylor]
 * 
 * Revision 1.1.2.14  1997/11/21  23:54:17  hayes
 * 	MII link down works
 * 	[1997/11/21  23:53:56  hayes]
 * 
 * Revision 1.1.2.13  1997/11/21  04:48:11  hayes
 * 	Merged with changes from 1.1.2.12
 * 	[1997/11/21  04:47:59  hayes]
 * 
 * 	release for NIC 2.1 pre-Beta
 * 	[1997/11/21  03:19:11  hayes]
 * 
 * 	internal and external SERDES co-exist peacefully
 * 	[1997/11/20  01:28:01  hayes]
 * 
 * Revision 1.1.2.12  1997/11/19  19:22:07  ted
 * 	Support Tigon and Tigon2 in the same driver
 * 	[1997/11/19  19:15:03  ted]
 * 
 * Revision 1.1.2.11  1997/11/13  16:45:35  kyung
 * 	Merged with changes from 1.1.2.10
 * 	[1997/11/13  16:45:24  kyung]
 * 
 * 	Rev5: more hardware software integration
 * 	[1997/11/13  16:41:10  kyung]
 * 
 * Revision 1.1.2.10  1997/11/13  00:51:38  hayes
 * 	add BRINGUP_1000_FLAP_CHECK_TIMER_NOLC
 * 	[1997/11/13  00:50:30  hayes]
 * 
 * Revision 1.1.2.9  1997/11/11  19:05:50  hayes
 * 	restructuring for NIC scratchpad use
 * 	[1997/11/11  19:04:42  hayes]
 * 
 * Revision 1.1.2.8  1997/11/09  23:27:28  hayes
 * 	link bringup is more reliable for non-LC, int-SERDES mode
 * 	[1997/11/09  23:27:07  hayes]
 * 
 * Revision 1.1.2.7  1997/11/03  22:38:28  hayes
 * 	 fix link bringup
 * 	[1997/11/03  22:37:29  hayes]
 * 
 * Revision 1.1.2.6  1997/09/25  20:42:16  hayes
 * 	fix len notify from 32 to 64 bytes
 * 	[1997/09/25  20:41:46  hayes]
 * 
 * Revision 1.1.2.5  1997/09/20  19:44:43  hayes
 * 	fix up for TIGON_REV5
 * 	[1997/09/20  19:43:58  hayes]
 * 
 * Revision 1.1.2.4  1997/09/17  03:26:28  hayes
 * 	Added proper #ifdefs for rev4 and rev5.
 * 	Changed various BRINGUP_XXX_TIMER to use real clock values instead
 * 	of times through the state machine.
 * 	Swapped position of ATTACHED_PHY_IF_SERDES_EXT and _INT.
 * 	[1997/09/15  22:22:25  hayes]
 * 
 * Revision 1.1.2.3  1997/09/10  03:55:11  hayes
 * 	remove old ATTACHED_PHY_XXX definitions
 * 	[1997/09/10  03:51:05  hayes]
 * 
 * 	completed link code restructuring
 * 	[1997/08/29  22:10:56  hayes]
 * 
 * Revision 1.1.2.2  1997/08/29  22:11:55  hayes
 * 	completed link code restructuring
 * 
 * Revision 1.1.2.1  1997/08/26  21:08:57  hayes
 * 	initial checkin
 * 	[1997/08/26  21:01:27  hayes]
 * 
 * $EndLog$
 */

#ifndef _LINK_OP_H_
#define _LINK_OP_H_

/*
 * fundamental hardclock is 1 us.
 */
#define LINK_TIMER			10000

/**************************************************************/

extern U32 runt_frame[16];	/* runt_frame[] is declared in link.c */
#define RUNT_LEN        	  64 /* not really a runt anymore... */
#define LOOPBACK_FRAME_LEN        64

/**************************************************************/

/*
 * generify the NIC/switch areas...
 */
#if defined(NIC)

#if (TIGON_REV & TIGON_REV4)
#define EVENT_MASK              NIC->event_mask
#else /*  (TIGON_REV & TIGON_REV4) */
#define EVENT_MASK              event_mask
#endif /*  (TIGON_REV & TIGON_REV4) */

#define LINK_TRACE              NIC_TRACE
#define LINK_UTRACE             NIC_UTRACE
#define BRINGUP_LINK_STATE      NIC->bringup_link_state
 
#else /* defined(NIC) */
 
#define EVENT_MASK              event_mask
#define LINK_TRACE              TS_TRACE
#define LINK_UTRACE             TS_UTRACE
#if defined(SP2)
#define BRINGUP_LINK_STATE      timedata.bringup_link_state
#else /* defined(SP2) */
#define BRINGUP_LINK_STATE      macdata.bringup_link_state
#endif /* defined(SP2) */
 
#endif /* defined(NIC) */

/*
 * generify REV 4/5 things here...
 */
#if (TIGON_REV & TIGON_REV4)
#define SERDES_CONFIG 0
#else /*  (TIGON_REV & TIGON_REV4) */
#define SERDES_CONFIG trp->mac_control.mac_serdes_config
#endif /*  (TIGON_REV & TIGON_REV4) */
 
/**** end generification section ************/

/**************************************************************/

/*
 * number if MAC we have (and size of arrays of MAC data structures)
 */
#define NUM_MACS		1

/*
 * index for single MAC (Tigon 1 & 2) implementations
 */
#define TIGON_MAC_INDEX		0

extern U32 additional_rx_bits_wanted;
 
/* link related externs */

/*
 * defines for the bringup_link() state machine
 */
 
#define BRINGUP_LINK_STATE_RESET_START          1
#define BRINGUP_LINK_STATE_RESET_WAIT           2
#define BRINGUP_LINK_STATE_STABILIZE_START      3
#define BRINGUP_LINK_STATE_STABILIZE_WAIT       4
#define BRINGUP_LINK_STATE_FLAP_CHECK_START     5
#define BRINGUP_LINK_STATE_FLAP_CHECK_WAIT      6
#define BRINGUP_LINK_STATE_READY_START          7
#define BRINGUP_LINK_STATE_READY                8

#define BRINGUP_10_100_FLAP_CHECK_TIMER         10000   /* 10 ms */
#define BRINGUP_1000_RESET_TIMER                10000   /* 10 ms */
#define BRINGUP_1000_STABILIZE_TIMER            10000   /* 10 ms */
#define BRINGUP_1000_FLAP_CHECK_TIMER           10      /* 10 us */

extern U32 link_attn_count;

#define LINK_ATTN_THRESH 3

#define FLAP_RETRY_THRESH	3

/*
 * MAC enable and disable macros
 * XXX Note that these are very hardware specific
 */

#if (TIGON_REV & TIGON_REV4)
void disable_mac_rx(void);
#define DISABLE_MAC_RX() disable_mac_rx()
 
#define ENABLE_MAC_RX() \
    trp->mac_control.mac_rx_state &= ~TG_MAC_RX_STATE_STOP_NEXT; \
    trp->mac_control.mac_rx_state |= TG_MAC_RX_STATE_ENABLE;
#endif  /* (TIGON_REV & TIGON_REV4) */

#if (TIGON_REV & TIGON_REV5)
#define DISABLE_MAC_RX()

#define ENABLE_MAC_RX() \
    trp->mac_control.mac_rx_state |= TG_MAC_RX_STATE_ENABLE;
#endif  /* (TIGON_REV & TIGON_REV5) */
 
/* forward declarations */
void bringup_link(void);
void activate_phy(void);
void probe_phy(void);
void init_mac1(void);
void mac_reset(void);

/* the following routines are specified in mac.c for each platform */
void link_up_notify(void);
void link_down_notify(void);

/*
 * defines and forward declarations for determining what PHY we are
 * attached to
 */

extern U32 attached_phy;
extern U32 active_phy;
extern U32 active_phy_fail;
extern U32 reset_phy;
extern U32 link_ready;

extern U32 phy_link_state;

/*
 * attached phy interfaces
 */
#define ATTACHED_PHY_IF_MII		0x0001
#define ATTACHED_PHY_IF_GMII		0x0002
#define ATTACHED_PHY_IF_SERDES_EXT	0x0004
#define ATTACHED_PHY_IF_SERDES_INT	0x0008

/*
 * states for reset_gig_phy()...
 */
#define RESET_PHY_GIG_RESET			1
#define RESET_PHY_GIG_RESET_WAIT		2
#define RESET_PHY_GIG_LOOPBACK_SYNC		3
#define RESET_PHY_GIG_LOOPBACK_SYNC_WAIT	4
#define RESET_PHY_GIG_DISPARITY_FIX		5
#define RESET_PHY_GIG_DISPARITY_FIX_WAIT	6
#define RESET_PHY_GIG_CORRECT_DISPARITY		7
#define RESET_PHY_GIG_RESET_WAIT_2		8
#define RESET_PHY_GIG_READY			9

#endif /* _LINK_OP_H_ */
