/*
 * COPYRIGHT NOTICE
 * Copyright (c) Alteon Networks, Inc. 1996, 1997 
 * All rights reserved
 * 
 */
/*
 * HISTORY
 * $Log: link_if.h,v $
 * Revision 1.4  1999/06/22 12:43:01  tjd21
 * Before removing extra recv rings
 *
 * Revision 1.1  1999/06/07 10:53:09  tjd21
 * Start of archive
 *
 * Revision 1.1.2.7  1998/03/18  03:44:00  hayes
 * 	restructure mac mgt interface
 * 	[1998/03/18  03:37:58  hayes]
 *
 * Revision 1.1.2.6  1998/02/27  02:42:15  hayes
 * 	fix link preferences and restructure link mgt interface
 * 	[1998/02/27  02:41:30  hayes]
 * 
 * Revision 1.1.2.5  1997/12/12  05:34:32  hayes
 * 	set_mac_link() and get_mac_link() now take the desired phy as a parameter
 * 	[1997/12/12  04:03:27  hayes]
 * 
 * Revision 1.1.2.4  1997/11/24  18:48:19  hayes
 * 	fixed cut and paste typo...
 * 	[1997/11/24  18:48:04  hayes]
 * 
 * Revision 1.1.2.3  1997/11/22  21:39:43  hayes
 * 	changes to support new phy mgt interface for both 110 and 180
 * 	[1997/11/22  21:39:34  hayes]
 * 
 * Revision 1.1.2.2  1997/11/21  23:54:16  hayes
 * 	MII link down works
 * 	[1997/11/21  23:53:54  hayes]
 * 
 * 	MII interface works
 * 	[1997/11/21  22:45:30  hayes]
 * 
 * Revision 1.1.2.1  1997/08/29  22:11:54  hayes
 * 	initial checkin
 * 
 * Revision 1.1.1.2  1997/08/29  22:10:19  hayes
 * 	initial checkin
 * 
 * $EndLog$
 */

#ifndef _LINK_IF_H_
#define _LINK_IF_H_

/*
 * information that we must save across calls to set_mac_link(),
 * get_mac_link() and set_mac_active()
 */

typedef struct link_mgt_state {
    U32 link_state_gig;
    U32 link_state_fast;
    U32 link_set_gig;
    U32 link_set_fast;
    U32 tx_fctl_fast;
    U32 tx_fctl_gig;
    U32 rx_fctl_fast;
    U32 rx_fctl_gig;
} link_mgt_state_t;

extern link_mgt_state_t mac_mgt_state[];

extern void set_mac_link(U32 index, U32 phy, U32 link_set);
extern U32 get_mac_link(U32 index, U32 phy);
extern void set_mac_active(U32 index);

#endif /* _LINK_IF_H_ */

