/*
 * COPYRIGHT NOTICE
 * Copyright (c) Alteon Networks, Inc. 1996, 1997 
 * All rights reserved
 * 
 */
/*
 * HISTORY
 * $Log: link_if.c,v $
 * Revision 1.4  1999/06/22 12:43:01  tjd21
 * Before removing extra recv rings
 *
 * Revision 1.1  1999/06/07 10:53:09  tjd21
 * Start of archive
 *
 * Revision 1.1.2.28  1999/01/27  19:09:41  hayes
 * 	incorporate autosense code
 * 	[1999/01/27  19:07:54  hayes]
 *
 * Revision 1.1.17.2  1998/11/07  20:59:56  hayes
 * 	link autosense mode now works
 * 
 * Revision 1.1.2.27  1998/07/01  00:31:00  taylor
 * 	Fixed defects 1286 and 1288
 * 	[1998/07/01  00:30:08  taylor]
 * 
 * Revision 1.1.2.26  1998/05/27  01:19:35  fhwang
 * 	OR MII_AUTONEG_ADV_802_3 with advertise value before set the register.
 * 	[1998/05/27  01:03:55  fhwang]
 * 
 * Revision 1.1.2.25  1998/03/18  03:43:59  hayes
 * 	restructure mac mgt interface
 * 	[1998/03/18  03:37:56  hayes]
 * 
 * Revision 1.1.2.24  1998/03/09  17:32:06  hayes
 * 	add support for MII LOOPBACK mode
 * 	[1998/03/09  01:00:01  hayes]
 * 
 * Revision 1.1.2.23  1998/02/27  02:42:14  hayes
 * 	fix link preferences and restructure link mgt interface
 * 	[1998/02/27  02:41:28  hayes]
 * 
 * Revision 1.1.2.22  1998/02/24  00:09:09  kyung
 * 	1. disabling a port didn't set the link state correctly
 * 	2. when fast phy is active, gig port cap change caused
 * 		mac_tx_state regist
 * 	[1998/02/24  00:08:58  kyung]
 * 
 * Revision 1.1.11.1  1998/02/18  19:20:51  kyung
 * 	sync up with ge_latest
 * 	[1998/02/18  19:20:26  kyung]
 * 
 * Revision 1.1.2.20  1998/02/07  00:17:21  taylor
 * 	Rev5: dont overwrite tag type in mac_len reg
 * 	[1998/02/07  00:16:58  taylor]
 * 
 * Revision 1.1.2.19  1998/02/06  22:19:45  hayes
 * 	add support for link preferences
 * 	[1998/02/06  21:33:35  hayes]
 * 
 * Revision 1.1.2.18  1998/01/22  22:51:13  hayes
 * 	fix different phy fctl bug
 * 	[1998/01/22  22:47:23  hayes]
 * 
 * Revision 1.1.2.17  1998/01/09  18:26:06  hayes
 * 	Merged with changes from 1.1.2.16
 * 	[1998/01/09  18:26:02  hayes]
 * 
 * 	fix fctl negotiation bug
 * 	[1998/01/09  18:23:45  hayes]
 * 
 * Revision 1.1.2.16  1998/01/08  22:32:50  tibor
 * 	converted DISABLE_MAC_RX to function
 * 	[1998/01/08  22:21:44  tibor]
 * 
 * Revision 1.1.2.15  1997/12/12  19:45:40  hayes
 * 	fix phy disable
 * 	[1997/12/12  19:45:30  hayes]
 * 
 * Revision 1.1.2.14  1997/12/12  05:34:31  hayes
 * 	set_mac_link() and get_mac_link() now take the desired phy as a parameter
 * 	[1997/12/12  04:03:25  hayes]
 * 
 * Revision 1.1.2.13  1997/12/08  23:10:57  hayes
 * 	call link_down_notify() on link disable
 * 	[1997/12/08  23:10:48  hayes]
 * 
 * Revision 1.1.2.12  1997/11/26  01:08:46  hayes
 * 	improve external serdes bringup
 * 	[1997/11/26  01:07:22  hayes]
 * 
 * Revision 1.1.2.11  1997/11/24  01:00:19  taylor
 * 	Rev5: move data structures into scratchpad
 * 	[1997/11/23  21:42:52  taylor]
 * 
 * Revision 1.1.2.10  1997/11/22  21:39:42  hayes
 * 	changes to support new phy mgt interface for both 110 and 180
 * 	[1997/11/22  21:39:31  hayes]
 * 
 * Revision 1.1.2.9  1997/11/21  23:54:15  hayes
 * 	MII link down works
 * 	[1997/11/21  23:53:52  hayes]
 * 
 * 	MII interface works
 * 	[1997/11/21  22:45:27  hayes]
 * 
 * Revision 1.1.2.8  1997/11/21  04:48:10  hayes
 * 	release for NIC 2.1 pre-Beta
 * 	[1997/11/21  03:19:13  hayes]
 * 
 * 	internal and external SERDES co-exist peacefully
 * 	[1997/11/20  01:28:03  hayes]
 * 
 * Revision 1.1.2.7  1997/11/10  02:55:07  hayes
 * 	adjuct for better link bringup
 * 	[1997/11/10  02:54:52  hayes]
 * 
 * Revision 1.1.2.6  1997/10/27  22:59:51  hayes
 * 	make Tigon 2 support work for internal SERDES
 * 	[1997/10/27  22:56:07  hayes]
 * 
 * Revision 1.1.2.5  1997/10/11  19:02:50  hayes
 * 	updated rerorting of ALTEON, NIC and JUMBO LNK_XXX bits
 * 	[1997/10/11  19:02:25  hayes]
 * 
 * Revision 1.1.2.4  1997/09/17  03:26:26  hayes
 * 	Make get_mac_link() and set_mac_link() aware of active phys vs attached phys.
 * 	Change restart condition to active_phy_fail = TRUE.
 * 	[1997/09/15  22:20:44  hayes]
 * 
 * Revision 1.1.2.3  1997/09/10  03:55:09  hayes
 * 	start code preparation to handle multiple phys per mac
 * 	remove references to LNK_XX_FLOW_CTL_N
 * 	[1997/09/10  03:52:05  hayes]
 * 
 * Revision 1.1.2.2  1997/09/09  02:57:32  hayes
 * 	Add support for using various MII devices
 * 	Add device support for Level One LXT970 in addition
 * 	to ICS 1890
 * 	[1997/09/09  02:55:48  hayes]
 * 
 * Revision 1.1.2.1  1997/08/29  22:11:52  hayes
 * 	initial checkin
 * 
 * Revision 1.1.1.2  1997/08/29  22:10:16  hayes
 * 	initial checkin
 * 
 * $EndLog$
 */

#include "alt_const.h"
#include "link_op.h"
#include "mii.h"
#include "zconf.h"
#include "np.h"
#include "link.h"
#include "link_if.h"

#if defined(_SP_CONF_H_)
#include "sp_regs.h"
#endif /* defined(_SP_CONF_H_) */

#include "timer.h"
#include "mac.h"
#include "assert.h"
#include "trace.h"

link_mgt_state_t mac_mgt_state[NUM_MACS];

void
set_mac_link(U32 index, U32 phy, U32 link_set)
{
    mii_pair_t *miip;
    U16 zero = 0;
    U16 loc_reg_control;

    LINK_UTRACE("stmacLNK", 0x99001, 
	index, phy, active_phy, link_set);

    switch (phy) {
	    
	case ATTACHED_PHY_IF_MII:

	    /* remove impossible options */
	    link_set &= ~LNK_1000MB;

	    /* save it away */
	    mac_mgt_state[index].link_set_fast = link_set;
	    
	    /* enable or disable */
	    if (link_set & LNK_ENABLE) {

		/* set or negotiate */
		miip = &mii_set[(link_set & LNK_DPX_MASK) >> 
			LNK_DPX_SHIFT]
		    [(link_set & LNK_SPD_MASK) >> LNK_SPD_SHIFT];
		
		if (link_set & LNK_TX_FLOW_CTL_Y) {
		    mac_mgt_state[index].tx_fctl_fast = TG_MAC_TX_STATE_ENA_FC;
		} else {
		    mac_mgt_state[index].tx_fctl_fast = 0;
		}

		if (link_set & LNK_RX_FLOW_CTL_Y) {
		    mac_mgt_state[index].rx_fctl_fast = TG_MAC_RX_STATE_ENA_FC;
		} else {
		    mac_mgt_state[index].rx_fctl_fast = 0;
		}

		loc_reg_control = miip->reg_control;

		if (link_set & LNK_LOOPBACK)
		    loc_reg_control |= MII_CONTROL_LOOPBACK;
		    
		/* now set the PHY */
		miip->reg_autoneg_adv |= MII_AUTONEG_ADV_802_3;
		write_mii_mgt(1, MII_REG_AUTONEG_AD, &miip->reg_autoneg_adv);
		write_mii_mgt(1, MII_REG_CONTROL, &loc_reg_control);

		/*
		 * we've changed the link, so we must bring it back up.
		 * notifying a link down will make this happen.
		 * But only if this is the currently active phy...
		 */
		reset_phy = 1;
		if (active_phy == phy) {
		    link_down_notify();
		}

		/*
		 * if we've got the priority bit set, force a restart of
		 * this PHY...
		 */
		if (link_set & LNK_PREF) {
		    link_down_notify();
		    /*
		     * insure that this phy gets tried next...
		     */
		    active_phy_fail = 1;
		    active_phy = ATTACHED_PHY_IF_MII << 1;
		}

	    } else {

		/* disable the PHY */
		write_mii_mgt(1, MII_REG_AUTONEG_AD, &zero);
		write_mii_mgt(1, MII_REG_CONTROL, &zero);

		/*
		 * we've changed the link, so we must bring it back up.
		 * notifying a link down will make this happen.
		 */
		reset_phy = 1;
		mac_mgt_state[index].link_state_fast &= ~LNK_ENABLE;
		if (active_phy == phy) {
		    link_down_notify();
		}
		
	    }

	    break;	/* ATTACHED_PHY_IF_MII */
	    
	case ATTACHED_PHY_IF_GMII:
	    /* XXX */
	    break;

	case ATTACHED_PHY_IF_SERDES_INT:
	    /* fall through */

	case ATTACHED_PHY_IF_SERDES_EXT:
	   
	    /* remove impossible options */
	    link_set &= ~(LNK_10MB | LNK_100MB | LNK_HALF_DUPLEX);
	    /* add required options */
	    link_set |= LNK_FULL_DUPLEX;

	    /* save it away */
	    mac_mgt_state[index].link_set_gig = link_set;

	    /* see if we're being asked to negotiate this */
	    if ((link_set & LNK_NEGOTIATE) && !link_sense_mode) {
		gig_negotiate = 1;
	    } else {
		gig_negotiate = 0;
	    }

	    /* are we disabled */
	    if (!(link_set & LNK_ENABLE)) {
		if (gig_negotiate) {
		    gig_negotiate_options = 
			CONFIG_BASE_REM_FAULT_OFFLINE | CONFIG_BASE_FD;
		    BRINGUP_LINK_STATE = BRINGUP_LINK_STATE_RESET_START;
		}

		mac_mgt_state[index].link_state_gig &= ~LNK_ENABLE;
		if (active_phy != ATTACHED_PHY_IF_MII)
		    link_down_notify();
		return;
	    }

	    if (gig_negotiate) {
		gig_negotiate_options = CONFIG_BASE_FD;

		if ((link_set & 
			(LNK_TX_FLOW_CTL_Y | LNK_RX_FLOW_CTL_Y)) == 
		    (LNK_TX_FLOW_CTL_Y | LNK_RX_FLOW_CTL_Y)) {
		    gig_negotiate_options |= CONFIG_BASE_PAUSE_SYM;
		} else if (mac_mgt_state[index].link_set_gig & 
		    LNK_TX_FLOW_CTL_Y) {
		    gig_negotiate_options |= CONFIG_BASE_PAUSE_ASYM_REMOTE;
		} else if (mac_mgt_state[index].link_set_gig & 
		    LNK_RX_FLOW_CTL_Y) {
		    gig_negotiate_options |= CONFIG_BASE_PAUSE_ASYM_LOCAL;
		} else {
		    gig_negotiate_options |= CONFIG_BASE_PAUSE_NONE;
		}
	    } else {
		if (link_set & LNK_TX_FLOW_CTL_Y) {
		    mac_mgt_state[index].tx_fctl_gig = TG_MAC_TX_STATE_ENA_FC;
		} else {
		    mac_mgt_state[index].tx_fctl_gig = 0;
		}

		if (link_set & LNK_RX_FLOW_CTL_Y) {
		    mac_mgt_state[index].rx_fctl_gig = TG_MAC_RX_STATE_ENA_FC;
		} else {
		    mac_mgt_state[index].rx_fctl_gig = 0;
		}
	    }

	    /*
	     * reset the link 
	     */
	    if (active_phy != ATTACHED_PHY_IF_MII) {
		link_down_notify();
	    }

	    break;	/* ATTACHED_PHY_IF_SERDES_EXT */
	    
	default:
	    /* XXX error */
    }
}

U32
get_mac_link(U32 index, U32 phy)
{
    U16 mii_reg_vendor = 0;
    U16 mii_reg_status = 0;
    U32 speed = 0;
    U32 duplex = 0;
    U32 link_state = 0;

    switch (phy) {
	case ATTACHED_PHY_IF_MII:

	    if (mac_mgt_state[index].link_set_fast & LNK_ENABLE)
		link_state = LNK_ENABLE;
	    else {
		/* disabled, just return the request */
	        link_state = mac_mgt_state[index].link_set_fast;
		link_state &= ~LNK_UP;
	        mac_mgt_state[index].link_state_fast = link_state;
		return(link_state);
	    }

	    /* read once to clear latch... */
	    read_mii_mgt(1, MII_REG_STATUS, &mii_reg_status);
	    /* and again for new status */
	    read_mii_mgt(1, MII_REG_STATUS, &mii_reg_status);

	    if (mii_reg_status & MII_STATUS_LINK_UP) {

		switch (mii_device_attached) {
		    case MII_DEVICE_ICS_1890_2:
			/* read once to clear latch... */
			read_mii_mgt(1, MII_REG_ICS_QUICK_STATUS, 
			    &mii_reg_vendor);
			/* and again for new status */
			read_mii_mgt(1, MII_REG_ICS_QUICK_STATUS, 
			    &mii_reg_vendor);

			if (mii_reg_vendor & MII_ICS_QUICKPOLL_FD) {
			    duplex = LNK_FULL_DUPLEX;
			} else {
			    duplex = LNK_HALF_DUPLEX;
			}

			if (mii_reg_vendor & MII_ICS_QUICKPOLL_100) {
			    speed = LNK_100MB;
			} else {
			    speed = LNK_10MB;
			}
			break;

		    case MII_DEVICE_LXT_970:
			/* read once to clear latch... */
			read_mii_mgt(1, MII_REG_LEVL1_CHIPSTAT, 
			    &mii_reg_vendor);
			/* and again for new status */
			read_mii_mgt(1, MII_REG_LEVL1_CHIPSTAT, 
			    &mii_reg_vendor);

			if (mii_reg_vendor & MII_LEVL1_CHIPSTAT_FD) {
			    duplex = LNK_FULL_DUPLEX;
			} else {
			    duplex = LNK_HALF_DUPLEX;
			}

			if (mii_reg_vendor & MII_LEVL1_CHIPSTAT_100) {
			    speed = LNK_100MB;
			} else {
			    speed = LNK_10MB;
			}
			break;

		    case MII_DEVICE_UNKNOWN:
		    case MII_DEVICE_NONE:
		    default:
			/* XXX */
		}

		link_state |= speed | duplex | LNK_UP;
	    } else {
	        link_state = mac_mgt_state[index].link_set_fast;
		link_state &= ~LNK_UP;
	    }
	    mac_mgt_state[index].link_state_fast = link_state;
	    return(link_state);
	    break;

	case ATTACHED_PHY_IF_GMII:
	    /* fall through */

	case ATTACHED_PHY_IF_SERDES_INT:
	    /* fall through */

	case ATTACHED_PHY_IF_SERDES_EXT:

	    if (mac_mgt_state[index].link_set_gig & LNK_ENABLE)
		link_state = LNK_ENABLE;
	    else {
		/* disabled, just return the request */
	        link_state = mac_mgt_state[index].link_set_gig;
		link_state &= ~LNK_UP;
	        mac_mgt_state[index].link_state_gig = link_state;
		return(link_state);
	    }

	    link_state |= LNK_1000MB | LNK_FULL_DUPLEX;

	    if (link_ready) {

	        link_state |= LNK_UP;

		if (link_sense_mode)
		    link_state |= LNK_SENSE_NO_NEG;

		if (gig_negotiate) {
		    link_state |= LNK_NEGOTIATE;
		}

		if (mac_mgt_state[index].tx_fctl_gig) {
		    link_state |= LNK_TX_FLOW_CTL_Y;
		} else {
		    link_state &= ~LNK_TX_FLOW_CTL_Y;
		}

		if (mac_mgt_state[index].rx_fctl_gig) {
		    link_state |= LNK_RX_FLOW_CTL_Y;
		} else {
		    link_state &= ~LNK_RX_FLOW_CTL_Y;
		}

		/*
		 * is the link partner another Alteon device?
		 */
		if (link_partner_alteon)
		    link_state |= LNK_ALTEON;

		/*
		 * can the remote end handle large frames
		 */
		if (link_partner_jumbo)
		    link_state |= LNK_JUMBO;

		/*
		 * Is the remote end a NIC?
		 */
		if (link_partner_nic)
		    link_state |= LNK_NIC;

	    } else {
	        link_state = mac_mgt_state[index].link_set_gig;
		link_state &= ~LNK_UP;
	    }
	    mac_mgt_state[index].link_state_gig = link_state;
	    return(link_state);

	    break;

	default:
	    /* XXX error */
    }
    return(link_state);
}

void
set_mac_active(U32 index)
{
    U32 tx_state = trp->mac_control.mac_tx_state;
    U32 rx_state = trp->mac_control.mac_rx_state;

    U32 link_set;
    U32 link_state;

    switch (active_phy) {
	    
	case ATTACHED_PHY_IF_MII:

	    link_set = mac_mgt_state[index].link_set_fast;
	    link_state = mac_mgt_state[index].link_state_fast;

	    /* enable or disable */
	    if (link_set & LNK_ENABLE) {
		/* enable the MAC */
		tx_state |= TG_MAC_TX_STATE_ENABLE;

		/* MAC duplex setting must match PHY state */
	   	if (link_state & LNK_FULL_DUPLEX) {
		    tx_state |= TG_MAC_TX_STATE_ENA_FULL_DUPLEX;

		    if (mac_mgt_state[index].tx_fctl_fast) {
			tx_state |= TG_MAC_TX_STATE_ENA_FC;
			link_state |= LNK_TX_FLOW_CTL_Y;
		    } else {
			tx_state &= ~TG_MAC_TX_STATE_ENA_FC;
			link_state &= ~LNK_TX_FLOW_CTL_Y;
		    }

		    if (mac_mgt_state[index].rx_fctl_fast) {
			rx_state |= TG_MAC_RX_STATE_ENA_FC;
			link_state |= LNK_RX_FLOW_CTL_Y;
		    } else {
			rx_state &= ~TG_MAC_RX_STATE_ENA_FC;
			link_state &= ~LNK_RX_FLOW_CTL_Y;
		    }

		} else {
		    /* MAC duplex state must match PHY duplex state */
		    /* Also disable FC for half duplex operation */

		    tx_state &= 
			~(TG_MAC_TX_STATE_ENA_FULL_DUPLEX |
			  TG_MAC_TX_STATE_ENA_FC);

		    rx_state &= ~TG_MAC_RX_STATE_ENA_FC;
		    mac_mgt_state[index].tx_fctl_fast = 0;
		    mac_mgt_state[index].rx_fctl_fast = 0;

		    link_state &= 
			~(LNK_TX_FLOW_CTL_Y | LNK_RX_FLOW_CTL_Y);

		}
		/*
		 * disable mac_rx_state reg so we can modify control
		 * bits
		 */
		DISABLE_MAC_RX();

		trp->mac_control.mac_tx_state = tx_state;
		trp->mac_control.mac_rx_state = rx_state;

		ENABLE_MAC_RX();

	    } else {
		/* disable the MAC */
		trp->mac_control.mac_tx_state &= 
		    ~TG_MAC_TX_STATE_ENABLE;
		DISABLE_MAC_RX();

                link_state &= ~LNK_ENABLE;
		link_down_notify();
	    }
	    mac_mgt_state[index].link_state_fast = link_state;

	    break;	/* ATTACHED_PHY_IF_MII */
	    
	case ATTACHED_PHY_IF_GMII:
	    /* XXX */
	    break;

	case ATTACHED_PHY_IF_SERDES_INT:
	    /* fall through */

	case ATTACHED_PHY_IF_SERDES_EXT:
	   
	    link_set = mac_mgt_state[index].link_set_gig;
	    link_state = mac_mgt_state[index].link_state_gig;

	    /* are we disabled */
	    if (!(link_set & LNK_ENABLE)) {
		if (!gig_negotiate) {
		    trp->mac_control.mac_tx_state |= TG_MAC_TX_STATE_ENABLE;
		    DISABLE_MAC_RX();
		}
                link_state &= ~LNK_ENABLE;
		link_down_notify();
		mac_mgt_state[index].link_state_gig = link_state;
		return;	/* early return */
	    }

	    if (!gig_negotiate || link_sense_mode) {

                tx_state |= TG_MAC_TX_STATE_ENA_FULL_DUPLEX;

		if (link_set & LNK_TX_FLOW_CTL_Y) {
		    mac_mgt_state[index].tx_fctl_gig = TG_MAC_TX_STATE_ENA_FC;
                    tx_state |= TG_MAC_TX_STATE_ENA_FC;
		} else {
		    mac_mgt_state[index].tx_fctl_gig = 0;
                    tx_state &= ~TG_MAC_TX_STATE_ENA_FC;
		}

		if (link_set & LNK_RX_FLOW_CTL_Y) {
		    mac_mgt_state[index].rx_fctl_gig = TG_MAC_RX_STATE_ENA_FC;
                    rx_state |= TG_MAC_RX_STATE_ENA_FC;
		} else {
		    mac_mgt_state[index].rx_fctl_gig = 0;
                    rx_state &= ~TG_MAC_RX_STATE_ENA_FC;
		}

		/*
		 * disable mac_rx_state before setting any control bits...
		 */
		DISABLE_MAC_RX();

		trp->mac_control.mac_tx_state = tx_state;
		trp->mac_control.mac_rx_state = rx_state;

		ENABLE_MAC_RX();
	    }
	    mac_mgt_state[index].link_state_gig = link_state;

	    break;	/* ATTACHED_PHY_IF_SERDES_EXT */
	    
	default:
	    /* XXX error */
    }
}

