/* Does the thread stuff. Gross hack.
 * $Id: thread.h,v 3.2 1999/12/18 16:27:38 kaf24 Exp kaf24 $
 *
 * $Log: thread.h,v $
 * Revision 3.2  1999/12/18 16:27:38  kaf24
 * Performance tweaks
 *
 * Revision 3.1  1999/12/18 16:27:26  kaf24
 * Performance tweaks
 *
 * Revision 3.0  1999/12/17 11:37:01  kaf24
 * Now uses Linux stack.
 *
 * Revision 2.5  1999/12/17 11:36:21  kaf24
 * Now uses Linux stack.
 *
 * Revision 2.4  1999/11/01 15:33:25  kaf24
 * before changing to new tx2 send path
 *
 * Revision 2.3  1999/10/07 10:49:47  kaf24
 * Changed to Gnu pth thread lib.
 *
 * Revision 2.2  1999/10/01 08:12:36  kaf24
 * clean interface to USD details. Bugs in hash code but ready for change to pth threads.
 *
 * Revision 2.1  1999/09/28 13:02:34  kaf24
 * Performance enhancements, before changing thread lib.
 *
 * Revision 2.0  1999/09/23 13:27:03  kaf24
 * Bug fixes, and added SOCK_USER
 *
 * Revision 1.6  1999/08/06 14:41:36  kaf24
 *  First working UDP version for acenic gigabit ethernet.
 *
 * Revision 1.5  1999/08/02 14:00:32  kaf24
 * Removed pthread references.
 *
 * Revision 1.4  1999/07/22 14:58:54  kaf24
 * Removed non-compiled code
 *
 * Revision 1.3  1998/02/26 10:36:13  dbs20
 * First version with simulator and new buffering methods.
 *
 * Revision 1.2  1998/01/21 11:04:55  dbs20
 * ,
 *
 * Revision 1.1  1998/01/09 14:06:05  dbs20
 * Initial revision
 *
 */

#ifndef _THREAD_H_
#define _THREAD_H_

#include <pth.h>

typedef pth_t       pthread_t;
typedef pth_mutex_t pthread_mutex_t;
typedef pth_cond_t  pthread_cond_t;

#define pthread_create(__thr, __attr, __start, __arg) \
 ({ *(__thr) = pth_spawn(PTH_ATTR_DEFAULT, __start, __arg); 0; }) 
#define pthread_cancel(__t) (!pth_cancel(__t))
#define pthread_join(__t, __r) (!pth_join(__t, __r))
#define pthread_setcanceltype(__t, __o) \
 pth_cancel_state(PTH_CANCEL_ENABLE|PTH_CANCEL_ASYNCHRONOUS, __o)
#define sched_yield() pth_yield(NULL)

#define PTHREAD_MUTEX_INITIALIZER PTH_MUTEX_INIT
#define pthread_mutex_init(__x, __t) (!pth_mutex_init(__x))
#define pthread_mutex_lock(__x) (!pth_mutex_acquire(__x, FALSE, NULL))
#define pthread_mutex_unlock(__x) (!pth_mutex_release(__x))
#define pthread_mutex_destroy(__x) (!pth_mutex_destroy(__x))

#define PTHREAD_COND_INITIALIZER PTH_COND_INIT
#define pthread_cond_init(__x, __t) (!pth_cond_init(__x))
#define pthread_cond_wait(__c, __m) (!pth_cond_await(__c, __m, NULL))
#define pthread_cond_signal(__c) (!pth_cond_notify(__c, FALSE))
#define pthread_cond_broadcast(__c) (!pth_cond_notify(__c,TRUE))
#define pthread_cond_destroy(__x) ((void)0)

/******************************************************************************
 * To be used if the wait is not related to a pcb structure. We use DB
 * rather than FDB.
 */
#define WAIT_NO_PCB(_cond, _cond_variable, _lock)       \
    while ( !(_cond) )                                  \
    {                                                   \
        DB("waiting (%p)", &(_cond_variable));          \
        pthread_cond_wait(&(_cond_variable), &(_lock)); \
        DB("awoken (%p)", &(_cond_variable));           \
    }

#endif _THREAD_H_
/* end of $RCSfile: thread.h,v $ */
