/******************************************************************************/
/******************************************************************************/
/* timestamp.c                                                                */
/*   Gathers kernel and user-space timestamp info, pretty-prints it and       */
/*   calculates some simple stats.                                            */
/******************************************************************************/
/******************************************************************************/

#include <stdio.h>
#include <netinet/in.h>
#include "tcp_timer.h"
#include "private.h"

void newentry(FILE *fp, unsigned int id, unsigned int stamp)
{
    static unsigned int lpfw = 0, lws = 0, lic = 0, prev = 0, lwu = 0;

    switch ( id )
    {
    case TS_PAUSE_FOR_WORK:
        fprintf(fp, "  TPFW    %8.8x (%d)\n", stamp, stamp-prev);
        lpfw = prev = stamp;
        break;
    case TS_WAIT_START:
        fprintf(fp, "    TWS   %8.8x (%d)\n", stamp, stamp-prev);
        lws  = prev = stamp;
        break;
    case TS_IRQ_CALLBACK:
        fprintf(fp, "      TIC %8.8x (%d)\n", stamp, stamp-prev);
        lic  = prev = stamp;
        break;
    case TS_WAIT_END:
        fprintf(fp, "    TWE   %8.8x (%d %d)\n", stamp, stamp-lic, stamp-lws);
        prev = stamp;
        break;
    case TS_UNPAUSED:
        fprintf(fp, "  TU      %8.8x (%d %d)\n", stamp, stamp-prev,stamp-lpfw);
        prev = stamp;
        break;
    case TS_DGRAM_WAKEUP:
        fprintf(fp, "          WAKEUP %8.8x (%d)\n", stamp, stamp-prev);
        lwu = prev = stamp;
        break;
    case TS_DGRAM_WOKEN:
        fprintf(fp, "          WOKEN  %8.8x (%d %d)\n", stamp,stamp-prev, stamp-lwu);
        prev = stamp;
        break;
    default:
        fprintf(fp, "******** UNRECOGNISED!!!\n");
        break;
    }
}

int main(int argc, char *argv[])
{
    FILE *kfp, *ufp, *ofp;
    unsigned int basetime;
    unsigned int k_ent[2], u_ent[2];
    int k_finished = 0, u_finished = 0;

    if ( argc != 4 )
    {
        fprintf(stderr, "timestamp <kernel file> <user file> <output file>\n");
        exit(1);
    }

    if ( strcmp("/proc/afuser_stamps", argv[1]) == 0 )
    {
        FILE *in, *out;
        printf("Copying kernel file to /local/scratch/kaf24/kernel_stamps\n");
        in  = fopen(argv[1], "rb");
        out = fopen("/local/scratch/kaf24/kernel_stamps", "wb");
        if ( !in || !out ) exit(1);
        while ( fread(&basetime, 1, 4, in) == 4 ) fwrite(&basetime, 1, 4, out);
        fclose(in);
        fclose(out);
        argv[1] = "/local/scratch/kaf24/kernel_stamps";
    }

    kfp = fopen(argv[1], "rb");
    ufp = fopen(argv[2], "rb");
    ofp = fopen(argv[3], "wb");
    if ( !kfp || !ufp || !ofp ) exit(1);

    k_ent[1] = ~0; u_ent[1] = ~0;
    if ( fread(k_ent, 1, 8, kfp) != 8 ) k_finished = 1;
    if ( fread(u_ent, 1, 8, ufp) != 8 ) u_finished = 1;

    basetime=u_ent[1];
    if ( k_ent[1] < u_ent[1] ) basetime = k_ent[1];
    k_ent[1] -= basetime; u_ent[1] -= basetime;

    while ( !(k_finished && u_finished) )
    {
        if ( u_finished || ((k_ent[1] < u_ent[1]) && !k_finished) )
        {
            newentry(ofp, k_ent[0], k_ent[1]);
            if ( fread(k_ent, 1, 8, kfp) != 8 ) k_finished = 1;
            k_ent[1] -= basetime;
        }
        else
        {
            newentry(ofp, u_ent[0], u_ent[1]);
            if ( fread(u_ent, 1, 8, ufp) != 8 ) u_finished = 1;
            u_ent[1] -= basetime;
        }
    }

    fclose(ofp);
    fclose(ufp);
    fclose(kfp);
    
    return(0);
}
