/******************************************************************************
 * profile.h
 * 
 * Main header file for fast tracking of profiling events.
 * 
 * Compilation is controlled by PROFILE in the obvious way.
 * 
 * Copyright (c) 1999, K A Fraser.
 */

#ifndef __KAF_PROFILE_H
#define __KAF_PROFILE_H

#ifdef PROFILE

void prof_init(void);
void prof_close(void);
void flush_prof_buffer(void);
extern unsigned int *__prof;
extern unsigned int *__prof_end;

#define PROF_INIT() prof_init()

#define PROF_EVENT(__id, __arg) \
({ unsigned int __time; __asm__("rdtsc" : "=a" (__time) : : "edx"); \
*__prof++ = (unsigned int)(__id); \
*__prof++ = __time; \
*__prof++ = (unsigned int)(__arg); \
if ( __prof == __prof_end ) flush_prof_buffer(); })

#define PROF_CLOSE() prof_close()

#else /* PROFILE */

#define PROF_INIT() ((void)0)
#define PROF_EVENT(__id, __arg) ((void)0)
#define PROF_CLOSE() ((void)0)

#endif /* PROFILE */

#endif /* __KAF_PROFILE_H */
