# Rules for making the library.
#
# $Id: Rules.mk,v 3.0 1999/12/17 11:37:26 kaf24 Exp kaf24 $
#

## PTH_INSTALL should point at the place you installed the special build
##             of PTH
PTH_INSTALL = /anfs/scratch/uridium/kaf24/ix86-libs

## LINUXROOT   should point at the root of your Linux build tree
## MODULESROOT should point at the directory containing the GigE kernel modules
ifndef IN_SUBDIR
LINUXROOT   = ../linux-2.3.29
MODULESROOT = ../gige-mods
else
LINUXROOT   = ../../linux-2.3.29
MODULESROOT = ../../gige-mods
endif

CC              = gcc
OPT		= -O2 -D_REENTRANT -D__TEST_NO_CHECKSUMS
#-DHDR_SPLIT
WARN		= -Wall -Wno-unused
DEBUG		= -g -DNDEBUG
INCLUDES        = -I. -I$(LINUXROOT)/include -I$(MODULESROOT) \
                  -I$(PTH_INSTALL)/include

CFLAGS  = -shared -fPIC $(WARN) $(DEBUG) $(OPT) $(INCLUDES)


%.d: %.c
	$(SHELL) -ec '$(CC) -M $(CFLAGS) $< \
		| sed '\''s/\($*\)\.o[ :]*/\1.o $@ : /g'\'' > $@'

default: all

.PHONY: clean all

# end of $RCSFile$
